!----------------------------------------------------------------------
!     Copyright (c) 2008 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wq_module ƥȥץ
!
!      ݥݥƥ󥷥ζ
!
!  2008/04/04  ݹ
!      2008/07/05  ʿ  ѹ
!
!
!      2008/07/05  ʿ 1D-1 ݾڤǤʤ?
!
program wq_test_polvelbc

  use dc_message, only : MessageNotify
  use wq_module

  implicit none

  integer,parameter  :: im=32, jm=16, km=8   ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=15         ! ȿ(ʿ, ư)
  real(8),parameter  :: ra=0.5D0             ! Ⱦ

  real(8), dimension(0:im-1,1:jm,km)     :: xyr_Poloidal
  real(8), dimension(0:im-1,1:jm,km)     :: xyr_LaplaPol
  real(8), dimension(0:im-1,1:jm,km)     :: xyr_LaplaPol1
  real(8), dimension(0:im-1,1:jm,km)     :: xyr_True
  real(8), dimension((nm+1)**2,km) :: wr_Poloidal
  real(8), dimension((nm+1)**2,0:lm) :: wq_Poloidal
  character(len=1), dimension(2), parameter :: BCond=(/'F','R'/)

  real(8), parameter  :: pi=3.1415926535897932385D0
  real(8), parameter  :: eps=1D-1

  integer :: k, l, i, j

  call MessageNotify('M','wq_test_polvelbc', &
       'wq_module  wq_LaplaPol2polGrid_wq function tests')

  write( 6,* ) 
  write( 6,* ) 'Output is displayed if computational error is larger than',eps

  call wq_initial(im,jm,km,nm,lm,ra)

  do l=1,2

     ! P_10
     xyr_Poloidal = sin(xyr_Lat) * xyr_Rad * ((xyr_Rad-ra)*(xyr_Rad+ra))**2
     xyr_LaplaPol = xyr_wr(wr_Lapla_wq(wq_xyr(xyr_Poloidal)))
     !xyr_LaplaPol = sin(xyr_Lat) * sin( pi*(xyr_Rad-ri)/(ro-ri) )
     ! P_1_1
     !xyr_LaplaPol = cos(xyr_Lat)*cos(xyr_Lon)* xyr_Rad * (xyr_Rad-ra) 
     !xyr_LaplaPol = 2*sin(xyr_Lat)**2 * xyr_Rad * (xyr_Rad-ra) 

     !xyr_Poloidal = xyr_wz(wr_LaplaPol2pol_wr(wr_xyr(xyr_LaplaPol),BCond(l)))
     !xyr_Poloidal = xyr_wq(wq_LaplaPol2PolTau_wq(wq_xyr(xyr_LaplaPol),BCond(l)))

!!$     wr_Poloidal = wr_LaplaPol2Pol_wr(wr_xyr(xyr_LaplaPol),BCond(l),new=.true.)
!!$     xyr_LaplaPol1 = xyr_wr(wr_Lapla_wq(wq_wr(wr_Poloidal)))
!!$     xyr_Poloidal = xyr_wr(wr_Poloidal)
!!$     wq_Poloidal  = wq_wr(wr_Poloidal)

     wq_Poloidal = wq_LaplaPol2Pol_wq(wq_xyr(xyr_LaplaPol),BCond(l),new=.true.)
     xyr_LaplaPol1 = xyr_wr(wr_Lapla_wq(wq_Poloidal))
     xyr_Poloidal = xyr_wq(wq_Poloidal)

     !---------------- å -----------------------
     xyr_True = xyr_LaplaPol1 - xyr_LaplaPol

     do k=1,km-2
        do j=1,jm
           do i=0,im-1
              if ( abs(xyr_True(i,j,k)) > eps ) then
                 write(6,*) 'internal value. : ', i,j,xyr_True(i,j,k)
                 call MessageNotify('E','wq_test_polvelbc',&
                              'internal value error too large')
              endif
           enddo
        enddo
     enddo

     call MessageNotify('M','wq_test_polvelbc', &
                        'internal value test succeeded!')

     !--------- üå ----------

     !----- =0 at the top ---------
     do j=1,jm
        do i=0,im-1
           if ( abs(xyr_Poloidal(i,j,km)) > eps ) then
              write(6,*) 'Top B.C. : ', i,j,xyr_Poloidal(i,j,km)
              call MessageNotify('E','wq_test_polvelbc',&
                              '=0 Top B.C. error too large')
           endif
        enddo
     enddo

     !----- d/dr=0, d^2/dr^2 at the top ---------
     if( BCond(l)(1:1) == 'F' ) then
        xyr_True = xyr_wq(wq_RadDRad_wq(wq_RadDRad_wq(wq_Poloidal))&
                                       -wq_RadDRad_wq(wq_Poloidal))/xyr_Rad**2
     else
        xyr_True = xyr_wq(wq_RadDRad_wq(wq_Poloidal))/xyr_Rad
     endif
     do j=1,jm
        do i=0,im-1
           if ( abs(xyr_True(i,j,km)) > eps ) then
              write(6,*) 'Top B.C. : ', i,j,xyr_True(i,j,km)
              call MessageNotify('E','wq_test_polvelbc',&
                              BCond(l)//'-Top B.C. error too large')
           endif
        enddo
     enddo

     call MessageNotify('M','wq_test_polvelbc', &
                        BCond(l)//'-Top B.C. test succeeded!')
  end do

  write( 6,* ) 
  call MessageNotify('M','wq_test_polvelbc', &
       'wq_module  wq_LaplaPol2polGrid_wq function tests succeeded!')


end program wq_test_polvelbc
