!----------------------------------------------------------------------
!     Copyright (c) 2007 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  au_module ƥȥץ
!
!  2007/12/28  ݹ  
!      2008/12/04  ʿ DGamma ѻߤȼ exp(gammaln) ѹ
!      
!
program aq_test_weight

  use dc_message, only : MessageNotify
  use aq_module
  implicit none

  integer, parameter :: im=16, km=31       ! ʻ, ȿ
  real(8), parameter :: ra=2               ! ΰ礭
  real(8), parameter :: alpha=0.5D0        ! Ÿ¿༰ѥ᥿  0 <  <= 1
  real(8), parameter :: beta= 1.0D0        ! Ÿ¿༰ѥ᥿  0 < 
  real(8), parameter :: gamma=2*alpha+beta ! Ÿ¿༰ѥ᥿ 
  real(8), parameter :: eps=1.0D-6
  real(8) :: gammaln
  external gammaln

  real(8), dimension(im) :: g_z
  real(8) :: Intsol

  integer :: i

  write(6,*)'++++++ Testing g_R_Weight +++++'

do i=1,2
  call aq_Initial(im,km,ra,alpha,beta,(/0/))

!!$  write(6,*) 'R'
!!$  write(6,*) g_R
!!$  write(6,*) 
!!$  write(6,*) 'R weight'
!!$  write(6,*) g_R_weight

  !  W(R) = R^beta/(a^2-R^2)^(1-alpha)
  !
  !  \int_0^a R^n W(R) dR 
  !       = a^{n+gamma-1} \int_0^1 r^(n+beta) (1-r^2)^(alpha-1) dr
  !       = (1/2) a^{n+gamma-1}((n+beta+1)/2)(alpha)/(alpha+(n+beta+1)/2)
  !
  !  \int_0^1 r^n w(r) dr = \int_0^1 r^(n+beta) (1-r^2)^(alpha-1) dr
  !                   = (1/2)\int_0^1 t^{(n+beta-1)/2} (1-t)^(alpha-1) dt
  !                   = (1/2) B((n+beta+1)/2,alpha)
  !                   = (1/2) ((n+beta+1)/2)(alpha)/(alpha+(n+beta+1)/2)
  !
  g_z(:) = 1
  Intsol = ra**(gamma-1)/2 * exp(gammaln(alpha)) &
              *exp(gammaln((beta+1)/2))/exp(gammaln(alpha+(Beta+1)/2))
  write(6,*) 
  write(6,*) 'z = 1, int_0^a z w(r) dr = ', IntSol
  write(6,*) 'Calculated value is   ', sum(g_z*g_R_weight)
  if ( abs(sum(g_z*g_R_weight)-IntSol) > eps )then
     call MessageNotify('E','au_test_weight', &
          'Integration error too large.')
  endif

  g_z(:) = g_R**2
  Intsol = ra**(2+gamma-1)/2 &
       * exp(gammaln(alpha)) &
       * exp(gammaln((2+beta+1)/2))/exp(gammaln(alpha+(2+Beta+1)/2))
  write(6,*) 
  write(6,*) 'z = R**2, int_0^a z dx = ', IntSol
  write(6,*) 'Calculated value is      ',sum(g_z*g_R_weight)
  if ( abs(sum(g_z*g_R_weight)-IntSol) > eps )then
     call MessageNotify('E','au_test_weight', &
          'Integration error too large.')
  endif

  call aq_Initial(im,km,ra,alpha,beta,(/1/))

  write(6,*) 
  g_z(:) = g_R**3
  Intsol = ra**(3+gamma-1)/2 &
       * exp(gammaln(alpha)) &
       * exp(gammaln((3+beta+1)/2))/exp(gammaln(alpha+(3+Beta+1)/2))
  write(6,*) 'z = R**3, int_0^2 z dx = ', IntSol
  write(6,*) 'Calculated value is             ',sum(g_z*g_R_weight)
  if ( abs(sum(g_z*g_R_weight)-IntSol) > eps )then
     call MessageNotify('E','aq_test_weight', &
          'Integration error too large.')
  endif

end do

  call MessageNotify('M','aq_test_weight', &
       'Test of g_R_Weight suceeded!')

end program aq_test_weight



