!----------------------------------------------------------------------
!     Copyright (c) 2008 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wq_module ƥȥץ
!
!      ȥݥƥ󥷥ζ
!
!  2008/04/04  ݹ
!      2008/07/05  ʿ  ѹ
!
program wq_test_tormagbc

  use dc_message, only : MessageNotify
  use wq_module

  implicit none

  integer,parameter  :: im=32, jm=16, km=8   ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=15         ! ȿ(ʿ, ư)
  real(8),parameter  :: ra=0.5D0               ! Ⱦ

  real(8), dimension(0:im-1,1:jm,km)             :: xyr_TORMAG
  real(8), dimension((nm+1)*(nm+1),0:lm)   :: wq_TORMAG
  real(8), dimension((nm+1)*(nm+1),0:lm)   :: wq_TORMAG_orig
  real(8), dimension((nm+1)*(nm+1),km)     :: wr_TORMAG

  real(8), parameter  :: pi=3.1415926535897932385D0
  real(8), parameter  :: eps=1D-16

  integer :: i,j,l,n

  call MessageNotify('M','wq_test_tormagbc', &
       'wq_module  wq_TormagBoundary subroutine test')

  write( 6,* ) 
  write( 6,* ) 'Output is displayed if computational error is larger than',eps

  call wq_initial(im,jm,km,nm,lm,ra)

 !==================== wq_TormagBoundary =========================
  ! P_10
  xyr_TORMAG = sin(xyr_lat) * cos( pi*(xyr_rad-ra)/ra ) * xyr_Rad
  ! P_1_1
  !xyr_TORMAG = cos(xyr_lat)*cos(xyr_lon)* cos( pi*(xyr_rad-ri)/(ro-ri) )
  !xyr_TORMAG = 2*sin(xyr_lat)**2 * cos( pi*(xyr_rad-ri)/(ro-ri) )

  wq_TORMAG = wq_xyr(xyr_TORMAG)
  wq_TORMAG_orig = wq_TORMAG
  call wq_TormagBoundary(wq_TORMAG)
  xyr_TORMAG = xyr_wq(wq_TORMAG)

  do n=1,(nm+1)**2
     do l=0,lm-2
        if ( abs(wq_TORMAG(n,l)-wq_TORMAG_orig(n,l)) > eps ) then
           write(6,*) 'internal value. : ', n,l,&
                     wq_TORMAG(n,l)-wq_TORMAG_orig(n,l)
           call MessageNotify('E','wq_test_polmagbc',&
                           'internal value error too large')
        endif
     enddo
  enddo

  call MessageNotify('M','wq_test_tormagbc', &
                         'internal value test succeeded!')
  do j=1,jm
     do i=0,im-1
        if ( abs(xyr_TORMAG(i,j,km)) > eps ) then
           write(6,*) 'Top B.C. : ', i,j,xyr_TORMAG(i,j,km)
           call MessageNotify('E','wq_test_tormagbc',&
                              'Top B.C. error too large')
        endif
     enddo
  enddo

  call MessageNotify('M','wq_test_tormagbc', &
       'wq_TormagBoundary test succeeded!')

 !==================== wq_TormagBoundaryGrid =========================
  ! P_10
  !xyr_TORMAG = sin(xyr_lat) * cos( pi*(xyr_rad-ra)/ra )
  ! P_1_1
  xyr_TORMAG = cos(xyr_lat)*cos(xyr_lon)* cos( pi*(xyr_rad-ra)/ra )*xyr_Rad
  !xyr_TORMAG = 2*sin(xyr_lat)**2 * cos( pi*(xyr_rad-ra)/ra )

  wr_TORMAG = wr_xyr(xyr_TORMAG)
  call wr_TormagBoundaryGrid(wr_TORMAG)
  xyr_TORMAG = xyr_wr(wr_TORMAG)

  do j=1,jm
     do i=0,im-1
        if ( abs(xyr_TORMAG(i,j,km)) > eps ) then
           write(6,*) 'Top B.C. : ', i,j,xyr_TORMAG(i,j,km)
           call MessageNotify('E','wq_test_tormagbc',&
                              'Top B.C. error too large')
        endif
     enddo
  enddo

  call MessageNotify('M','wq_test_tormagbc', &
       'wq_TormagBoundaryGrid test succeeded!')


  call MessageNotify('M','wq_test_tormagbc', &
       'wq_module  wq_TormagBoundary subroutine test succeded')


end program wq_test_tormagbc
