!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  w_deriv_module
!
!  2001/12/08  ݹ
!      2001/12/26  ݹ  ؿ,ѿ̾ѹ
!      2002/02/07  ݹ  ؿ,ѿ̾ѹ
!      2002/03/30  ݹ  ؿ,ѿ̾ƺѹ
!      2002/05/25  ݹ  ʻɸ̤٤̿̾ˡѹ
!      2005/07/04  ݹ  OPENMP Ѵ롼б
!
!      
!         Ѵʻǡ, ڥȥǡ礭Ϸᤦ
!
module w_deriv_module
  use w_base_module, only : im, jm, nm, it, t, y, ip, p, r, ia, a, &
                            w_base_Initial, xy_w, w_xy
  implicit none

  real(8), allocatable  :: rn(:,:)            ! ץ饷黻
  integer, allocatable  :: irm(:,:)           ! ʬ黻
  integer, allocatable  :: ip2(:), ip3(:)     ! 䥳ӥ׻
  real(8), allocatable  :: p2(:), p3(:)       ! 䥳ӥ׻
  real(8), allocatable  :: r2(:), r3(:)       ! 䥳ӥ׻

  real(8), allocatable  :: q(:)               ! 
  real(8), allocatable  :: ww(:),ws(:)        ! 

  private

  public w_deriv_Initial                      ! 
  public w_Lapla_w, w_LaplaInv_w              ! ץ饷ȵձ黻
  public w_DLon_w                             ! ʬ
  public xy_GradLon_w, xy_GradLat_w           ! ۷ʬ
  public w_DivLon_xy, w_DivLat_xy             ! ȯʬ
  public w_Div_xy_xy                          ! ȯʬ
  public w_Jacobian_w_w                       ! 䥳ӥ
  public xy_GradLambda_w, xy_GradMu_w         ! ۷ʬ(,̺ɸ)
  public w_DivLambda_xy, w_DivMu_xy           ! ȯʬ(,̺ɸ)

  public rn, irm                              ! ץ饷/ʬ黻

  save rn, irm, ip2, ip3, p2, p3, r2, r3

  contains

  !---------------  -----------------
    subroutine w_deriv_initial(n_in,i_in,j_in,np_in)

      integer,intent(in) :: i_in, j_in        ! ʻ(, )
      integer,intent(in) :: n_in              ! ȿ
      integer,intent(in), optional :: np_in   ! OPENMP Ǥκ祹åɿ

      integer iw

      if ( present (np_in) )then
         call w_base_initial(n_in,i_in,j_in,np_in)
      else
         call w_base_initial(n_in,i_in,j_in)
      endif

      allocate(rn((nm+1)*(nm+1),2))           ! ץ饷黻
      allocate(irm((nm+1)*(nm+1),2))          ! ʬ黻
      call spnini(nm,rn)
      call spmini(nm,irm)

      allocate(ip2(2*((nm+1)/2+nm+1)*2))      ! 䥳ӥ׻
      allocate(p2(2*((nm+1)/2+nm+1)*jm))      ! 䥳ӥ׻
      allocate(r2(2*((nm+1)/2*2+3)*(nm/2+1))) ! 䥳ӥ׻
      allocate(ip3(3*((nm+1)/2+nm+1)*2))      ! 䥳ӥ׻
      allocate(p3(3*((nm+1)/2+nm+1)*jm))      ! 䥳ӥ׻
      allocate(r3(3*((nm+1)/2*2+3)*(nm/2+1))) ! 䥳ӥ׻
      call snkini(nm,jm,2,ip,p,r,ip2,p2,r2)
      call snkini(nm,jm,3,ip,p,r,ip3,p3,r3)

      allocate(q(3*((nm+1)/2+nm+1)*jm))       ! 
      iw=3*max( ((nm+1)/2*2+3)*(nm/2+2)*2, &
                jm*((nm+1)/2+nm+1)*2, jm*jm )
      allocate(ws(iw),ww(iw))                 ! 
    end subroutine w_deriv_initial

  !--------------- ʬ׻ -----------------
    function w_Lapla_w(w_data)      ! ڥȥ˺Ѥ Laplacian
      real(8)              :: w_Lapla_w((nm+1)*(nm+1))
      real(8), intent(in)  :: w_data((nm+1)*(nm+1))

      call spclap(nm,w_data,w_Lapla_w,rn(1,1))
    end function w_Lapla_w

    function w_LaplaInv_w(w_data)   ! ڥȥ˺Ѥ Laplacian 黻
      real(8)              :: w_LaplaInv_w((nm+1)*(nm+1))
      real(8), intent(in)  :: w_data((nm+1)*(nm+1))

      call spclap(nm,w_data,w_LaplaInv_w,rn(1,2))
    end function w_LaplaInv_w

    function w_DLon_w(w_data)       ! ڥȥ˺Ѥʬ /ߦ
      real(8)              :: w_DLon_w((nm+1)*(nm+1))
      real(8), intent(in)  :: w_data((nm+1)*(nm+1))

      call spclam(nm,w_data,w_DLon_w,irm)
    end function w_DLon_w

    function xy_GradLon_w(w_data) ! ڥȥ˺Ѥ۷ʬ
                                  ! 1/cosա/ߦ
      real(8)              :: xy_GradLon_w(im,jm)
      real(8), intent(in)  :: w_data((nm+1)*(nm+1))

      xy_GradLon_w = xy_w(w_data,ipow=1,iflag=-1)
    end function xy_GradLon_w

    function xy_GradLat_w(w_data) ! ڥȥ˺Ѥ۷ʬ, /ߦ
      real(8)              :: xy_GradLat_w(im,jm)
      real(8), intent(in)  :: w_data((nm+1)*(nm+1))

      xy_GradLat_w = xy_w(w_data,ipow=1,iflag=1)
    end function xy_GradLat_w

    function w_DivLon_xy(xy_data) ! ʻҤ˺Ѥȯʬ 1/cosա/ߦ
      real(8)              :: w_DivLon_xy((nm+1)*(nm+1))
      real(8), intent(in)  :: xy_data(im,jm)

      w_DivLon_xy = w_xy(xy_data,ipow=1,iflag=-1)
    end function w_DivLon_xy

    function w_DivLat_xy(xy_data)   ! ʻҤ˺Ѥȯʬ
                                   ! 1/cosա(f cos)/ߦ

      real(8)              :: w_DivLat_xy((nm+1)*(nm+1))
      real(8), intent(in)  :: xy_data(im,jm)

      w_DivLat_xy = w_xy(xy_data,ipow=1,iflag=1)
    end function w_DivLat_xy

    function w_Div_xy_xy(xy_u,xy_v)   ! ʻҤ˺Ѥȯ
      real(8)              :: w_Div_xy_xy((nm+1)*(nm+1))
      real(8), intent(in)  :: xy_u(im,jm)   ! ٥ȥʬ
      real(8), intent(in)  :: xy_v(im,jm)   ! ٥ȥʬ

      w_Div_xy_xy = w_Divlon_xy(xy_u) + w_Divlat_xy(xy_v)
    end function w_Div_xy_xy

    function w_Jacobian_w_w(w_a,w_b) ! ڥȥ˺Ѥ䥳ӥ
                             ! J(f,g) = f/ߦˡg/ߦ - g/ߦˡf/ߦ
                             !        = f/ߦˡ1/cosաg/ߦ
                             !           - g/ߦˡ1/cosաf/ߦ

      real(8)             :: w_Jacobian_w_w((nm+1)*(nm+1))
      real(8), intent(in) :: w_a((nm+1)*(nm+1))
      real(8), intent(in) :: w_b((nm+1)*(nm+1))

      call spnjcb(nm,im,im,jm,jm,w_a,w_b,w_Jacobian_w_w,&
           it,t,y,ip2,p2,r2,ip3,p3,r3,ia,a,q,ws,ww)
    end function w_Jacobian_w_w

  !--------------- ʬ׻ (,̺ɸ) -----------------
    function xy_GradLambda_w(w_data) ! ڥȥ˺Ѥ۷ʬ
                                     ! /ߦ
      real(8)              :: xy_GradLambda_w(im,jm)
      real(8), intent(in)  :: w_data((nm+1)*(nm+1))

      xy_GradLambda_w = xy_w(w_data,ipow=0,iflag=-1)
    end function xy_GradLambda_w

    function xy_GradMu_w(w_data) ! ڥȥ˺Ѥ۷ʬ
                                  ! (1-^2)/ߦ  (=sin)
      real(8)              :: xy_GradMu_w(im,jm)
      real(8), intent(in)  :: w_data((nm+1)*(nm+1))

      xy_GradMu_w = xy_w(w_data,ipow=0,iflag=1)
    end function xy_GradMu_w

    function w_DivLambda_xy(xy_data) ! ʻҤ˺Ѥȯʬ
                                     ! 1/(1-^2)/ߦ
      real(8)              :: w_DivLambda_xy((nm+1)*(nm+1))
      real(8), intent(in)  :: xy_data(im,jm)

      w_DivLambda_xy = w_xy(xy_data,ipow=2,iflag=-1)
    end function w_DivLambda_xy

    function w_DivMu_xy(xy_data)   ! ʻҤ˺Ѥȯʬ
                                    ! /ߦ

      real(8)              :: w_DivMu_xy((nm+1)*(nm+1))
      real(8), intent(in)  :: xy_data(im,jm)

      w_DivMu_xy = w_xy(xy_data,ipow=2,iflag=1)
    end function w_DivMu_xy

  end module w_deriv_module
