!----------------------------------------------------------------------
!     Copyright (c) 2002-2005 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  wa_base_module
!
!  2002/02/02  ݹ  ¿Ѥ˲¤
!      2002/03/30  ݹ  ⥸塼̾ѹ
!      2002/05/25  ݹ  ʻɸ̤٤̿̾ˡѹ
!      2005/01/09  ݹ  msgdmp -> MessageNotify ѹ
!      2005/07/09  ݹ  OPENMP Ѵ롼б
!                            Х󥯶򤱤뤿κɲ
!      2005/07/10  ݹ  OpenMP åȥåפΥå
!
!         Ѵʻǡ, ڥȥǡ礭Ϸᤦ
!
module wa_base_module

  use dc_message
  use w_base_module, only : im, jm, nm, it, t, y, ip, p, r, ia, a, openmp, np
  implicit none

  integer               :: km=16         ! Ʊ˽ǡ(ؤο)

  integer, allocatable  :: ipk(:,:)            ! Ѵ(¿)
  real(8), allocatable  :: pk(:,:), rk(:,:)    ! Ѵ(¿)

  real(8), allocatable  :: q(:)                ! 
  real(8), allocatable  :: ww(:), ws(:)        ! 
  real(8), allocatable  :: wv(:)               ! (OPENMP)

  real(8), allocatable  :: xya_work(:,:,:)     ! w_xy,xy_w Ѵ
  integer               :: id=65, jd=33        ! xya_work 礭

  real(8), parameter    :: pi=3.14159265358979

  private

  public km                                    ! ؿ
  public wa_base_Initial                       ! ֥롼
  public xya_wa, wa_xya                        ! Ѵؿ

  save km                                      ! ǡ(ؿ)򵭲
  save ipk, pk, rk                             ! Ѵ򵭲
  save id, jd                                  ! Ѵ礭

  contains
  !---------------  -----------------
    subroutine wa_base_initial(k_in)

      integer,intent(in) :: k_in               ! ǡ(ؿ)򵭲

      integer :: iw

      km = k_in

      allocate(ipk(km,((nm+1)/2+nm+1)*2))      ! Ѵ(¿)
      allocate(pk(km,((nm+1)/2+nm+1)*jm))      ! Ѵ(¿)
      allocate(rk(km,((nm+1)/2*2+3)*(nm/2+1))) ! Ѵ(¿)

      allocate(q(km*((nm+1)/2+nm+1)*jm))       ! (¿)

      if ( im/2*2 .eq. im ) then
         id = im+1 
      else
         id = im
      endif
      if ( openmp ) then
         jd = jm
      else if ( jm/2*2 .eq. jm ) then
         jd = jm+1
      else
         jd = jm
      endif

      allocate(xya_work(id,jd,km))                ! Ѵ

      if ( openmp ) then
         iw=km*(im+nm+1)*3*jm/2
         allocate(wv(km*(nm+4)*(nm+3)*np))
         call MessageNotify('M','wa_base_Initial', &
              'OpenMP computation was set up.')
      else
         iw=km * max((nm+4)*(nm+3),jd*3*(nm+1),jd*im)
      endif

      allocate(ws(iw),ww(iw))                  ! (¿)

      call snkini(nm,jm,km,ip,p,r,ipk,pk,rk)

    end subroutine wa_base_Initial

  !--------------- Ѵ -----------------

    function xya_wa(wa_data,ipow,iflag)    ! Ĵ´ؿڥȥ -> ʻ
      real(8), intent(in)   :: wa_data(:,:)                    ! ڥȥ
      real(8)               :: xya_wa(im,jm,size(wa_data,2))   ! ʻ
      integer, intent(in), optional  :: ipow      ! Ѥ 1/cos μ
      integer, intent(in), optional  :: iflag     ! Ѵμ

      integer, parameter  :: ipow_default  = 0
      integer, parameter  :: iflag_default = 0

      integer ipval, ifval
      integer k

      logical :: first=.true.                    ! Ƚꥹå
      save first

      if (present(ipow)) then
         ipval = ipow
      else
         ipval = ipow_default
      endif

      if (present(iflag)) then
         ifval = iflag
      else
         ifval = iflag_default
      endif

      k= size(wa_data,2)
      if  ( k > km ) then
         call MessageNotify('E','xya_wa','Size of 3rd dimension invalid.')
      else  if ( openmp ) then
         if ( first ) then
            call MessageNotify('M','xya_wa', &
                 'OpenMP routine SNTSOG/SNPACK is used for spherical harmonic transformation.')
         endif
         call sntsog(nm,im,id,jm,k,wa_data,xya_work,&
              it,t,y,ipk(1:k,:),pk(1:k,:),rk(1:k,:),&
              ia,a,q,ws,ww,wv,ipval,ifval)
      else
         call snts2g(nm,im,id,jm,jd,k,wa_data, xya_work,&
              it,t,y,ipk(1:k,:),pk(1:k,:),rk(1:k,:),ia,a,q,ws,ww,ipval,ifval)
      endif
      xya_wa=xya_work(1:im,1:jm,1:k)

      first = .false.

    end function xya_wa

    function wa_xya(xya_data,ipow,iflag) ! ʻ -> Ĵ´ؿڥȥ
      real(8), intent(in)   :: xya_data(:,:,:)      ! ʻ(im,jm,*)
      real(8)               :: wa_xya((nm+1)*(nm+1),size(xya_data,3))  ! ڥȥ
      integer, intent(in), optional  :: ipow        ! Ѥ 1/cos μ
      integer, intent(in), optional  :: iflag       ! Ѵμ

      integer, parameter  :: ipow_default  = 0      ! åǥե
      integer, parameter  :: iflag_default = 0      ! åǥե

      integer ipval, ifval
      integer k

      logical :: first=.true.                     ! Ƚꥹå
      save first

      if (present(ipow)) then
         ipval = ipow
      else
         ipval = ipow_default
      endif

      if (present(iflag)) then
         ifval = iflag
      else
         ifval = iflag_default
      endif

      k = size(xya_data,3)
      if ( k > km ) then
         call MessageNotify('E','wa_xya','Size of 3rd dimension invalid.')
      endif

      xya_work(1:im,1:jm,1:k) = xya_data

      if ( openmp ) then
         if ( first ) then
            call MessageNotify('M','wa_xya', &
                 'OpenMP routine SNTGOS/SNPACK is used for spherical harmonic transformation.')
         endif
         call sntgos(nm,im,id,jm,k,xya_work,wa_xya,&
              it,t,y,ipk(1:k,:),pk(1:k,:),rk(1:k,:),&
              ia,a,q,ws,ww,wv,ipval,ifval)
      else
         call sntg2s(nm,im,id,jm,jd,k,xya_work,wa_xya,&
              it,t,y,ipk(1:k,:),pk(1:k,:),rk(1:k,:),ia,a,q,ws,ww,ipval,ifval)
      endif
      first = .false.

    end function wa_xya

  end module wa_base_module
