!----------------------------------------------------------------------
!     Copyright (c) 2005 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  eigmatrix ƥȥץ
!
!  2005/01/26  ݹ
!
!  lapack, blas 饤֥꤬ɬ. Debian/GNU Linux + Fujitsu frt ʤ
!      lapack, lapack-deb ѥå򥤥󥹥ȡ뤷, 
!         -llapack -lblas -L/usr/lib/gcc-lib/i386-linux/2.95.4 -lg2c
!      ȤäץĤ٤. 
!
!
program eigmatrix_test

  use eigmatrix
  implicit none

  real(8), dimension(:,:), allocatable  :: amatrix
  real(8), dimension(:),   allocatable  :: eigval_r, eigval_i
  real(8), dimension(:,:), allocatable  :: eigvec_r, eigvec_i
  complex(16), dimension(:),   allocatable  :: cwork
  integer                     :: info
  integer                     :: i, j

!--------------- 3x3  ------------------
!  VALUE = 1, 2, 3
!  VECTOR = (-15,12,4), (-16,13,4), (-4,3,1)

  allocate(amatrix(3,3))
  allocate(eigval_r(3), eigval_i(3))
  allocate(eigvec_r(3,3), eigvec_i(3,3))

  amatrix(:,1) = (/ 33, -24,  -8 /)
  amatrix(:,2) = (/ 16, -10,  -4 /)
  amatrix(:,3) = (/ 72, -57, -17 /)

  call eigen(amatrix,eigval_r,eigval_i,eigvec_r,eigvec_i,info,&
             sort='R',reverse=.true.)


  do i=1,3
     write(6,*) 'EIGENVALUE  : ', eigval_r(i),eigval_i(i)
     write(6,*) 'EIGENVECTOR : ', (eigvec_r(j,i),eigvec_i(j,i),j=1,3)
  enddo

  deallocate(amatrix)
  deallocate(eigval_r, eigval_i)
  deallocate(eigvec_r, eigvec_i)

!--------------- 4x4  ------------------
!  VALUE = 12, 1+5I, 1-5i, 2
!  VECTOR = (1,-1,1,1), (1,-i,-i,-1), (1,i,i,-1), (1,1,-1,1)

  allocate(amatrix(4,4))
  allocate(eigval_r(4), eigval_i(4))
  allocate(eigvec_r(4,4), eigvec_i(4,4))
  allocate(cwork(4))

  amatrix(:,1) = (/  4,  0,  5,  3 /)
  amatrix(:,2) = (/ -5,  4, -3,  0 /)
  amatrix(:,3) = (/  0, -3,  4,  5 /)
  amatrix(:,4) = (/  3, -5,  0,  4 /)

  call eigen(amatrix,eigval_r,eigval_i,eigvec_r,eigvec_i,info,&
            sort='RA')

  do i=4,1,-1
     cwork = (eigvec_r(i,:)+(0,1)*eigvec_i(i,:))&
          /(eigvec_r(1,:)+(0,1)*eigvec_i(1,:))
     eigvec_r(i,:) = real(cwork)
     eigvec_i(i,:) = imag(cwork)
  enddo

  do i=1,4
     write(6,*) 'EIGENVALUE  : ', eigval_r(i),eigval_i(i)
     write(6,*) 'EIGENVECTOR : '
     do j=1,4
        write(6,*) eigvec_r(j,i),eigvec_i(j,i)
     enddo
  enddo

  deallocate(amatrix)
  deallocate(eigval_r, eigval_i)
  deallocate(eigvec_r, eigvec_i)

end program eigmatrix_test

