!----------------------------------------------------------------------
!     Copyright (c) 2002-2005 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  wt_module
!
!  2002/05/19  ݹ  yt_module ⥸塼̾ѹ.
!                            ʻ̤ɬפ뤿. 
!      2002/06/10  ݹ  ݥ뼧춭롼ɲ
!      2002/11/10  ݹ  ¶֤Ǥζ롼ɲ
!      2002/11/24  ݹ  ӥշϤ
!                            ץ饷ղ򤭥롼ɲ
!      2002/11/28  ݹ  VGradV η׻ѹ.
!      2005/01/09  ݹ  msgdmp -> MessageNotify ѹ
!      2005/01/09  ݹ  ٥ȥβžγʬ׻ؿɲ.
!      2005/02/19  ݹ  ȥǴ嶭ˤ®پ
!                             Ϳ褦˥ץɲ
!      2005/02/19  ݹ  ѿ xy_Lon, xy_Lat ɲ
!      2005/03/18  ݹ  ʬʿѴؿɲ
!                            z_IntLon_xz, x_IntRad_xz, IntLonRad_xz
!                            z_InRad_xz, y_IntRad_yz, IntLatRad_yz
!                            IntRad_z 
!                            z_IntLon_xz, x_IntRad_xz, IntLonRad_xz
!                            z_InRad_xz, y_IntRad_yz, IntLatRad_yz
!                            IntRad_z 
!      2005/04/24  ݹ  ڥȥϷ׻롼ɲ
!                            nmz_ToroidalEnergySpectrum_wt
!                            nz_ToroidalEnergySpectrum_wt
!                            nmz_PoloidalEnergySpectrum_wt
!                            nz_PoloidalEnergySpectrum_wt
!                            ѿ» wt_VMiss ɲ
!      2005/07/09  ݹ  OPENMP Ѵ롼б
!
!
!      ǡ index
!        x :          y :         z : ư
!        w : Ĵ´ؿڥȥ
!        n : Ĵ´ؿڥȥ(ʿȿ)
!        m : Ĵ´ؿڥȥ(Ӿȿ)
!        t : ӥմؿڥȥ
!        a : Ǥդμ
!
!        xyz : 3 ʻǡ
!        xy  : ʿ 2 ʻǡ
!        yz  : Ҹ 2 ʻǡ
!        xz  :  2 ʻǡ
!
!        wz  : ʿڥȥư³ʻǡ
!        wt  : ڥȥǡ
!
module wt_module

  use dc_message
  use lumatrix
  use wa_module
  use at_module, z_RAD => g_X, z_RAD_WEIGHT => g_X_WEIGHT, &
                 at_az => at_ag, az_at => ag_at, &
                 t_Dr_t => t_Dx_t, at_Dr_at => at_Dx_at
  implicit none
  private

  public wt_Initial

  public x_Lon, x_Lon_Weight
  public y_Lat, y_Lat_Weight
  public z_Rad, z_Rad_Weight
  public l_nm, nm_l
  public xy_Lon, xy_Lat
  public xyz_Lon, xyz_Lat, xyz_Rad
  public wz_Rad
  public wt_VMiss

  public w_xy, xy_w
  public at_Dr_at, t_Dr_t, az_at, at_az
  public xyz_wt, wt_xyz, xyz_wz, wz_xyz, wz_wt, wt_wz
  public wt_DRad_wt, wt_DivRad_wt, wt_RotRad_wt, wt_Lapla_wt
  public xyz_GradLon_wt, xyz_gradlat_wt
  public wt_DivLon_xyz, wt_DivLat_xyz
  public wt_Div_xyz_xyz_xyz, xyz_Div_xyz_xyz_xyz
  public xyz_RotLon_wt_wt, xyz_RotLat_wt_wt, wt_RotRad_xyz_xyz

  public yz_IntLon_xyz, xz_IntLat_xyz, xy_IntRad_xyz
  public x_IntLatRad_xyz, y_IntLonRad_xyz, z_IntLonLat_xyz
  public IntLonLatRad_xyz

  public x_IntLat_xy, y_IntLon_xy, IntLonLat_xy
  public z_IntLat_yz, y_IntRad_yz, IntLatRad_yz
  public z_IntLon_xz, x_IntRad_xz, IntLonRad_xz
  public IntLon_x, IntLat_y, IntRad_z

  public yz_AvrLon_xyz, xz_AvrLat_xyz, xy_AvrRad_xyz
  public x_AvrLatRad_xyz, y_AvrLonRad_xyz, z_AvrLonLat_xyz
  public AvrLonLatRad_xyz

  public x_AvrLat_xy, y_AvrLon_xy, AvrLonLat_xy
  public z_AvrLat_yz, y_AvrRad_yz, AvrLatRad_yz
  public z_AvrLon_xz, x_AvrRad_xz, AvrLonRad_xz
  public AvrLon_x, AvrLat_y, AvrRad_z

  public wt_KxRGrad_wt, xyz_KGrad_wt, wt_L2_wt, wt_L2Inv_wt, wt_QOperator_wt
  public wt_RadRot_xyz_xyz, wt_RadRotRot_xyz_xyz_xyz
  public wt_Potential2vector, wt_Potential2Rotation
  public wt_VGradV

  public nmz_ToroidalEnergySpectrum_wt, nz_ToroidalEnergySpectrum_wt
  public nmz_PoloidalEnergySpectrum_wt, nz_PoloidalEnergySpectrum_wt

  public wt_Boundaries, wt_TorBoundaries, wz_LaplaPol2Pol_wz
  public wt_TormagBoundaries, wt_PolmagBoundaries

  public wt_BoundariesTau, wt_TorBoundariesTau
  public wt_TormagBoundariesTau, wt_PolmagBoundariesTau

  public wt_BoundariesGrid, wt_TorBoundariesGrid, wt_LaplaPol2PolGrid_wt
  public wt_TormagBoundariesGrid, wt_PolmagBoundariesGrid

  interface wt_Boundaries
     module procedure wt_BoundariesTau
  end interface

  interface wt_TorBoundaries
     module procedure wt_TorBoundariesTau
  end interface

  interface wt_TorMagBoundaries
     module procedure wt_TorMagBoundariesTau
  end interface

  interface wt_PolMagBoundaries
     module procedure wt_PolMagBoundariesTau
  end interface

  integer            :: im=64, jm=32, km=16  ! ʻ(, , ư)
  integer            :: nm=21, lm=16         ! ȿ(ʿ, ư)
  real(8)            :: ri=0.0, ro=1.0       ! ⳰Ⱦ
  real(8), parameter :: pi=3.1415926535897932385D0

  real(8), dimension(:,:,:), allocatable :: xyz_LON, xyz_LAT, xyz_RAD ! ɸ
  real(8), dimension(:,:), allocatable   :: wz_RAD                    ! ɸ

  real(8) :: wt_VMiss = -999.0        ! »

  save im, jm, km, nm, lm, ri, ro

  contains
  !---------------  -----------------
    subroutine wt_Initial(i,j,k,n,l,r_in,r_out,np)

     integer,intent(in) :: i, j, k        ! ʻ(, , ư)
     integer,intent(in) :: n, l           ! ȿ(ʿ, ư)

     real(8),intent(in) :: r_in, r_out    ! ⳰Ⱦ

     integer,intent(in), optional :: np   ! OPENMP Ǥκ祹åɿ

     im = i  ; jm = j ; km = k
     nm = n  ; lm = l
     ri = r_in ; ro = r_out

     if ( present(np) ) then
        call wa_Initial(nm,im,jm,km+1,np)
     else
        call wa_Initial(nm,im,jm,km+1)
     endif

     call at_Initial(km,lm,r_in,r_out)

     allocate(xyz_Lon(im,jm,0:km))
     allocate(xyz_Lat(im,jm,0:km))
     allocate(xyz_Rad(im,jm,0:km))

     allocate(wz_Rad((nm+1)*(nm+1),0:km))

     xyz_Lon = spread(xy_Lon,3,km+1)
     xyz_Lat = spread(xy_Lat,3,km+1)
     xyz_Rad = spread(spread(z_Rad,1,jm),1,im)

     wz_Rad = spread(z_Rad,1,(nm+1)*(nm+1))

     z_Rad_Weight = z_Rad_Weight * z_Rad**2       ! r^2 dr ʬŤ
   end subroutine wt_initial

  !--------------- Ѵ -----------------

    function xyz_wt(wt)  ! ڥȥ -> ʻ
      real(8), dimension(im,jm,0:km)                     :: xyz_wt
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt

      xyz_wt = xya_wa(az_at(wt))

    end function xyz_wt

    function wt_xyz(xyz)  ! ʻ -> ڥȥ
      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wt_xyz
      real(8), dimension(im,jm,0:km), intent(in)         :: xyz

      wt_xyz = at_az(wa_xya(xyz))

    end function wt_xyz

    function xyz_wz(wz)  ! ʿڥȥ -> ʻ
      real(8), dimension(im,jm,0:km)                     :: xyz_wz
      real(8), dimension((nm+1)*(nm+1),0:km), intent(in) :: wz

      xyz_wz = xya_wa(wz)

    end function xyz_wz

    function wz_xyz(xyz)  ! ʻ -> ʿڥȥ
      real(8), dimension((nm+1)*(nm+1),0:km)             :: wz_xyz
      real(8), dimension(im,jm,0:km), intent(in)         :: xyz

      wz_xyz = wa_xya(xyz)

    end function wz_xyz

    function wz_wt(wt)  ! ڥȥ -> ʿڥȥ
      real(8), dimension((nm+1)*(nm+1),0:km)             :: wz_wt
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt

      wz_wt = az_at(wt)

    end function wz_wt

    function wt_wz(wz)  ! ʿڥȥ -> ڥȥ
      real(8), dimension((nm+1)*(nm+1),0:km)             :: wt_wz
      real(8), dimension((nm+1)*(nm+1),0:km), intent(in) :: wz

      wt_wz = at_az(wz)

    end function wt_wz

  !--------------- ʬ׻ -----------------
    function wt_DRad_wt(wt)     ! ưʬ
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wt_DRad_wt

      wt_DRad_wt = at_Dr_at(wt)

    end function wt_DRad_wt

    function wt_DivRad_wt(wt)    ! ȯưʬ 
                                 ! 1/r^2 /r r^2 = /r + 2/r 
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wt_DivRad_wt

      wt_DivRad_wt = wt_Drad_wt(wt) + wt_wz(2/wz_rad*wz_wt(wt))

    end function wt_DivRad_wt

    function wt_RotRad_wt(wt)    ! žưʬ 
                                 ! 1/r (r.)/r = ./r + 1x./r 
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wt_RotRad_wt

      wt_RotRad_wt = wt_Drad_wt(wt) + wt_wz(1/wz_Rad*wz_wt(wt))

    end function wt_RotRad_wt

    function wt_Lapla_wt(wt)     ! ץ饷
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wt_Lapla_wt

      wt_Lapla_wt = wt_DivRad_wt(wt_Drad_wt(wt)) &
                   + wt_wz(wz_wt(wa_Lapla_wa(wt))/wz_Rad**2)

    end function wt_Lapla_wt

    function xyz_GradLon_wt(wt) ! ڥȥ˺Ѥ۷ʬ
                                ! 1/rcosա/ߦ
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      real(8), dimension(im,jm,0:km)                     :: xyz_GradLon_wt

      xyz_GradLon_wt = xya_GradLon_wa(wz_wt(wt))/xyz_Rad

    end function xyz_GradLon_wt

    function xyz_GradLat_wt(wt) ! ڥȥ˺Ѥ۷ʬ
                                ! 1/r /ߦ
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      real(8), dimension(im,jm,0:km)                     :: xyz_GradLat_wt

      xyz_GradLat_wt = xya_GradLat_wa(wz_wt(wt))/xyz_Rad
    end function xyz_GradLat_wt

    function wt_DivLon_xyz(xyz)   ! ʻҤ˺Ѥȯʬ 
                                  ! 1/rcosա/ߦ

      real(8), dimension(im,jm,0:km), intent(in)   :: xyz
      real(8), dimension((nm+1)*(nm+1),0:lm)       :: wt_DivLon_xyz

      wt_DivLon_xyz = wt_wz(wa_DivLon_xya(xyz/xyz_Rad))
    end function wt_DivLon_xyz

    function wt_DivLat_xyz(xyz)   ! ʻҤ˺Ѥȯʬ
                                  ! 1/rcosա(f cos)/ߦ

      real(8), dimension(im,jm,0:km), intent(in)   :: xyz
      real(8), dimension((nm+1)*(nm+1),0:lm)       :: wt_DivLat_xyz

      wt_DivLat_xyz = wt_wz(wa_divlat_xya(xyz/xyz_Rad))
    end function wt_DivLat_xyz

    function wt_Div_xyz_xyz_xyz(xyz_Vlon,xyz_Vlat,xyz_Vrad) ! ȯ

      real(8), dimension(im,jm,0:km), intent(in) :: xyz_Vlon   ! ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyz_Vlat   ! ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyz_Vrad   ! ưʬ
      real(8), dimension((nm+1)*(nm+1),0:lm)     :: wt_Div_xyz_xyz_xyz

      wt_Div_xyz_xyz_xyz =   wt_DivLon_xyz(xyz_Vlon) &
                           + wt_DivLat_xyz(xyz_Vlat) &
                           + wt_DivRad_wt(wt_xyz(xyz_Vrad))

    end function wt_Div_xyz_xyz_xyz

    function xyz_Div_xyz_xyz_xyz(xyz_Vlon,xyz_Vlat,xyz_Vrad) ! ȯ
      !
      ! ˤð򤹤뤿˥٥ȥ cos/r νŤߤ򤫤
      ! ׻Ƥ. 
      !      div V = (r/cos)div (Vcos/r) + V_tan/r + V_r/r
      ! 
      real(8), dimension(im,jm,0:km), intent(in) :: xyz_Vlon   ! ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyz_Vlat   ! ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyz_Vrad   ! ưʬ
      real(8), dimension(im,jm,0:km)             :: xyz_Div_xyz_xyz_xyz

      xyz_Div_xyz_xyz_xyz &
           = xyz_Rad/cos(xyz_Lat) &
                * xyz_wt(wt_Div_xyz_xyz_xyz(xyz_VLon*cos(xyz_Lat)/xyz_Rad,  &
                                            xyz_VLat*cos(xyz_Lat)/xyz_Rad,  &
                                            xyz_VRad*cos(xyz_Lat)/xyz_Rad ))&
             + xyz_VLat*tan(xyz_Lat)/xyz_Rad &
             + xyz_VRad/xyz_Rad

    end function xyz_Div_xyz_xyz_xyz

    function xyz_RotLon_wt_wt(wt_Vrad,wt_Vlat) 
      ! ٥ȥβžηʬ
      ! 1/rcosաVrad/ߦ-1/r (r Vlat)/r

        real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt_Vrad ! ưʬ
        real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt_Vlat ! ʬ

        real(8), dimension(im,jm,0:km)                     :: xyz_RotLon_wt_wt

        xyz_RotLon_wt_wt =   xyz_GradLon_wt(wt_Vrad) &
                           - xyz_wt(wt_RotRad_wt(wt_Vlat))

    end function xyz_RotLon_wt_wt

    function xyz_RotLat_wt_wt(wt_Vlon,wt_Vrad) 
       ! ٥ȥβžΰʬ
       ! 1/r (r Vlon)/r -  1/r Vrad/ߦ

        real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt_Vlon ! ʬ
        real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt_Vrad ! ưʬ

        real(8), dimension(im,jm,0:km)                     :: xyz_RotLat_wt_wt

        xyz_RotLat_wt_wt =   xyz_wt(wt_RotRad_wt(wt_Vlon)) &
                           - xyz_GradLat_wt(wt_Vrad) 

    end function xyz_RotLat_wt_wt

    function wt_RotRad_xyz_xyz(xyz_Vlat,xyz_Vlon) 
      ! ٥ȥβžưʬ
      ! 1/rcosաVlat/ߦ - 1/rcosա(Vlon cos)/ߦ

        real(8), dimension(im,jm,0:km), intent(in) :: xyz_Vlat
        real(8), dimension(im,jm,0:km), intent(in) :: xyz_Vlon
        real(8), dimension((nm+1)*(nm+1),0:lm)     :: wt_RotRad_xyz_xyz

        wt_RotRad_xyz_xyz =   wt_DivLon_xyz(xyz_Vlat) &
                            - wt_DivLat_xyz(xyz_Vlon)

    end function wt_RotRad_xyz_xyz

  !--------------- ʬ׻ -----------------
    !----(ϥǡ xyz)---
    function yz_IntLon_xyz(xyz)  ! (Ӿ)ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyz    ! 3 ʻǡ
      real(8), dimension(jm,0:km)  :: yz_IntLon_xyz        ! Ҹ̳ʻǡ
      integer :: i

      yz_IntLon_xyz = 0.0d0
      do i=1,im
         yz_IntLon_xyz(:,:) = yz_IntLon_xyz(:,:) &
                       + xyz(i,:,:) * x_Lon_Weight(i)
      enddo
    end function yz_IntLon_xyz

    function xz_IntLat_xyz(xyz)  ! ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyz    ! 3 ʻǡ
      real(8), dimension(im,0:km)  :: xz_IntLat_xyz        ! ٱ߳ʻǡ
      integer :: j

      xz_IntLat_xyz = 0.0d0
      do j=1,jm
         xz_IntLat_xyz(:,:) = xz_IntLat_xyz(:,:) &
                       + xyz(:,j,:) * y_Lat_Weight(j)
      enddo
    end function xz_IntLat_xyz

    function xy_IntRad_xyz(xyz)  ! ưʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyz    ! 3 ʻǡ
      real(8), dimension(im,jm)  :: xy_IntRad_xyz          ! ʿʻǡ
      integer :: k

      xy_IntRad_xyz = 0.0d0
      do k=0,km
         xy_IntRad_xyz(:,:) = xy_IntRad_xyz(:,:) &
                       + xyz(:,:,k) * z_Rad_Weight(k) 
      enddo
    end function xy_IntRad_xyz

    function x_IntLatRad_xyz(xyz)  ! ư(Ҹ)ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyz    ! 3 ʻǡ
      real(8), dimension(im)     :: x_IntLatRad_xyz      ! ٳʻǡ
      integer :: j, k

      x_IntLatRad_xyz = 0
      do k=0,km
         do j=1,jm
            x_IntLatRad_xyz = x_IntLatRad_xyz &
                 + xyz(:,j,k) * y_Lat_Weight(j) * z_Rad_Weight(k)
         enddo
      enddo
    end function x_IntLatRad_xyz

    function y_IntLonRad_xyz(xyz)  ! ư(ٱ)ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyz    ! 3 ʻǡ
      real(8), dimension(jm)       :: y_IntLonRad_xyz      ! ٳʻǡ
      integer :: i, k

      y_IntLonRad_xyz = 0
      do k=0,km
         do i=1,im
            y_IntLonRad_xyz = y_IntLonRad_xyz &
                 + xyz(i,:,k) * x_Lon_Weight(i) * z_Rad_Weight(k)
         enddo
      enddo
    end function y_IntLonRad_xyz

    function z_IntLonLat_xyz(xyz)  ! ٷ(ʿ)ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyz    ! 3 ʻǡ
      real(8), dimension(0:km)     :: z_IntLonLat_xyz      ! ư³ʻǡ
      integer :: i, j

      z_IntLonLat_xyz = 0
      do j=1,jm
         do i=1,im
            z_IntLonLat_xyz = z_IntLonLat_xyz &
                 + xyz(i,j,:) * x_Lon_Weight(i) * y_Lat_Weight(j)
         enddo
      enddo
    end function z_IntLonLat_xyz

    function IntLonLatRad_xyz(xyz) ! ٷư()ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyz    ! 3 ʻǡ
      real(8)                     :: IntLonLatRad_xyz      ! ʬ
      integer :: i, j, k

      IntLonLatRad_xyz = 0
      do k=0,km
         do j=1,jm
            do i=1,im
               IntLonLatRad_xyz = IntLonLatRad_xyz &
                    + xyz(i,j,k) * x_Lon_Weight(i) &
                         * y_Lat_Weight(j) * z_Rad_Weight(k)
            enddo
         enddo
      enddo
    end function IntLonLatRad_xyz

    !----(ϥǡ yz)---
    function z_IntLat_yz(yz)  ! ʬ
      real(8), dimension(jm,0:km), intent(in) :: yz   ! 2 ʻǡ
      real(8), dimension(0:km)  :: z_IntLat_yz        ! ư³ʻǡ
      integer :: j

      z_IntLat_yz = 0.0d0
      do j=1,jm
         z_IntLat_yz(:) = z_IntLat_yz(:) + yz(j,:) * y_Lat_Weight(j)
      enddo
    end function z_IntLat_yz

    function y_IntRad_yz(yz)  ! ưʬ
      real(8), dimension(jm,0:km), intent(in) :: yz    ! 2 ʻǡ
      real(8), dimension(jm)  :: y_IntRad_yz           ! ٱ߳ʻǡ
      integer :: k

      y_IntRad_yz = 0.0d0
      do k=0,km
         y_IntRad_yz(:) = y_IntRad_yz(:) &
                       + yz(:,k) * z_Rad_Weight(k) 
      enddo
    end function y_IntRad_yz

    function IntLatRad_yz(yz)  ! ư(Ҹ)ʬ
      real(8), dimension(jm,0:km), intent(in) :: yz  ! Ҹ̳ʻǡ
      real(8)                   :: IntLatRad_yz      ! ʬ
      integer :: j, k

      IntLatRad_yz = 0
      do k=0,km
         do j=1,jm
            IntLatRad_yz = IntLatRad_yz &
                 + yz(j,k) * y_Lat_Weight(j) * z_Rad_Weight(k)
         enddo
      enddo
    end function IntLatRad_yz

    !----(ϥǡ xz)---
    function z_IntLon_xz(xz)  ! (Ӿ)ʬ
      real(8), dimension(im,0:km), intent(in) :: xz   ! 2 ʻǡ
      real(8), dimension(0:km)  :: z_IntLon_xz        ! ľʻǡ
      integer :: i

      z_IntLon_xz = 0.0d0
      do i=1,im
         z_IntLon_xz(:) = z_IntLon_xz(:) + xz(i,:) * x_Lon_Weight(i)
      enddo
    end function z_IntLon_xz

    function x_IntRad_xz(xz)  ! ưʬ
      real(8), dimension(im,0:km), intent(in) :: xz    ! 2 ʻǡ
      real(8), dimension(im)  :: x_IntRad_xz           ! ٳʻǡ
      integer :: k

      x_IntRad_xz = 0.0d0
      do k=0,km
         x_IntRad_xz(:) = x_IntRad_xz(:) &
                       + xz(:,k) * z_Rad_Weight(k) 
      enddo
    end function x_IntRad_xz

    function IntLonRad_xz(xz)  ! ư(ٱ)ʬ
      real(8), dimension(im,0:km), intent(in) :: xz    ! 2 ʻǡ
      real(8)                                 :: IntLonRad_xz      ! ʬ
      integer :: i, k

      IntLonRad_xz = 0
      do k=0,km
         do i=1,im
            IntLonRad_xz = IntLonRad_xz &
                 + xz(i,k) * x_Lon_Weight(i) * z_Rad_Weight(k)
         enddo
      enddo
    end function IntLonRad_xz

    !----(ϥǡ z)---
    function IntRad_z(z)  ! ưʬ
      real(8), dimension(0:km), intent(in) :: z    ! 2 ʻǡ
      real(8)                              :: IntRad_z   ! ٳʻǡ
      integer :: k

      IntRad_z = 0.0d0
      do k=0,km
         IntRad_z = IntRad_z + z(k) * z_Rad_Weight(k) 
      enddo
    end function IntRad_z

  !--------------- ʿѷ׻ -----------------
    !----(ϥǡ xyz)---
    function yz_AvrLon_xyz(xyz)  ! (Ӿ)ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyz    ! 3 ʻǡ
      real(8), dimension(jm,0:km)  :: yz_AvrLon_xyz        ! Ҹ̳ʻǡ

      yz_AvrLon_xyz = yz_IntLon_xyz(xyz)/sum(x_Lon_Weight)

    end function yz_AvrLon_xyz

    function xz_AvrLat_xyz(xyz)  ! ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyz    ! 3 ʻǡ
      real(8), dimension(im,0:km)  :: xz_AvrLat_xyz        ! ٱ߳ʻǡ

      xz_AvrLat_xyz = xz_IntLat_xyz(xyz)/sum(y_Lat_Weight)

    end function xz_AvrLat_xyz

    function xy_AvrRad_xyz(xyz)  ! ưʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyz    ! 3 ʻǡ
      real(8), dimension(im,jm)  :: xy_AvrRad_xyz          ! ʿʻǡ

      xy_AvrRad_xyz = xy_IntRad_xyz(xyz)/sum(z_Rad_Weight)

    end function xy_AvrRad_xyz

    function x_AvrLatRad_xyz(xyz)  ! ư(Ҹ)ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyz    ! 3 ʻǡ
      real(8), dimension(im)     :: x_AvrLatRad_xyz      ! ٳʻǡ

      x_AvrLatRad_xyz = x_IntLatRad_xyz(xyz) &
                   /( sum(y_Lat_Weight)*sum(z_Rad_Weight) )

    end function x_AvrLatRad_xyz

    function y_AvrLonRad_xyz(xyz)  ! ư(ٱ)ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyz    ! 3 ʻǡ
      real(8), dimension(jm)       :: y_AvrLonRad_xyz      ! ٳʻǡ

      y_AvrLonRad_xyz = y_IntLonRad_xyz(xyz) &
                 /(sum(x_Lon_Weight)*sum(z_Rad_Weight))

    end function y_AvrLonRad_xyz

    function z_AvrLonLat_xyz(xyz)  ! ٷ(ʿ)ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyz    ! 3 ʻǡ
      real(8), dimension(0:km)     :: z_AvrLonLat_xyz      ! ư³ʻǡ

      z_AvrLonLat_xyz = z_IntLonLat_xyz(xyz) &
                 /(sum(x_Lon_Weight)*sum(y_Lat_Weight))

    end function z_AvrLonLat_xyz

    function AvrLonLatRad_xyz(xyz) ! ٷư()ʬ
      real(8), dimension(im,jm,0:km), intent(in) :: xyz    ! 3 ʻǡ
      real(8)                     :: AvrLonLatRad_xyz      ! ʿ

      AvrLonLatRad_xyz = IntLonLatRad_xyz(xyz) &
            /(sum(x_Lon_Weight)*sum(y_Lat_Weight) * sum(z_Rad_Weight))

    end function AvrLonLatRad_xyz

    !----(ϥǡ yz)---
    function z_AvrLat_yz(yz)  ! ʬ
      real(8), dimension(jm,0:km), intent(in) :: yz   ! 2 ʻǡ
      real(8), dimension(0:km)  :: z_AvrLat_yz        ! ư³ʻǡ

      z_AvrLat_yz = z_IntLat_yz(yz)/sum(y_Lat_Weight)
    end function z_AvrLat_yz

    function y_AvrRad_yz(yz)  ! ưʬ
      real(8), dimension(jm,0:km), intent(in) :: yz    ! 2 ʻǡ
      real(8), dimension(jm)  :: y_AvrRad_yz           ! ٱ߳ʻǡ

      y_AvrRad_yz = y_IntRad_yz(yz)/sum(z_Rad_Weight)

    end function y_AvrRad_yz

    function AvrLatRad_yz(yz)  ! ư(Ҹ)ʬ
      real(8), dimension(jm,0:km), intent(in) :: yz  ! Ҹ̳ʻǡ
      real(8)                   :: AvrLatRad_yz      ! ʬ

      AvrLatRad_yz = IntLatRad_yz(yz)/(sum(y_Lat_Weight)*sum(z_Rad_Weight))

    end function AvrLatRad_yz

    !----(ϥǡ xz)---
    function z_AvrLon_xz(xz)  ! (Ӿ)ʬ
      real(8), dimension(im,0:km), intent(in) :: xz   ! 2 ʻǡ
      real(8), dimension(0:km)  :: z_AvrLon_xz        ! ľʻǡ

      z_AvrLon_xz = z_IntLon_xz(xz)/sum(x_Lon_Weight)

    end function z_AvrLon_xz

    function x_AvrRad_xz(xz)  ! ưʬ
      real(8), dimension(im,0:km), intent(in) :: xz    ! 2 ʻǡ
      real(8), dimension(im)  :: x_AvrRad_xz           ! ٳʻǡ

      x_AvrRad_xz = x_IntRad_xz(xz)/sum(z_Rad_Weight)

    end function x_AvrRad_xz

    function AvrLonRad_xz(xz)  ! ư(ٱ)ʬ
      real(8), dimension(im,0:km), intent(in) :: xz    ! 2 ʻǡ
      real(8)                                 :: AvrLonRad_xz      ! ʬ

      AvrLonRad_xz = IntLonRad_xz(xz)/(sum(x_Lon_Weight)*sum(z_Rad_Weight))

    end function AvrLonRad_xz

    !----(ϥǡ z)---
    function AvrRad_z(z)  ! ưʬ
      real(8), dimension(im,0:km), intent(in) :: z    ! 2 ʻǡ
      real(8)                                 :: AvrRad_z   ! ٳʻǡ

      AvrRad_z = IntRad_z(z)/sum(z_Rad_Weight)

    end function AvrRad_z

  !--------------- ݥ/ȥǥʬ -----------------

    function wt_KxRGrad_wt(wt)    ! kr = /ߦ
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wt_KxRGrad_wt

      wt_KxRGrad_wt =  wa_Dlon_wa(wt)
    end function wt_KxRGrad_wt

    function xyz_KGrad_wt(wt)    ! k = cos/r /ߦ + sinբ/r
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      real(8), dimension(im,jm,0:km)                     :: xyz_KGrad_wt

      xyz_KGrad_wt =  cos(xyz_Lat)*xyz_GradLat_wt(wt) &
                    + sin(xyz_Lat)*xyz_wt(wt_Drad_wt(wt))
    end function xyz_KGrad_wt

    function wt_L2_wt(wt)    ! L2 黻 = -ʿץ饷 
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wt_L2_wt

      wt_L2_wt = -wa_Lapla_wa(wt)
    end function wt_L2_wt

    function wt_L2Inv_wt(wt)    ! L2 黻Ҥε = -տʿץ饷 
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wt_L2Inv_wt

      wt_L2Inv_wt = -wa_LaplaInv_wa(wt)
    end function wt_L2Inv_wt

    function wt_QOperator_wt(wt)    ! Q=(k-1/2(L2 k+ kL2))
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wt_QOperator_wt

      wt_QOperator_wt = &
             wt_xyz(xyz_KGrad_wt(wt) - xyz_KGrad_wt(wt_L2_wt(wt))/2) &
           - wt_L2_wt(wt_xyz(xyz_KGrad_wt(wt)))/2

    end function wt_QOperator_wt

    function wt_RadRot_xyz_xyz(xyz_VLON,xyz_VLAT)  ! r(v)
      real(8), dimension(im,jm,0:km), intent(in) :: xyz_VLON
      real(8), dimension(im,jm,0:km), intent(in) :: xyz_VLAT
      real(8), dimension((nm+1)*(nm+1),0:lm)     :: wt_RadRot_xyz_xyz

      wt_RadRot_xyz_xyz = wt_wz(wa_DivLon_xya(xyz_VLAT) &
                                - wa_DivLat_xya(xyz_VLON))
      
    end function wt_RadRot_xyz_xyz

    function wt_RadRotRot_xyz_xyz_xyz(xyz_VLON,xyz_VLAT,xyz_VRAD) 
                                                  ! r(ߢv)
      real(8), dimension(im,jm,0:km), intent(in) :: xyz_VLON
      real(8), dimension(im,jm,0:km), intent(in) :: xyz_VLAT
      real(8), dimension(im,jm,0:km), intent(in) :: xyz_VRAD
      real(8), dimension((nm+1)*(nm+1),0:lm)     :: wt_RadRotRot_xyz_xyz_xyz

      wt_RadRotRot_xyz_xyz_xyz = &
               wt_RotRad_wt(wt_wz( &
                   (wa_DivLon_xya(xyz_VLON)+ wa_DivLat_xya(xyz_VLAT)))) &
             + wt_L2_wt(wt_xyz(xyz_VRAD/xyz_RAD))

    end function wt_RadRotRot_xyz_xyz_xyz

    subroutine wt_Potential2Vector(&
         xyz_VLON,xyz_VLAT,xyz_VRAD,wt_TORPOT,wt_POLPOT)

      ! ȥݥݥƥ󥷥릷,ɽȯ٥ȥ
      !     v = x(r) + xx(r) 
      ! γʬ׻

      real(8), dimension(im,jm,0:km)     :: xyz_VLON   ! ٥ȥ(ʬ)
      real(8), dimension(im,jm,0:km)     :: xyz_VLAT   ! ٥ȥ(ʬ)
      real(8), dimension(im,jm,0:km)     :: xyz_VRAD   ! ٥ȥ(ưʬ)
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) &
                                         :: wt_TORPOT ! ȥݥƥ󥷥
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) &
                                         :: wt_POLPOT ! ݥݥƥ󥷥

      xyz_VLON =   xyz_RAD * xyz_GradLat_wt(wt_TORPOT) &
                 + xya_GradLon_wa(wz_wt(wt_RotRad_wt(wt_POLPOT)))
      xyz_VLAT = - xyz_RAD * xyz_GradLon_wt(wt_TORPOT) &
                 + xya_GradLat_wa(wz_wt(wt_RotRad_wt(wt_POLPOT)))
      xyz_VRAD = xyz_wt(wt_L2_wt(wt_POLPOT))/xyz_RAD

    end subroutine wt_Potential2Vector

    subroutine wt_Potential2Rotation(&
       xyz_RotVLON,xyz_RotVLAT,xyz_RotVRAD,wt_TORPOT,wt_POLPOT)

      ! ȥݥݥƥ󥷥릷,ɽȯ٥ȥ
      !     v = x(r) + xx(r) 
      ! Ф, βž
      !     xv = xx(r) + xxx(r) = xx(r) - x((^2)r)
      ! ׻. 

      ! ٥ȥβž
      real(8), dimension(im,jm,0:km), intent(OUT) :: xyz_RotVLON   ! ʬ
      real(8), dimension(im,jm,0:km), intent(OUT) :: xyz_RotVLAT   ! ʬ
      real(8), dimension(im,jm,0:km), intent(OUT) :: xyz_RotVRAD   ! ưʬ

      ! ϥ٥ȥɽݥƥ󥷥
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) &
                                         :: wt_TORPOT ! ȥݥƥ󥷥
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) &
                                         :: wt_POLPOT ! ݥݥƥ󥷥

      call wt_Potential2Vector( &
           xyz_RotVLON,xyz_RotVLAT,xyz_RotVRAD, &
           -wt_Lapla_wt(wt_POLPOT), wt_TORPOT)

    end subroutine wt_Potential2Rotation

 !------------------- ׻ ----------------------
    subroutine wt_VGradV(xyz_VGRADV_LON,xyz_VGRADV_LAT,xyz_VGRADV_RAD, &
                          xyz_VLON,xyz_VLAT,xyz_VRAD )

      real(8), dimension(im,jm,0:km),intent(out)   :: xyz_VGRADV_LON
      real(8), dimension(im,jm,0:km),intent(out)   :: xyz_VGRADV_LAT
      real(8), dimension(im,jm,0:km),intent(out)   :: xyz_VGRADV_RAD
      real(8), dimension(im,jm,0:km),intent(in)    :: xyz_VLON
      real(8), dimension(im,jm,0:km),intent(in)    :: xyz_VLAT
      real(8), dimension(im,jm,0:km),intent(in)    :: xyz_VRAD

      xyz_VGRADV_LON = &
              xyz_Div_xyz_xyz_xyz( &
                  xyz_VLON * xyz_VLON, xyz_VLON*xyz_VLAT, xyz_VLON*xyz_VRAD ) &
            + xyz_VLON*xyz_VRAD/xyz_RAD              &
            - xyz_VLON*xyz_VLAT*tan(xyz_LAT)/xyz_RAD 

      xyz_VGRADV_LAT = &
              xyz_Div_xyz_xyz_xyz( &
                  xyz_VLAT*xyz_VLON, xyz_VLAT*xyz_VLAT, xyz_VLAT*xyz_VRAD ) &
            + xyz_VLAT*xyz_VRAD/xyz_RAD        &
            + xyz_VLON**2*tan(xyz_LAT)/xyz_RAD 

      xyz_VGRADV_RAD = &
              xyz_Div_xyz_xyz_xyz( &
                  xyz_VRAD*xyz_VLON, xyz_VRAD*xyz_VLAT, xyz_VRAD*xyz_VRAD ) &
            - (xyz_VLON**2 + xyz_VLAT**2)/xyz_RAD 

    end subroutine wt_VGradV

  !--------------- ݥ/ȥǥѥڥȥ ----------------

    function nmz_ToroidalEnergySpectrum_wt(wt_TORPOT)
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) &
           :: wt_TORPOT                       ! ȥݥƥ󥷥
      real(8), dimension(0:nm,-nm:nm,0:km) &
           :: nmz_ToroidalEnergySpectrum_wt   ! ڥȥȥʬ

      real(8), dimension((nm+1)*(nm+1),0:lm) ::wz_DATA   ! ΰ
      integer :: n, m

      nmz_ToroidalEnergySpectrum_wt = wt_VMiss

      wz_DATA = wz_wt(wt_TORPOT)
      do n=0,nm
         do m=-n,n
            nmz_ToroidalEnergySpectrum_wt(n,m,:) &
              = 0.5 * n*(n+1)* (4*pi) * z_Rad**2 &
                * wz_DATA(l_nm(n,m),:)**2
         enddo
      enddo

    end function nmz_ToroidalEnergySpectrum_wt

    function nz_ToroidalEnergySpectrum_wt(wt_TORPOT)
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) &
           :: wt_TORPOT                      ! ȥݥƥ󥷥
      real(8), dimension(0:nm,0:km) &
           :: nz_ToroidalEnergySpectrum_wt   ! ڥȥȥʬ

      real(8), dimension((nm+1)*(nm+1),0:km) ::wz_DATA   ! ΰ
      integer :: n, m

      wz_DATA = wz_wt(wt_TORPOT)
      do n=0,nm
         nz_ToroidalEnergySpectrum_wt(n,:) &
              = 0.5 * n*(n+1)* (4*pi) * z_Rad**2 &
                * sum(wz_Data(l_nm(n,(/(m,m=-n,n)/)),:)**2,1)
      enddo

    end function nz_ToroidalEnergySpectrum_wt

    function nmz_PoloidalEnergySpectrum_wt(wt_POLPOT)
      real(8), dimension((nm+1)*(nm+1),0:km), intent(in) &
           :: wt_POLPOT                      ! ݥݥƥ󥷥
      real(8), dimension(0:nm,-nm:nm,0:km) &
           :: nmz_PoloidalEnergySpectrum_wt   ! ڥȥȥʬ


      real(8), dimension((nm+1)*(nm+1),0:km) ::wz_DATA1   ! ΰ
      real(8), dimension((nm+1)*(nm+1),0:km) ::wz_DATA2   ! ΰ
      integer :: n, m

      nmz_PoloidalEnergySpectrum_wt = wt_VMiss

      wz_Data1 = wz_wt(wt_POLPOT)
      wz_Data2 = wz_Rad*wz_wt(wt_DRad_wt(wt_POLPOT)) &    ! d(r)/dr
               + wz_wt(wt_POLPOT)                         ! = rd/dr+

      do n=0,nm
         do m=-n,n
            nmz_PoloidalEnergySpectrum_wt(n,m,:) = &
                 + 0.5* n*(n+1)* (4*pi) &
                 *( wz_Data2(l_nm(n,m),:)**2  &
                   + n*(n+1)*wz_Data1(l_nm(n,m),:)**2 )
         enddo
      enddo

    end function nmz_PoloidalEnergySpectrum_wt

    function nz_PoloidalEnergySpectrum_wt(wt_POLPOT)
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) &
           :: wt_POLPOT                      ! ݥݥƥ󥷥
      real(8), dimension(0:nm,0:km) &
           :: nz_PoloidalEnergySpectrum_wt   ! ڥȥȥʬ

      real(8), dimension((nm+1)*(nm+1),0:km) ::wz_DATA1   ! ΰ
      real(8), dimension((nm+1)*(nm+1),0:km) ::wz_DATA2   ! ΰ
      integer :: n, m

      wz_Data1 = wz_wt(wt_POLPOT)
      wz_Data2 = wz_Rad*wz_wt(wt_DRad_wt(wt_POLPOT)) &    ! d(r)/dr
               + wz_wt(wt_POLPOT)                         ! = rd/dr+

      do n=0,nm
         nz_PoloidalEnergySpectrum_wt(n,:) = &
              + 0.5* n*(n+1)* (4*pi) &
              *( sum(wz_Data2(l_nm(n,(/(m,m=-n,n)/)),:)**2,1)  &
                + n*(n+1)*sum(wz_Data1(l_nm(n,(/(m,m=-n,n)/)),:)**2,1) )
      enddo

    end function nz_PoloidalEnergySpectrum_wt


  !---------------  -----------------

    subroutine wt_BoundariesTau(wt,values,cond)   ! ǥꥯ, Υޥ
      ! Chebyshev ֤ǤζŬ(ˡ)

      real(8), dimension((nm+1)*(nm+1),0:lm),intent(inout)      :: wt
              ! ŬѤǡ. 줿֤ͤ. 

      real(8), dimension((nm+1)*(nm+1),2), intent(in), optional :: values
              ! Ǥ / ʬۤʿڥȥѴΤͿ. 
              ! ά/ 0 Ȥʤ. 

      character(len=2), intent(in), optional             :: cond
              ! . ά 'DD'
              !   DD : ξüǥꥯ
              !   DN,ND : ǥꥯ/Υޥ
              !   NN : ξüΥޥ

      if (.not. present(cond)) then
         if (present(values)) then
            call at_BoundariesTau_DD(wt,values)
         else
            call at_BoundariesTau_DD(wt)
         endif
         return
      endif

      select case(cond)
      case ('NN')
         if (present(values)) then
            call at_BoundariesTau_NN(wt,values)
         else
            call at_BoundariesTau_NN(wt)
         endif
      case ('DN')
         if (present(values)) then
            call at_BoundariesTau_DN(wt,values)
         else
            call at_BoundariesTau_DN(wt)
         endif
      case ('ND')
         if (present(values)) then
            call at_BoundariesTau_ND(wt,values)
         else
            call at_BoundariesTau_ND(wt)
         endif
      case ('DD')
         if (present(values)) then
            call at_BoundariesTau_DD(wt,values)
         else
            call at_BoundariesTau_DD(wt)
         endif
      case default
         call MessageNotify('E','wt_BoundariesTau','B.C. not supported')
      end select

    end subroutine wt_BoundariesTau

    subroutine wt_BoundariesGrid(wt,values,cond)   ! ǥꥯ, Υޥ
      ! ¶֤ǤζŬ

      real(8), dimension((nm+1)*(nm+1),0:lm),intent(inout)      :: wt
              ! ŬѤǡ. 줿֤ͤ. 

      real(8), dimension((nm+1)*(nm+1),2), intent(in), optional :: values
              ! Ǥ / ʬۤʿڥȥѴΤͿ. 
              ! ά/ 0 Ȥʤ. 

      character(len=2), intent(in), optional             :: cond
              ! . ά 'DD'
              !   DD : ξüǥꥯ
              !   DN,ND : ǥꥯ/Υޥ
              !   NN : ξüΥޥ

      if (.not. present(cond)) then
         if (present(values)) then
            call at_boundariesGrid_DD(wt,values)
         else
            call at_boundariesGrid_DD(wt)
         endif
         return
      endif

      select case(cond)
      case ('NN')
         if (present(values)) then
            call at_BoundariesGrid_NN(wt,values)
         else
            call at_BoundariesGrid_NN(wt)
         endif
      case ('DN')
         if (present(values)) then
            call at_BoundariesGrid_DN(wt,values)
         else
            call at_BoundariesGrid_DN(wt)
         endif
      case ('ND')
         if (present(values)) then
            call at_BoundariesGrid_ND(wt,values)
         else
            call at_BoundariesGrid_ND(wt)
         endif
      case ('DD')
         if (present(values)) then
            call at_BoundariesGrid_DD(wt,values)
         else
            call at_BoundariesGrid_DD(wt)
         endif
      case default
         call MessageNotify('E','wt_BoundariesGrid','B.C. not supported')
      end select

    end subroutine wt_BoundariesGrid

    subroutine wt_TorBoundariesTau(wt_TORPOT,values,cond) 
      ! ȥݥƥ󥷥붭
      ! Chebyshev ֤ǤζŬ
      !  ȥݥƥ󥷥 \psi ζŬ
      ! Ǵ
      !    \psi = values  at boundaries (default 0)
      ! Ϥʤ
      !    \DP{\psi/r}{r} = 0  at boundaries

      real(8), dimension((nm+1)*(nm+1),0:lm),intent(inout)      :: wt_TORPOT
              ! ŬѤǡ. 줿֤ͤ. 

      real(8), dimension((nm+1)*(nm+1),2), intent(in), optional :: values
              ! ξüǤΥȥݥƥ󥷥
              ! ǴλΤͭ

      character(len=2), intent(in), optional  :: cond
              ! 凉å. ά 'RR'
              !   RR    : ξüǴ
              !   RF/FR : Ǵ/Ϥʤ
              !   FF    : ξüϤʤ

      real(8), dimension(:,:), allocatable  :: alu
      integer, dimension(:), allocatable    :: kp
      real(8), dimension(0:lm,0:lm)         :: tt_data
      real(8), dimension(0:lm,0:km)         :: tg_data
      logical                               :: rigid1, rigid2   ! 

      logical :: first = .true.
      integer  :: l
      save     :: alu, kp, first

      if (.not. present(cond)) then
         rigid1=.TRUE. ; rigid2=.TRUE.
      else
         select case (cond)
         case ('RR')
            rigid1 = .TRUE.  ; rigid2 = .TRUE.
         case ('RF')
            rigid1 = .TRUE.  ; rigid2 = .FALSE.
         case ('FR')
            rigid1 = .FALSE. ; rigid2 = .TRUE.
         case ('FF')
            rigid1 = .FALSE. ; rigid2 = .FALSE.
         case default
            call MessageNotify('E','wt_TorBoundariesTau','B.C. not supported')
         end select
      endif

      if ( first ) then
         first = .false.

         allocate(alu(0:lm,0:lm),kp(0:lm))

         tt_data = 0
         do l=0,lm
            tt_data(l,l)=1
         enddo
         alu = tt_data

         ! ϳŪǴ 
         if ( rigid1 ) then
            tg_data = az_at(tt_data)
         else
            tg_data = az_at(at_dr_at(at_az( &
                 az_at(tt_data)/spread(z_rad,1,lm+1))))
         endif
         alu(lm-1,:) = tg_data(:,0)       !  k=0 ǤξＰ

         if ( rigid2 ) then
            tg_data = az_at(tt_data)    
         else
            tg_data = az_at(at_dr_at(at_az( &
                 az_at(tt_data)/spread(z_rad,1,lm+1))))
         endif
         alu(lm,:)   = tg_data(:,km)      !  k=km ǤξＰ

         call ludecomp(alu,kp)

         if ( rigid1 .AND. present(values) ) then 
            call MessageNotify('M','wt_TorBoundariesTau',&
                 'Toroidal potential at k=0 was given by the optional variable.')
         else if ( rigid1 .AND. (.NOT.present(values)) ) then
            call MessageNotify('M','wt_TorBoundariesTau',&
                 'Toroidal potential at k=0 was set to zero.')
         else if ( (.NOT. rigid1) .AND. present(values) ) then
            call MessageNotify('W','wt_TorBoundariesTau',&
                 'Boundary value k=0 cannot be set under stress-free condition.')
         endif

         if ( rigid2 .AND. present(values) ) then 
            call MessageNotify('M','wt_TorBoundariesTau',&
                 'Toroidal potential at k=0 was given by the optional variable.')
         else if ( rigid2 .AND. (.NOT.present(values)) ) then
            call MessageNotify('M','wt_TorBoundariesTau',&
                 'Toroidal potential at k=0 was set to zero.')
         else if ( (.NOT. rigid2) .AND. present(values) ) then
            call MessageNotify('W','wt_TorBoundariesTau',&
                 'Boundary value k=0 cannot be set under stress-free condition.')
         endif
      endif

      if ( rigid1 .AND. present(values) ) then
         wt_torpot(:,lm-1) = values(:,1)
      else
         wt_torpot(:,lm-1) = 0
      endif
      if ( rigid2 .AND. present(values) ) then
         wt_torpot(:,lm)   = values(:,2)
      else
         wt_torpot(:,lm) = 0
      endif

      wt_torpot = lusolve(alu,kp,wt_TORPOT)

    end subroutine wt_TorBoundariesTau

    subroutine wt_TorBoundariesGrid(wt_TORPOT,values,cond) 
      ! ȥݥƥ󥷥붭
      ! ¶֤ǤζŬ
      !  ȥݥƥ󥷥 \psi ζŬ
      ! Ǵ
      !    \psi = values  at boundaries (default 0)
      ! Ϥʤ
      !    \DP{\psi/r}{r} = 0  at boundaries

      real(8), dimension((nm+1)*(nm+1),0:lm),intent(inout)      :: wt_TORPOT
              ! ŬѤǡ. 줿֤ͤ. 

      real(8), dimension((nm+1)*(nm+1),2), intent(in), optional :: values
              ! ξüǤΥȥݥƥ󥷥
              ! ǴλΤͭ

      character(len=2), intent(in), optional  :: cond
              ! 凉å. ά 'RR'
              !   RR    : ξüǴ
              !   RF,FR : Ǵ/Ϥʤ
              !   FF    : ξüϤʤ

      real(8), dimension((nm+1)*(nm+1),0:km):: wz_TORPOT
      real(8), dimension(:,:), allocatable  :: alu
      integer, dimension(:), allocatable    :: kp
      real(8), dimension(0:lm,0:lm)         :: tt_data
      real(8), dimension(0:lm,0:km)         :: tz_data
      logical                               :: rigid1, rigid2   ! 

      logical :: first = .true.
      integer  :: l
      save     :: alu, kp, first

      if (.not. present(cond)) then
         rigid1=.TRUE. ; rigid2=.TRUE.
      else
         select case (cond)
         case ('RR')
            rigid1 = .TRUE.  ; rigid2 = .TRUE.
         case ('RF')
            rigid1 = .TRUE.  ; rigid2 = .FALSE.
         case ('FR')
            rigid1 = .FALSE. ; rigid2 = .TRUE.
         case ('FF')
            rigid1 = .FALSE. ; rigid2 = .FALSE.
         case default
            call MessageNotify('E','wt_TorBoundariesGrid','B.C. not supported')
         end select
      endif

      if ( first ) then
         first = .false.

         if ( lm /= km ) then
            call MessageNotify('E','TorBoundariesGrid', &
             'Chebyshev truncation and number of grid points should be same.')
         endif

         allocate(alu(0:km,0:lm),kp(0:lm))

         tt_data = 0
         do l=0,lm
            tt_data(l,l)=1
         enddo
         tz_data = az_at(tt_data)
         alu = transpose(tz_data)       ! ΰǤͤϤΤޤ

         if ( rigid1 ) then
            tz_data = az_at(tt_data)
         else
            tz_data = az_at(at_dr_at(at_az( &
                 az_at(tt_data)/spread(z_rad,1,lm+1))))
         endif
         alu(0,:) = tz_data(:,0)        !  k=0 ǤξＰ

         if ( rigid2 ) then
            tz_data = az_at(tt_data)
         else
            tz_data = az_at(at_dr_at(at_az( &
                 az_at(tt_data)/spread(z_rad,1,lm+1))))
         endif
         alu(km,:)   = tz_data(:,km)    !  k=km ǤξＰ

         call ludecomp(alu,kp)

         if ( rigid1 .AND. present(values) ) then 
            call MessageNotify('M','wt_TorBoundariesGrid',&
                 'Toroidal potential at k=0 was given by the optional variable.')
         else if ( rigid1 .AND. (.NOT.present(values)) ) then
            call MessageNotify('M','wt_TorBoundariesGrid',&
                 'Toroidal potential at k=0 was set to zero.')
         else if ( (.NOT. rigid1) .AND. present(values) ) then
            call MessageNotify('W','wt_TorBoundariesGrid',&
                 'Boundary value at k=0 cannot be set under stress-free condition.')
         endif

         if ( rigid2 .AND. present(values) ) then 
            call MessageNotify('M','wt_TorBoundariesGrid',&
                 'Toroidal potential at k=km was given by the optional variable.')
         else if ( rigid2 .AND. (.NOT.present(values)) ) then
            call MessageNotify('M','wt_TorBoundariesGrid',&
                 'Toroidal potential at k=km was set to zero.')
         else if ( (.NOT. rigid2) .AND. present(values) ) then
            call MessageNotify('W','wt_TorBoundariesGrid',&
                 'Boundary value at k=km cannot be set under stress-free condition.')
         endif
      endif

      wz_TorPot       = wz_wt(wt_TorPot)

      if ( rigid1 .AND. present(values) ) then
         wz_TorPot(:,0)  = values(:,1)
      else
         wz_TorPot(:,0)  = 0
      endif

      if ( rigid2 .AND. present(values) ) then
         wz_TorPot(:,km) = values(:,2)
      else
         wz_TorPot(:,km) = 0
      endif

      wt_torpot = lusolve(alu,kp,wz_TorPot)

    end subroutine wt_TorBoundariesGrid

    function wz_LaplaPol2Pol_wz(wz,cond)        ! ^2 ݥ
                                                ! ǥեȤǴ
      ! Chebyshev-Collocation ˡˤ׻
      !  f=\nabla^2\phi Ϳƥݥݥƥ󥷥 \phi .
      !    \nabla^2 \phi = f
      !    \phi = const. at boundaries.
      ! Ǵ
      !    \DP{\phi}{r} = 0 at boundaries
      ! Ϥʤ
      !    \DP[2]{\phi}{r} = 0 at boundaries

      !  : ǽ˸ƤФȤζǰʸ׻(׻ѹ)

      real(8), dimension((nm+1)*(nm+1),0:km),intent(in)  :: wz
              ! Ϣ^2ʬ

      real(8), dimension((nm+1)*(nm+1),0:km)             :: wz_LaplaPol2Pol_wz
              ! ϥݥݥƥ󥷥ʬ

      character(len=2), intent(in), optional  :: cond
              ! 凉å. ά 'RR'
              !   RR : ξüǴ
              !   RF,FR : Ǵ/Ϥʤ
              !   FF : ξüϤʤ

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension((nm+1)*(nm+1),0:km)  :: wz_work
      real(8), dimension(0:km,0:km)           :: gg
      real(8), dimension(0:km,0:km)           :: gg_work
      logical                                 :: rigid1, rigid2   ! 

      logical :: first = .true.
      integer :: k,n
      save    :: alu, kp, first

      if (.not. present(cond)) then
         rigid1=.TRUE. ; rigid2=.TRUE.
      else
         select case (cond)
         case ('RR')
            rigid1 = .TRUE.  ; rigid2 = .TRUE.
         case ('RF')
            rigid1 = .TRUE.  ; rigid2 = .FALSE.
         case ('FR')
            rigid1 = .FALSE. ; rigid2 = .TRUE.
         case ('FF')
            rigid1 = .FALSE. ; rigid2 = .FALSE.
         case default
            call MessageNotify('E','wt_laplapol2pol_wt','B.C. not supported')
         end select
      endif

      if ( first ) then
         first = .false.

         if ( lm /= km ) then
            call MessageNotify('E','wz_LaplaPol2Pol_wz', &
             'Chebyshev truncation and number of grid points should be same.')
         endif

         allocate(alu((nm+1)*(nm+1),0:km,0:km),kp((nm+1)*(nm+1),0:km))

         do k=0,km
            wz_work = 0 ; wz_work(:,k) = 1

            ! ƿʿȿ˴ؤΩμ
            alu(:,:,k) = wz_wt(wt_lapla_wt(wt_wz(wz_work)))
         enddo

         ! ưŪ. ή϶ǰ
         gg = 0
         do k=0,km
            gg(k,k)=1
         enddo
         do n=1,(nm+1)*(nm+1)
            alu(n,0,:)   = gg(:,0)
            alu(n,km,:)  = gg(:,km)
         enddo

         ! ϳŪǴ 
         if ( rigid1 ) then
            gg_work=az_at(at_dr_at(at_az(gg)))
         else
            gg_work=az_at(at_dr_at(at_dr_at(at_az(gg))))
         endif
         do n=1,(nm+1)*(nm+1)
            alu(n,1,:) = gg_work(:,0)
         enddo

         ! ϳŪǴ 
         if ( rigid2 ) then
            gg_work=az_at(at_dr_at(at_az(gg)))
         else
            gg_work=az_at(at_dr_at(at_dr_at(at_az(gg))))
         endif
         do n=1,(nm+1)*(nm+1)
            alu(n,km-1,:) = gg_work(:,km)
         enddo

         call ludecomp(alu,kp)
      endif

      wz_work         = wz
      wz_work(:,1)    = 0               ! ϳŪ
      wz_work(:,km-1) = 0               ! ϳŪ
      wz_work(:,0)    = 0               ! ưŪ
      wz_work(:,km)   = 0               ! ưŪ 

      wz_laplapol2pol_wz = lusolve(alu,kp,wz_work)

    end function wz_LaplaPol2Pol_wz

    function wt_LaplaPol2PolGrid_wt(wt,cond)    ! ^2 ݥ
                                                ! ǥեȤǴ
      ! Chebyshev-Collocation ˡˤ׻
      !  f=\nabla^2\phi Ϳƥݥݥƥ󥷥 \phi .
      !    \nabla^2 \phi = f
      !    \phi = const. at boundaries.
      ! Ǵ
      !    \DP{\phi}{r} = 0 at boundaries
      ! Ϥʤ
      !    \DP[2]{\phi}{r} = 0 at boundaries

      !  : ǽ˸ƤФȤζǰʸ׻(׻ѹ)

      real(8), dimension((nm+1)*(nm+1),0:lm),intent(in)  :: wt
              ! Ϣ^2ʬ

      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wt_LaplaPol2PolGrid_wt
              ! ϥݥݥƥ󥷥ʬ

      character(len=2), intent(in), optional  :: cond
              ! 凉å. ά 'RR'
              !   RR : ξüǴ
              !   RF,FR : Ǵ/Ϥʤ
              !   FF : ξüϤʤ

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension((nm+1)*(nm+1),0:km)  :: wz_work
      real(8), dimension((nm+1)*(nm+1),0:lm)  :: wt_work
      real(8), dimension(0:lm,0:lm)           :: tt_I
      real(8), dimension(0:lm,0:km)           :: tz_work
      logical                                 :: rigid1, rigid2   ! 

      logical :: first = .true.
      integer :: l,n
      save    :: alu, kp, first

      if (.not. present(cond)) then
         rigid1=.TRUE. ; rigid2=.TRUE.
      else
         select case (cond)
         case ('RR')
            rigid1 = .TRUE.  ; rigid2 = .TRUE.
         case ('RF')
            rigid1 = .TRUE.  ; rigid2 = .FALSE.
         case ('FR')
            rigid1 = .FALSE. ; rigid2 = .TRUE.
         case ('FF')
            rigid1 = .FALSE. ; rigid2 = .FALSE.
         case default
            call MessageNotify('E','wt_LaplaPol2PolGrid_wt','B.C. not supported')
         end select
      endif

      if ( first ) then
         first = .false.

         if ( lm /= km ) then
            call MessageNotify('E','wt_LaplaPol2PolGrid_wt', &
             'Chebyshev truncation and number of grid points should be same.')
         endif

         allocate(alu((nm+1)*(nm+1),0:km,0:lm),kp((nm+1)*(nm+1),0:lm))

         do l=0,lm
            wt_work = 0 ; wt_work(:,l) = 1

            ! ƿʿȿ˴ؤΩμ
            alu(:,:,l) = wz_wt(wt_Lapla_wt(wt_work))
         enddo

         ! ưŪ. ή϶ǰ
         tt_I = 0.0
         do l=0,lm
            tt_I(l,l)=1
         enddo

         ! ŵƳ
         tz_work = az_at(tt_I)

         do n=1,(nm+1)*(nm+1)
            alu(n,0,:)  = tz_work(:,0)
            alu(n,km,:) = tz_work(:,km)
         enddo

         ! ϳŪǴ 
         if ( rigid1 ) then
            tz_work=az_at(at_Dr_at(tt_I))
         else
            tz_work=az_at(at_Dr_at(at_Dr_at(tt_I)))
         endif
         do n=1,(nm+1)*(nm+1)
            alu(n,1,:) = tz_work(:,0)
         enddo

         ! ϳŪǴ 
         if ( rigid2 ) then
            tz_work=az_at(at_Dr_at(tt_I))
         else
            tz_work=az_at(at_Dr_at(at_Dr_at(tt_I)))
         endif
         do n=1,(nm+1)*(nm+1)
            alu(n,km-1,:) = tz_work(:,km)
         enddo

         call ludecomp(alu,kp)
      endif

      wz_work         = wz_wt(wt)
      wz_work(:,1)    = 0               ! ϳŪ
      wz_work(:,km-1) = 0               ! ϳŪ
      wz_work(:,0)    = 0               ! ưŪ
      wz_work(:,km)   = 0               ! ưŪ 

      wt_LaplaPol2PolGrid_wt = lusolve(alu,kp,wz_work)

    end function wt_LaplaPol2PolGrid_wt

    subroutine wt_TormagBoundariesTau(wt_TOR) ! ȥݥƥ󥷥붭
      ! Chebyshev ֤ǤζŬ
      ! ȥݥƥ󥷥 \psi ζ(ŵƳ)
      ! ¦
      !    wt_psi = 0   at the outer boundary
      ! ¦
      !    wt_psi = 0       at the inner boundary
      ! 
      ! wt_Boundaries бǽ, ΤӺƤ

      real(8), dimension((nm+1)*(nm+1),0:lm),intent(inout)   :: wt_TOR
              ! ŬѤǡ. 줿֤ͤ. 

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension(:,:), allocatable    :: tt_I
      real(8), dimension(:,:), allocatable    :: tz_PSI

      logical :: first = .true.
      integer  :: l, n
      save     :: alu, kp, first

      if ( first ) then
         first = .false.

         allocate(alu((nm+1)*(nm+1),0:lm,0:lm),kp((nm+1)*(nm+1),0:lm))
         allocate(tt_I(0:lm,0:lm),tz_PSI(0:lm,0:km))

         tt_I = 0.0
         do l=0,lm
            tt_I(l,l)=1
         enddo
         do n=1,(nm+1)*(nm+1)
            alu(n,:,:) = tt_I
         enddo

         ! ŵƳ
         tz_PSI = az_at(tt_I)

         do n=1,(nm+1)*(nm+1)
            alu(n,lm-1,:) = tz_PSI(:,0)
            alu(n,lm,:)   = tz_PSI(:,km)
         enddo
         call ludecomp(alu,kp)

         deallocate(tt_I,tz_PSI)
      endif

      wt_TOR(:,lm-1) = 0.0
      wt_TOR(:,lm)   = 0.0
      wt_TOR = lusolve(alu,kp,wt_TOR)

    end subroutine wt_TormagBoundariesTau

    subroutine wt_TormagBoundariesGrid(wt_TOR) ! ȥݥƥ󥷥붭
      ! ľ¶֤ǤζŬ
      ! ȥݥƥ󥷥 \psi ζ(ŵƳ)
      ! ¦
      !    wt_psi = 0   at the outer boundary
      ! ¦
      !    wt_psi = 0       at the inner boundary
      ! 
      ! wt_Boundaries бǽ, ΤӺƤ

      real(8), dimension((nm+1)*(nm+1),0:lm),intent(inout)   :: wt_TOR
              ! ŬѤǡ. 줿֤ͤ. 

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension(:,:), allocatable    :: tt_I
      real(8), dimension(:,:), allocatable    :: tz_PSI
      real(8), dimension((nm+1)*(nm+1),0:km)  :: wz_TOR

      logical :: first = .true.
      integer  :: l, n
      save     :: alu, kp, first

      if ( first ) then
         first = .false.

         if ( lm /= km ) then
            call MessageNotify('E','TorMagBoundariesGrid', &
             'Chebyshev truncation and number of grid points should be same.')
         endif

         allocate(alu((nm+1)*(nm+1),0:km,0:lm),kp((nm+1)*(nm+1),0:lm))
         allocate(tt_I(0:lm,0:lm),tz_PSI(0:lm,0:km))

         tt_I = 0.0
         do l=0,lm
            tt_I(l,l)=1
         enddo
         do n=1,(nm+1)*(nm+1)
            alu(n,:,:) = transpose(az_at(tt_I))   ! ΰͤΤޤ.
         enddo

         ! ŵƳ
         tz_PSI = az_at(tt_I)

         do n=1,(nm+1)*(nm+1)
            alu(n,0,:) = tz_PSI(:,0)
            alu(n,km,:)   = tz_PSI(:,km)
         enddo
         call ludecomp(alu,kp)

         deallocate(tt_I,tz_PSI)
      endif
      
      wz_TOR       = wz_wt(wt_TOR)
      wz_TOR(:,0)  = 0.0
      wz_TOR(:,km) = 0.0
      wt_TOR = lusolve(alu,kp,wz_TOR)

    end subroutine wt_TormagBoundariesGrid

    subroutine wt_PolmagBoundariesTau(wt_POL) ! ݥݥƥ󥷥붭
      ! Chebyshev ֤ǤζŬ
      ! ݥݥƥ󥷥 \psi ζ(ŵƳ)
      ! ¦
      !    \DP{wt_psi}{r} + (l+1) wt_psi/r = 0   at the outer boundary
      ! ¦
      !    \DP{wt_psi}{r} - l wt_psi/r = 0       at the inner boundary

      real(8), dimension((nm+1)*(nm+1),0:lm),intent(inout)   :: wt_POL
              ! ŬѤǡ. 줿֤ͤ. 

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension(:,:), allocatable    :: tt_I
      real(8), dimension(:,:), allocatable    :: tz_PSI
      real(8), dimension(:,:), allocatable    :: tz_DPSIDR

      logical :: first = .true.
      integer  :: l, n, nn(2)
      save     :: alu, kp, first

      if ( first ) then
         first = .false.

         allocate(alu((nm+1)*(nm+1),0:lm,0:lm),kp((nm+1)*(nm+1),0:lm))
         allocate(tt_I(0:lm,0:lm),tz_PSI(0:lm,0:km),tz_DPSIDR(0:lm,0:km))

         tt_I = 0.0
         do l=0,lm
            tt_I(l,l)=1
         enddo
         do n=1,(nm+1)*(nm+1)
            alu(n,:,:) = tt_I
         enddo

         ! ŵƳ
         tz_PSI = az_at(tt_I)
         tz_DPSIDR = az_at(at_dr_at(tt_I))

         do n=1,(nm+1)*(nm+1)
            nn=nm_l(n)
            alu(n,lm-1,:) = tz_DPSIDR(:,0) + (nn(1)+1) * tz_PSI(:,0)/z_RAD(0)
            alu(n,lm,:)   = tz_DPSIDR(:,km) - nn(1) * tz_PSI(:,km)/z_RAD(km)
         enddo
         call ludecomp(alu,kp)

         deallocate(tt_I,tz_PSI,tz_DPSIDR)
      endif

      wt_POL(:,lm-1) = 0.0
      wt_POL(:,lm)   = 0.0
      wt_POL = lusolve(alu,kp,wt_POL)

    end subroutine wt_PolmagBoundariesTau

    subroutine wt_PolmagBoundariesGrid(wt_POL) ! ݥݥƥ󥷥붭
      ! ľ¶֤ǤζŬ
      ! ݥݥƥ󥷥 \psi ζ(ŵƳ)
      ! ¦
      !    \DP{wt_psi}{r} + (l+1) wt_psi/r = 0   at the outer boundary
      ! ¦
      !    \DP{wt_psi}{r} - l wt_psi/r = 0       at the inner boundary

      real(8), dimension((nm+1)*(nm+1),0:lm),intent(inout)   :: wt_POL
              ! ŬѤǡ. 줿֤ͤ. 

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension(:,:), allocatable    :: tt_I
      real(8), dimension(:,:), allocatable    :: tz_PSI
      real(8), dimension(:,:), allocatable    :: tz_DPSIDR
      real(8), dimension((nm+1)*(nm+1),0:km)  :: wz_POL

      logical :: first = .true.
      integer  :: l, n, nn(2)
      save     :: alu, kp, first

      if ( first ) then
         first = .false.

         if ( lm /= km ) then
            call MessageNotify('E','PolMagBoundariesGrid', &
             'Chebyshev truncation and number of grid points should be same.')
         endif

         allocate(alu((nm+1)*(nm+1),0:lm,0:lm),kp((nm+1)*(nm+1),0:lm))
         allocate(tt_I(0:lm,0:lm),tz_PSI(0:lm,0:km),tz_DPSIDR(0:lm,0:km))

         tt_I = 0.0
         do l=0,lm
            tt_I(l,l)=1
         enddo
         do n=1,(nm+1)*(nm+1)
            alu(n,:,:) = transpose(az_at(tt_I))  ! ΰͤ¸
         enddo

         ! ŵƳ
         tz_PSI = az_at(tt_I)
         tz_DPSIDR = az_at(at_dr_at(tt_I))

         do n=1,(nm+1)*(nm+1)
            nn=nm_l(n)
            alu(n,0,:)  = tz_DPSIDR(:,0) + (nn(1)+1) * tz_PSI(:,0)/z_RAD(0)
            alu(n,km,:) = tz_DPSIDR(:,km) - nn(1) * tz_PSI(:,km)/z_RAD(km)
         enddo
         call ludecomp(alu,kp)

         deallocate(tt_I,tz_PSI,tz_DPSIDR)
      endif

      wz_POL       = wz_wt(wt_POL)
      wz_POL(:,0)  = 0.0
      wz_POL(:,km) = 0.0
      wt_POL = lusolve(alu,kp,wz_POL)

    end subroutine wt_PolmagBoundariesGrid

  end module wt_module
