module typhoon_analy  ! ټ¸ѥڥϥ⥸塼

contains

subroutine tangent_mean_scal( x, y, xc, yc, u, r, theta, v )
  ! Ǥդʪ̤濴ʿѤ롼
  ! Υ롼®ʿѤˤѤ뤳ȤϤǤʤ.
  ! ʿѤԤݤˤ, ̤Υ롼, tangent_mean_vec λѤɬ.
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r. 
  ! ʿѲμϰʲΤȤ.
  ! (1) nr, nt Τ٤ƤˤĤƤб x, y ɸͤ rt_2_xy Ƿ׻.
  ! (2) ޤ x,y åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  ! (4) nr x nt Ĥޥ顼ͤޤä, nt ʿѷ׻ mean_1d .
  ! ʾǳ nr ˤĤʿͤ.
  use analy
  use max_min
  use statistics
  use Geometry
  implicit none
  real, intent(in) :: x(:)  ! ǥȺɸϤǤ x ɸ
  real, intent(in) :: y(:)  ! ǥȺɸϤǤ y ɸ
  real, intent(in) :: u(size(x),size(y))  ! ǥȺɸϤǤʿѲ
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ.
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ.
  real, intent(in) :: r(:)  ! ʿѲȤưκɸ(xc ͤ).
  real, intent(in) :: theta(:)  ! ʿѲȤκɸ [rad].
  real, intent(inout) :: v(size(r))  ! ʿѲ u .
  integer :: i, j, k, nx, ny, nr, nt
  real :: work(size(r),size(theta))
  real :: point(size(r),size(theta),2)
  integer :: ip(size(r),size(theta),2)
  real :: tmpx(2), tmpy(2), tmpz(2,2), inter(2)

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

!-- ΰ򥯥ꥢƤ뤫ǧ ---
  if(abs(x(1)-xc) < r(nr))then
     write(*,*) "error : |x(1)-xc| >= rmax. "
     stop
  else
     if(abs(x(nx)-xc) < r(nr))then
        write(*,*) "error : |x(nx)-xc| >= rmax. "
        stop
     else
        if(abs(y(1)-yc) < r(nr))then
           write(*,*) "error : |y(1)-yc| >= rmax. "
           stop
        else
           if(abs(y(ny)-yc) < r(nr))then
              write(*,*) "error : |y(ny)-yc| >= rmax. "
              stop
           end if
        end if
     end if
  end if

!-- (1) ---
  do j=1,nt
     do i=1,nr
        call rt_2_xy( r(i), theta(j), point(i,j,1), point(i,j,2) )
        point(i,j,1)=xc+point(i,j,1)
        point(i,j,2)=yc+point(i,j,2)
     end do
  end do

!-- (2) ---
  do j=1,nt
     do i=1,nr
        call interpo_search_2d( x, y, point(i,j,1), point(i,j,2),  &
      &                         ip(i,j,1), ip(i,j,2) )
     end do
  end do

!-- (3) ---
  do j=1,nt
     do i=1,nr
        tmpx(1)=x(ip(i,j,1))
        tmpx(2)=x(ip(i,j,1)+1)
        tmpy(1)=y(ip(i,j,2))
        tmpy(2)=y(ip(i,j,2)+1)
        tmpz(1,1)=u(ip(i,j,1),ip(i,j,2))
        tmpz(2,1)=u(ip(i,j,1)+1,ip(i,j,2))
        tmpz(1,2)=u(ip(i,j,1),ip(i,j,2)+1)
        tmpz(2,2)=u(ip(i,j,1)+1,ip(i,j,2)+1)
        inter(1)=point(i,j,1)
        inter(2)=point(i,j,2)
        call interpolation_2d( tmpx, tmpy, tmpz, inter, work(i,j) )
     end do
  end do

!-- (4) ---
  do i=2,nr
     call Mean_1d( work(i,:), v(i) )
  end do
  v(1)=work(1,1)

end subroutine tangent_mean_scal

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_anom_scal( x, y, xc, yc, u, r, theta, v )
  ! Ǥդʪ̤濴ʿѤ, ΥΥޥ꡼׻롼
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r. 
  ! ʿѲμϰʲΤȤ.
  ! (1) nr, nt Τ٤ƤˤĤƤб x, y ɸͤ rt_2_xy Ƿ׻.
  ! (2) ޤ x,y åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  ! (4) nr x nt Ĥޥ顼ͤޤä, nt к׻ Anomaly_1d .
  ! ʾǳ nr ˤĤкͤ.
  ! ܥ롼ʿ̶˺ɸåͤǤк׻Ԥ.
  ! ʿѤԤäΤ, ǥȺɸкȤˤ, 
  ! tangent_mean_anom_scal_r2c .
  use analy
  use max_min
  use statistics
  use Geometry
  implicit none
  real, intent(in) :: x(:)  ! ǥȺɸϤǤ x ɸ
  real, intent(in) :: y(:)  ! ǥȺɸϤǤ y ɸ
  real, intent(in) :: u(size(x),size(y))  ! ǥȺɸϤǤʿѲ
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ.
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ.
  real, intent(in) :: r(:)  ! ʿѲȤưκɸ(xc ͤ).
  real, intent(in) :: theta(:)  ! ʿѲȤκɸ [rad].
  real, intent(inout) :: v(size(r),size(theta))  ! ʿѲ u ΥΥޥ꡼.
  integer :: i, j, k, nx, ny, nr, nt
  real :: work(size(r),size(theta))
  real :: point(size(r),size(theta),2)
  integer :: ip(size(r),size(theta),2)
  real :: tmpx(2), tmpy(2), tmpz(2,2), inter(2)

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

!-- ΰ򥯥ꥢƤ뤫ǧ ---
  if(abs(x(1)-xc) < r(nr))then
     write(*,*) "error : |x(1)-xc| >= rmax. "
     stop
  else
     if(abs(x(nx)-xc) < r(nr))then
        write(*,*) "error : |x(nx)-xc| >= rmax. "
        stop
     else
        if(abs(y(1)-yc) < r(nr))then
           write(*,*) "error : |y(1)-yc| >= rmax. "
           stop
        else
           if(abs(y(ny)-yc) < r(nr))then
              write(*,*) "error : |y(ny)-yc| >= rmax. "
              stop
           end if
        end if
     end if
  end if

!-- (1) ---
  do j=1,nt
     do i=1,nr
        call rt_2_xy( r(i), theta(j), point(i,j,1), point(i,j,2) )
        point(i,j,1)=xc+point(i,j,1)
        point(i,j,2)=yc+point(i,j,2)
     end do
  end do

!-- (2) ---
  do j=1,nt
     do i=1,nr
        call interpo_search_2d( x, y, point(i,j,1), point(i,j,2),  &
      &                         ip(i,j,1), ip(i,j,2) )
     end do
  end do

!-- (3) ---
  do j=1,nt
     do i=1,nr
        tmpx(1)=x(ip(i,j,1))
        tmpx(2)=x(ip(i,j,1)+1)
        tmpy(1)=y(ip(i,j,2))
        tmpy(2)=y(ip(i,j,2)+1)
        tmpz(1,1)=u(ip(i,j,1),ip(i,j,2))
        tmpz(2,1)=u(ip(i,j,1)+1,ip(i,j,2))
        tmpz(1,2)=u(ip(i,j,1),ip(i,j,2)+1)
        tmpz(2,2)=u(ip(i,j,1)+1,ip(i,j,2)+1)
        inter(1)=point(i,j,1)
        inter(2)=point(i,j,2)
        call interpolation_2d( tmpx, tmpy, tmpz, inter, work(i,j) )
     end do
  end do

!-- (4) ---
  do i=2,nr
     call Anomaly_1d( work(i,:), v(i,:) )
  end do
  v(1,:)=work(1,1)

end subroutine tangent_mean_anom_scal

!--------------------------------------------------------------
!--------------------------------------------------------------
subroutine tangent_mean_anom_scal_Cart( x, y, xc, yc, scal, r, theta, scal_anom, undef )
  ! 濴Υޥ׻, ǥȺɸϤ᤹.
  ! ʿѥ롼Ѥʪ̤ʿѤ,  1 ǡݤƤ.
  ! Ʊ, ǥȷϤǤʪ̤αɸϤǤ radial ֤.
  !  radial ΰ֤ˤʿͤ 1 ǡޤǵ.
  ! ε᤿ͤ򸵤ΥǥȥǡȤǥΥޥȤ.
  use statistics
  implicit none
  real, intent(in) :: x(:)  ! ǥȺɸϤǤ x ɸ
  real, intent(in) :: y(:)  ! ǥȺɸϤǤ y ɸ
  real, intent(in) :: scal(size(x),size(y))  ! ǥȺɸϤǤʿѲ.
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ.
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ.
  real, intent(in) :: r(:)  ! ʿѲȤưκɸ(xc ͤ).
  real, intent(in) :: theta(:)  ! ʿѲȤκɸ [rad].
  real, intent(inout) :: scal_anom(size(x),size(y))  ! ǥȷϤǤΥΥޥ.
  real, optional :: undef  ! ͤĤʤȤ̤. ǥեȤǤ dcl ̤
  integer :: i, j, k, nx, ny, nr, nt, itmpr
  real :: tmp(size(r))
  real :: tmpr, tmp_anom, undeff

  if(present(undef))then
     undeff=undef
  else
     undeff=999.0
  end if

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

  call tangent_mean_scal( x, y, xc, yc, scal, r, theta, tmp )

!-- ʿͤޤ, ͤƥΥޥ.
  do k=1,ny
     do j=1,nx
        tmpr=sqrt((x(j)-xc)**2+(y(k)-yc)**2)
        call interpo_search_1d( r, tmpr, itmpr )
        if(nr>itmpr)then
           call interpolation_1d( r(itmpr), r(itmpr+1), tmp(itmpr),  &
  &                               tmp(itmpr+1), tmpr, tmp_anom )
           scal_anom(j,k)=scal(j,k)-tmp_anom
        else
           scal_anom(j,k)=undeff
        end if
     end do
  end do

end subroutine tangent_mean_anom_scal_Cart

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_vec( charc, x, y, xc, yc, u1, u2, r, theta, v )
  ! Ǥդʪ̤濴ʿѤ롼
  ! ®ʿ.
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r. 
  ! ʿѲμϰʲΤȤ.
  ! (1) nr, nt Τ٤ƤˤĤƤб x, y ɸͤ rt_2_xy Ƿ׻.
  ! (2) ޤ x,y åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  !     Ʊ롼, 2 ĤΥ٥ȥʬʿͤΤ,
  !     Ѥ vec_prod ˤä濴ΰ֥٥ȥȤγѤ׻
  !     . Ʊ롼濴εΥǳä v ʬΤ.
  ! (4) nr x nt Ĥʬͤޤä, nt ʿѷ׻ mean_1d .
  ! ʾǳ nr ˤĤʿͤ.
  use analy
  use max_min
  use statistics
  use Geometry
  implicit none
  character(6), intent(in) :: charc  ! ưʬʬȽ, vector = , scalar = ưʬ.
  real, intent(in) :: x(:)  ! ǥȺɸϤǤ x ɸ
  real, intent(in) :: y(:)  ! ǥȺɸϤǤ y ɸ
  real, intent(in) :: u1(size(x),size(y))  ! ǥȺɸϤǤʿѲ 1
  real, intent(in) :: u2(size(x),size(y))  ! ǥȺɸϤǤʿѲ 2
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ.
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ.
  real, intent(in) :: r(:)  ! ʿѲȤưκɸ(xc ͤ).
  real, intent(in) :: theta(:)  ! ʿѲȤκɸ [rad].
  real, intent(inout) :: v(size(r))  ! ʿѲ u .
  integer :: i, j, k, nx, ny, nr, nt
  real :: work1(size(r),size(theta),1), work2(size(r),size(theta),1), work3(size(r),size(theta),1)
  real :: posx(size(r),size(theta),1), posy(size(r),size(theta),1), posz(size(r),size(theta),1)
  real :: vecx(size(r),size(theta),1), vecy(size(r),size(theta),1), vecz(size(r),size(theta),1)
  real :: abpos(size(r),size(theta))
  real :: point(size(r),size(theta),2)
  integer :: ip(size(r),size(theta),2)
  real :: tmpx(2), tmpy(2), tmpz(2,2), inter(2)

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

!-- ΰ򥯥ꥢƤ뤫ǧ ---
  if(abs(x(1)-xc) < r(nr))then
     write(*,*) "error : |x(1)-xc| >= rmax. "
     stop
  else
     if(abs(x(nx)-xc) < r(nr))then
        write(*,*) "error : |x(nx)-xc| >= rmax. "
        stop
     else
        if(abs(y(1)-yc) < r(nr))then
           write(*,*) "error : |y(1)-yc| >= rmax. "
           stop
        else
           if(abs(y(ny)-yc) < r(nr))then
              write(*,*) "error : |y(ny)-yc| >= rmax. "
              stop
           end if
        end if
     end if
  end if

!-- (1) ---
  do j=1,nt
     do i=1,nr
        call rt_2_xy( r(i), theta(j), point(i,j,1), point(i,j,2) )
        point(i,j,1)=xc+point(i,j,1)
        point(i,j,2)=yc+point(i,j,2)
     end do
  end do

!-- (2) ---
  do j=1,nt
     do i=1,nr
        call interpo_search_2d( x, y, point(i,j,1), point(i,j,2),  &
      &                         ip(i,j,1), ip(i,j,2) )
     end do
  end do


!-- (3) ---
!-- 1. ٥ȥ 2 ʬˤĤޤͤ˳Ǽ ---
  do j=1,nt
     do i=1,nr
        tmpx(1)=x(ip(i,j,1))
        tmpx(2)=x(ip(i,j,1)+1)
        tmpy(1)=y(ip(i,j,2))
        tmpy(2)=y(ip(i,j,2)+1)
        tmpz(1,1)=u1(ip(i,j,1),ip(i,j,2))
        tmpz(2,1)=u1(ip(i,j,1)+1,ip(i,j,2))
        tmpz(1,2)=u1(ip(i,j,1),ip(i,j,2)+1)
        tmpz(2,2)=u1(ip(i,j,1)+1,ip(i,j,2)+1)
        inter(1)=point(i,j,1)
        inter(2)=point(i,j,2)
        call interpolation_2d( tmpx, tmpy, tmpz, inter, work1(i,j,1) )
        tmpz(1,1)=u2(ip(i,j,1),ip(i,j,2))
        tmpz(2,1)=u2(ip(i,j,1)+1,ip(i,j,2))
        tmpz(1,2)=u2(ip(i,j,1),ip(i,j,2)+1)
        tmpz(2,2)=u2(ip(i,j,1)+1,ip(i,j,2)+1)
        call interpolation_2d( tmpx, tmpy, tmpz, inter, work2(i,j,1) )
     end do
  end do

!-- 2. ޤȤä, Ǥ x,y ɸ(ֹ, ix,iy ˳Ǽ)
!--    ΰ֥٥ȥȤγѤ׻
  do j=1,nt
     do i=1,nr
        work3(i,j,1)=0.0
        posx(i,j,1)=point(i,j,1)-xc
        posy(i,j,1)=point(i,j,2)-yc
        posz(i,j,1)=0.0
     end do
  end do

  select case (charc)
  case ('vector')
     call vec_prod( posx, posy, posz, work1, work2, work3, vecx, vecy, vecz )
  case ('scalar')
     call dot_prod( posx, posy, posz, work1, work2, work3, vecz )
  case default
     write(*,*) "error : bad character. select 'vector', or 'scalar'."
     stop
  end select

!-- 3. ٥ȥγʬΤ, z ʬˤĤ (2 ʿ̥٥ȥƱΤγ)
!--    ֥٥ȥͤǳ. -> ®ʬޤͤ.
  call abst( posx, posy, posz, abpos )

  do j=1,nt
     do i=2,nr   
        vecz(i,j,1)=vecz(i,j,1)/abpos(i,j)
     end do
  end do


!-- (4) ---
  do i=2,nr
     call Mean_1d( vecz(i,:,1), v(i) )
  end do
  v(1)=0.0

end subroutine tangent_mean_vec


!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_anom_vec( charc, x, y, xc, yc, u1, u2, r, theta, v )
  ! Ǥդʪ̤濴ʿѥΥޥ׻롼
  ! ®ʿ.
  ! ¤Ȥ, |x(1)-xc|, |xc-x(nx)|, |y(1)-yc|, |yc-y(ny)| > r. 
  ! ʿѲμϰʲΤȤ.
  ! (1) nr, nt Τ٤ƤˤĤƤб x, y ɸͤ rt_2_xy Ƿ׻.
  ! (2) ޤ x,y åɤΰ interpo_search_2d Ǹ.
  ! (3) ޤ 4 Ф, ǤΥ顼ͤ 4 Υ顼
  !     ,  interpolation_2d Ƿ׻.
  !     Ʊ롼, 2 ĤΥ٥ȥʬʿͤΤ,
  !     Ѥ vec_prod ˤä濴ΰ֥٥ȥȤγѤ׻
  !     . Ʊ롼濴εΥǳä v ʬΤ.
  ! (4) nr x nt Ĥʬͤޤä, nt ʿѷ׻ mean_1d .
  ! ʾǳ nr ˤĤʿͤ.
  use analy
  use max_min
  use statistics
  use Geometry
  implicit none
  character(6), intent(in) :: charc  ! ưʬʬȽ, vector = , scalar = ưʬ.
  real, intent(in) :: x(:)  ! ǥȺɸϤǤ x ɸ
  real, intent(in) :: y(:)  ! ǥȺɸϤǤ y ɸ
  real, intent(in) :: u1(size(x),size(y))  ! ǥȺɸϤǤʿѲ 1
  real, intent(in) :: u2(size(x),size(y))  ! ǥȺɸϤǤʿѲ 2
  real, intent(in) :: xc  ! ʿѤݤ濴 x ʬ.
  real, intent(in) :: yc  ! ʿѤݤ濴 y ʬ.
  real, intent(in) :: r(:)  ! ʿѲȤưκɸ(xc ͤ).
  real, intent(in) :: theta(:)  ! ʿѲȤκɸ [rad].
  real, intent(inout) :: v(size(r),size(theta))  ! Υޥ u .
  integer :: i, j, k, nx, ny, nr, nt
  real :: work1(size(r),size(theta),1), work2(size(r),size(theta),1), work3(size(r),size(theta),1)
  real :: posx(size(r),size(theta),1), posy(size(r),size(theta),1), posz(size(r),size(theta),1)
  real :: vecx(size(r),size(theta),1), vecy(size(r),size(theta),1), vecz(size(r),size(theta),1)
  real :: abpos(size(r),size(theta))
  real :: point(size(r),size(theta),2)
  integer :: ip(size(r),size(theta),2)
  real :: tmpx(2), tmpy(2), tmpz(2,2), inter(2)

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nt=size(theta)

!-- ΰ򥯥ꥢƤ뤫ǧ ---
  if(abs(x(1)-xc) < r(nr))then
     write(*,*) "error : |x(1)-xc| >= rmax. "
     stop
  else
     if(abs(x(nx)-xc) < r(nr))then
        write(*,*) "error : |x(nx)-xc| >= rmax. "
        stop
     else
        if(abs(y(1)-yc) < r(nr))then
           write(*,*) "error : |y(1)-yc| >= rmax. "
           stop
        else
           if(abs(y(ny)-yc) < r(nr))then
              write(*,*) "error : |y(ny)-yc| >= rmax. "
              stop
           end if
        end if
     end if
  end if

!-- (1) ---
  do j=1,nt
     do i=1,nr
        call rt_2_xy( r(i), theta(j), point(i,j,1), point(i,j,2) )
        point(i,j,1)=xc+point(i,j,1)
        point(i,j,2)=yc+point(i,j,2)
     end do
  end do

!-- (2) ---
  do j=1,nt
     do i=1,nr
        call interpo_search_2d( x, y, point(i,j,1), point(i,j,2),  &
      &                         ip(i,j,1), ip(i,j,2) )
     end do
  end do


!-- (3) ---
!-- 1. ٥ȥ 2 ʬˤĤޤͤ˳Ǽ ---
  do j=1,nt
     do i=1,nr
        tmpx(1)=x(ip(i,j,1))
        tmpx(2)=x(ip(i,j,1)+1)
        tmpy(1)=y(ip(i,j,2))
        tmpy(2)=y(ip(i,j,2)+1)
        tmpz(1,1)=u1(ip(i,j,1),ip(i,j,2))
        tmpz(2,1)=u1(ip(i,j,1)+1,ip(i,j,2))
        tmpz(1,2)=u1(ip(i,j,1),ip(i,j,2)+1)
        tmpz(2,2)=u1(ip(i,j,1)+1,ip(i,j,2)+1)
        inter(1)=point(i,j,1)
        inter(2)=point(i,j,2)
        call interpolation_2d( tmpx, tmpy, tmpz, inter, work1(i,j,1) )
        tmpz(1,1)=u2(ip(i,j,1),ip(i,j,2))
        tmpz(2,1)=u2(ip(i,j,1)+1,ip(i,j,2))
        tmpz(1,2)=u2(ip(i,j,1),ip(i,j,2)+1)
        tmpz(2,2)=u2(ip(i,j,1)+1,ip(i,j,2)+1)
        call interpolation_2d( tmpx, tmpy, tmpz, inter, work2(i,j,1) )
     end do
  end do

!-- 2. ޤȤä, Ǥ x,y ɸ(ֹ, ix,iy ˳Ǽ)
!--    ΰ֥٥ȥȤγѤ׻
  do j=1,nt
     do i=1,nr
        work3(i,j,1)=0.0
        posx(i,j,1)=point(i,j,1)-xc
        posy(i,j,1)=point(i,j,2)-yc
        posz(i,j,1)=0.0
     end do
  end do

  select case (charc)
  case ('vector')
     call vec_prod( posx, posy, posz, work1, work2, work3, vecx, vecy, vecz )
  case ('scalar')
     call dot_prod( posx, posy, posz, work1, work2, work3, vecz )
  case default
     write(*,*) "error : bad character. select 'vector', or 'scalar'."
     stop
  end select

!-- 3. ٥ȥγʬΤ, z ʬˤĤ (2 ʿ̥٥ȥƱΤγ)
!--    ֥٥ȥͤǳ. -> ®ʬޤͤ.
  call abst( posx, posy, posz, abpos )

  do j=1,nt
     do i=2,nr   
        vecz(i,j,1)=vecz(i,j,1)/abpos(i,j)
     end do
  end do


!-- (4) ---
  do i=2,nr
     call Anomaly_1d( vecz(i,:,1), v(i,:) )
  end do
  v(1,:)=0.0

end subroutine tangent_mean_anom_vec

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_turb( signal, r, z, u, v, w, rho, nuh, nuv, val, undef, sfctau )
!  ʿѤήեå׻.
!  ʿѤƤΤ, tau_{*2} ʬ (\theta ʬʬ) ϴޤޤʤ.
  use analy
  implicit none
  character(1) :: signal  ! ɸϤβܤήʬȽꤹ.
                  ! [1] = ɸˤ radial ɸʬ ( vr ʬ)
                  ! [2] = ɸˤ tangential ɸʬ ( vt ʬ)
                  ! [3] = ɸˤ vertical ɸʬ ( w ʬ)
  real, intent(in) :: r(:)  ! ưΰֺɸ [m]
  real, intent(in) :: z(:)  ! ľΰֺɸ [m]
  real, intent(in) :: u(size(r),size(z))  ! x б 2 ٥ȥʬ
  real, intent(in) :: v(size(r),size(z))  ! y б 2 ٥ȥʬ
  real, intent(in) :: w(size(r),size(z))  ! y б 2 >ȥʬ
  real, intent(in) :: rho(size(z))  ! ʿ̤ʿѤܾ̩ [kg/m^3]
  real, intent(in) :: nuh(size(r),size(z))  ! ʿǴ
  real, intent(in) :: nuv(size(r),size(z))  ! ľǴ
  real, intent(inout) :: val(size(r),size(z))  ! ήեå
  real, intent(in), optional :: undef
  real, intent(in), optional :: sfctau(size(r))  ! ɽ̤Υեå
                 ! 줬Ϳ, ǲؤαϤϤ֤.
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: id   ! 졼ź
  integer :: nr  ! ǿ 1 
  integer :: nz  ! ǿ 2 
  real :: dr  ! 1 ܤʬʻҴֳ [m]
  real :: dz  ! 2 ܤʬʻҴֳ [m]
  character(1) :: signaltau(3)
  real, dimension(size(r),size(z),3) :: tau  ! signal 
              ! Ѥ 1,2,3 ̤˿ľʱ
  real, dimension(size(r),size(z)) :: tmp
  real, dimension(size(r)) :: stau

  signaltau=(/ '1', '2', '3' /)

  dr=r(2)-r(1)
  dz=z(2)-z(1)
  nr=size(r)
  nz=size(z) 

  val=0.0

  do id=1,3
     if(id/=2)then  ! tau_{*2} ʬϥʤΤ, ׻ʤ.
        if(present(sfctau))then
           stau(:)=sfctau(:)
           call tangent_mean_Reynolds( signal//signaltau(id),  &
  &             r, z, u, v, w, rho, nuh, nuv, tau(:,:,id), sfctau=stau )
        else
           call tangent_mean_Reynolds( signal//signaltau(id),  &
  &             r, z, u, v, w, rho, nuh, nuv, tau(:,:,id) )
        end if
     end if
  end do

!-- (signal, 1) ʬη׻
  do k=1,nz
     call grad_1d( r, tau(:,k,1), tmp(:,k))
     do i=1,nr
        if(r(i)/=0.0)then
           val(i,k)=tmp(i,k)+val(i,k)+tau(i,k,1)/r(i)
        else
           val(i,k)=tmp(i,k)+val(i,k)
        end if
     end do
  end do

!-- (signal, 3) ʬη׻
  do i=1,nr
     call grad_1d( z, tau(i,:,3), tmp(i,:))
     do k=1,nz
        val(i,k)=tmp(i,k)+val(i,k)
     end do
  end do



end subroutine

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_Reynolds( signal, r, z, u, v, w, rho, nuh, nuv, val, undef, sfctau )
! ɸϤˤ쥤Υ륺ϥƥ󥽥׻.
  use analy
  implicit none
  character(2) :: signal  ! ׻ƥ󥽥ʬ.
                  ! ['11', '22', '33'] = 줾гѥƥ󥽥ʬ
                  ! ['12', '13', '21', '23', '31', '32'] = 줾г
                  ! ƥ󥽥ʬ. , оΥƥ󥽥Ǥ뤿, '12'='21' 
                  ! ׻Ƥ뤳Ȥ.
  real, intent(in) :: r(:)  ! radial ζֺɸ [m]
  real, intent(in) :: z(:)  ! vertical ζֺɸ [m]
  real, intent(in) :: u(size(r),size(z))  ! radial б 3 ٥ȥʬ
  real, intent(in) :: v(size(r),size(z))  ! tangential б 3 ٥ȥʬ
  real, intent(in) :: w(size(r),size(z))  ! vertical б 3 ٥ȥʬ
  real, intent(in) :: rho(size(z))  ! ʿ̤ʿѤܾ̩ [kg/m^3]
  real, intent(in) :: nuh(size(r),size(z))  ! ʿǴ
  real, intent(in) :: nuv(size(r),size(z))  ! ľǴ
  real, intent(inout) :: val(size(r),size(z))  ! ׻줿ƥ󥽥ʬ
! , ʲΥץϻѤƤʤ.
  real, intent(in), optional :: undef
  real, intent(in), optional :: sfctau(size(r))  ! ɽ̤Υեå
                 ! 줬Ϳ, ǲؤαϤϤ֤.
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nr  ! ǿ 1 
  integer :: nz  ! ǿ 3 
  real :: dr  ! 1 ܤʬʻҴֳ [m]
  real :: dz  ! 3 ܤʬʻҴֳ [m]
  real, dimension(size(r),size(z)) :: tau1, tau2, tau3  ! signal 
              ! Ѥ 1,2,3 ̤˿ľʱ
  integer :: signaltau
  real :: sxx(size(r),size(z)), nu(size(r),size(z))
  real :: stau(size(r))

  dr=r(2)-r(1)
  dz=z(2)-z(1)
  nr=size(r)
  nz=size(z)

  val=0.0
  stau=0.0

  if(present(sfctau))then
     if(signal(2:2)=='3'.and.signal(1:1)/='3')then
        stau(:)=sfctau(:)
     end if
  end if

!-- [NOTE]
!-- ʲ, ʸ case  or Ǥʤ, 
!-- if ʸҤǤϤʤ, if ʸɽ case Ʊ褦˸.
!-- Ϥ, 夫 if 򤿤ɤ뤬, ɤξ 2 ʾ if 
!-- פʤȤΤǤ뤿˲ǽȤʤǤ,
!-- ɽ if  2 ѥʾ˹פƤޤ褦ʾʸǤ,
!-- case ѤˤѤ뤳ȤǤʤȤ.
!-- ܥ饤֥ǤΤ褦ʶ路ɽ򤷤Ƥɬ NOTE .

  if(signal(1:2)=='12'.or.signal(1:2)=='21')then
     call tangent_mean_deform( signal, r, z, u, v, w, sxx )

     do k=1,nz
        do i=1,nr
           nu(i,k)=nuh(i,k)
        end do
     end do
  end if

  if(signal(1:2)=='23'.or.signal(1:2)=='32')then
     call tangent_mean_deform( signal, r, z, u, v, w, sxx )

     if(signal(2:2)=='3')then
        do k=1,nz
           do i=1,nr
              nu(i,k)=nuv(i,k)
           end do
        end do
     else
        do k=1,nz
           do i=1,nr
              nu(i,k)=nuh(i,k)
           end do
        end do
     end if
  end if

  if(signal(1:2)=='13'.or.signal(1:2)=='31')then
     call tangent_mean_deform( signal, r, z, u, v, w, sxx )

     if(signal(2:2)=='3')then
        do k=1,nz
           do i=1,nr
              nu(i,k)=nuv(i,k)
           end do
        end do
     else
        do k=1,nz
           do i=1,nr
              nu(i,k)=nuh(i,k)
           end do
        end do
     end if
  end if

  if(signal(1:2)=='11')then
     call tangent_mean_deform( signal, r, z, u, v, w, sxx )
     call div( r, z, u, w, val )
     do k=1,nz
        do i=1,nr
           if(r(i)/=0.0)then
              val(i,k)=val(i,k)+u(i,k)/r(i)
           end if
        end do
     end do

     do k=1,nz
        do i=1,nr
           nu(i,k)=nuh(i,k)
        end do
     end do
  end if

  if(signal(1:2)=='22')then
     call tangent_mean_deform( signal, r, z, u, v, w, sxx )
     call div( r, z, u, w, val )
     do k=1,nz
        do i=1,nr
           if(r(i)/=0.0)then
              val(i,k)=val(i,k)+u(i,k)/r(i)
           end if
        end do
     end do

     do k=1,nz
        do i=1,nr
           nu(i,k)=nuh(i,k)
        end do
     end do

  end if

  if(signal(1:2)=='33')then
     call tangent_mean_deform( signal, r, z, u, v, w, sxx )
     call div( r, z, u, w, val )
     do k=1,nz
        do i=1,nr
           if(r(i)/=0.0)then
              val(i,k)=val(i,k)+u(i,k)/r(i)
           end if
        end do
     end do

     do k=1,nz
        do i=1,nr
           nu(i,k)=nuh(i,k)
        end do
     end do

  end if

!-- ʲμ, ǽ val = 0  if ʸǷ׻ƤΤȤƤʤ
!-- ΤʬΤ, μɾǤ.
!-- ׻ƤʤΤˤĤƤϤ⤽⥼Ǥ.

!-- ʲ, ǲؤɽ̥եå뤫ɤΥץΤ, ̥롼

  if(present(sfctau))then
     do i=1,nr
        val(i,1)=stau(i)
     end do
  else
     do i=1,nr
        val(i,1)=rho(1)*nu(i,1)*(sxx(i,1)-(2.0/3.0)*val(i,1))
     end do
  end if

  do k=2,nz
     do i=1,nr
        val(i,k)=rho(k)*nu(i,k)*(sxx(i,k)-(2.0/3.0)*val(i,k))
     end do
  end do

end subroutine


!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine tangent_mean_deform( signal, r, z, u, v, w, val, undef )
! ǥȺɸϤˤѷ®٥ƥ󥽥׻.
  use analy
  implicit none
  character(2) :: signal  ! ׻ƥ󥽥ʬ.
                  ! ['11', '22', '33'] = 줾гѥƥ󥽥ʬ
                  ! ['12', '13', '21', '23', '31', '32'] = 줾г
                  ! ƥ󥽥ʬ. , оΥƥ󥽥Ǥ뤿, '12'='21' 
                  ! ׻Ƥ뤳Ȥ.
  real, intent(in) :: r(:)  ! radial ζֺɸ [m]
  real, intent(in) :: z(:)  ! vertical ζֺɸ [m]
  real, intent(in) :: u(size(r),size(z))  ! radial б 3 ٥ȥʬ
  real, intent(in) :: v(size(r),size(z))  ! tangential б 3 ٥ȥʬ
  real, intent(in) :: w(size(r),size(z))  ! vertical б 3 ٥ȥʬ
  real, intent(inout) :: val(size(r),size(z))  ! ׻줿ƥ󥽥ʬ
! , ʲΥץϻѤƤʤ.
  real, intent(in), optional :: undef
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nr  ! ǿ 1 
  integer :: nz  ! ǿ 2 
  real :: dr  ! 1 ܤʬʻҴֳ [m]
  real :: dz  ! 2 ܤʬʻҴֳ [m]
  real, dimension(size(r),size(z)) :: tau1, tau2, tau3  ! signal 
              ! Ѥ 1,2,3 ̤˿ľʱ

  dr=r(2)-r(1)
  dz=z(2)-z(1)
  nr=size(r)
  nz=size(z)

!-- [NOTE]
!-- ʲ, ʸ case  or Ǥʤ, 
!-- if ʸҤǤϤʤ, if ʸɽ case Ʊ褦˸.
!-- Ϥ, 夫 if 򤿤ɤ뤬, ɤξ 2 ʾ if 
!-- פʤȤΤǤ뤿˲ǽȤʤǤ,
!-- ɽ if  2 ѥʾ˹פƤޤ褦ʾʸǤ,
!-- case ѤˤѤ뤳ȤǤʤȤ.
!-- ܥ饤֥ǤΤ褦ʶ路ɽ򤷤Ƥɬ NOTE .

  if(signal(1:2)=='12'.or.signal(1:2)=='21')then
     do k=1,nz
        call grad_1d( r, v(:,k), val(:,k) )
        do i=1,nr
           if(r(i)/=0.0)then
              val(i,k)=val(i,k)-v(i,k)/r(i)
           end if
        end do
     end do
  end if

  if(signal(1:2)=='23'.or.signal(1:2)=='32')then
!$omp parallel default(shared)
!$omp do private(k)
     do k=1,nr
        call grad_1d( z, v(k,:), val(k,:) )
     end do
!$omp end do
!$omp end parallel
  end if

  if(signal(1:2)=='13'.or.signal(1:2)=='31')then
     call div( r, z, w, u, val )
  end if

  if(signal(1:2)=='11')then
!$omp parallel default(shared)
!$omp do private(k)
     do k=1,nz
        call grad_1d( r, u(:,k), val(:,k) )
        val(:,k)=2.0*val(:,k)
     end do
!$omp end do
!$omp end parallel
  end if

  if(signal(1:2)=='22')then
!$omp parallel default(shared)
!$omp do private(j,k)
     do k=1,nz
        do j=1,nr
           if(r(j)/=0.0)then
              val(j,k)=2.0*u(j,k)/r(j)
           else
              val(j,k)=0.0
           end if
        end do
     end do
!$omp end do
!$omp end parallel
  end if

  if(signal(1:2)=='33')then
!$omp parallel default(shared)
!$omp do private(j)
     do j=1,nr
        call grad_1d( z, w(j,:), val(j,:) )
        val(j,:)=2.0*val(j,:)
     end do
!$omp end do
!$omp end parallel
  end if

end subroutine

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine hydro_grad_eqb( r, z, coril, v, pres_s, rho_s, pres, rho, error )
!  ǥ󥰤ȼоήϳءʿվη׻.
  use Thermo_Const
  use Phys_Const
  use Algebra
  use Analy
  implicit none
  real, intent(in) :: r(:)  ! ưºɸ [m]
  real, intent(in) :: z(:)  ! ľɸ [m]
  real, intent(in) :: coril(size(r),size(z))  ! ꥪѥ᡼ [/s]
  real, intent(in) :: v(size(r),size(z))  ! оή [m/s]
  real, intent(in) :: pres_s(size(z))  ! ǥ󥰤ε [Pa]
  real, intent(in) :: rho_s(size(z))  ! ǥ󥰤̩ [kg/m^3]
  real, intent(in), optional :: error  ! 졼μ«
                    ! default = 1.0e-5
  real, intent(inout) :: pres(size(r),size(z))  ! ʿվε [Pa]
  real, intent(inout) :: rho(size(r),size(z))  ! ʿվ̩ [K]
  real :: old_pres(size(r),size(z)), old_rho(size(r),size(z))
  integer :: nr, nz
  integer :: i, j, k
  real :: err, err_tmp, err_max

  nr=size(r)
  nz=size(z)

  if(present(error))then
     err_max=error
  else
     err_max=1.0e-5
  end if

!-- ʲǳƹ٤ˤ, ̩٤ϰǤȤƷʿդ鵤׻,
!-- ͤѤϳʿդ̩٤. eps ʲˤʤޤǷ֤.
!--  2 ȥǥ󥰤.
  do i=1,nz
     old_pres(nr,i)=pres_s(i)
  end do
!-- ̩٤ˤĤƤ, ʿ̰ͤ
  do j=1,nz
     do i=1,nr
        old_rho(i,j)=rho_s(j)
     end do
  end do

!-- ʲǥ졼󳫻.
  err=err_max

  do while(err>=err_max)
     err=0.0
!-- ʿդ鰵Ͼ׻
     do j=1,nz
        call grad_wind_pres( r, coril(:,j), v(:,j), old_rho(:,j), r(nr), old_pres(nr,j), pres(:,j) )
     end do

!-- ϳʿդ̩پ
     do i=1,nr
        call grad_1d( z, pres(i,:), rho(i,:) )
        do j=1,nz
if(i==1)then
write(*,*) "#### pres", pres(i,j), rho(i,j)
end if
           rho(i,j)=-rho(i,j)/g  ! ϳؤμ, dp/dz=-g*rho ǤΤ
        end do
     end do

!-- ̩پμ«׻
     do j=1,nz
        do i=1,nr
           if(rho(i,j)==0.0)then
              err_tmp=abs(old_rho(i,j)-rho(i,j))/abs(old_rho(i,j))
           else
              err_tmp=abs(old_rho(i,j)-rho(i,j))/abs(old_rho(i,j))
           end if

!-- ι
           if(err<=err_tmp)then
              err=err_tmp
           end if

           old_rho(i,j)=rho(i,j)
           old_pres(i,j)=pres(i,j)

        end do
     end do

  end do

end subroutine

!--------------------------------------------------------------
!--------------------------------------------------------------

subroutine grad_wind_pres( r, coril, v, rho, r_ref, p_ref, pres )
!  ʿվ׻.
  use Algebra
  implicit none
  real, intent(in) :: r(:)  ! r ΰֺɸ [m]
  real, intent(in) :: coril(size(r))  ! ꥪѥ᡼ [/s]
  real, intent(in) :: v(size(r))  ! r ΰֺɸ [m]
  real, intent(in) :: rho(size(r))  ! ̩ [kg/m^3]
  real, intent(in) :: r_ref  ! ʬȤʤֺɸ [m]
  real, intent(in) :: p_ref  ! r_ref Ǥε (ʬ) [Pa]
  real, intent(inout) :: pres(size(r))  ! ʿդǤε [kg/m^3]
  integer :: i, nr
  real :: grad(size(r))

  nr=size(r)

  do i=1,nr
     if(r(i)/=0.0)then
        grad(i)=rho(i)*(v(i)*v(i)/r(i)+coril(i)*v(i))
     else
        grad(i)=0.0
     end if
  end do

  do i=1,nr
     if(r(i)<r_ref)then
        call rectangle_int( r, grad, r(i), r_ref, pres(i) )
        pres(i)=p_ref-pres(i)
     else
        if(r(i)>r_ref)then
           call rectangle_int( r, grad, r_ref, r(i), pres(i) )
           pres(i)=p_ref+pres(i)
        else
           pres(i)=p_ref
        end if
     end if
  end do

end subroutine




end module
