module Special_Function  !-- üؿ׻⥸塼 ---

interface Full_Ellip1_Func

  module procedure Full_Ellip1_Func_f, Full_Ellip1_Func_d

end interface

interface Full_Ellip2_Func

  module procedure Full_Ellip2_Func_f, Full_Ellip2_Func_d

end interface

interface bessj

  module procedure bessj_f, bessj_d

end interface

interface beszero

  module procedure besfzero, besdzero

end interface


contains

real function digamma(k)
  !-- ޴ؿ׻륵֥롼 ---
  !-- Ȥ ---
  !-- ؿ̾ "digamma(n)" , ɬǤʤФʤʤ
  implicit none
  integer, intent(in) :: k  ! (k+1) ܤޤǤη׻
  integer :: j

  if (k.gt.1) then
     digamma=0.0
     do j=1,k
        digamma=digamma+1.0/j
     end do
  else
     if (k.eq.1) then
        digamma=1.0
     else
        digamma=0.0
     end if
  end if
  return
end function

real function epsilon(i,j,k)
!-- ǥȥΥץ׻륵֥롼 ---
!-- F77 ǤǤѤǤʤä CASE ʸǿʬԤ ---
!-- i,j,k  1..3  3 ष¸ߤʤȤΤȤδؿǤΤ,
!-- ǤΥƥ󥽥ˤŬѤǤʤ. ---
  implicit none
  integer, intent(in) :: i  !  1 ʬ
  integer, intent(in) :: j  !  1 ʬ
  integer, intent(in) :: k  !  1 ʬ

  select case (i)

  case (1)

     select case (j)

     case (1)
        epsilon=0.0

     case (2)

        select case (k)

        case (1)
           epsilon=0.0

        case (2)
           epsilon=0.0

        case (3)
           epsilon=1.0

        end select

     case (3)

        select case (k)

        case (1)
           epsilon=0.0

        case (2)
           epsilon=-1.0

        case (3)
           epsilon=0.0

        end select
     end select

  case (2)

     select case (j)

     case (1)

        select case (k)

        case (1)
           epsilon=0.0

        case (2)
           epsilon=0.0

        case (3)
           epsilon=-1.0

        end select

     case (2)
        epsilon=0.0

     case (3)

        select case (k)

        case (1)
           epsilon=1.0

        case (2)
           epsilon=0.0

        case (3)
           epsilon=0.0

        end select
     end select

  case (3)

     select case (j)

     case (1)

        select case (k)

        case (1)
           epsilon=0.0

        case (2)
           epsilon=1.0

        case (3)
           epsilon=0.0

        end select

     case (2)

        select case (k)

        case (1)
           epsilon=-1.0

        case (2)
           epsilon=0.0

        case (3)
           epsilon=0.0

        end select

     case (3)
        epsilon=0.0

     end select
  end select

  return
end function


real function Full_Ellip1_Func_f(k)  !  1 ﴰʱߴؿ׻
  implicit none
  real, intent(in) :: k  ! ؿΰ
  real :: pi, m, dt, t, tmin, tmax
  integer :: i, j
  integer, parameter :: nmax=1000
  real :: f, x

  f(m,x) = 1.0/sqrt(1.0-(m*sin(x))**2)

  if(k.ge.1.0)then
     write(*,*) "(error ! : k must 0=<k<1.)"
     return
  end if

  pi = 3.14159265

  tmin = 0.0
  tmax = pi/2.0
  dt = (tmax-tmin)/(nmax-1)

  Full_Ellip1_Func_f = 0.5*dt*(f(k,tmin)+f(k,tmax))
  do i=1,nmax-2
     t = tmin+dt*i
     Full_Ellip1_Func_f = Full_Ellip1_Func_f+dt*f(k,t)
  end do

  return
end function


double precision function Full_Ellip1_Func_d(k)  !  1 ﴰʱߴؿ׻
  implicit none
  double precision, intent(in) :: k  ! ؿΰ
  double precision :: pi, m, dt, t, tmin, tmax
  integer :: i, j
  integer, parameter :: nmax=1000
  double precision :: f, x

  f(m,x) = 1.0d0/dsqrt(1.0d0-(m*dsin(x))**2)

  if(k.ge.1.0d0)then
     write(*,*) "(error ! : k must 0=<k<1.)"
     return
  end if

  pi = 3.1415926535898d0

  tmin = 0.0d0
  tmax = pi/2.0d0
  dt = (tmax-tmin)/dble(nmax-1)

  Full_Ellip1_Func_d = 0.5d0*dt*(f(k,tmin)+f(k,tmax))
  do i=1,nmax-2
     t = tmin+dt*dble(i)
     Full_Ellip1_Func_d = Full_Ellip1_Func_d+dt*f(k,t)
  end do

  return
end function


real function Full_Ellip2_Func_f(k)  ! ﴰʱߴؿ
  implicit none
  real, intent(in) :: k  ! ؿΰ
  real :: pi, m, dt, t, tmin, tmax
  integer :: i, j
  integer, parameter :: nmax=1000
  real :: f, x

  f(m,x) = sqrt(1.0-(m*sin(x))**2)

  pi = 3.14159265

  if(k.gt.1.0)then
     write(*,*) "(error) ! : k must 0=<k=<1."
     return
  end if

  tmin = 0.0
  tmax = pi/2.0
  dt = (tmax-tmin)/(nmax-1)

  Full_Ellip2_Func_f = 0.5*dt*(f(k,tmin)+f(k,tmax))
  do i=1,nmax-2
     t = tmin+dt*i
     Full_Ellip2_Func_f = Full_Ellip2_Func_f+dt*f(k,t)
  end do

  return
end function



double precision function Full_Ellip2_Func_d(k)  ! ﴰʱߴؿ
  implicit none
  double precision, intent(in) :: k  ! ؿΰ
  double precision :: pi, m, dt, t, tmin, tmax
  integer :: i, j
  integer, parameter :: nmax=1000
  double precision :: f, x

  f(m,x) = dsqrt(1.0d0-(m*dsin(x))**2)

  pi = 3.1415926535898d0

  if(k.gt.1.0d0)then
     write(*,*) "(error) ! : k must 0=<k=<1."
     return
  end if

  tmin = 0.0d0
  tmax = pi/2.0d0
  dt = (tmax-tmin)/dble(nmax-1)

  Full_Ellip2_Func_d = 0.5d0*dt*(f(k,tmin)+f(k,tmax))
  do i=1,nmax-2
     t = tmin+dt*dble(i)
     Full_Ellip2_Func_d = Full_Ellip2_Func_d+dt*f(k,t)
  end do

  return
end function


real function kaijo(k)
  !-- ؿ׻륵֥롼 ---
  !-- Ȥ ---
  !-- ؿ̾ "kaijo(k)" ,  "k" ˤΤ뤳
  implicit none
  integer, intent(in) :: k
  integer :: j

  if (k.lt.2) then
     kaijo=1.0
  else
     kaijo=1.0
     do j=1,k
        kaijo=j*kaijo
     end do
  end if

  return
end function


real function bessj_f(m,t)  !  I ٥åؿ׻
  implicit none
  integer, intent(in) :: m  ! ׻뼡
  real, intent(in) :: t  ! 
  integer :: istep, n
  real :: x
  integer, parameter :: mmax = 100 ! ʬѤ
  real, parameter :: pis=3.14159265
  real, parameter :: xmin = 0.0d0, xmax = 2.0d0*pis
  real, parameter :: dx = (xmax-xmin)/(mmax-1)

!-- μǤäʬ ---
  if(m < 0)then
     n=-m
  else
     n=m
  end if

!-- ٥åؿʬ׻ ---
  bessj_f=0.0

  do istep=2,mmax-1
     x=xmin+dx*(istep-1)
     bessj_f=bessj_f+dx*(cos(t*sin(x)-real(n)*x))
  end do

  bessj_f=bessj_f+0.5*dx*(cos(t*sin(xmin)-real(n)*xmin) &
 &            +cos(t*sin(xmax)-real(n)*xmax))
  bessj_f=bessj_f/(2.0*pis)

!-- μǤäʬ ---
  if(m.lt.0)then
     bessj_f=((-1.0)**n)*bessj_f
  end if

  return
end function



double precision function bessj_d(m,t)  !  I ٥åؿ׻
  implicit none
  integer, intent(in) :: m  ! ׻뼡
  double precision, intent(in) :: t  ! 
  integer :: istep, n
  double precision :: x
  integer, parameter :: mmax = 100 ! ʬѤ
  double precision, parameter :: pis=3.14159265
  double precision, parameter :: xmin = 0.0d0, xmax = 2.0d0*pis
  double precision, parameter :: dx = (xmax-xmin)/(mmax-1)

!-- μǤäʬ ---
  if(m < 0)then
     n=-m
  else
     n=m
  end if

!-- ٥åؿʬ׻ ---
  bessj_d=0.0d0

  do istep=2,mmax-1
     x=xmin+dx*dble(istep-1)
     bessj_d=bessj_d+dx*(dcos(t*dsin(x)-dble(n)*x))
  end do

  bessj_d=bessj_d+0.5d0*dx*(dcos(t*dsin(xmin)-dble(n)*xmin) &
 &            +dcos(t*dsin(xmax)-dble(n)*xmax))
  bessj_d=bessj_d/(2.0d0*pis)

!-- μǤäʬ ---
  if(m.lt.0)then
     bessj_d=((-1.0d0)**n)*bessj_d
  end if

  return
end function


real function delta(t,u)  ! ͥåΥǥ륿׻륵֥롼
  implicit none
  integer, intent(in) :: t  ! ʬ
  integer, intent(in) :: u  ! ʬ

  if(t==u)then
     delta=1.0
  else
     delta=0.0
  end if

  return
end function


subroutine besfzero(nmax,mmax,k)
!**********************************
!  ٥åؿΥ׻ *
!**********************************
  implicit none
  integer, intent(in) :: nmax          ! ٥åؿΥκĿ
  integer, intent(in) :: mmax          ! ٥åؿκ缡
  real, intent(inout) :: k(0:nmax,mmax)  ! mmax ޤǤ nmax+1 ĤΥǼ
  real :: bessj_f, a, b, c, d, e, f, g, lim, dx
  integer :: i, j, n

!-- ʬˡβȶ ---
  lim=1.0e-6    ! «

!-- ʬˡꤹ뤿,  ---
!-- ٥åؿΥδֳ֤Ϥ褽 3 ȤǤΤ,
!-- 0.5 Ĺ, ޤ
!-- ա˼ºݻѤκݤ, bessj_f ؿȤƤ뤫ǧΤ.
!-- Х
  dx=0.5
!-- ν ---
  do i=0,nmax
     do j=1,mmax
        k(i,j)=0.0
     end do
  end do

!-- 0 ׻ ---
  k(0,1)=0.0
  d=k(0,1)

  do 10 i=1,mmax

     if(i.gt.1)then
        d=k(0,i-1)+dx
     end if

     do while (k(0,mmax).eq.0.0)
        a=d
        e=bessj_f(0,a)
        b=a+dx
        f=bessj_f(0,b)
        d=d+dx

        do while (e*f.lt.0.0)
           c=0.5*(a+b)
           g=bessj_f(0,c)
           if(e*g.lt.0.0)then
              b=c
           else
              a=c
           end if

           if(abs(g).lt.lim)then
              k(0,i)=c
              go to 10
           end if

        end do
     end do 
  10 continue

  if(nmax > 0)then
!-- 1 ʾ׻ ---
     do n=1,nmax
     do 21 i=1,mmax
        d=k(n-1,i)+dx
        do while (k(n,mmax).eq.0.0)
           a=d
           e=bessj_f(n,a)
           b=a+dx
           f=bessj_f(n,b)
           d=d+dx
           do while (e*f.lt.0.0)
              c=0.5*(a+b)
              g=bessj_f(n,c)
              if(e*g.lt.0.0)then
                 b=c
              else
                 a=c
              end if
              if(abs(g).lt.lim)then
                 k(n,i)=c
                 go to 21
              end if
           end do
        end do
  21  continue
     end do
  end if

end subroutine


subroutine besdzero(nmax,mmax,k)
!**********************************
!  ٥åؿΥ׻ *
!**********************************
  implicit none
  integer, intent(in) :: nmax          ! ٥åؿΥκĿ
  integer, intent(in) :: mmax          ! ٥åؿκ缡
  double precision, intent(inout) :: k(0:nmax,mmax)  ! mmax ޤǤ nmax+1 ĤΥǼ
  double precision :: bessj_d, a, b, c, d, e, f, g, lim, dx
  integer :: i, j, n

!-- ʬˡβȶ ---
  lim=1.0d-6    ! «

!-- ʬˡꤹ뤿,  ---
!-- ٥åؿΥδֳ֤Ϥ褽 3 ȤǤΤ,
!-- 0.5 Ĺ, ޤ
  dx=0.5d0
!-- ν ---
  do i=0,nmax
     do j=1,mmax
        k(i,j)=0.0d0
     end do
  end do

!-- 0 ׻ ---
  k(0,1)=0.0d0
  d=k(0,1)

  do 10 i=1,mmax

     if(i.gt.1)then
        d=k(0,i-1)+dx
     end if

     do while (k(0,mmax).eq.0.0d0)
        a=d
        e=bessj_d(0,a)
        b=a+dx
        f=bessj_d(0,b)
        d=d+dx

        do while (e*f.lt.0.0d0)
           c=0.5d0*(a+b)
           g=bessj_d(0,c)
           if(e*g.lt.0.0d0)then
              b=c
           else
              a=c
           end if

           if(abs(g).lt.lim)then
              k(0,i)=c
              go to 10
           end if

        end do
     end do 
  10 continue

  if(nmax > 0)then
!-- 1 ʾ׻ ---
     do n=1,nmax
     do 21 i=1,mmax
        d=k(n-1,i)+dx
        do while (k(n,mmax).eq.0.0d0)
           a=d
           e=bessj_d(n,a)
           b=a+dx
           f=bessj_d(n,b)
           d=d+dx
           do while (e*f.lt.0.0d0)
              c=0.5d0*(a+b)
              g=bessj_d(n,c)
              if(e*g.lt.0.0d0)then
                 b=c
              else
                 a=c
              end if
              if(abs(g).lt.lim)then
                 k(n,i)=c
                 go to 21
              end if
           end do
        end do
  21  continue
     end do
  end if

end subroutine

end module Special_Function

