program draw
  use dcl
  use Dcl_Automatic
  use gtool_history
  use Statistics
  use Math_Const
  use max_min
  use Thermo_Const
  use file_operate
  use basis
  use ffts
  use Derivation

  implicit none

  integer :: i, j, k, it, ix, ivmax
  integer :: nx, ny, nl, nt, char_num, nit, ntt, ntxt, ndy
  integer :: xdmin, xdmax, ydmin, ydmax
  real :: xmin, xmax, ymin, ymax, xscale, yscale
  real :: vmax
  real, parameter :: coril=1.0e-5
  real, allocatable, dimension(:) :: x, y, time, theta, rk
  real, allocatable, dimension(:) :: ubar, vbar, hbar, rbar
  real, allocatable, dimension(:) :: unbar, vnbar, hnbar, pvbar
  real, allocatable, dimension(:) :: dunbardr, dvnbardr, dhnbardr
  real, allocatable, dimension(:,:) :: up, vp, hp, dupdt, dvpdr, pv, pvp
  real, allocatable, dimension(:,:) :: xd, yd
  real, allocatable, dimension(:,:) :: draw_cpl, draw_cpr, draw_cgr
  character(80) :: fname, txtname
  character(80), allocatable, dimension(:,:) :: cval
  character(10) :: title_tmp, cvmax
  real :: cmin, cmax, smin, smax, dt
  complex, allocatable, dimension(:,:) :: pvpf

!-- draw parameter
  real, dimension(2), parameter :: vl=(/0.1, 0.34/), vm=(/0.35, 0.59/)
  real, dimension(2), parameter :: vr=(/0.6, 0.84/), vv=(/0.3, 0.8/)
!  real, dimension(2), parameter :: vr=(/0.6, 0.84/), vv=(/0.1, 0.95/)

  namelist /drawinput /nx, ny, nt, nit, ntt, dt,  &
  &                    xmin, xmax, ymin, ymax, fname,  &
  &                    txtname, cmin, cmax, smin, smax
  read(5,nml=drawinput)

  if(mod(ny,2)/=0)then
     write(*,*) "### ERROR ###"
     write(*,*) "'ny' must be odd number for FFT"
     write(*,*) "adjustted 'ny'"
     ndy=ny-1
  else
     ndy=ny
  end if

  allocate(x(nx))
  allocate(y(ny))
  allocate(rk(nx))
  allocate(theta(ny))
  allocate(unbar(nx))
  allocate(vnbar(nx))
  allocate(hnbar(nx))
  allocate(pvbar(nx))
  allocate(ubar(nit))
  allocate(vbar(nit))
  allocate(hbar(nit))
  allocate(rbar(nit))
  allocate(dunbardr(nx))
  allocate(dvnbardr(nx))
  allocate(dhnbardr(nx))
  allocate(time(0:nt-1))
  allocate(up(nx,ny))
  allocate(vp(nx,ny))
  allocate(hp(nx,ny))
  allocate(dupdt(nx,ny))
  allocate(dvpdr(nx,ny))
  allocate(pv(nx,ny))
  allocate(pvp(nx,ny))
  allocate(pvpf(nx,ndy/2))
  allocate(draw_cpl(ny,0:nt-1))
  allocate(draw_cpr(nx,0:nt-1))
  allocate(draw_cgr(nx,0:nt-1))

  call SGISET('IFONT',2 )
  call UZFACT( 0.6 )
  call GLLSET('LMISS',.TRUE.)
  call DclSetParm( 'ENABLE_CONTOUR_MESSAGE', .false. )

!-- ѿ
  call HistoryGet( trim(fname), 'r', x(1:nx) )
  call HistoryGet( trim(fname), 'theta', y(1:ny) )

  rk=x*1.0e-3
  theta=y
  y=theta*180.0/pi

  xscale=0.005
  call calc_vscale( (/(xmax-xmin), (ymax-ymin)/), (/0.6, 0.6/), xscale, yscale )
  yscale=yscale

!  dummy=-10.0

!-- ΰη
  call nearest_search_1d( x, xmin, xdmin )
  call nearest_search_1d( x, xmax, xdmax )
  call nearest_search_1d( y, ymin, ydmin )
  call nearest_search_1d( y, ymax, ydmax )

!-- ƥȥǡ뤫ǧ
!-- ä, ĥҤ ".nc" ξ netcdf ǡȤưʬۤϤ.
  if(txtname/='')then

     ntxt=len_trim(txtname)

     if(txtname(ntxt-2:ntxt)=='.nc')then
        call HistoryGet( trim(txtname), 'vbar', vbar )
        call HistoryGet( trim(txtname), 'ubar', ubar )
        call HistoryGet( trim(txtname), 'hbar', hbar )
        call HistoryGet( trim(txtname), 'r', rbar )
     else
        nl=line_number_counter( trim(txtname) )
        allocate(xd(nl,1))
        allocate(yd(nl,1))
        allocate(cval(2,nl))

        call read_file_text( trim(txtname), 2, nl, cval )

        do i=1,nl
           xd(i,1)=c2r_convert( cval(1,i) )
           yd(i,1)=c2r_convert( cval(2,i) )
        end do
     end if
  end if

  call color_setting( 10, (/smin, smax/), col_tab=14, min_tab=10999, max_tab=99999 )  

  call DclOpenGraphics(2)

  do it=0,nt-1

     write(*,'(f5.1)') it*dt
     write(title_tmp,'(f7.1)') it*dt
!     title_tmp=r2c_convert( (it*dt), '(f3.1)' )
     title_tmp='t='//trim(adjustl(title_tmp))
     write(*,*) "read time is ", title_tmp
     time(it)=real(it*dt/3600)

     call HistoryGet( trim(fname), 'up', up, range=trim(title_tmp) )
     call HistoryGet( trim(fname), 'vp', up, range=trim(title_tmp) )
     call HistoryGet( trim(fname), 'hp', up, range=trim(title_tmp) )

  !-- ʲ, PV η׻
  !-- ޤ, оξΥǡ, ǡδֳ֤ޤ.
     do k=1,nx
        call interpo_search_1d( rbar, x(k), ix )
        call interpolation_1d( rbar(ix:ix+1), vbar(ix:ix+1),  &
  &                            x(k), vnbar(k) )
        call interpolation_1d( rbar(ix:ix+1), ubar(ix:ix+1),  &
  &                            x(k), unbar(k) )
        call interpolation_1d( rbar(ix:ix+1), hbar(ix:ix+1),  &
  &                            x(k), hnbar(k) )
     end do

  !-- η׻
     call grad_1d( x, vnbar, dvnbardr )
!     call grad_1d( x, hnbar, dhnbardr )
!     call grad_1d( x, unbar, dunbardr )

     do k=1,ny
        call grad_1d( x, vp(:,k), dvpdr(:,k) )
     end do

     do k=1,nx
        call grad_1d( theta, up(k,:), dupdt(k,:) )
     end do

  !-- PV η׻

     do k=1,ny
        do j=1,nx
           if(x(j)/=0.0)then
              pv(j,k)=(coril+dvnbardr(j)+dvpdr(j,k)  &
  &                   +(vnbar(j)+vp(j,k)+dupdt(j,k))/x(j))/(hnbar(j)+hp(j,k))*1.0e6
           else
              pv(j,k)=0.0
           end if
        end do
     end do

     !-- PV ΥΥޥ׻
     do k=1,nx
        call Mean_1d( pv(k,:), pvbar(k) )
        call Anomaly_1d( pv(k,:), pvp(k,:) )
     end do

     !-- PVp  FFT
     do k=1,nx
        call r2c_ffttp_1d( ndy, pvp(k,1:ndy), pvpf(k,1:ndy/2) )
     end do

     !-- ɽȿΤ ntt ʬΥ (Cpl)
     do k=1,ndy/2
        do j=1,nx
           if(k/=ntt+1)then
              pvpf(j,k)=(0.0,0.0)
           end if
        end do
     end do

  !-- ʲ, ޤΤΥѥ᡼׻

     !-- r-t ޤΤ
     do k=1,nx
        draw_cpr(k,it)=real(pvpf(k,ntt+1))
        draw_cgr(k,it)=abs(pvpf(k,ntt+1))
     end do

     !-- theta-t ޤΤ
        !-- PVpf  IFFT
     do k=1,nx
        call c2r_ffttp_1d( ndy, pvpf(k,1:ndy/2), pvp(k,1:ndy) )
     end do

        !-- 褵Ⱦ¤(®Ⱦ¤Ƿ׻)
     call max_val_1d( vnbar, ivmax, vmax )
     do k=1,ny
        draw_cpl(k,it)=real(pvp(ivmax,k))
     end do

  end do

  cvmax=r2c_convert( x(ivmax)*1.0e-3, '(f5.1)' )

  call Dcl_2D_cont_shade(  &
  &    'C_gl"',  &
  &    rk(xdmin:xdmax), time,  &
  &    draw_cgr(xdmin:xdmax,:),  &
  &    draw_cgr(xdmin:xdmax,:),  &
  &    (/cmin, cmax/), (/smin, smax/),  &
  &    (/'radius (km)', ''/), (/'(f6.1)', 'f(6.1)'/),  &
  &    c_num=(/10, 10/), viewx_int=vr, viewy_int=vv,  &
  &    no_tone=.true. )  !,  &

  call Dcl_2D_cont_shade(  &
  &    'C_pr"',  &
  &    rk(xdmin:xdmax), time,  &
  &    draw_cpr(xdmin:xdmax,:),  &
  &    draw_cpr(xdmin:xdmax,:),  &
  &    (/cmin, cmax/), (/smin, smax/),  &
  &    (/'radius (km)', ''/), (/'(f6.1)', 'f(6.1)'/),  &
  &    c_num=(/10, 10/), viewx_int=vm, viewy_int=vv,  &
  &    no_frame=.true., no_tone=.true. )  !,  &

  call Dcl_2D_cont_shade(  &
  &    'C_pl (RMW='//trim(cvmax)//'km)"',  &
  &    y(ydmin:ydmax), time,  &
  &    draw_cpl(ydmin:ydmax,:),  &
  &    draw_cpl(ydmin:ydmax,:),  &
  &    (/cmin, cmax/), (/smin, smax/),  &
  &    (/'angle (degree)', 'time series (hour)'/), (/'(f6.1)', '(f6.1)'/),  &
  &    c_num=(/10, 10/), viewx_int=vl, viewy_int=vv,  &
  &    no_frame=.true., no_tone=.true. )  !,  &

  call tone_bar( 10, (/smin, smax/), (/vr(2)+0.025, vr(2)+0.05/), vv,  &
  &              '(f6.1)', trigle='a' )

  call DclCloseGraphics

end program
