program wind
! ŪʵͿ, ʬ롼󤫤Ϲ䱲٤׻롼.
! ޤ, ή׻.
  use Math_Const
  use trajectory
  use Derivation
  use gtool_history
  implicit none
  integer :: i, j
  integer, parameter :: nx=300, ny=300    ! ʿʻ
  integer, parameter :: tstep=20000       ! ήη׻ƥå
  real, dimension(nx,ny) :: u, v          ! Ϲ
  real, dimension(nx,ny) :: rot_2d, pres  ! ľ٤ȵ
  real, dimension(tstep,1) :: tx, ty      ! ή x, y ɸ
  real :: x(nx), y(ny)                    ! ֺɸ
  real, parameter :: xmin=-pi, xmax=pi    ! x ΰ 
  real, parameter :: ymin=-pi, ymax=pi    ! y ΰ
  real, parameter :: dt=0.1               ! ήη׻ֳִ
  real :: dx, dy                          ! ʻҲ
  character(3) :: sche
  logical :: FTF

  dx=(xmax-xmin)/(nx-1)
  dy=(ymax-ymin)/(ny-1)

  x=(/((xmin+dx*(i-1)),i=1,nx)/)
  y=(/((ymin+dy*(i-1)),i=1,ny)/)

  write(*,*) "input scheme of time integration."
  write(*,*) "EU1 or RK4."
  read(*,*) sche

  do j=1,ny
     do i=1,nx
        pres(i,j)=cos(x(i))+cos(y(j))  ! ŪʵͿ.
     end do
  end do

  do j=1,ny
     call grad_1d( x, pres(:,j), v(:,j) )  ! dp/dx ׻
  end do
  do i=1,nx
     call grad_1d( y, pres(i,:), u(i,:) )  ! dp/dy ׻
  end do

  v=-v

  call curl( x, y, u, v, rot_2d )  ! u, v Ϲ٤׻

  call Stream_Line_2d( dt,  &                ! ֳִ
  &                    tstep,  &             ! ֥ƥå
  &                    0.1, 0.1,  &          ! ѡν (x,y) ɸ
  &                    x, y,  &              ! x, y ɸ
  &                    u, v,  &              ! x, y γƤ®پ
  &                    tx(:,1), ty(:,1),  &  ! ºݤήε
  &                    FTF,  &               ! ή׻ΰ賰˽ФȽ
  &                    sche )                ! ֥

!-- gtool writing (netcdf)

  call HistoryCreate( &                             ! ҥȥ꡼
    & file='wind.nc', title='derivation test program', &
    & source='Sample program of gtool_history/gtool5',   &
    & institution='GFD_Dennou Club davis project',       &
    & dims=(/'x','y'/), dimsizes=(/nx,ny/),               &
    & longnames=(/'X-coordinate','Y-coordinate'/),       &
    & units=(/'m','m'/),                                 &
    & origin=0.0, interval=0.0 )

  call HistoryPut('x',x)                            ! ѿ
  call HistoryPut('y',y)                            ! ѿ

  call HistoryAddVariable( &                        ! ѿ
    & varname='pres', dims=(/'x','y'/), &
    & longname='pressure', units='1', xtype='float')

  call HistoryPut('pres',pres)                      ! ѿ

  call HistoryAddVariable( &                        ! ѿ
    & varname='rot', dims=(/'x','y'/), &
    & longname='rotation', units='1/s', xtype='float')

  call HistoryPut('rot',rot_2d)                      ! ѿ

  call HistoryAddVariable( &                        ! ѿ
    & varname='u', dims=(/'x','y'/), &
    & longname='X-wind', units='1', xtype='float')

  call HistoryPut('u',u)                      ! ѿ

  call HistoryAddVariable( &                        ! ѿ
    & varname='v', dims=(/'x','y'/), &
    & longname='Y-wind', units='1', xtype='float')

  call HistoryPut('v',v)                      ! ѿ
  call HistoryClose

  open(unit=10,file='wind.dat',status='unknown')
     do i=1,tstep
        write(10,*) tx(i,1), ty(i,1)
     end do
  close(unit=10)

end program
