!---------------------------------------------------------------
! Copyright (C) 2009-2013 GFD Dennou Club. All rights reserved.
!---------------------------------------------------------------

module Ellip_Slv   ! 黻Ѥʱ߷ʬ򤯥⥸塼

  public  :: Ellip_GauSei_2d, Ellip_Gausei_3d
  public  :: Ellip_Jacobi_2d, Ellip_Jacobi_3d
  private :: set_bound, setval_bound, set_coe, calculate_bound
  private :: set_bound_3d, setval_bound_3d, set_coe_3d, calculate_bound_3d
!  private :: check_bound

contains

subroutine Ellip_GauSei_2d( x, y, rho, eps, boundary, psi, bound_opt,  &
  &                         a, b, c, d, e, f, undef, inner_bound, init_flag,  &
  &                         accel, ln )
! =ǥˡˤʱ߷ε
! ƥץ, ݥϤγʬ. ǥեȤϥꤵ.
! $$a\dfrac{\partial ^2\psi}{\partial x^2} +b\dfrac{\partial ^2\psi}{\partial x\partial y} +c\dfrac{\partial ^2\psi}{\partial y^2} +d\dfrac{\partial \psi}{\partial x} +e\dfrac{\partial \psi}{\partial y} +f\psi =\rho $$
! γƷбƤ.
  implicit none
  real, intent(in) :: x(:)  ! ΰβɸ
  real, intent(in) :: y(:)  ! ΰνĺɸ
  real, intent(in) :: rho(size(x),size(y))  ! ݥζ
                   ! rho =0 ǥץ饹Ѳǽ
  real, intent(in) :: eps  ! «
  character(4), intent(in) :: boundary  ! 
                ! 4 ʸǳդζͿ.
                ! 1 ʸ : x ü, 2 ʸ : y ü, 3 ʸ : x ü,
                ! 4 ʸ : y ü
                ! boundary  1 : ü, 2 : ͳü, 3 : 
  real, intent(in), optional :: bound_opt(size(x),size(y))  ! Ǥζ
                             ! Υޥ󶭳ξ : եå
  real, intent(in), optional :: a(size(x),size(y))  ! ʬη
  real, intent(in), optional :: b(size(x),size(y))  ! ʬη
  real, intent(in), optional :: c(size(x),size(y))  ! ʬη
  real, intent(in), optional :: d(size(x),size(y))  ! ʬη
  real, intent(in), optional :: e(size(x),size(y))  ! ʬη
  real, intent(in), optional :: f(size(x),size(y))  ! ʬη
  real, intent(inout) :: psi(size(x),size(y))  ! ݥβ
  real, intent(in), optional :: undef  ! ̤
  integer, intent(in), optional :: inner_bound(size(x),size(y))
                             ! ΰζ. ͤ˱ƤγʻǶͷ׻
                             ! 1 = ü, 10 = ¦.
                             ! 2 = y ͳü (եåϾ)
                             ! -2 = y ͳü (եåϲ)
                             ! 4 = x ͳü (եåϱ)
                             ! -4 = x ͳü (եåϺ)
                             ! 3 = 
                             ! 8 = |_, ~| ξȤ⼫ͳ
                             ! -8 = |~, _| ξȤ⼫ͳ
                             ! ΰͿʤΰ׻.
                             ! ¦ʻ (10) ȿ׻Ԥ鷺,
                             ! undef ꤵ줿ͤ⤷ϥ.
                             ! ΤȤζͤ bound_opt ͤѤ.
  logical, intent(in), optional :: init_flag  ! psi ͤ򥼥ǽ뤫.
                             ! .true. = . .false. = ʤ.
                             ! ǥեȤǤϽ.
  real, intent(in), optional :: accel  ! SOR β® (0 < accel < 2)
                             ! ǥե = 1
  integer, intent(in), optional :: ln  ! ȿ
                             ! ͤͿȤ, eps ̵ͤط
                             ! ln 롼פ.
  integer :: i, j, ix, jy, nl, counter
  integer :: nx  ! x 
  integer :: ny  ! y 
  integer :: signb  ! Ʒ׻뤫ɤ
  integer, dimension(size(x),size(y)) :: ib

  real :: defun
  real :: tmp, err, err_max
  real :: tmp_b, accc
  real :: bnd(size(x),size(y))
  real :: dx(size(x)), dy(size(y)), dx2(size(x)), dy2(size(y))
  real, dimension(size(x),size(y)) :: dxdy
  real, dimension(size(x),size(y)) :: at, bt, ct, dt, et, ft
  real, dimension(size(x),size(y)) :: adp, adm, cep, cem, ac, divi

  character(4) :: bound
  logical :: sor_flag
  logical, dimension(size(x),size(y)) :: inner_flag

  bound(1:4)=boundary(1:4)

  nx=size(x)
  ny=size(y)

!-- ؿν

  if(present(init_flag))then
     if(init_flag.eqv..true.)then
        psi = 0.0
     end if
  else
     psi = 0.0
  end if

!-- Ƚ̥ե饰

  if(present(inner_bound))then
     call set_bound( bound, ib, inner_flag, inner_bound )
  else
     call set_bound( bound, ib, inner_flag )
  end if

!-- ΰ衦ˤ붭ͤ

  if(present(bound_opt))then
     call setval_bound( ib, bnd, psi, bound_opt )
  else
     call setval_bound( ib, bnd, psi )
  end if

!-- ̤ͤ

  if(present(undef))then
     defun=undef
  else
     defun=0.0
  end if

!-- 
!-- a, c ˤĤƤ, ͤƤʤ,  1 .
  if(present(a))then
     call set_coe( at, ext=a )
  else
     call set_coe( at, def=1.0 )
  end if

  if(present(c))then
     call set_coe( ct, ext=c )
  else
     call set_coe( ct, def=1.0 )
  end if

  if(present(b))then
     call set_coe( bt, ext=b )
     signb=1
  else
     call set_coe( bt, def=0.0 )
     signb=0
  end if

  if(present(d))then
     call set_coe( dt, ext=d )
  else
     call set_coe( dt, def=0.0 )
  end if

  if(present(e))then
     call set_coe( et, ext=e )
  else
     call set_coe( et, def=0.0 )
  end if

  if(present(f))then
     call set_coe( ft, ext=f )
  else
     call set_coe( ft, def=0.0 )
  end if

!-- ǹⳬˤ뷸å. (ǤʤĴ٤.)

  call check_coe( at, 0.0 )
  call check_coe( ct, 0.0 )

!-- ®Ƚ

  if(present(accel))then
     accc=accel
     sor_flag=.true.
  else
     sor_flag=.false.
  end if

!-- ln ν
  if(present(ln))then
     nl=ln
  else
     nl=0
  end if

!-- ʲ˳ʻҴֳ 1 ׻Ǥ褤ΤƤ.
!--  1 ΤߤѲФ褤.
!-- ʻֳ֤η׻
  do i=2,nx-1
     dx(i)=(x(i+1)-x(i-1))*0.5
     dx2(i)=dx(i)**2
  end do
  do j=2,ny-1
     dy(j)=(y(j+1)-y(j-1))*0.5
     dy2(j)=dy(j)**2
  end do

  dx(1)=(x(2)-x(1))
  dx(nx)=(x(nx)-x(nx-1))
  dy(1)=(y(2)-y(1))
  dy(ny)=(y(ny)-y(ny-1))

  do j=1,ny
     do i=1,nx
        dxdy(i,j)=dx(i)*dy(j)
     end do
  end do

!-- ݥ󷸿η׻
!-- ºݤ˥ݥ󷸿ѤΤ,  1 ¦ʤΤ,
!-- ׻̺︺Τ, 롼פ򤽤Τ褦ˤƤ.

  ac=0.0
  adp=0.0
  adm=0.0
  cep=0.0
  cem=0.0
  bt=0.0

!-- ǹ⼡ ac η׻
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j)

  do j=2,ny-1
     do i=2,nx-1
        ac(i,j)=1.0/(2.0*(at(i,j)/dx2(i)+ct(i,j)/dy2(j))-ft(i,j))
        adp(i,j)=(at(i,j)/(dx2(i))+0.5*dt(i,j)/dx(i))*ac(i,j)
        adm(i,j)=(at(i,j)/(dx2(i))-0.5*dt(i,j)/dx(i))*ac(i,j)
        cep(i,j)=(ct(i,j)/(dy2(j))+0.5*et(i,j)/dy(j))*ac(i,j)
        cem(i,j)=(ct(i,j)/(dy2(j))-0.5*et(i,j)/dy(j))*ac(i,j)
        bt(i,j)=0.25*bt(i,j)/(dxdy(i,j))*ac(i,j)
     end do
  end do

!$omp end do
!$omp end parallel

  err_max=eps  ! while 뤿صŪ
  counter=0

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0

     do j=1,ny
        do i=1,nx

!-- ʹ, ȿ׻ɬפμ 8 ˤĤƤ줾
!-- inner_flag ΥåƱŬڤͤ򤽤줾༡׻,
!-- , γʻҷ׻ԤäƤ뤬, ib=8,-8  4 ʻҤΤȤˤ
!-- case select ʤ. ʤʤ, 岼˶ʻҤ뤳ȤϤꤨʤ.
           if(inner_flag(i,j).eqv..false.)then  ! .false. ʤΰ׻
              tmp=-rho(i,j)*ac(i,j)
              tmp=tmp+adp(i,j)*psi(i+1,j)  &
 &                   +adm(i,j)*psi(i-1,j)  &
 &                   +cep(i,j)*psi(i,j+1)  &
 &                   +cem(i,j)*psi(i,j-1)

              if(signb==0)then  ! ⤽ bt = 0 ʤ׻ʤ.
                 tmp_b=0.0
              else
                 tmp_b=bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                            -psi(i+1,j-1)-psi(i-1,j+1))
              end if

              tmp=tmp+tmp_b

           else  ! .true. ʤ鶭׻˰ܹ.

              select case (ib(i,j))
              case (1)
                 tmp=bnd(i,j)

              case (2)  ! x ˥եå, ¦
                 tmp=psi(i+1,j)-bnd(i,j)*dx(i)

              case (-2)  ! x ˥եå, ¦
                 tmp=psi(i-1,j)+bnd(i,j)*dx(i)

              case (4)  ! y ˥եå, ¦
                 tmp=psi(i,j+1)-bnd(i,j)*dy(j)

              case (-4)  ! y ˥եå, ¦
                 tmp=psi(i,j-1)+bnd(i,j)*dy(j)

              case (3)  ! 
                 if(i==1)then
                    ix=nx-1
                 else if(i==nx)then
                    ix=2
                 else
                    ix=i
                 end if
                 if(j==1)then
                    jy=ny-1
                 else if(j==ny)then
                    jy=2
                 else
                    jy=j
                 end if

                 tmp=psi(ix,jy)

              case (7)  ! ξեå.
                 if((ib(i+1,j+1)==10).and.(ib(i+1,j)/=10).and.  &
  &                 (ib(i,j+1)/=10))then
                    tmp=0.5*(psi(i-1,j+1)+psi(i+1,j-1)  &
  &                         +bnd(i,j+1)*dx(i)+bnd(i+1,j)*dy(j))

                 else if((ib(i-1,j-1)==10).and.(ib(i-1,j)/=10).and.  &
  &                      (ib(i,j-1)/=10))then
                    tmp=0.5*(psi(i+1,j-1)+psi(i-1,j+1)  &
  &                         -bnd(i,j-1)*dx(i)-bnd(i-1,j)*dy(j))

                 end if

              case (-7)  ! ξեå.
                 if((ib(i-1,j+1)==10).and.(ib(i-1,j)/=10).and.  &
  &                 (ib(i,j+1)/=10))then
                    tmp=0.5*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                         -bnd(i,j+1)*dx(i)+bnd(i-1,j)*dy(j))

                 else if((ib(i+1,j-1)==10).and.(ib(i+1,j)/=10).and.  &
  &                 (ib(i,j-1)/=10))then
                    tmp=0.5*(psi(i-1,j-1)+psi(i+1,j+1)  &
  &                         +bnd(i,j-1)*dx(i)-bnd(i+1,j)*dy(j))

                 end if

              case (8)  ! ξեåǺѤ, ⤷.
                 if(i==1.and.j==1)then  ! -- ɾ 1
                    tmp=psi(i+1,j+1)-0.5*(bnd(i+1,j)*dy(j)+bnd(i,j+1)*dx(i))

                 else if(i==nx.and.j==ny)then  ! -- ɾ 2
                    tmp=psi(i-1,j-1)+0.5*(bnd(i-1,j)*dy(j)+bnd(i,j-1)*dx(i))

                 else if(ib(i-1,j)==10.and.ib(i,j-1)==10)then
                    ! -- ɾ 1 Ʊ
                    tmp=psi(i+1,j+1)-0.5*(bnd(i+1,j)*dy(j)+bnd(i,j+1)*dx(i))

                 else if(ib(i+1,j)==10.and.ib(i,j+1)==10)then
                    ! -- ɾ 2 Ʊ
                    tmp=psi(i-1,j-1)+0.5*(bnd(i-1,j)*dy(j)+bnd(i,j-1)*dx(i))

                 end if

              case (-8)  ! ξեåǱѤ
                 if(i==1.and.j==ny)then  ! -- ɾ 1
                    tmp=psi(i+1,j-1)+0.5*(bnd(i+1,j)*dy(j)-bnd(i,j-1)*dx(i))

                 else if(i==nx.and.j==1)then  ! -- ɾ 2
                    tmp=psi(i-1,j+1)+0.5*(-bnd(i-1,j)*dy(j)+bnd(i,j+1)*dx(i))

                 else if(ib(i-1,j)==10.and.ib(i,j+1)==10)then
                    ! -- ɾ 1 Ʊ
                    tmp=psi(i+1,j-1)+0.5*(bnd(i+1,j)*dy(j)-bnd(i,j-1)*dx(i))

                 else if(ib(i+1,j)==10.and.ib(i,j-1)==10)then
                    ! -- ɾ 2 Ʊ
                    tmp=psi(i-1,j+1)+0.5*(-bnd(i-1,j)*dy(j)+bnd(i,j+1)*dx(i))

                 end if
              end select

           end if

           if(sor_flag.eqv..true.)then
              tmp=(1.0-accc)*psi(i,j)+tmp*accc
           end if

           err=abs(tmp-psi(i,j))

!-- ι
           if(err_max<=err)then
              err_max=err
           end if

           psi(i,j)=tmp

        end do
     end do

     if(nl/=0)then
        err_max=eps
        counter=counter+1
        if(counter==nl)then
           exit
        end if
     end if

  end do

!-- 

  call calculate_bound( ib, dx, dy, bnd, psi )

!-- ̤ΰˤ undef .

  do j=1,ny
     do i=1,nx
        if(ib(i,j)==10)then
           psi(i,j)=defun
        end if
     end do
  end do

end subroutine Ellip_GauSei_2d


subroutine Ellip_Jacobi_2d( x, y, rho, eps, boundary, psi, bound_opt,  &
  &                         a, b, c, d, e, f, undef, inner_bound, init_flag,  &
  &                         accel, ln )
  ! openmp ˤ륹å󤬲ǽ.
  ! ǥˡǤϥ르ꥺ󲽤Ȼפ줿Τ,
  ! ׻ˤݥεѤɬפȤʤʤ,
  ! 䥳ˡΤΤѤ줿.
  implicit none
  real, intent(in) :: x(:)  ! ΰβɸ
  real, intent(in) :: y(:)  ! ΰνĺɸ
  real, intent(in) :: rho(size(x),size(y))  ! ݥζ
                   ! rho =0 ǥץ饹Ѳǽ
  real, intent(in) :: eps  ! «
  character(4), intent(in) :: boundary  ! 
                ! 4 ʸǳդζͿ.
                ! 1 ʸ : x ü, 2 ʸ : y ü, 3 ʸ : x ü,
                ! 4 ʸ : y ü
                ! boundary  1 : ü, 2 : ͳü, 3 : 
  real, intent(in), optional :: bound_opt(size(x),size(y))  ! Ǥζ
                             ! Υޥ󶭳ξ : եå
  real, intent(in), optional :: a(size(x),size(y))  ! ʬη
  real, intent(in), optional :: b(size(x),size(y))  ! ʬη
  real, intent(in), optional :: c(size(x),size(y))  ! ʬη
  real, intent(in), optional :: d(size(x),size(y))  ! ʬη
  real, intent(in), optional :: e(size(x),size(y))  ! ʬη
  real, intent(in), optional :: f(size(x),size(y))  ! ʬη
  real, intent(in), optional :: undef  ! ̤
  integer, intent(in), optional :: inner_bound(size(x),size(y))
                             ! ΰζ. ͤ˱ƤγʻǶͷ׻
                             ! 1 = ü, 10 = ¦.
                             ! 2 = y ͳü (եåϾ)
                             ! -2 = y ͳü (եåϲ)
                             ! 4 = x ͳü (եåϱ)
                             ! -4 = x ͳü (եåϺ)
                             ! 3 = , -3 = ΰξȤ
                             ! 8 = |_, ~| ξȤ⼫ͳ
                             ! -8 = |~, _| ξȤ⼫ͳ
                             ! ΰͿʤΰ׻.
                             ! ¦ʻ (10) ȿ׻Ԥ鷺,
                             ! undef ꤵ줿ͤ⤷ϥ.
                             ! ΤȤζͤ bound_opt ͤѤ.
  real, intent(inout) :: psi(size(x),size(y))  ! ݥβ
  logical, intent(in), optional :: init_flag  ! psi ͤ򥼥ǽ뤫.
                             ! .true. = . .false. = ʤ.
                             ! ǥեȤǤϽ.
  real, intent(in), optional :: accel  ! SOR β® (0 < accel < 2)
                             ! ǥե = 1
  integer, intent(in), optional :: ln  ! ȿ
                             ! ͤͿȤ, eps ̵ͤط
                             ! ln 롼פ.

  integer :: i, j, ix, jy, nl, counter
  integer :: nx  ! x 
  integer :: ny  ! y 
  integer :: signb  !  b ¸ߤ뤫
  integer, dimension(size(x),size(y)) :: ib

  real :: defun
  real :: err, err_max, accc
  real :: bnd(size(x),size(y))
  real :: dx(size(x)), dy(size(y)), dx2(size(x)), dy2(size(y))
  real, dimension(size(x),size(y)) :: dxdy
  real, dimension(size(x),size(y)) :: at, bt, ct, dt, et, ft
  real, dimension(size(x),size(y)) :: adp, adm, cep, cem, ac
  real, dimension(size(x),size(y)) :: tmp, tmp_b, divi

  character(4) :: bound
  logical :: sor_flag
  logical, dimension(size(x),size(y)) :: inner_flag

  bound(1:4)=boundary(1:4)

  nx=size(x)
  ny=size(y)

!-- ؿν

  if(present(init_flag))then
     if(init_flag.eqv..true.)then
        psi = 0.0
     end if
  else
     psi = 0.0
  end if

!-- Ƚ̥ե饰

  if(present(inner_bound))then
     call set_bound( bound, ib, inner_flag, inner_bound )
  else
     call set_bound( bound, ib, inner_flag )
  end if

!-- ΰ衦ˤ붭ͤ

  if(present(bound_opt))then
     call setval_bound( ib, bnd, psi, bound_opt )
  else
     call setval_bound( ib, bnd, psi )
  end if

!-- ̤ͤ

  if(present(undef))then
     defun=undef
  else
     defun=0.0
  end if

!-- 
!-- a, c ˤĤƤ, ͤƤʤ,  1 .

  if(present(a))then
     call set_coe( at, ext=a )
  else
     call set_coe( at, def=1.0 )
  end if

  if(present(c))then
     call set_coe( ct, ext=c )
  else
     call set_coe( ct, def=1.0 )
  end if

  if(present(b))then
     call set_coe( bt, ext=b )
     signb=1
  else
     call set_coe( bt, def=0.0 )
     signb=0
  end if

  if(present(d))then
     call set_coe( dt, ext=d )
  else
     call set_coe( dt, def=0.0 )
  end if

  if(present(e))then
     call set_coe( et, ext=e )
  else
     call set_coe( et, def=0.0 )
  end if

  if(present(f))then
     call set_coe( ft, ext=f )
  else
     call set_coe( ft, def=0.0 )
  end if

!-- ǹⳬˤ뷸å. (ǤʤĴ٤.)

  call check_coe( at, 0.0 )
  call check_coe( ct, 0.0 )

!-- ®Ƚ

  if(present(accel))then
     accc=accel
     sor_flag=.true.
  else
     sor_flag=.false.
  end if

!-- ln ν
  if(present(ln))then
     nl=ln
  else
     nl=0
  end if

!-- ʲ˳ʻҴֳ 1 ׻Ǥ褤ΤƤ.
!--  1 ΤߤѲФ褤.
!-- ʻֳ֤η׻
  do i=2,nx-1
     dx(i)=(x(i+1)-x(i-1))*0.5
     dx2(i)=dx(i)**2
  end do
  do j=2,ny-1
     dy(j)=(y(j+1)-y(j-1))*0.5
     dy2(j)=dy(j)**2
  end do

  dx(1)=(x(2)-x(1))
  dx(nx)=(x(nx)-x(nx-1))
  dy(1)=(y(2)-y(1))
  dy(ny)=(y(ny)-y(ny-1))

  do j=1,ny
     do i=1,nx
        dxdy(i,j)=dx(i)*dy(j)
     end do
  end do

!-- ݥ󷸿η׻
!-- ºݤ˥ݥ󷸿ѤΤ,  1 ¦ʤΤ,
!-- ׻̺︺Τ, 롼פ򤽤Τ褦ˤƤ.

  ac=0.0
  adp=0.0
  adm=0.0
  cep=0.0
  cem=0.0
  bt=0.0

!-- ǹ⼡ ac η׻
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j)

  do j=2,ny-1
     do i=2,nx-1
        ac(i,j)=1.0/(2.0*(at(i,j)/dx2(i)+ct(i,j)/dy2(j))-ft(i,j))
        adp(i,j)=(at(i,j)/(dx2(i))+0.5*dt(i,j)/dx(i))*ac(i,j)
        adm(i,j)=(at(i,j)/(dx2(i))-0.5*dt(i,j)/dx(i))*ac(i,j)
        cep(i,j)=(ct(i,j)/(dy2(j))+0.5*et(i,j)/dy(j))*ac(i,j)
        cem(i,j)=(ct(i,j)/(dy2(j))-0.5*et(i,j)/dy(j))*ac(i,j)
        bt(i,j)=0.25*bt(i,j)/(dxdy(i,j))*ac(i,j)
     end do
  end do

!$omp end do
!$omp end parallel

  err_max=eps  ! while 뤿صŪ
  counter=0

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,ix,jy)
     do j=1,ny
        do i=1,nx

!-- ʹ, ȿ׻ɬפμ 8 ˤĤƤ줾
!-- inner_flag ΥåƱŬڤͤ򤽤줾༡׻,
!-- , γʻҷ׻ԤäƤ뤬, ib=8,-8  4 ʻҤΤȤˤ
!-- case select ʤ. ʤʤ, 岼˶ʻҤ뤳ȤϤꤨʤ.
           if(inner_flag(i,j).eqv..false.)then  ! .false. ʤΰ׻
              tmp(i,j)=-rho(i,j)*ac(i,j)
              tmp(i,j)=tmp(i,j)+adp(i,j)*psi(i+1,j)  &
 &                             +adm(i,j)*psi(i-1,j)  &
 &                             +cep(i,j)*psi(i,j+1)  &
 &                             +cem(i,j)*psi(i,j-1)
              if(signb==0)then  ! ⤽ bt = 0 ʤ׻ʤ.
                  tmp_b(i,j)=0.0
              else
                  tmp_b(i,j)=bt(i,j)*(psi(i+1,j+1)+psi(i-1,j-1)  &
  &                             -psi(i+1,j-1)-psi(i-1,j+1))
              end if

              tmp(i,j)=tmp(i,j)+tmp_b(i,j)

           else  ! .true. ʤ鶭׻˰ܹ.

              select case (ib(i,j))
              case (1)
                 tmp(i,j)=bnd(i,j)

              case (2)  ! x ˥եå, ¦
                 tmp(i,j)=psi(i+1,j)-bnd(i,j)*dx(i)

              case (-2)  ! x ˥եå, ¦
                 tmp(i,j)=psi(i-1,j)+bnd(i,j)*dx(i)

              case (4)  ! y ˥եå, ¦
                 tmp(i,j)=psi(i,j+1)-bnd(i,j)*dy(j)

              case (-4)  ! y ˥եå, ¦
                 tmp(i,j)=psi(i,j-1)+bnd(i,j)*dy(j)

              case (3)  ! 
                 if(i==1)then
                    ix=nx-1
                 else if(i==nx)then
                    ix=2
                 else
                    ix=i
                 end if
                 if(j==1)then
                    jy=ny-1
                 else if(j==ny)then
                    jy=2
                 else
                    jy=j
                 end if

                 tmp(i,j)=psi(ix,jy)

              case (7)  ! ξեå.
                 if((ib(i+1,j+1)==10).and.(ib(i+1,j)/=10).and.  &
  &                 (ib(i,j+1)/=10))then
                    tmp(i,j)=0.5*(psi(i-1,j)+psi(i,j-1))  &
  &                          +0.5*bnd(i,j)*(dy(j)+dx(i))

                 else if((ib(i-1,j-1)==10).and.(ib(i-1,j)/=10).and.  &
  &                      (ib(i,j-1)/=10))then
                    tmp(i,j)=0.5*(psi(i+1,j)+psi(i,j+1))  &
  &                          -0.5*bnd(i,j)*(dy(j)+dx(i))

                 end if

              case (-7)  ! ξեå.
                 if((ib(i-1,j+1)==10).and.(ib(i-1,j)/=10).and.  &
  &                 (ib(i,j+1)/=10))then
                    tmp(i,j)=0.5*(psi(i+1,j)+psi(i,j-1))  &
  &                          +0.5*bnd(i,j)*(dy(j)-dx(i))

                 else if((ib(i+1,j-1)==10).and.(ib(i+1,j)/=10).and.  &
  &                 (ib(i,j-1)/=10))then
                    tmp(i,j)=0.5*(psi(i-1,j)+psi(i,j+1))  &
  &                          +0.5*bnd(i,j)*(-dy(j)+dx(i))

                 end if

              case (8)  ! ξեåǺѤ, ⤷.
                 if(i==1.and.j==1)then  ! -- ɾ 1
                    tmp(i,j)=psi(i+1,j+1)-0.5*(bnd(i+1,j)*dy(j)+bnd(i,j+1)*dx(i))

                 else if(i==nx.and.j==ny)then  ! -- ɾ 2
                    tmp(i,j)=psi(i-1,j-1)+0.5*(bnd(i-1,j)*dy(j)+bnd(i,j-1)*dx(i))

                 else if(ib(i-1,j)==10.and.ib(i,j-1)==10)then
                    ! -- ɾ 1 Ʊ
                    tmp(i,j)=psi(i+1,j+1)-0.5*(bnd(i+1,j)*dy(j)+bnd(i,j+1)*dx(i))

                 else if(ib(i+1,j)==10.and.ib(i,j+1)==10)then
                    ! -- ɾ 2 Ʊ
                    tmp(i,j)=psi(i-1,j-1)+0.5*(bnd(i-1,j)*dy(j)+bnd(i,j-1)*dx(i))

                 end if

              case (-8)  ! ξեåǱѤ
                 if(i==1.and.j==ny)then  ! -- ɾ 1
                    tmp(i,j)=psi(i+1,j-1)+0.5*(bnd(i+1,j)*dy(j)-bnd(i,j-1)*dx(i))

                 else if(i==nx.and.j==1)then  ! -- ɾ 2
                    tmp(i,j)=psi(i-1,j+1)+0.5*(-bnd(i-1,j)*dy(j)+bnd(i,j+1)*dx(i))

                 else if(ib(i-1,j)==10.and.ib(i,j+1)==10)then
                    ! -- ɾ 1 Ʊ
                    tmp(i,j)=psi(i+1,j-1)+0.5*(bnd(i+1,j)*dy(j)-bnd(i,j-1)*dx(i))

                 else if(ib(i+1,j)==10.and.ib(i,j-1)==10)then
                    ! -- ɾ 2 Ʊ
                    tmp(i,j)=psi(i-1,j+1)+0.5*(-bnd(i-1,j)*dy(j)+bnd(i,j+1)*dx(i))

                 end if
              end select

           end if

           if(sor_flag.eqv..true.)then
              tmp(i,j)=(1.0-accc)*psi(i,j)+tmp(i,j)*accc
           end if

        end do
     end do
!$omp end do
!$omp end parallel

!!-- ޤǤ if ʸΥǥȤĴᤷʤ.
!        end if
!
!        tmp=tmp/ac(i,j)
!-- η׻ ---
     do j=2,ny-1
        do i=2,nx-1
           err=abs(tmp(i,j)-psi(i,j))

!-- ι
           if(err_max<=err)then
              err_max=err
           end if
        end do
     end do

!-- ƹ

     do j=1,ny
        do i=1,nx
           psi(i,j)=tmp(i,j)
        end do
     end do

     if(nl/=0)then
        counter=counter+1
        if(counter==nl)then
           exit
        else
           err_max=eps
        end if
     end if

  end do
  
!-- 

  call calculate_bound( ib, dx, dy, bnd, psi )

!-- ̤ΰˤ undef .

  do j=1,ny
     do i=1,nx
        if(ib(i,j)==10)then
           psi(i,j)=defun
        end if
     end do
  end do

end subroutine Ellip_Jacobi_2d


subroutine Ellip_GauSei_3d(x, y, z, rho, eps, boundary, psi, bound_opt,  &
  &                        xa, ya, za, a, b, c, d, e, f, g,  &
  &                        undef, inner_bound, init_flag, accel, ln )
! =ǥˡˤʱ߷ε
! ƥץ, ݥϤγʬ. ǥեȤϥꤵ.
! $$xa\dfrac{\partial ^2\psi}{\partial x^2} +ya\dfrac{\partial ^2\psi}{\partial y^2} +za\dfrac{\partial ^2\psi}{\partial z^2} +a\dfrac{\partial ^2\psi}{\partial x\partial y} +b\dfrac{\partial ^2\psi}{\partial y\partial z} +c\dfrac{\partial ^2\psi}{\partial z\partial x} +d\dfrac{\partial \psi}{\partial x} +e\dfrac{\partial \psi}{\partial y} +f\dfrac{\partial \psi}{\partial z} +g\psi =\rho $$
! γƷбƤ.
  implicit none
  real, intent(in) :: x(:)  ! ΰ x ɸ
  real, intent(in) :: y(:)  ! ΰ y ɸ
  real, intent(in) :: z(:)  ! ΰ z ɸ
  real, intent(in) :: rho(size(x),size(y),size(z))  ! ݥζ
                   ! rho =0 ǥץ饹Ѳǽ
  real, intent(in) :: eps  ! «
  character(6), intent(in) :: boundary  ! 
                ! 4 ʸǳդζͿ.
                ! 1 ʸ : x ü, 2 ʸ : y ü, 3 ʸ : x ü,
                ! 4 ʸ : y ü
                ! boundary  1 : ü, 2 : ͳü, 3 : 
  real, intent(in), optional :: bound_opt(size(x),size(y),size(z))
                             ! Ǥζ
                             ! Υޥ󶭳ξ : եå
  real, intent(in), optional :: xa(size(x),size(y),size(z))  ! ʬη
  real, intent(in), optional :: ya(size(x),size(y),size(z))  ! ʬη
  real, intent(in), optional :: za(size(x),size(y),size(z))  ! ʬη
  real, intent(in), optional :: a(size(x),size(y),size(z))  ! ʬη
  real, intent(in), optional :: b(size(x),size(y),size(z))  ! ʬη
  real, intent(in), optional :: c(size(x),size(y),size(z))  ! ʬη
  real, intent(in), optional :: d(size(x),size(y),size(z))  ! ʬη
  real, intent(in), optional :: e(size(x),size(y),size(z))  ! ʬη
  real, intent(in), optional :: f(size(x),size(y),size(z))  ! ʬη
  real, intent(in), optional :: g(size(x),size(y),size(z))  ! ʬη
  real, intent(inout) :: psi(size(x),size(y),size(z))  ! ݥβ
  real, intent(in), optional :: undef  ! ̤
  integer, intent(in), optional :: inner_bound(size(x),size(y),size(z))
                             ! ΰζ. ͤ˱ƤγʻǶͷ׻
                             ! 1 = ü, 10 = ¦.
                             ! 2 = y ͳü (եåϾ)
                             ! -2 = y ͳü (եåϲ)
                             ! 4 = x ͳü (եåϱ)
                             ! -4 = x ͳü (եåϺ)
                             ! 3 = 
                             ! 8 = |_, ~| ξȤ⼫ͳ
                             ! -8 = |~, _| ξȤ⼫ͳ
                             ! ΰͿʤΰ׻.
                             ! ¦ʻ (10) ȿ׻Ԥ鷺,
                             ! undef ꤵ줿ͤ⤷ϥ.
                             ! ΤȤζͤ bound_opt ͤѤ.
  logical, intent(in), optional :: init_flag  ! psi ͤ򥼥ǽ뤫.
                             ! .true. = . .false. = ʤ.
                             ! ǥեȤǤϽ.
  real, intent(in), optional :: accel  ! SOR β® (0 < accel < 2)
                             ! ǥե = 1
  integer, intent(in), optional :: ln  ! ȿ
                             ! ͤͿȤ, eps ̵ͤط
                             ! ln 롼פ.

  integer :: i, j, k, ix, jy, kz, nl, counter
  integer :: nx  ! x 
  integer :: ny  ! y 
  integer :: nz  ! z 
  integer :: signa, signb, signc  ! Ʒ׻뤫ɤ
  integer, dimension(size(x),size(y),size(z)) :: ib

  real :: defun
  real :: tmp, err, err_max
  real :: tmp_b, accc
  real :: bnd(size(x),size(y),size(z))
  real :: dx(size(x)), dy(size(y)), dx2(size(x)), dy2(size(y))
  real :: dz(size(z)), dz2(size(z))
  real, dimension(size(x),size(y)) :: dxdy
  real, dimension(size(y),size(z)) :: dydz
  real, dimension(size(x),size(z)) :: dxdz
  real, dimension(size(x),size(y),size(z)) :: xt, yt, zt, at, bt, ct, dt, et, ft, gt
  real, dimension(size(x),size(y),size(z)) :: xdp, xdm, yep, yem, zfp, zfm, xyz, divi

  character(6) :: bound
  logical :: sor_flag
  logical, dimension(size(x),size(y),size(z)) :: inner_flag

  bound(1:6)=boundary(1:6)

  nx=size(x)
  ny=size(y)
  nz=size(z)

!-- ؿν

  if(present(init_flag))then
     if(init_flag.eqv..true.)then
        psi = 0.0
     end if
  else
     psi = 0.0
  end if

!-- Ƚ̥ե饰

  if(present(inner_bound))then
     call set_bound_3d( bound, ib, inner_flag, inner_bound )
  else
     call set_bound_3d( bound, ib, inner_flag )
  end if

!-- ΰ衦ˤ붭ͤ

  if(present(bound_opt))then
     call setval_bound_3d( ib, bnd, psi, bound_opt )
  else
     call setval_bound_3d( ib, bnd, psi )
  end if

!-- ̤ͤ

  if(present(undef))then
     defun=undef
  else
     defun=0.0
  end if

!-- 
!-- xa, ya, za ˤĤƤ, ͤƤʤ,  1 .
  if(present(xa))then
     call set_coe_3d( xt, ext=xa )
  else
     call set_coe_3d( xt, def=1.0 )
  end if

  if(present(ya))then
     call set_coe_3d( yt, ext=ya )
  else
     call set_coe_3d( yt, def=1.0 )
  end if

  if(present(za))then
     call set_coe_3d( zt, ext=za )
  else
     call set_coe_3d( zt, def=1.0 )
  end if

  if(present(a))then
     call set_coe_3d( at, ext=a )
     signa=1
  else
     call set_coe_3d( at, def=0.0 )
     signa=0
  end if

  if(present(b))then
     call set_coe_3d( bt, ext=b )
     signb=1
  else
     call set_coe_3d( bt, def=0.0 )
     signb=0
  end if

  if(present(c))then
     signc=1
     call set_coe_3d( ct, ext=c )
  else
     call set_coe_3d( ct, def=0.0 )
     signc=0
  end if

  if(present(d))then
     call set_coe_3d( dt, ext=d )
  else
     call set_coe_3d( dt, def=0.0 )
  end if

  if(present(e))then
     call set_coe_3d( et, ext=e )
  else
     call set_coe_3d( et, def=0.0 )
  end if

  if(present(f))then
     call set_coe_3d( ft, ext=f )
  else
     call set_coe_3d( ft, def=0.0 )
  end if

  if(present(g))then
     call set_coe_3d( gt, ext=g )
  else
     call set_coe_3d( gt, def=0.0 )
  end if

!-- ǹⳬˤ뷸å. (ǤʤĴ٤.)

  call check_coe_3d( xt, 0.0 )
  call check_coe_3d( yt, 0.0 )
  call check_coe_3d( zt, 0.0 )

!-- ®Ƚ

  if(present(accel))then
     accc=accel
     sor_flag=.true.
  else
     sor_flag=.false.
  end if

!-- ln ν
  if(present(ln))then
     nl=ln
  else
     nl=0
  end if

!-- ʲ˳ʻҴֳ 1 ׻Ǥ褤ΤƤ.
!--  1 ΤߤѲФ褤.
!-- ʻֳ֤η׻
  do i=2,nx-1
     dx(i)=(x(i+1)-x(i-1))*0.5
     dx2(i)=dx(i)**2
  end do
  do j=2,ny-1
     dy(j)=(y(j+1)-y(j-1))*0.5
     dy2(j)=dy(j)**2
  end do
  do k=2,nz-1
     dz(k)=(z(k+1)-z(k-1))*0.5
     dz2(k)=dz(k)**2
  end do

  dx(1)=(x(2)-x(1))
  dx(nx)=(x(nx)-x(nx-1))
  dy(1)=(y(2)-y(1))
  dy(ny)=(y(ny)-y(ny-1))
  dz(1)=(z(2)-z(1))
  dz(nz)=(z(nz)-z(nz-1))

  do j=1,ny
     do i=1,nx
        dxdy(i,j)=dx(i)*dy(j)
     end do
  end do
  do k=1,nz
     do j=1,ny
        dydz(j,k)=dy(j)*dz(k)
     end do
  end do
  do k=1,nz
     do i=1,nx
        dxdz(i,k)=dx(i)*dz(k)
     end do
  end do

!-- ݥ󷸿η׻
!-- ºݤ˥ݥ󷸿ѤΤ,  1 ¦ʤΤ,
!-- ׻̺︺Τ, 롼פ򤽤Τ褦ˤƤ.

  xyz=0.0
  xdp=0.0
  xdm=0.0
  yep=0.0
  yem=0.0
  zfp=0.0
  zfm=0.0

!-- ǹ⼡ ac η׻
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)

  do k=2,nz-1
     do j=2,ny-1
        do i=2,nx-1
           xyz(i,j,k)=1.0/(2.0*(xt(i,j,k)/dx2(i)+yt(i,j,k)/dy2(j)+zt(i,j,k)/dz2(k))-gt(i,j,k))
           xdp(i,j,k)=(xt(i,j,k)/(dx2(i))+0.5*dt(i,j,k)/dx(i))*xyz(i,j,k)
           xdm(i,j,k)=(xt(i,j,k)/(dx2(i))-0.5*dt(i,j,k)/dx(i))*xyz(i,j,k)
           yep(i,j,k)=(yt(i,j,k)/(dy2(j))+0.5*et(i,j,k)/dy(j))*xyz(i,j,k)
           yem(i,j,k)=(yt(i,j,k)/(dy2(j))-0.5*et(i,j,k)/dy(j))*xyz(i,j,k)
           zfp(i,j,k)=(zt(i,j,k)/(dz2(k))+0.5*ft(i,j,k)/dz(k))*xyz(i,j,k)
           zfm(i,j,k)=(zt(i,j,k)/(dz2(k))-0.5*ft(i,j,k)/dz(k))*xyz(i,j,k)
           if(signa==1)then
              at(i,j,k)=0.25*at(i,j,k)/(dxdy(i,j))*xyz(i,j,k)
           else
              at(i,j,k)=0.0
           end if
           if(signb==1)then
              bt(i,j,k)=0.25*bt(i,j,k)/(dydz(j,k))*xyz(i,j,k)
           else
              bt(i,j,k)=0.0
           end if
           if(signc==1)then
              ct(i,j,k)=0.25*ct(i,j,k)/(dxdz(i,k))*xyz(i,j,k)
           else
              ct(i,j,k)=0.0
           end if
        end do
     end do
  end do

!$omp end do
!$omp end parallel

  err_max=eps  ! while 뤿صŪ
  counter=0

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0

     do k=1,nz
        do j=1,ny
           do i=1,nx

!-- ʹ, ȿ׻ɬפμ 8 ˤĤƤ줾
!-- inner_flag ΥåƱŬڤͤ򤽤줾༡׻,
!-- , γʻҷ׻ԤäƤ뤬, ib=8,-8  4 ʻҤΤȤˤ
!-- case select ʤ. ʤʤ, 岼˶ʻҤ뤳ȤϤꤨʤ.
              if(inner_flag(i,j,k).eqv..false.)then  ! .false. ʤΰ׻

                 tmp=-rho(i,j,k)*xyz(i,j,k)
                 tmp=tmp+xdp(i,j,k)*psi(i+1,j,k)  &
  &                     +xdm(i,j,k)*psi(i-1,j,k)  &
  &                     +yep(i,j,k)*psi(i,j+1,k)  &
  &                     +yem(i,j,k)*psi(i,j-1,k)  &
  &                     +zfp(i,j,k)*psi(i,j,k+1)  &
  &                     +zfm(i,j,k)*psi(i,j,k-1)

                 if(signa==1)then
                    tmp_b=at(i,j,k)*(psi(i+1,j+1,k)+psi(i-1,j-1,k)  &
  &                                 -psi(i+1,j-1,k)-psi(i-1,j+1,k))
                 else
                    tmp_b=0.0
                 end if
                 if(signb==1)then  ! ⤽ bt = 0 ʤ׻ʤ.
                    tmp_b=tmp_b+bt(i,j,k)*(psi(i,j+1,k+1)+psi(i,j-1,k-1)  &
  &                                       -psi(i,j-1,k+1)-psi(i,j+1,k-1))
                 end if
                 if(signc==1)then  ! ⤽ bt = 0 ʤ׻ʤ.
                    tmp_b=tmp_b+ct(i,j,k)*(psi(i+1,j,k+1)+psi(i-1,j,k-1)  &
  &                                       -psi(i-1,j,k+1)-psi(i+1,j,k-1))
                 end if
              
                 tmp=tmp+tmp_b

              else   ! .true. ʤ鶭׻.

                 select case (ib(i,j,k))
                 case (1)
                    tmp=bnd(i,j,k)

                 case (2)  ! x ˥եå, ¦
                    tmp=psi(i+1,j,k)-bnd(i,j,k)*dx(i)

                 case (-2)  ! x ˥եå, ¦
                    tmp=psi(i-1,j,k)+bnd(i,j,k)*dx(i)

                 case (4)  ! y ˥եå, ¦
                    tmp=psi(i,j+1,k)-bnd(i,j,k)*dy(j)

                 case (-4)  ! y ˥եå, ¦
                    tmp=psi(i,j-1,k)+bnd(i,j,k)*dy(j)

                 case (6)  ! y ˥եå, ¦
                    tmp=psi(i,j,k+1)-bnd(i,j,k)*dz(k)

                 case (-6)  ! y ˥եå, ¦
                    tmp=psi(i,j,k-1)+bnd(i,j,k)*dz(k)

                 case (3)  ! 12 , ⤷ 8 ǼȽ
                    if(i==1)then
                       ix=nx-1
                    else if(i==nx)then
                       ix=2
                    else
                       ix=i
                    end if
                    if(j==1)then
                       jy=ny-1
                    else if(j==ny)then
                       jy=2
                    else
                       jy=j
                    end if
                    if(k==1)then
                       kz=nz-1
                    else if(k==nz)then
                       kz=2
                    else
                       kz=k
                    end if
                    tmp=psi(ix,jy,kz)

                 case (8)  ! ξեå z ̤ x, y 夫.
                    if(i==1.and.j==1)then  ! -- ɾ 1
                       tmp=psi(i+1,j+1,k)  &
  &                        -0.5*(bnd(i+1,j,k)*dy(j)+bnd(i,j+1,k)*dx(i))

                    else if(i==nx.and.j==ny)then  ! -- ɾ 2
                       tmp=psi(i-1,j-1,k)  &
  &                        +0.5*(bnd(i-1,j,k)*dy(j)+bnd(i,j-1,k)*dx(i))

                    else if(ib(i-1,j,k)==10.and.ib(i,j-1,k)==10)then
                       ! -- ɾ 1 Ʊ
                       tmp=psi(i+1,j+1,k)  &
  &                        -0.5*(bnd(i+1,j,k)*dy(j)+bnd(i,j+1,k)*dx(i))

                    else if(ib(i+1,j,k)==10.and.ib(i,j+1,k)==10)then
                       ! -- ɾ 2 Ʊ
                       tmp=psi(i-1,j-1,k)  &
  &                        +0.5*(bnd(i-1,j,k)*dy(j)+bnd(i,j-1,k)*dx(i))

                    end if

                 case (-8)  ! ξեå z ̤ x, y .
                    if(i==1.and.j==ny)then  ! -- ɾ 1
                       tmp=psi(i+1,j-1,k)  &
  &                        +0.5*(bnd(i+1,j,k)*dy(j)-bnd(i,j-1,k)*dx(i))

                    else if(i==nx.and.j==1)then  ! -- ɾ 2
                       tmp=psi(i-1,j+1,k)  &
  &                        +0.5*(-bnd(i-1,j,k)*dy(j)+bnd(i,j+1,k)*dx(i))

                    else if(ib(i-1,j,k)==10.and.ib(i,j+1,k)==10)then
                       ! -- ɾ 1 Ʊ
                       tmp=psi(i+1,j-1,k)  &
  &                        +0.5*(bnd(i+1,j,k)*dy(j)-bnd(i,j-1,k)*dx(i))

                    else if(ib(i+1,j,k)==10.and.ib(i,j-1,k)==10)then
                       ! -- ɾ 2 Ʊ
                       tmp=psi(i-1,j+1,k)  &
  &                        +0.5*(-bnd(i-1,j,k)*dy(j)+bnd(i,j+1,k)*dx(i))
                    end if

                 case (12)  ! ξեå y ̤ x, z 夫.
                    if(i==1.and.k==1)then  ! -- ɾ 1
                       tmp=psi(i+1,j,k+1)  &
  &                        -0.5*(bnd(i+1,j,k)*dz(k)+bnd(i,j,k+1)*dx(i))

                    else if(i==nx.and.k==nz)then  ! -- ɾ 2
                       tmp=psi(i-1,j,k-1)  &
  &                        +0.5*(bnd(i-1,j,k)*dz(k)+bnd(i,j,k-1)*dx(i))

                    else if(ib(i-1,j,k)==10.and.ib(i,j,k-1)==10)then
                       ! -- ɾ 1 Ʊ
                       tmp=psi(i+1,j,k+1)  &
  &                        -0.5*(bnd(i+1,j,k)*dz(k)+bnd(i,j,k+1)*dx(i))

                    else if(ib(i+1,j,k)==10.and.ib(i,j,k+1)==10)then
                       ! -- ɾ 2 Ʊ
                       tmp=psi(i-1,j,k-1)  &
  &                        +0.5*(bnd(i-1,j,k)*dz(k)+bnd(i,j,k-1)*dx(i))
                    end if

                 case (-12)  ! ξեå y ̤ x, z .
                    if(i==1.and.k==nz)then  ! -- ɾ 1
                       tmp=psi(i+1,j,k-1)  &
  &                        +0.5*(bnd(i+1,j,k)*dz(k)-bnd(i,j,k-1)*dx(i))

                    else if(i==nx.and.k==1)then  ! -- ɾ 2
                       tmp=psi(i-1,j,k+1)  &
  &                        +0.5*(-bnd(i-1,j,k)*dz(k)+bnd(i,j,k+1)*dx(i))

                    else if(ib(i-1,j,k)==10.and.ib(i,j,k+1)==10)then
                       ! -- ɾ 1 Ʊ
                       tmp=psi(i+1,j,k-1)  &
  &                        +0.5*(bnd(i+1,j,k)*dz(k)-bnd(i,j,k-1)*dx(i))

                    else if(ib(i+1,j,k)==10.and.ib(i,j,k-1)==10)then
                       ! -- ɾ 2 Ʊ
                       tmp=psi(i-1,j,k+1)  &
  &                        +0.5*(-bnd(i-1,j,k)*dz(k)+bnd(i,j,k+1)*dx(i))
                    end if

                 case (24)  ! ξեå x ̤ y, z 夫.
                    if(j==1.and.k==1)then  ! -- ɾ 1
                       tmp=psi(i,j+1,k+1)  &
  &                        -0.5*(bnd(i,j+1,k)*dz(k)+bnd(i,j,k+1)*dy(j))

                    else if(j==ny.and.k==nz)then  ! -- ɾ 2
                       tmp=psi(i,j-1,k-1)  &
  &                        +0.5*(bnd(i,j-1,k)*dz(k)+bnd(i,j,k-1)*dy(j))

                    else if(ib(i,j-1,k)==10.and.ib(i,j,k-1)==10)then
                       ! -- ɾ 1 Ʊ
                       tmp=psi(i,j+1,k+1)  &
  &                        -0.5*(bnd(i,j+1,k)*dz(k)+bnd(i,j,k+1)*dy(j))

                    else if(ib(i,j+1,k)==10.and.ib(i,j,k+1)==10)then
                       ! -- ɾ 2 Ʊ
                       tmp=psi(i,j-1,k-1)  &
  &                        +0.5*(bnd(i,j-1,k)*dz(k)+bnd(i,j,k-1)*dy(j))
                    end if

                 case (-24)  ! ξեå x ̤ y, z .
                    if(j==1.and.k==nz)then  ! -- ɾ 1
                       tmp=psi(i,j+1,k-1)  &
  &                        +0.5*(bnd(i,j+1,k)*dz(k)-bnd(i,j,k-1)*dy(j))

                    else if(j==ny.and.k==1)then  ! -- ɾ 2
                       tmp=psi(i,j-1,k+1)  &
  &                        +0.5*(-bnd(i,j-1,k)*dz(k)+bnd(i,j,k+1)*dy(j))

                    else if(ib(i,j-1,k)==10.and.ib(i,j,k+1)==10)then
                       ! -- ɾ 1 Ʊ
                       tmp=psi(i,j+1,k-1)  &
  &                        +0.5*(bnd(i,j+1,k)*dz(k)-bnd(i,j,k-1)*dy(j))

                    else if(ib(i,j+1,k)==10.and.ib(i,j,k-1)==10)then
                       ! -- ɾ 2 Ʊ
                       tmp=psi(i,j-1,k+1)  &
  &                        +0.5*(-bnd(i,j-1,k)*dz(k)+bnd(i,j,k+1)*dy(j))
                    end if

                 !-- ʹ, ΰʤΤ, ̤.
                 case (11)  ! ξեå (1,1,1) , ⤷ΰ.
                    tmp=psi(i+1,j+1,k+1)  &
  &                           -(bnd(i,j+1,k+1)*dx(i)  &
  &                            +bnd(i+1,j,k+1)*dy(j)  &
  &                            +bnd(i+1,j+1,k)*dz(k))/3.0

                 case (13)  ! ξեå (nx,1,1) , ⤷ΰ.
                    tmp=psi(i-1,j+1,k+1)  &
  &                           -(-bnd(i,j+1,k+1)*dx(i)  &
  &                             +bnd(i-1,j,k+1)*dy(j)  &
  &                             +bnd(i-1,j+1,k)*dz(k))/3.0

                 case (17)  ! ξեå (1,ny,1) , ⤷ΰ.
                    tmp=psi(i+1,j-1,k+1)  &
  &                           -(bnd(i,j-1,k+1)*dx(i)  &
  &                            -bnd(i+1,j,k+1)*dy(j)  &
  &                            +bnd(i+1,j-1,k)*dz(k))/3.0

                 case (19)  ! ξեå (nx,ny,1) , ⤷ΰ.
                    tmp=psi(i-1,j-1,k+1)  &
  &                           -(-bnd(i,j-1,k+1)*dx(i)  &
  &                             -bnd(i-1,j,k+1)*dy(j)  &
  &                             +bnd(i-1,j-1,k)*dz(k))/3.0

                 case (23)  ! ξեå (1,1,nz) , ⤷ΰ.
                    tmp=psi(i+1,j+1,k-1)  &
  &                           -(bnd(i,j+1,k-1)*dx(i)  &
  &                            +bnd(i+1,j,k-1)*dy(j)  &
  &                            -bnd(i+1,j+1,k)*dz(k))/3.0

                 case (29)  ! ξեå (nx,1,nz) , ⤷ΰ.
                    tmp=psi(i-1,j+1,k-1)  &
  &                           -(-bnd(i,j+1,k-1)*dx(i)  &
  &                             +bnd(i-1,j,k-1)*dy(j)  &
  &                             -bnd(i-1,j+1,k)*dz(k))/3.0

                 case (31)  ! ξեå (1,ny,nz) , ⤷ΰ.
                    tmp=psi(i+1,j-1,k-1)  &
  &                           -(bnd(i,j-1,k-1)*dx(i)  &
  &                            -bnd(i+1,j,k-1)*dy(j)  &
  &                            -bnd(i+1,j-1,k)*dz(k))/3.0

                 case (37)  ! ξեå (nx,ny,nz) , ⤷ΰ.
                    tmp=psi(i-1,j-1,k-1)  &
  &                           -(-bnd(i,j-1,k-1)*dx(i)  &
  &                             -bnd(i-1,j,k-1)*dy(j)  &
  &                             -bnd(i-1,j-1,k)*dz(k))/3.0

                 case (-11)  ! ξեå (i+1,j+1,k+1)  10 .
                    tmp=(psi(i-1,j+1,k+1)+psi(i+1,j-1,k+1)+psi(i+1,j+1,k-1)  &
  &                            +bnd(i,j+1,k+1)*dx(i)+bnd(i+1,j,k+1)*dy(j)  &
  &                            +bnd(i+1,j+1,k)*dz(k))/3.0

                 case (-13)  ! ξեå (i-1,j+1,k+1)  10 .
                    tmp=(psi(i+1,j+1,k+1)+psi(i-1,j-1,k+1)+psi(i-1,j+1,k-1)  &
  &                            -bnd(i,j+1,k+1)*dx(i)+bnd(i-1,j,k+1)*dy(j)  &
  &                            +bnd(i-1,j+1,k)*dz(k))/3.0

                 case (-17)  ! ξեå (i+1,j-1,k+1)  10 .
                    tmp=(psi(i-1,j-1,k+1)+psi(i+1,j+1,k+1)+psi(i+1,j-1,k-1)  &
  &                            +bnd(i,j-1,k+1)*dx(i)-bnd(i+1,j,k+1)*dy(j)  &
  &                            +bnd(i+1,j-1,k)*dz(k))/3.0

                 case (-19)  ! ξեå (i-1,j-1,k+1)  10 .
                    tmp=(psi(i+1,j-1,k+1)+psi(i-1,j+1,k+1)+psi(i-1,j-1,k-1)  &
  &                            -bnd(i,j-1,k+1)*dx(i)-bnd(i-1,j,k+1)*dy(j)  &
  &                            +bnd(i-1,j-1,k)*dz(k))/3.0

                 case (-23)  ! ξեå (i+1,j+1,k-1)  10 .
                    tmp=(psi(i-1,j+1,k-1)+psi(i+1,j-1,k-1)+psi(i+1,j+1,k+1)  &
  &                            +bnd(i,j+1,k-1)*dx(i)+bnd(i+1,j,k-1)*dy(j)  &
  &                            -bnd(i+1,j+1,k)*dz(k))/3.0

                 case (-29)  ! ξեå (i-1,j+1,k-1)  10 .
                    tmp=(psi(i+1,j+1,k-1)+psi(i-1,j-1,k-1)+psi(i-1,j+1,k+1)  &
  &                            -bnd(i,j+1,k-1)*dx(i)+bnd(i-1,j,k-1)*dy(j)  &
  &                            -bnd(i-1,j+1,k)*dz(k))/3.0

                 case (-31)  ! ξեå (i+1,j-1,k-1)  10 .
                    tmp=(psi(i-1,j-1,k-1)+psi(i+1,j+1,k-1)+psi(i+1,j-1,k+1)  &
  &                            +bnd(i,j-1,k-1)*dx(i)-bnd(i+1,j,k-1)*dy(j)  &
  &                            -bnd(i+1,j-1,k)*dz(k))/3.0

                 case (-37)  ! ξեå (i-1,j-1,k-1)  10 .
                    tmp=(psi(i+1,j-1,k-1)+psi(i-1,j+1,k-1)+psi(i-1,j-1,k+1)  &
  &                            -bnd(i,j-1,k-1)*dx(i)-bnd(i-1,j,k-1)*dy(j)  &
  &                            -bnd(i-1,j-1,k)*dz(k))/3.0

                 end select

              end if

              if(sor_flag.eqv..true.)then
                 tmp=(1.0-accc)*psi(i,j,k)+tmp*accc
              end if

              err=abs(tmp-psi(i,j,k))

!-- ι
              if(err_max<=err)then
                 err_max=err
              end if

              psi(i,j,k)=tmp

           end do
        end do
     end do

     if(nl/=0)then
        counter=counter+1
        if(counter==nl)then
           exit
        else
           err_max=eps
        end if
     end if

  end do

!-- 

  call calculate_bound_3d( ib, dx, dy, dz, bnd, psi )

!-- ̤ΰˤ undef .

  do k=1,nz
     do j=1,ny
        do i=1,nx
           if(ib(i,j,k)==10)then
              psi(i,j,k)=defun
           end if
        end do
     end do
  end do

end subroutine Ellip_GauSei_3d


subroutine Ellip_Jacobi_3d(x, y, z, rho, eps, boundary, psi, bound_opt,  &
  &                        xa, ya, za, a, b, c, d, e, f, g,  &
  &                        undef, inner_bound, init_flag, accel, ln )
use omp_lib
! openmp ˤ륹å󤬲ǽ.
! ǥˡǤϥ르ꥺ󲽤Ȼפ줿Τ,
! ׻ˤݥεѤɬפȤʤʤ,
! 䥳ˡΤΤѤ줿.
! ƥץ, ݥϤγʬ. ǥեȤϥꤵ.
! $$xa\dfrac{\partial ^2\psi}{\partial x^2} +ya\dfrac{\partial ^2\psi}{\partial y^2} +za\dfrac{\partial ^2\psi}{\partial z^2} +a\dfrac{\partial ^2\psi}{\partial x\partial y} +b\dfrac{\partial ^2\psi}{\partial y\partial z} +c\dfrac{\partial ^2\psi}{\partial z\partial x} +d\dfrac{\partial \psi}{\partial x} +e\dfrac{\partial \psi}{\partial y} +f\dfrac{\partial \psi}{\partial z} +g\psi =\rho $$
! γƷбƤ.
  implicit none
  real, intent(in) :: x(:)  ! ΰ x ɸ
  real, intent(in) :: y(:)  ! ΰ y ɸ
  real, intent(in) :: z(:)  ! ΰ z ɸ
  real, intent(in) :: rho(size(x),size(y),size(z))  ! ݥζ
                   ! rho =0 ǥץ饹Ѳǽ
  real, intent(in) :: eps  ! «
  character(6), intent(in) :: boundary  ! 
                ! 4 ʸǳդζͿ.
                ! 1 ʸ : x ü, 2 ʸ : y ü, 3 ʸ : x ü,
                ! 4 ʸ : y ü
                ! boundary  1 : ü, 2 : ͳü, 3 : 
  real, intent(in), optional :: bound_opt(size(x),size(y),size(z))
                             ! Ǥζ
                             ! Υޥ󶭳ξ : եå
  real, intent(in), optional :: xa(size(x),size(y),size(z))  ! ʬη
  real, intent(in), optional :: ya(size(x),size(y),size(z))  ! ʬη
  real, intent(in), optional :: za(size(x),size(y),size(z))  ! ʬη
  real, intent(in), optional :: a(size(x),size(y),size(z))  ! ʬη
  real, intent(in), optional :: b(size(x),size(y),size(z))  ! ʬη
  real, intent(in), optional :: c(size(x),size(y),size(z))  ! ʬη
  real, intent(in), optional :: d(size(x),size(y),size(z))  ! ʬη
  real, intent(in), optional :: e(size(x),size(y),size(z))  ! ʬη
  real, intent(in), optional :: f(size(x),size(y),size(z))  ! ʬη
  real, intent(in), optional :: g(size(x),size(y),size(z))  ! ʬη
  real, intent(inout) :: psi(size(x),size(y),size(z))  ! ݥβ
  real, intent(in), optional :: undef  ! ̤
  integer, intent(in), optional :: inner_bound(size(x),size(y),size(z))
                             ! ΰζ. ͤ˱ƤγʻǶͷ׻
                             ! 1 = ü, 10 = ¦.
                             ! 2 = y ͳü (եåϾ)
                             ! -2 = y ͳü (եåϲ)
                             ! 4 = x ͳü (եåϱ)
                             ! -4 = x ͳü (եåϺ)
                             ! 3 = 
                             ! 8 = |_, ~| ξȤ⼫ͳ
                             ! -8 = |~, _| ξȤ⼫ͳ
                             ! ΰͿʤΰ׻.
                             ! ¦ʻ (10) ȿ׻Ԥ鷺,
                             ! undef ꤵ줿ͤ⤷ϥ.
                             ! ΤȤζͤ bound_opt ͤѤ.
  logical, intent(in), optional :: init_flag  ! psi ͤ򥼥ǽ뤫.
                             ! .true. = . .false. = ʤ.
                             ! ǥեȤǤϽ.
  real, intent(in), optional :: accel  ! SOR β® (0 < accel < 2)
                             ! ǥե = 1
  integer, intent(in), optional :: ln  ! ȿ
                             ! ͤͿȤ, eps ̵ͤط
                             ! ln 롼פ.

  integer :: i, j, k, ix, jy, kz, nl, counter
  integer :: nx  ! x 
  integer :: ny  ! y 
  integer :: nz  ! z 
  integer :: signa, signb, signc  ! Ʒ׻뤫ɤ
  integer, dimension(size(x),size(y),size(z)) :: ib

  real :: defun
  real :: err, err_max, accc
  real :: bnd(size(x),size(y),size(z))
  real :: dx(size(x)), dy(size(y)), dx2(size(x)), dy2(size(y))
  real :: dz(size(z)), dz2(size(z))
  real, dimension(size(x),size(y)) :: dxdy
  real, dimension(size(y),size(z)) :: dydz
  real, dimension(size(x),size(z)) :: dxdz
  real, dimension(size(x),size(y),size(z)) :: xt, yt, zt, at, bt, ct, dt, et, ft, gt
  real, dimension(size(x),size(y),size(z)) :: xdp, xdm, yep, yem, zfp, zfm, xyz, divi
  real, dimension(size(x),size(y),size(z)) :: tmp, tmp_b

  character(6) :: bound
  logical :: sor_flag
  logical, dimension(size(x),size(y),size(z)) :: inner_flag

  bound(1:6)=boundary(1:6)

  nx=size(x)
  ny=size(y)
  nz=size(z)

!-- ؿν

  if(present(init_flag))then
     if(init_flag.eqv..true.)then
        psi = 0.0
     end if
  else
     psi = 0.0
  end if

!-- Ƚ̥ե饰

  if(present(inner_bound))then
     call set_bound_3d( bound, ib, inner_flag, inner_bound )
  else
     call set_bound_3d( bound, ib, inner_flag )
  end if

!-- ΰ衦ˤ붭ͤ

  if(present(bound_opt))then
     call setval_bound_3d( ib, bnd, psi, bound_opt )
  else
     call setval_bound_3d( ib, bnd, psi )
  end if

!-- ̤ͤ

  if(present(undef))then
     defun=undef
  else
     defun=0.0
  end if

!-- 
!-- xa, ya, za ˤĤƤ, ͤƤʤ,  1 .
  if(present(xa))then
     call set_coe_3d( xt, ext=xa )
  else
     call set_coe_3d( xt, def=1.0 )
  end if

  if(present(ya))then
     call set_coe_3d( yt, ext=ya )
  else
     call set_coe_3d( yt, def=1.0 )
  end if

  if(present(za))then
     call set_coe_3d( zt, ext=za )
  else
     call set_coe_3d( zt, def=1.0 )
  end if

  if(present(a))then
     call set_coe_3d( at, ext=a )
     signa=1
  else
     call set_coe_3d( at, def=0.0 )
     signa=0
  end if

  if(present(b))then
     call set_coe_3d( bt, ext=b )
     signb=1
  else
     call set_coe_3d( bt, def=0.0 )
     signb=0
  end if

  if(present(c))then
     signc=1
     call set_coe_3d( ct, ext=c )
  else
     call set_coe_3d( ct, def=0.0 )
     signc=0
  end if

  if(present(d))then
     call set_coe_3d( dt, ext=d )
  else
     call set_coe_3d( dt, def=0.0 )
  end if

  if(present(e))then
     call set_coe_3d( et, ext=e )
  else
     call set_coe_3d( et, def=0.0 )
  end if

  if(present(f))then
     call set_coe_3d( ft, ext=f )
  else
     call set_coe_3d( ft, def=0.0 )
  end if

  if(present(g))then
     call set_coe_3d( gt, ext=g )
  else
     call set_coe_3d( gt, def=0.0 )
  end if

!-- ǹⳬˤ뷸å. (ǤʤĴ٤.)

  call check_coe_3d( xt, 0.0 )
  call check_coe_3d( yt, 0.0 )
  call check_coe_3d( zt, 0.0 )

!-- ®Ƚ

  if(present(accel))then
     accc=accel
     sor_flag=.true.
  else
     sor_flag=.false.
  end if

!-- ln ν
  if(present(ln))then
     nl=ln
  else
     nl=0
  end if

!-- ʲ˳ʻҴֳ 1 ׻Ǥ褤ΤƤ.
!--  1 ΤߤѲФ褤.
!-- ʻֳ֤η׻
  do i=2,nx-1
     dx(i)=(x(i+1)-x(i-1))*0.5
     dx2(i)=dx(i)**2
  end do
  do j=2,ny-1
     dy(j)=(y(j+1)-y(j-1))*0.5
     dy2(j)=dy(j)**2
  end do
  do k=2,nz-1
     dz(k)=(z(k+1)-z(k-1))*0.5
     dz2(k)=dz(k)**2
  end do

  dx(1)=(x(2)-x(1))
  dx(nx)=(x(nx)-x(nx-1))
  dy(1)=(y(2)-y(1))
  dy(ny)=(y(ny)-y(ny-1))
  dz(1)=(z(2)-z(1))
  dz(nz)=(z(nz)-z(nz-1))

  do j=1,ny
     do i=1,nx
        dxdy(i,j)=dx(i)*dy(j)
     end do
  end do
  do k=1,nz
     do j=1,ny
        dydz(j,k)=dy(j)*dz(k)
     end do
  end do
  do k=1,nz
     do i=1,nx
        dxdz(i,k)=dx(i)*dz(k)
     end do
  end do

!-- ݥ󷸿η׻
!-- ºݤ˥ݥ󷸿ѤΤ,  1 ¦ʤΤ,
!-- ׻̺︺Τ, 롼פ򤽤Τ褦ˤƤ.

  xyz=0.0
  xdp=0.0
  xdm=0.0
  yep=0.0
  yem=0.0
  zfp=0.0
  zfm=0.0

!-- ǹ⼡ ac η׻
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k)

  do k=2,nz-1
     do j=2,ny-1
        do i=2,nx-1
           xyz(i,j,k)=1.0/(2.0*(xt(i,j,k)/dx2(i)+yt(i,j,k)/dy2(j)+zt(i,j,k)/dz2(k))-gt(i,j,k))
           xdp(i,j,k)=(xt(i,j,k)/(dx2(i))+0.5*dt(i,j,k)/dx(i))*xyz(i,j,k)
           xdm(i,j,k)=(xt(i,j,k)/(dx2(i))-0.5*dt(i,j,k)/dx(i))*xyz(i,j,k)
           yep(i,j,k)=(yt(i,j,k)/(dy2(j))+0.5*et(i,j,k)/dy(j))*xyz(i,j,k)
           yem(i,j,k)=(yt(i,j,k)/(dy2(j))-0.5*et(i,j,k)/dy(j))*xyz(i,j,k)
           zfp(i,j,k)=(zt(i,j,k)/(dz2(k))+0.5*ft(i,j,k)/dz(k))*xyz(i,j,k)
           zfm(i,j,k)=(zt(i,j,k)/(dz2(k))-0.5*ft(i,j,k)/dz(k))*xyz(i,j,k)
           if(signa==1)then
              at(i,j,k)=0.25*at(i,j,k)/(dxdy(i,j))*xyz(i,j,k)
           else
              at(i,j,k)=0.0
           end if
           if(signb==1)then
              bt(i,j,k)=0.25*bt(i,j,k)/(dydz(j,k))*xyz(i,j,k)
           else
              bt(i,j,k)=0.0
           end if
           if(signc==1)then
              ct(i,j,k)=0.25*ct(i,j,k)/(dxdz(i,k))*xyz(i,j,k)
           else
              ct(i,j,k)=0.0
           end if
        end do
     end do
  end do

!$omp end do
!$omp end parallel

  err_max=eps  ! while 뤿صŪ
  counter=0

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k,ix,jy,kz)
     do k=1,nz
        do j=1,ny
           do i=1,nx

!-- ʹ, ȿ׻ɬפμ 8 ˤĤƤ줾
!-- inner_flag ΥåƱŬڤͤ򤽤줾༡׻,
!-- , γʻҷ׻ԤäƤ뤬, ib=8,-8  4 ʻҤΤȤˤ
!-- case select ʤ. ʤʤ, 岼˶ʻҤ뤳ȤϤꤨʤ.
              if(inner_flag(i,j,k).eqv..false.)then  ! .false. ʤΰ׻

                 tmp(i,j,k)=-rho(i,j,k)*xyz(i,j,k)
                 tmp(i,j,k)=tmp(i,j,k)+xdp(i,j,k)*psi(i+1,j,k)  &
  &                                   +xdm(i,j,k)*psi(i-1,j,k)  &
  &                                   +yep(i,j,k)*psi(i,j+1,k)  &
  &                                   +yem(i,j,k)*psi(i,j-1,k)  &
  &                                   +zfp(i,j,k)*psi(i,j,k+1)  &
  &                                   +zfm(i,j,k)*psi(i,j,k-1)


                 if(signa==1)then
                    tmp_b(i,j,k)=at(i,j,k)*(psi(i+1,j+1,k)+psi(i-1,j-1,k)  &
  &                                        -psi(i+1,j-1,k)-psi(i-1,j+1,k))
                 else
                    tmp_b(i,j,k)=0.0
                 end if
                 if(signb==1)then  ! ⤽ bt = 0 ʤ׻ʤ.
                    tmp_b(i,j,k)=tmp_b(i,j,k)  &
  &                             +bt(i,j,k)*(psi(i,j+1,k+1)+psi(i,j-1,k-1)  &
  &                                        -psi(i,j-1,k+1)-psi(i,j+1,k-1))
                 end if
                 if(signc==1)then  ! ⤽ bt = 0 ʤ׻ʤ.
                    tmp_b(i,j,k)=tmp_b(i,j,k)  &
  &                             +ct(i,j,k)*(psi(i+1,j,k+1)+psi(i-1,j,k-1)  &
  &                                        -psi(i-1,j,k+1)-psi(i+1,j,k-1))
                 end if
              
                 tmp(i,j,k)=tmp(i,j,k)+tmp_b(i,j,k)

              else   ! .true. ʤ鶭׻.

                 select case (ib(i,j,k))
                 case (1)
                    tmp(i,j,k)=bnd(i,j,k)

                 case (2)  ! x ˥եå, ¦
                    tmp(i,j,k)=psi(i+1,j,k)-bnd(i,j,k)*dx(i)

                 case (-2)  ! x ˥եå, ¦
                    tmp(i,j,k)=psi(i-1,j,k)+bnd(i,j,k)*dx(i)

                 case (4)  ! y ˥եå, ¦
                    tmp(i,j,k)=psi(i,j+1,k)-bnd(i,j,k)*dy(j)

                 case (-4)  ! y ˥եå, ¦
                    tmp(i,j,k)=psi(i,j-1,k)+bnd(i,j,k)*dy(j)

                 case (6)  ! y ˥եå, ¦
                    tmp(i,j,k)=psi(i,j,k+1)-bnd(i,j,k)*dz(k)

                 case (-6)  ! y ˥եå, ¦
                    tmp(i,j,k)=psi(i,j,k-1)+bnd(i,j,k)*dz(k)

                 case (3)  ! 12 , ⤷ 8 ǼȽ
                    if(i==1)then
                       ix=nx-1
                    else if(i==nx)then
                       ix=2
                    else
                       ix=i
                    end if
                    if(j==1)then
                       jy=ny-1
                    else if(j==ny)then
                       jy=2
                    else
                       jy=j
                    end if
                    if(k==1)then
                       kz=nz-1
                    else if(k==nz)then
                       kz=2
                    else
                       kz=k
                    end if
                    tmp(i,j,k)=psi(ix,jy,kz)

                 case (8)  ! ξեå z ̤ x, y 夫.
                    if(i==1.and.j==1)then  ! -- ɾ 1
                       tmp(i,j,k)=psi(i+1,j+1,k)  &
  &                        -0.5*(bnd(i+1,j,k)*dy(j)+bnd(i,j+1,k)*dx(i))

                    else if(i==nx.and.j==ny)then  ! -- ɾ 2
                       tmp(i,j,k)=psi(i-1,j-1,k)  &
  &                        +0.5*(bnd(i-1,j,k)*dy(j)+bnd(i,j-1,k)*dx(i))

                    else if(ib(i-1,j,k)==10.and.ib(i,j-1,k)==10)then
                       ! -- ɾ 1 Ʊ
                       tmp(i,j,k)=psi(i+1,j+1,k)  &
  &                        -0.5*(bnd(i+1,j,k)*dy(j)+bnd(i,j+1,k)*dx(i))

                    else if(ib(i+1,j,k)==10.and.ib(i,j+1,k)==10)then
                       ! -- ɾ 2 Ʊ
                       tmp(i,j,k)=psi(i-1,j-1,k)  &
  &                        +0.5*(bnd(i-1,j,k)*dy(j)+bnd(i,j-1,k)*dx(i))

                    end if

                 case (-8)  ! ξեå z ̤ x, y .
                    if(i==1.and.j==ny)then  ! -- ɾ 1
                       tmp(i,j,k)=psi(i+1,j-1,k)  &
  &                        +0.5*(bnd(i+1,j,k)*dy(j)-bnd(i,j-1,k)*dx(i))

                    else if(i==nx.and.j==1)then  ! -- ɾ 2
                       tmp(i,j,k)=psi(i-1,j+1,k)  &
  &                        +0.5*(-bnd(i-1,j,k)*dy(j)+bnd(i,j+1,k)*dx(i))

                    else if(ib(i-1,j,k)==10.and.ib(i,j+1,k)==10)then
                       ! -- ɾ 1 Ʊ
                       tmp(i,j,k)=psi(i+1,j-1,k)  &
  &                        +0.5*(bnd(i+1,j,k)*dy(j)-bnd(i,j-1,k)*dx(i))

                    else if(ib(i+1,j,k)==10.and.ib(i,j-1,k)==10)then
                       ! -- ɾ 2 Ʊ
                       tmp(i,j,k)=psi(i-1,j+1,k)  &
  &                        +0.5*(-bnd(i-1,j,k)*dy(j)+bnd(i,j+1,k)*dx(i))
                    end if

                 case (12)  ! ξեå y ̤ x, z 夫.
                    if(i==1.and.k==1)then  ! -- ɾ 1
                       tmp(i,j,k)=psi(i+1,j,k+1)  &
  &                        -0.5*(bnd(i+1,j,k)*dz(k)+bnd(i,j,k+1)*dx(i))

                    else if(i==nx.and.k==nz)then  ! -- ɾ 2
                       tmp(i,j,k)=psi(i-1,j,k-1)  &
  &                        +0.5*(bnd(i-1,j,k)*dz(k)+bnd(i,j,k-1)*dx(i))

                    else if(ib(i-1,j,k)==10.and.ib(i,j,k-1)==10)then
                       ! -- ɾ 1 Ʊ
                       tmp(i,j,k)=psi(i+1,j,k+1)  &
  &                        -0.5*(bnd(i+1,j,k)*dz(k)+bnd(i,j,k+1)*dx(i))

                    else if(ib(i+1,j,k)==10.and.ib(i,j,k+1)==10)then
                       ! -- ɾ 2 Ʊ
                       tmp(i,j,k)=psi(i-1,j,k-1)  &
  &                        +0.5*(bnd(i-1,j,k)*dz(k)+bnd(i,j,k-1)*dx(i))

                    end if

                 case (-12)  ! ξեå y ̤ x, z .
                    if(i==1.and.k==nz)then  ! -- ɾ 1
                       tmp(i,j,k)=psi(i+1,j,k-1)  &
  &                        +0.5*(bnd(i+1,j,k)*dz(k)-bnd(i,j,k-1)*dx(i))

                    else if(i==nx.and.k==1)then  ! -- ɾ 2
                       tmp(i,j,k)=psi(i-1,j,k+1)  &
  &                        +0.5*(-bnd(i-1,j,k)*dz(k)+bnd(i,j,k+1)*dx(i))

                    else if(ib(i-1,j,k)==10.and.ib(i,j,k+1)==10)then
                       ! -- ɾ 1 Ʊ
                       tmp(i,j,k)=psi(i+1,j,k-1)  &
  &                        +0.5*(bnd(i+1,j,k)*dz(k)-bnd(i,j,k-1)*dx(i))

                    else if(ib(i+1,j,k)==10.and.ib(i,j,k-1)==10)then
                       ! -- ɾ 2 Ʊ
                       tmp(i,j,k)=psi(i-1,j,k+1)  &
  &                        +0.5*(-bnd(i-1,j,k)*dz(k)+bnd(i,j,k+1)*dx(i))

                    end if

                 case (24)  ! ξեå x ̤ y, z 夫.
                    if(j==1.and.k==1)then  ! -- ɾ 1
                       tmp(i,j,k)=psi(i,j+1,k+1)  &
  &                        -0.5*(bnd(i,j+1,k)*dz(k)+bnd(i,j,k+1)*dy(j))

                    else if(j==ny.and.k==nz)then  ! -- ɾ 2
                       tmp(i,j,k)=psi(i,j-1,k-1)  &
  &                        +0.5*(bnd(i,j-1,k)*dz(k)+bnd(i,j,k-1)*dy(j))

                    else if(ib(i,j-1,k)==10.and.ib(i,j,k-1)==10)then
                       ! -- ɾ 1 Ʊ
                       tmp(i,j,k)=psi(i,j+1,k+1)  &
  &                        -0.5*(bnd(i,j+1,k)*dz(k)+bnd(i,j,k+1)*dy(j))

                    else if(ib(i,j+1,k)==10.and.ib(i,j,k+1)==10)then
                       ! -- ɾ 2 Ʊ
                       tmp(i,j,k)=psi(i,j-1,k-1)  &
  &                        +0.5*(bnd(i,j-1,k)*dz(k)+bnd(i,j,k-1)*dy(j))

                    end if

                 case (-24)  ! ξեå x ̤ y, z .
                    if(j==1.and.k==nz)then  ! -- ɾ 1
                       tmp(i,j,k)=psi(i,j+1,k-1)  &
  &                        +0.5*(bnd(i,j+1,k)*dz(k)-bnd(i,j,k-1)*dy(j))

                    else if(j==ny.and.k==1)then  ! -- ɾ 2
                       tmp(i,j,k)=psi(i,j-1,k+1)  &
  &                        +0.5*(-bnd(i,j-1,k)*dz(k)+bnd(i,j,k+1)*dy(j))

                    else if(ib(i,j-1,k)==10.and.ib(i,j,k+1)==10)then
                       ! -- ɾ 1 Ʊ
                       tmp(i,j,k)=psi(i,j+1,k-1)  &
  &                        +0.5*(bnd(i,j+1,k)*dz(k)-bnd(i,j,k-1)*dy(j))

                    else if(ib(i,j+1,k)==10.and.ib(i,j,k-1)==10)then
                       ! -- ɾ 2 Ʊ
                       tmp(i,j,k)=psi(i,j-1,k+1)  &
  &                        +0.5*(-bnd(i,j-1,k)*dz(k)+bnd(i,j,k+1)*dy(j))

                    end if

                 !-- ʹ, ΰʤΤ, ̤.
                 case (11)  ! ξեå (1,1,1) , ⤷ΰ.
                    tmp(i,j,k)=psi(i+1,j+1,k+1)  &
  &                           -(bnd(i,j+1,k+1)*dx(i)  &
  &                            +bnd(i+1,j,k+1)*dy(j)  &
  &                            +bnd(i+1,j+1,k)*dz(k))/3.0

                 case (13)  ! ξեå (nx,1,1) , ⤷ΰ.
                    tmp(i,j,k)=psi(i-1,j+1,k+1)  &
  &                           -(-bnd(i,j+1,k+1)*dx(i)  &
  &                             +bnd(i-1,j,k+1)*dy(j)  &
  &                             +bnd(i-1,j+1,k)*dz(k))/3.0

                 case (17)  ! ξեå (1,ny,1) , ⤷ΰ.
                    tmp(i,j,k)=psi(i+1,j-1,k+1)  &
  &                           -(bnd(i,j-1,k+1)*dx(i)  &
  &                            -bnd(i+1,j,k+1)*dy(j)  &
  &                            +bnd(i+1,j-1,k)*dz(k))/3.0

                 case (19)  ! ξեå (nx,ny,1) , ⤷ΰ.
                    tmp(i,j,k)=psi(i-1,j-1,k+1)  &
  &                           -(-bnd(i,j-1,k+1)*dx(i)  &
  &                             -bnd(i-1,j,k+1)*dy(j)  &
  &                             +bnd(i-1,j-1,k)*dz(k))/3.0

                 case (23)  ! ξեå (1,1,nz) , ⤷ΰ.
                    tmp(i,j,k)=psi(i+1,j+1,k-1)  &
  &                           -(bnd(i,j+1,k-1)*dx(i)  &
  &                            +bnd(i+1,j,k-1)*dy(j)  &
  &                            -bnd(i+1,j+1,k)*dz(k))/3.0

                 case (29)  ! ξեå (nx,1,nz) , ⤷ΰ.
                    tmp(i,j,k)=psi(i-1,j+1,k-1)  &
  &                           -(-bnd(i,j+1,k-1)*dx(i)  &
  &                             +bnd(i-1,j,k-1)*dy(j)  &
  &                             -bnd(i-1,j+1,k)*dz(k))/3.0

                 case (31)  ! ξեå (1,ny,nz) , ⤷ΰ.
                    tmp(i,j,k)=psi(i+1,j-1,k-1)  &
  &                           -(bnd(i,j-1,k-1)*dx(i)  &
  &                            -bnd(i+1,j,k-1)*dy(j)  &
  &                            -bnd(i+1,j-1,k)*dz(k))/3.0

                 case (37)  ! ξեå (nx,ny,nz) , ⤷ΰ.
                    tmp(i,j,k)=psi(i-1,j-1,k-1)  &
  &                           -(-bnd(i,j-1,k-1)*dx(i)  &
  &                             -bnd(i-1,j,k-1)*dy(j)  &
  &                             -bnd(i-1,j-1,k)*dz(k))/3.0

                 case (-11)  ! ξեå (i+1,j+1,k+1)  10 .
                    tmp(i,j,k)=(psi(i-1,j+1,k+1)+psi(i+1,j-1,k+1)+psi(i+1,j+1,k-1)  &
  &                            +bnd(i,j+1,k+1)*dx(i)+bnd(i+1,j,k+1)*dy(j)  &
  &                            +bnd(i+1,j+1,k)*dz(k))/3.0

                 case (-13)  ! ξեå (i-1,j+1,k+1)  10 .
                    tmp(i,j,k)=(psi(i+1,j+1,k+1)+psi(i-1,j-1,k+1)+psi(i-1,j+1,k-1)  &
  &                            -bnd(i,j+1,k+1)*dx(i)+bnd(i-1,j,k+1)*dy(j)  &
  &                            +bnd(i-1,j+1,k)*dz(k))/3.0

                 case (-17)  ! ξեå (i+1,j-1,k+1)  10 .
                    tmp(i,j,k)=(psi(i-1,j-1,k+1)+psi(i+1,j+1,k+1)+psi(i+1,j-1,k-1)  &
  &                            +bnd(i,j-1,k+1)*dx(i)-bnd(i+1,j,k+1)*dy(j)  &
  &                            +bnd(i+1,j-1,k)*dz(k))/3.0

                 case (-19)  ! ξեå (i-1,j-1,k+1)  10 .
                    tmp(i,j,k)=(psi(i+1,j-1,k+1)+psi(i-1,j+1,k+1)+psi(i-1,j-1,k-1)  &
  &                            -bnd(i,j-1,k+1)*dx(i)-bnd(i-1,j,k+1)*dy(j)  &
  &                            +bnd(i-1,j-1,k)*dz(k))/3.0

                 case (-23)  ! ξեå (i+1,j+1,k-1)  10 .
                    tmp(i,j,k)=(psi(i-1,j+1,k-1)+psi(i+1,j-1,k-1)+psi(i+1,j+1,k+1)  &
  &                            +bnd(i,j+1,k-1)*dx(i)+bnd(i+1,j,k-1)*dy(j)  &
  &                            -bnd(i+1,j+1,k)*dz(k))/3.0

                 case (-29)  ! ξեå (i-1,j+1,k-1)  10 .
                    tmp(i,j,k)=(psi(i+1,j+1,k-1)+psi(i-1,j-1,k-1)+psi(i-1,j+1,k+1)  &
  &                            -bnd(i,j+1,k-1)*dx(i)+bnd(i-1,j,k-1)*dy(j)  &
  &                            -bnd(i-1,j+1,k)*dz(k))/3.0

                 case (-31)  ! ξեå (i+1,j-1,k-1)  10 .
                    tmp(i,j,k)=(psi(i-1,j-1,k-1)+psi(i+1,j+1,k-1)+psi(i+1,j-1,k+1)  &
  &                            +bnd(i,j-1,k-1)*dx(i)-bnd(i+1,j,k-1)*dy(j)  &
  &                            -bnd(i+1,j-1,k)*dz(k))/3.0

                 case (-37)  ! ξեå (i-1,j-1,k-1)  10 .
                    tmp(i,j,k)=(psi(i+1,j-1,k-1)+psi(i-1,j+1,k-1)+psi(i-1,j-1,k+1)  &
  &                            -bnd(i,j-1,k-1)*dx(i)-bnd(i-1,j,k-1)*dy(j)  &
  &                            -bnd(i-1,j-1,k)*dz(k))/3.0

                 end select

              end if

              if(sor_flag.eqv..true.)then
                 tmp(i,j,k)=(1.0-accc)*psi(i,j,k)+tmp(i,j,k)*accc
              end if

           end do
        end do
     end do
!$omp end do
!$omp end parallel

!-- ι
     do k=2,nz-1
        do j=2,ny-1
           do i=2,nx-1
              err=abs(tmp(i,j,k)-psi(i,j,k))
              if(err_max<=err)then
                 err_max=err
              end if
           end do
        end do
     end do

!-- ƹ

     do k=1,nz
        do j=1,ny
           do i=1,nx
              psi(i,j,k)=tmp(i,j,k)
           end do
        end do
     end do

     if(nl/=0)then
        counter=counter+1
        if(counter==nl)then
           exit
        else
           err_max=eps
        end if
     end if

  end do

!-- 

  call calculate_bound_3d( ib, dx, dy, dz, bnd, psi )

!-- ̤ΰˤ undef .

  do k=1,nz
     do j=1,ny
        do i=1,nx
           if(ib(i,j,k)==10)then
              psi(i,j,k)=defun
           end if
        end do
     end do
  end do

end subroutine Ellip_Jacobi_3d


!-----------------------------------
! ʲ, private subroutine
!-----------------------------------

subroutine set_bound( bound, ib, inner_flag, inner_bound )
! ȿˡ롼ˤꤵ붭Υե饰å, ꤹ.
  implicit none
  character(4), intent(in) :: bound   ! ΰ趭Υե饰
  integer, intent(inout) :: ib(:,:)   ! Ƚ
  logical, intent(inout) :: inner_flag(size(ib,1),size(ib,2))
                            ! ΰ趭ե饰
  integer, intent(in), optional :: inner_bound(size(ib,1),size(ib,2))
                            ! ΰ趭Ƚ
  integer :: i, j, nx, ny

  nx=size(ib,1)
  ny=size(ib,2)

!-- ѿν

  ib=0
  inner_flag=.true.

!-- ǧ.
!-- ʤΤ, ξüȤ 3 ꤵƤʤȤʤ.
  if(bound(1:1)=='3')then
     if(bound(3:3)/='3')then
        write(*,*) "### ERROR ###"
        write(*,*) "if bound = 3, bound(1:1)==bound(3:3). STOP."
        stop
     end if
  end if

  if(bound(3:3)=='3')then
     if(bound(1:1)/='3')then
        write(*,*) "### ERROR ###"
        write(*,*) "if bound = 3, bound(1:1)==bound(3:3). STOP."
        stop
     end if
  end if

  if(bound(2:2)=='3')then
     if(bound(4:4)/='3')then
        write(*,*) "### ERROR ###"
        write(*,*) "if bound = 3, bound(2:2)==bound(4:4). STOP."
        stop
     end if
  end if

  if(bound(4:4)=='3')then
     if(bound(2:2)/='3')then
        write(*,*) "### ERROR ###"
        write(*,*) "if bound = 3, bound(2:2)==bound(4:4). STOP."
        stop
     end if
  end if

  select case (bound(1:1))
  case ('1')
     do i=2,nx-1
        ib(i,1)=1
     end do

  case ('2')
     do i=2,nx-1
        ib(i,1)=4  ! y ΥեåǻͤϾ¦
     end do

  case ('3')
     do i=2,nx-1
        ib(i,1)=3  ! y  (x ) 
     end do
  end select

  select case (bound(2:2))
  case ('1')
     do j=2,ny-1
        ib(1,j)=1
     end do

  case ('2')
     do j=2,ny-1
        ib(1,j)=2  ! x Υեåǻͤϱ¦
     end do

  case ('3')
     do j=2,ny-1
        ib(1,j)=3  ! x  (y ) 
     end do
  end select

  select case (bound(3:3))
  case ('1')
     do i=2,nx-1
        ib(i,ny)=1
     end do

  case ('2')
     do i=2,nx-1
        ib(i,ny)=-4  ! y Υեåǻͤϲ¦
     end do

  case ('3')
     do i=2,nx-1
        ib(i,ny)=3  ! y  (x ) 
     end do
  end select

  select case (bound(4:4))
  case ('1')
     do j=2,ny-1
        ib(nx,j)=1
     end do

  case ('2')
     do j=2,ny-1
        ib(nx,j)=-2  ! x ΥեåǻͤϺ¦
     end do

  case ('3')
     do j=2,ny-1
        ib(nx,j)=3  ! x  (y ) 
     end do
  end select

!-- ΰ 2 դŤʤΤ, Ǥζˡϰʲνͥ褹.
!-- (1) ɤ餫 1 ΤȤ, ΰ 1,
!-- (2) (1) ʳǤɤ餫 3 ΤȤ, ΰ 3.
!-- (3) (1), (2) ʳ 2. Ĥޤ, ξȤ 2 ʤ 2 Ȥʤ.

  if(bound(1:1)=='1')then
     ib(1,1)=1
     ib(nx,1)=1
  end if
  if(bound(2:2)=='1')then
     ib(1,1)=1
     ib(1,ny)=1
  end if
  if(bound(3:3)=='1')then
     ib(1,ny)=1
     ib(nx,ny)=1
  end if
  if(bound(4:4)=='1')then
     ib(nx,1)=1
     ib(nx,ny)=1
  end if

!-- 4 Ȥξ
  if(bound(1:2)=='33')then
     ib(1,1)=3
     ib(1,ny)=3
     ib(nx,1)=3
     ib(nx,ny)=3
  end if

!-- ɤ餫ξ, ib 椬ꤵƤʤ -3 .
  if(bound(1:1)=='3'.or.bound(2:2)=='3')then
     if(ib(1,1)==0)then
        ib(1,1)=3
     end if
     if(ib(nx,1)==0)then
        ib(nx,1)=3
     end if
     if(ib(1,ny)==0)then
        ib(1,ny)=3
     end if
     if(ib(nx,ny)==0)then
        ib(nx,ny)=3
     end if
  end if

!-- ΰζǤ뤳Ȥ 8, -8 Ǽ.
!-- 8 ξ, Ǥ뤳Ȥ, -8 ξ, 夫Ǥ뤳Ȥ򼨤.

  if(ib(1,1)==0)then
     ib(1,1)=8
  end if
  if(ib(nx,1)==0)then
     ib(nx,1)=-8
  end if
  if(ib(1,ny)==0)then
     ib(1,ny)=-8
  end if
  if(ib(nx,ny)==0)then
     ib(nx,ny)=8
  end if

!-- 

  if(present(inner_bound))then
     do j=2,ny-1
        do i=2,nx-1
           ib(i,j)=inner_bound(i,j)
           if(ib(i,j)==0)then
              inner_flag(i,j)=.false.
           end if
        end do
     end do
  else   ! ΰ褬ꤵƤʤ, Ʒ׻.
     do j=2,ny-1
        do i=2,nx-1
           inner_flag(i,j)=.false.
        end do
     end do
  end if

end subroutine set_bound

subroutine setval_bound( ib, bnd, psi, bound_opt )
! ͤ򶭳ȽȤꤹ.
  implicit none
  integer, intent(in) :: ib(:,:)  ! Ƚ
  real, intent(inout) :: bnd(size(ib,1),size(ib,2))  ! Ǥ
  real, intent(inout) :: psi(size(ib,1),size(ib,2))  ! 
  real, intent(in), optional :: bound_opt(size(ib,1),size(ib,2))  ! Ǥ
  integer :: i, j, nx, ny

  nx=size(ib,1)
  ny=size(ib,2)

!-- ͤ
  if(present(bound_opt))then
     do j=1,ny
        do i=1,nx
           bnd(i,j)=bound_opt(i,j)
        end do
     end do
  else
     do j=1,ny
        do i=1,nx
           bnd(i,j)=0.0
        end do
     end do
  end if

!--  "ib(i,j)==1 ξΤ"
!-- ΰˤĤƤ⤳Ƥޤ.

  do j=1,ny
     do i=1,nx
        if(ib(i,j)==1)then
           psi(i,j)=bnd(i,j)
        end if
     end do
  end do

end subroutine setval_bound

subroutine set_coe( coe, ext, def )
! 2  ext ǻꤵ줿ͤ⤷ def ǻꤵ줿ͤ.
! ext, def ɤ optional Ǥ뤬, ɬɤ餫ϻꤵƤʤȤʤ.
  implicit none
  real, intent(inout) :: coe(:,:)  ! 
  real, intent(in), optional :: ext(size(coe,1),size(coe,2))  ! 
  real, intent(in), optional :: def  ! 
  integer :: i, j, nx, ny

  nx=size(coe,1)
  ny=size(coe,2)

  if(present(ext))then
     do j=1,ny
        do i=1,nx
           coe(i,j)=ext(i,j)
        end do
     end do
  else if(present(def))then
     do j=1,ny
        do i=1,nx
           coe(i,j)=def
        end do
     end do
  else
     write(*,*) "### ERROR ###"
     write(*,*) "subroutine set_coe must be set optional argument 'ext' or 'def'"
     write(*,*) "STOP."
     stop
  end if

end subroutine set_coe

subroutine check_coe( coe, aval )
! 2  aval Ƥʤå.
  implicit none
  real, intent(inout) :: coe(:,:)  ! 
  real, intent(in) :: aval         ! å
  integer :: i, j, nx, ny

  nx=size(coe,1)
  ny=size(coe,2)

  do j=1,ny
     do i=1,nx
        if(coe(i,j)==aval)then
           write(*,*) "### ERROR (Ellip_Slv module) ###"
           write(*,*) "Detect a certain value", aval
           write(*,*) "STOP."
           stop
        end if
     end do
  end do

end subroutine check_coe

subroutine calculate_bound( ib, dx, dy, bnd, psi )
! ib Ƚ̤򸵤, Υޥ, ˤĤƶͤ׻.
  integer, intent(in) :: ib(:,:)  ! Ƚ
  real, intent(in) :: dx(size(ib,1))  ! x γʻҲ
  real, intent(in) :: dy(size(ib,2))  ! y γʻҲ
  real, intent(in) :: bnd(size(ib,1),size(ib,2))  ! (Υޥ󷿤Τ߻)
  real, intent(inout) :: psi(size(ib,1),size(ib,2))  ! ؿ
  integer :: i, j, nx, ny, ix, jy

  nx=size(ib,1)
  ny=size(ib,2)

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,ix,jy)
  do j=1,ny
     do i=1,nx
        if(ib(i,j)/=0)then   ! ׻ΰ select ʸΤɤ.
           select case (ib(i,j))
           case (1)
              psi(i,j)=bnd(i,j)

           case (2)  ! x ˥եå, ¦
              psi(i,j)=psi(i+1,j)-bnd(i,j)*dx(i)

           case (-2)  ! x ˥եå, ¦
              psi(i,j)=psi(i-1,j)+bnd(i,j)*dx(i)

           case (4)  ! y ˥եå, ¦
              psi(i,j)=psi(i,j+1)-bnd(i,j)*dy(j)

           case (-4)  ! y ˥եå, ¦
              psi(i,j)=psi(i,j-1)+bnd(i,j)*dy(j)

           case (3)  ! 
              if(i==1)then
                 ix=nx-1
              else if(i==nx)then
                 ix=2
              else
                 ix=i
              end if
              if(j==1)then
                 jy=ny-1
              else if(j==ny)then
                 jy=2
              else
                 jy=j
              end if

              psi(i,j)=psi(ix,jy)

           case (7)  ! ξեå.
              if((ib(i+1,j+1)==10).and.(ib(i+1,j)/=10).and.  &
  &              (ib(i,j+1)/=10))then
                 psi(i,j)=0.5*(psi(i-1,j)+psi(i,j-1))  &
  &                       +0.5*bnd(i,j)*(dy(j)+dx(i))

              else if((ib(i-1,j-1)==10).and.(ib(i-1,j)/=10).and.  &
  &                   (ib(i,j-1)/=10))then
                 psi(i,j)=0.5*(psi(i+1,j)+psi(i,j+1))  &
  &                       -0.5*bnd(i,j)*(dy(j)+dx(i))

              end if

           case (-7)  ! ξեå.
              if((ib(i-1,j+1)==10).and.(ib(i-1,j)/=10).and.  &
  &              (ib(i,j+1)/=10))then
                 psi(i,j)=0.5*(psi(i+1,j)+psi(i,j-1))  &
  &                       +0.5*bnd(i,j)*(dy(j)-dx(i))

              else if((ib(i+1,j-1)==10).and.(ib(i+1,j)/=10).and.  &
  &              (ib(i,j-1)/=10))then
                 psi(i,j)=0.5*(psi(i-1,j)+psi(i,j+1))  &
  &                       +0.5*bnd(i,j)*(-dy(j)+dx(i))

              end if

           case (8)  ! ξեåǺѤ, ⤷.
              if(i==1.and.j==1)then  ! -- ɾ 1
                 psi(i,j)=psi(i+1,j+1)-0.5*(bnd(i+1,j)*dy(j)+bnd(i,j+1)*dx(i))

              else if(i==nx.and.j==ny)then  ! -- ɾ 2
                 psi(i,j)=psi(i-1,j-1)+0.5*(bnd(i-1,j)*dy(j)+bnd(i,j-1)*dx(i))

              else if(ib(i-1,j)==10.and.ib(i,j-1)==10)then
                 ! -- ɾ 1 Ʊ
                 psi(i,j)=psi(i+1,j+1)-0.5*(bnd(i+1,j)*dy(j)+bnd(i,j+1)*dx(i))

              else if(ib(i+1,j)==10.and.ib(i,j+1)==10)then
                 ! -- ɾ 2 Ʊ
                 psi(i,j)=psi(i-1,j-1)+0.5*(bnd(i-1,j)*dy(j)+bnd(i,j-1)*dx(i))

              end if

           case (-8)  ! ξեåǱѤ
              if(i==1.and.j==ny)then  ! -- ɾ 1
                 psi(i,j)=psi(i+1,j-1)+0.5*(bnd(i+1,j)*dy(j)-bnd(i,j-1)*dx(i))

              else if(i==nx.and.j==1)then  ! -- ɾ 2
                 psi(i,j)=psi(i-1,j+1)+0.5*(-bnd(i-1,j)*dy(j)+bnd(i,j+1)*dx(i))

              else if(ib(i-1,j)==10.and.ib(i,j+1)==10)then
                 ! -- ɾ 1 Ʊ
                 psi(i,j)=psi(i+1,j-1)+0.5*(bnd(i+1,j)*dy(j)-bnd(i,j-1)*dx(i))

              else if(ib(i+1,j)==10.and.ib(i,j-1)==10)then
                 ! -- ɾ 2 Ʊ
                 psi(i,j)=psi(i-1,j+1)+0.5*(-bnd(i-1,j)*dy(j)+bnd(i,j+1)*dx(i))

              end if
           end select

        end if
     end do
  end do
!$omp end do
!$omp end parallel

end subroutine calculate_bound


subroutine set_bound_3d( bound, ib, inner_flag, inner_bound )
! ȿˡ롼ˤꤵ붭Υե饰å, ꤹ.
  implicit none
  character(6), intent(in) :: bound     ! ΰ趭Υե饰
  integer, intent(inout) :: ib(:,:,:)   ! Ƚ
  logical, intent(inout) :: inner_flag(size(ib,1),size(ib,2),size(ib,3))
                            ! ΰ趭ե饰
  integer, intent(in), optional :: inner_bound(size(ib,1),size(ib,2),size(ib,3))
                            ! ΰ趭Ƚ
  integer :: i, j, k, nx, ny, nz

  nx=size(ib,1)
  ny=size(ib,2)
  nz=size(ib,3)

!-- ѿν

  ib=0
  inner_flag=.true.

!-- ǧ.
!-- ʤΤ, ξüȤ 3 ꤵƤʤȤʤ.
  if(bound(1:1)=='3')then
     if(bound(3:3)/='3')then
        write(*,*) "### ERROR ###"
        write(*,*) "if bound = 3, bound(1:1)==bound(3:3). STOP."
        stop
     end if
  end if

  if(bound(3:3)=='3')then
     if(bound(1:1)/='3')then
        write(*,*) "### ERROR ###"
        write(*,*) "if bound = 3, bound(1:1)==bound(3:3). STOP."
        stop
     end if
  end if

  if(bound(2:2)=='3')then
     if(bound(4:4)/='3')then
        write(*,*) "### ERROR ###"
        write(*,*) "if bound = 3, bound(2:2)==bound(4:4). STOP."
        stop
     end if
  end if

  if(bound(4:4)=='3')then
     if(bound(2:2)/='3')then
        write(*,*) "### ERROR ###"
        write(*,*) "if bound = 3, bound(2:2)==bound(4:4). STOP."
        stop
     end if
  end if

  if(bound(5:5)=='3')then
     if(bound(6:6)/='3')then
        write(*,*) "### ERROR ###"
        write(*,*) "if bound = 3, bound(5:5)==bound(6:6). STOP."
        stop
     end if
  end if

  if(bound(6:6)=='3')then
     if(bound(5:5)/='3')then
        write(*,*) "### ERROR ###"
        write(*,*) "if bound = 3, bound(5:5)==bound(6:6). STOP."
        stop
     end if
  end if

  select case (bound(1:1))
  case ('1')
     do k=2,nz-1
        do i=2,nx-1
           ib(i,1,k)=1
        end do
     end do

  case ('2')
     do k=2,nz-1
        do i=2,nx-1
           ib(i,1,k)=4  ! y ΥեåǻͤϾ¦
        end do
     end do

  case ('3')
     do k=2,nz-1
        do i=2,nx-1
           ib(i,1,k)=3  ! y  (x ) 
        end do
     end do
  end select

  select case (bound(2:2))
  case ('1')
     do k=2,nz-1
        do j=2,ny-1
           ib(1,j,k)=1
        end do
     end do

  case ('2')
     do k=2,nz-1
        do j=2,ny-1
           ib(1,j,k)=2  ! x Υեåǻͤϱ¦
        end do
     end do

  case ('3')
     do k=2,nz-1
        do j=2,ny-1
           ib(1,j,k)=3  ! x  (y ) 
        end do
     end do
  end select

  select case (bound(3:3))
  case ('1')
     do k=2,nz-1
        do i=2,nx-1
           ib(i,ny,k)=1
        end do
     end do

  case ('2')
     do k=2,nz-1
        do i=2,nx-1
           ib(i,ny,k)=-4  ! y Υեåǻͤϲ¦
        end do
     end do

  case ('3')
     do k=2,nz-1
        do i=2,nx-1
           ib(i,ny,k)=3  ! y  (x ) 
        end do
     end do
  end select

  select case (bound(4:4))
  case ('1')
     do k=2,nz-1
        do j=2,ny-1
           ib(nx,j,k)=1
        end do
     end do

  case ('2')
     do k=2,nz-1
        do j=2,ny-1
           ib(nx,j,k)=-2  ! x ΥեåǻͤϺ¦
        end do
     end do

  case ('3')
     do k=2,nz-1
        do j=2,ny-1
           ib(nx,j,k)=3  ! x  (y ) 
        end do
     end do
  end select

  select case (bound(5:5))
  case ('1')
     do j=2,ny-1
        do i=2,nx-1
           ib(i,j,1)=1
        end do
     end do

  case ('2')
     do j=2,ny-1
        do i=2,nx-1
           ib(i,j,1)=6  ! z Υեåǻͤϲ
        end do
     end do

  case ('3')
     do j=2,ny-1
        do i=2,nx-1
           ib(i,j,1)=3
        end do
     end do
  end select

  select case (bound(6:6))
  case ('1')
     do j=2,ny-1
        do i=2,nx-1
           ib(i,j,nz)=1
        end do
     end do

  case ('2')
     do j=2,ny-1
        do i=2,nx-1
           ib(i,j,nz)=-6  ! z ΥեåǻͤϾ
        end do
     end do

  case ('3')
     do j=2,ny-1
        do i=2,nx-1
           ib(i,j,nz)=3
        end do
     end do
  end select

!-- ΰ 2 դŤʤΤ, Ǥζˡϰʲνͥ褹.
!-- (1) ɤ餫 1 ΤȤ, ΰ 1,
!-- (2) (1) ʳǤɤ餫 3 ΤȤ, ΰ 3.
!-- (3) (1), (2) ʳ 2. Ĥޤ, ξȤ 2 ʤ 2 Ȥʤ.
!-- դ 12 ܤΤ, 12 ս.
!-- ƶդϰʲΤ褦 x, y, z ǻ.
!-- (1,1,0) -> z ˿Ӥ nx=1, ny=1 ̤̤.

!-- [] : 1, 3 ξ϶դǤʤ, ƱǤΤ
!--          ǰꤷƤޤ.

  if(bound(1:1)=='1')then  ! (1,1,0), (nx,1,0), (0,1,1), (0,1,nz) 
     ib(1,1,1:nz)=1
     ib(nx,1,1:nz)=1
     ib(1:nx,1,1)=1
     ib(1:nx,1,nz)=1
  end if
  if(bound(2:2)=='1')then  ! (1,1,0), (1,ny,0), (1,0,1), (1,0,nz) 
     ib(1,1,1:nz)=1
     ib(1,ny,1:nz)=1
     ib(1,1:ny,1)=1
     ib(1,1:ny,nz)=1
  end if
  if(bound(3:3)=='1')then  ! (1,ny,0), (nx,ny,0), (0,ny,1), (0,ny,nz) 
     ib(1,ny,1:nz)=1
     ib(nx,ny,1:nz)=1
     ib(1:nx,ny,1)=1
     ib(1:nx,ny,nz)=1
  end if
  if(bound(4:4)=='1')then  ! (nx,1,0), (nx,ny,0), (nx,0,1), (nx,0,nz) 
     ib(nx,1,1:nz)=1
     ib(nx,ny,1:nz)=1
     ib(nx,1:ny,1)=1
     ib(nx,1:ny,nz)=1
  end if
  if(bound(5:5)=='1')then  ! (0,1,1), (0,ny,1), (1,0,1), (nx,0,1) 
     ib(1:nx,1,1)=1
     ib(1:nx,ny,1)=1
     ib(1,1:ny,1)=1
     ib(nx,1:ny,1)=1
  end if
  if(bound(6:6)=='1')then  ! (0,1,nz), (0,ny,nz), (1,0,nz), (nx,0,nz) 
     ib(1:nx,1,nz)=1
     ib(1:nx,ny,nz)=1
     ib(1,1:ny,nz)=1
     ib(nx,1:ny,nz)=1
  end if

!-- 12 ܤȤξ
  if(bound(1:1)=='3'.and.bound(2:2)=='3'.and.bound(5:5)=='3')then
     ib(1,1,1:nz)=3
     ib(1,ny,1:nz)=3
     ib(nx,1,1:nz)=3
     ib(nx,ny,1:nz)=3
     ib(1:nx,1,1)=3
     ib(1:nx,1,nz)=3
     ib(1:nx,ny,1)=3
     ib(1:nx,ny,nz)=3
     ib(1,1:ny,1)=3
     ib(nx,1:ny,1)=3
     ib(1,1:ny,nz)=3
     ib(nx,1:ny,nz)=3
  end if

!-- 12 դΤ, 줫Ǽξ, ib ͤꤵƤʤ
!-- -3 ꤹ. -3 ϸ궭 1 ͥ٤Τ, .
  if(bound(1:1)=='3'.or.bound(2:2)=='3'.or.bound(5:5)=='3')then
     do k=1,nz
        do i=1,nx
           if(ib(i,1,k)==0)then
              ib(i,1,k)=3
           end if
           if(ib(i,ny,k)==0)then
              ib(i,ny,k)=3
           end if
        end do
     end do
     do k=1,nz
        do j=1,ny
           if(ib(1,j,k)==0)then
              ib(1,j,k)=3
           end if
           if(ib(nx,j,k)==0)then
              ib(nx,j,k)=3
           end if
        end do
     end do
     do j=1,ny
        do i=1,nx
           if(ib(i,j,1)==0)then
              ib(i,j,1)=3
           end if
           if(ib(i,j,nz)==0)then
              ib(i,j,nz)=3
           end if
        end do
     end do
  end if

!-- ͳ
!-- [] : Ǥ, դȶͤۤʤΤ,
!--          ̡ꤹ.
!-- դˤ, ib = 0 Ǥ뤳Ȥǧ,
!--  2 ̤ꤵƤͤѤȤʤ褦ꤹ.
!-- ޤꤹ.
!-- ̤ʤ 2, 4, 6 ꤵƤΤ
!-- 줾̤ܤ 12 դ
!-- 8, 12, 24 ȤͤĤꤵ.

  do k=2,nz-1
     if(ib(1,1,k)==0)then
        ib(1,1,k)=ib(2,1,k)*ib(1,2,k)
     end if
     if(ib(1,ny,k)==0)then
        ib(1,ny,k)=ib(2,ny,k)*ib(1,ny-1,k)
     end if
     if(ib(nx,1,k)==0)then
        ib(nx,1,k)=ib(nx-1,1,k)*ib(nx,2,k)
     end if
     if(ib(nx,ny,k)==0)then
        ib(nx,ny,k)=ib(nx-1,ny,k)*ib(nx,ny-1,k)
     end if
  end do

  do j=2,ny-1
     if(ib(1,j,1)==0)then
        ib(1,j,1)=ib(2,j,1)*ib(1,j,2)
     end if
     if(ib(nx,j,1)==0)then
        ib(nx,j,1)=ib(nx-1,j,1)*ib(nx,j,2)
     end if
     if(ib(1,j,nz)==0)then
        ib(1,j,nz)=ib(2,j,nz)*ib(1,j,nz-1)
     end if
     if(ib(nx,j,nz)==0)then
        ib(nx,j,nz)=ib(nx-1,j,nz)*ib(nx,j,nz-1)
     end if
  end do

  do i=2,nx-1
     if(ib(i,1,1)==0)then
        ib(i,1,1)=ib(i,1,2)*ib(i,2,1)
     end if
     if(ib(i,ny,1)==0)then
        ib(i,ny,1)=ib(i,ny,2)*ib(i,ny-1,1)
     end if
     if(ib(i,1,nz)==0)then
        ib(i,1,nz)=ib(i,1,nz-1)*ib(i,2,nz)
     end if
     if(ib(i,ny,nz)==0)then
        ib(i,ny,nz)=ib(i,ny,nz-1)*ib(i,ny-1,nz)
     end if
  end do

!-- 8 .
!-- 8 ʤΤ, ʲǿб.
!-- (1,1,1) = 11
!-- (nx,1,1) = 13
!-- (1,ny,1) = 17
!-- (nx,ny,1) = 19
!-- (1,1,nz) = 23
!-- (nx,1,nz) = 29
!-- (1,ny,nz) = 31
!-- (nx,ny,nz) = 33

  if(ib(1,1,1)==0)then
     ib(1,1,1)=11
  end if
  if(ib(nx,1,1)==0)then
     ib(nx,1,1)=13
  end if
  if(ib(1,ny,1)==0)then
     ib(1,ny,1)=17
  end if
  if(ib(nx,ny,1)==0)then
     ib(nx,ny,1)=19
  end if
  if(ib(1,1,nz)==0)then
     ib(1,1,nz)=23
  end if
  if(ib(nx,1,nz)==0)then
     ib(nx,1,nz)=29
  end if
  if(ib(1,ny,nz)==0)then
     ib(1,ny,nz)=31
  end if
  if(ib(nx,ny,nz)==0)then
     ib(nx,ny,nz)=37
  end if

!-- 

  if(present(inner_bound))then
     do k=2,nz-1
        do j=2,ny-1
           do i=2,nx-1
              ib(i,j,k)=inner_bound(i,j,k)
              if(ib(i,j,k)==0)then
                 inner_flag(i,j,k)=.false.
              end if
           end do
        end do
     end do
  else   ! ΰ褬ꤵƤʤƷ׻.
     do k=2,nz-1
        do j=2,ny-1
           do i=2,nx-1
              inner_flag(i,j,k)=.false.
           end do
        end do
     end do
  end if

end subroutine set_bound_3d

subroutine setval_bound_3d( ib, bnd, psi, bound_opt )
! ͤ򶭳ȽȤꤹ.
  implicit none
  integer, intent(in) :: ib(:,:,:)  ! Ƚ
  real, intent(inout) :: bnd(size(ib,1),size(ib,2),size(ib,3))  ! Ǥ
  real, intent(inout) :: psi(size(ib,1),size(ib,2),size(ib,3))  ! 
  real, intent(in), optional :: bound_opt(size(ib,1),size(ib,2),size(ib,3))  ! Ǥ
  integer :: i, j, k, nx, ny, nz

  nx=size(ib,1)
  ny=size(ib,2)
  nz=size(ib,3)

!-- ͤ
  if(present(bound_opt))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              bnd(i,j,k)=bound_opt(i,j,k)
           end do
        end do
     end do
  else
     do k=1,nz
        do j=1,ny
           do i=1,nx
              bnd(i,j,k)=0.0
           end do
        end do
     end do
  end if

!--  "ib(i,j)==1 ξΤ"
!-- ΰˤĤƤ⤳Ƥޤ.

  do k=1,nz
     do j=1,ny
        do i=1,nx
           if(ib(i,j,k)==1)then
              psi(i,j,k)=bnd(i,j,k)
           end if
        end do
     end do
  end do

end subroutine setval_bound_3d

subroutine set_coe_3d( coe, ext, def )
! 2  ext ǻꤵ줿ͤ⤷ def ǻꤵ줿ͤ.
! ext, def ɤ optional Ǥ뤬, ɬɤ餫ϻꤵƤʤȤʤ.
  implicit none
  real, intent(inout) :: coe(:,:,:)  ! 
  real, intent(in), optional :: ext(size(coe,1),size(coe,2),size(coe,3))  ! 
  real, intent(in), optional :: def  ! 
  integer :: i, j, k, nx, ny, nz

  nx=size(coe,1)
  ny=size(coe,2)
  nz=size(coe,3)

  if(present(ext))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              coe(i,j,k)=ext(i,j,k)
           end do
        end do
     end do
  else if(present(def))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              coe(i,j,k)=def
           end do
        end do
     end do
  else
     write(*,*) "### ERROR ###"
     write(*,*) "subroutine set_coe must be set optional argument 'ext' or 'def'"
     write(*,*) "STOP."
     stop
  end if

end subroutine set_coe_3d

subroutine check_coe_3d( coe, aval )
! 3  aval ǻꤵ줿ͤäƤʤ򸡽Ф.
  implicit none
  real, intent(inout) :: coe(:,:,:)  ! 
  real, intent(in) :: aval           ! Ф
  integer :: i, j, k, nx, ny, nz

  nx=size(coe,1)
  ny=size(coe,2)
  nz=size(coe,3)

  do k=1,nz
     do j=1,ny
        do i=1,nx
           if(coe(i,j,k)==aval)then
              write(*,*) "### ERROR (Ellip_Slv module) ###"
              write(*,*) "Detect a certain value", aval
              write(*,*) "STOP."
              stop
           end if
        end do
     end do
  end do

end subroutine check_coe_3d

subroutine calculate_bound_3d( ib, dx, dy, dz, bnd, psi )
! ib Ƚ̤򸵤, Υޥ, ˤĤƶͤ׻.
  integer, intent(in) :: ib(:,:,:)  ! Ƚ
  real, intent(in) :: dx(size(ib,1))  ! x γʻҲ
  real, intent(in) :: dy(size(ib,2))  ! y γʻҲ
  real, intent(in) :: dz(size(ib,3))  ! z γʻҲ
  real, intent(in) :: bnd(size(ib,1),size(ib,2),size(ib,3))
                                      ! (Υޥ󷿤Τ߻)
  real, intent(inout) :: psi(size(ib,1),size(ib,2),size(ib,3))  ! ؿ
  integer :: i, j, k, nx, ny, nz, ix, jy, kz

  nx=size(ib,1)
  ny=size(ib,2)
  nz=size(ib,3)

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j,k,ix,jy,kz)
  do k=1,nz
     do j=1,ny
        do i=1,nx
           if(ib(i,j,k)/=0)then
              select case (ib(i,j,k))
              case (1)
                 psi(i,j,k)=bnd(i,j,k)

              case (2)  ! x ˥եå, ¦
                 psi(i,j,k)=psi(i+1,j,k)-bnd(i,j,k)*dx(i)

              case (-2)  ! x ˥եå, ¦
                 psi(i,j,k)=psi(i-1,j,k)+bnd(i,j,k)*dx(i)

              case (4)  ! y ˥եå, ¦
                 psi(i,j,k)=psi(i,j+1,k)-bnd(i,j,k)*dy(j)

              case (-4)  ! y ˥եå, ¦
                 psi(i,j,k)=psi(i,j-1,k)+bnd(i,j,k)*dy(j)

              case (6)  ! y ˥եå, ¦
                 psi(i,j,k)=psi(i,j,k+1)-bnd(i,j,k)*dz(k)

              case (-6)  ! y ˥եå, ¦
                 psi(i,j,k)=psi(i,j,k-1)+bnd(i,j,k)*dz(k)

              case (3)  ! 12 , ⤷ 8 ǼȽ
                 if(i==1)then
                    ix=nx-1
                 else if(i==nx)then
                    ix=2
                 else
                    ix=i
                 end if
                 if(j==1)then
                    jy=ny-1
                 else if(j==ny)then
                    jy=2
                 else
                    jy=j
                 end if
                 if(k==1)then
                    kz=nz-1
                 else if(k==nz)then
                    kz=2
                 else
                    kz=k
                 end if
                 psi(i,j,k)=psi(ix,jy,kz)

              case (8)  ! ξեå z ̤ x, y 夫.
                 if(i==1.and.j==1)then  ! -- ɾ 1
                    psi(i,j,k)=psi(i+1,j+1,k)-0.5*(bnd(i+1,j,k)*dy(j)+bnd(i,j+1,k)*dx(i))

                 else if(i==nx.and.j==ny)then  ! -- ɾ 2
                    psi(i,j,k)=psi(i-1,j-1,k)+0.5*(bnd(i-1,j,k)*dy(j)+bnd(i,j-1,k)*dx(i))

                 else if(ib(i-1,j,k)==10.and.ib(i,j-1,k)==10)then
                    ! -- ɾ 1 Ʊ
                    psi(i,j,k)=psi(i+1,j+1,k)-0.5*(bnd(i+1,j,k)*dy(j)+bnd(i,j+1,k)*dx(i))

                 else if(ib(i+1,j,k)==10.and.ib(i,j+1,k)==10)then
                    ! -- ɾ 2 Ʊ
                    psi(i,j,k)=psi(i-1,j-1,k)+0.5*(bnd(i-1,j,k)*dy(j)+bnd(i,j-1,k)*dx(i))

                 end if

              case (-8)  ! ξեå z ̤ x, y .
                 if(i==1.and.j==ny)then  ! -- ɾ 1
                    psi(i,j,k)=psi(i+1,j-1,k)+0.5*(bnd(i+1,j,k)*dy(j)-bnd(i,j-1,k)*dx(i))

                 else if(i==nx.and.j==1)then  ! -- ɾ 2
                    psi(i,j,k)=psi(i-1,j+1,k)+0.5*(-bnd(i-1,j,k)*dy(j)+bnd(i,j+1,k)*dx(i))

                 else if(ib(i-1,j,k)==10.and.ib(i,j+1,k)==10)then
                    ! -- ɾ 1 Ʊ
                    psi(i,j,k)=psi(i+1,j-1,k)+0.5*(bnd(i+1,j,k)*dy(j)-bnd(i,j-1,k)*dx(i))

                 else if(ib(i+1,j,k)==10.and.ib(i,j-1,k)==10)then
                    ! -- ɾ 2 Ʊ
                    psi(i,j,k)=psi(i-1,j+1,k)+0.5*(-bnd(i-1,j,k)*dy(j)+bnd(i,j+1,k)*dx(i))
                 end if

              case (12)  ! ξեå y ̤ x, z 夫.
                 if(i==1.and.k==1)then  ! -- ɾ 1
                    psi(i,j,k)=psi(i+1,j,k+1)-0.5*(bnd(i+1,j,k)*dz(k)+bnd(i,j,k+1)*dx(i))

                 else if(i==nx.and.k==nz)then  ! -- ɾ 2
                    psi(i,j,k)=psi(i-1,j,k-1)+0.5*(bnd(i-1,j,k)*dz(k)+bnd(i,j,k-1)*dx(i))

                 else if(ib(i-1,j,k)==10.and.ib(i,j,k-1)==10)then
                    ! -- ɾ 1 Ʊ
                    psi(i,j,k)=psi(i+1,j,k+1)-0.5*(bnd(i+1,j,k)*dz(k)+bnd(i,j,k+1)*dx(i))

                 else if(ib(i+1,j,k)==10.and.ib(i,j,k+1)==10)then
                    ! -- ɾ 2 Ʊ
                    psi(i,j,k)=psi(i-1,j,k-1)+0.5*(bnd(i-1,j,k)*dz(k)+bnd(i,j,k-1)*dx(i))

                 end if

              case (-12)  ! ξեå y ̤ x, z .
                 if(i==1.and.k==nz)then  ! -- ɾ 1
                    psi(i,j,k)=psi(i+1,j,k-1)+0.5*(bnd(i+1,j,k)*dz(k)-bnd(i,j,k-1)*dx(i))

                 else if(i==nx.and.k==1)then  ! -- ɾ 2
                    psi(i,j,k)=psi(i-1,j,k+1)+0.5*(-bnd(i-1,j,k)*dz(k)+bnd(i,j,k+1)*dx(i))

                 else if(ib(i-1,j,k)==10.and.ib(i,j,k+1)==10)then
                    ! -- ɾ 1 Ʊ
                    psi(i,j,k)=psi(i+1,j,k-1)+0.5*(bnd(i+1,j,k)*dz(k)-bnd(i,j,k-1)*dx(i))

                 else if(ib(i+1,j,k)==10.and.ib(i,j,k-1)==10)then
                    ! -- ɾ 2 Ʊ
                    psi(i,j,k)=psi(i-1,j,k+1)+0.5*(-bnd(i-1,j,k)*dz(k)+bnd(i,j,k+1)*dx(i))

                 end if

              case (24)  ! ξեå x ̤ y, z 夫.
                 if(j==1.and.k==1)then  ! -- ɾ 1
                    psi(i,j,k)=psi(i,j+1,k+1)-0.5*(bnd(i,j+1,k)*dz(k)+bnd(i,j,k+1)*dy(j))

                 else if(j==ny.and.k==nz)then  ! -- ɾ 2
                    psi(i,j,k)=psi(i,j-1,k-1)+0.5*(bnd(i,j-1,k)*dz(k)+bnd(i,j,k-1)*dy(j))

                 else if(ib(i,j-1,k)==10.and.ib(i,j,k-1)==10)then
                    ! -- ɾ 1 Ʊ
                    psi(i,j,k)=psi(i,j+1,k+1)-0.5*(bnd(i,j+1,k)*dz(k)+bnd(i,j,k+1)*dy(j))

                 else if(ib(i,j+1,k)==10.and.ib(i,j,k+1)==10)then
                    ! -- ɾ 2 Ʊ
                    psi(i,j,k)=psi(i,j-1,k-1)+0.5*(bnd(i,j-1,k)*dz(k)+bnd(i,j,k-1)*dy(j))

                 end if

              case (-24)  ! ξեå x ̤ y, z .
                 if(j==1.and.k==nz)then  ! -- ɾ 1
                    psi(i,j,k)=psi(i,j+1,k-1)+0.5*(bnd(i,j+1,k)*dz(k)-bnd(i,j,k-1)*dy(j))

                 else if(j==ny.and.k==1)then  ! -- ɾ 2
                    psi(i,j,k)=psi(i,j-1,k+1)+0.5*(-bnd(i,j-1,k)*dz(k)+bnd(i,j,k+1)*dy(j))

                 else if(ib(i,j-1,k)==10.and.ib(i,j,k+1)==10)then
                    ! -- ɾ 1 Ʊ
                    psi(i,j,k)=psi(i,j+1,k-1)+0.5*(bnd(i,j+1,k)*dz(k)-bnd(i,j,k-1)*dy(j))

                 else if(ib(i,j+1,k)==10.and.ib(i,j,k-1)==10)then
                    ! -- ɾ 2 Ʊ
                    psi(i,j,k)=psi(i,j-1,k+1)+0.5*(-bnd(i,j-1,k)*dz(k)+bnd(i,j,k+1)*dy(j))

                 end if

              !-- ʹ, ΰʤΤ, ̤.
              case (11)  ! ξեå (1,1,1) , ⤷ΰ.
                 psi(i,j,k)=psi(i+1,j+1,k+1)  &
  &                        -(bnd(i,j+1,k+1)*dx(i)  &
  &                         +bnd(i+1,j,k+1)*dy(j)  &
  &                         +bnd(i+1,j+1,k)*dz(k))/3.0

              case (13)  ! ξեå (nx,1,1) , ⤷ΰ.
                 psi(i,j,k)=psi(i-1,j+1,k+1)  &
  &                        -(-bnd(i,j+1,k+1)*dx(i)  &
  &                          +bnd(i-1,j,k+1)*dy(j)  &
  &                          +bnd(i-1,j+1,k)*dz(k))/3.0

              case (17)  ! ξեå (1,ny,1) , ⤷ΰ.
                 psi(i,j,k)=psi(i+1,j-1,k+1)  &
  &                        -(bnd(i,j-1,k+1)*dx(i)  &
  &                         -bnd(i+1,j,k+1)*dy(j)  &
  &                         +bnd(i+1,j-1,k)*dz(k))/3.0

              case (19)  ! ξեå (nx,ny,1) , ⤷ΰ.
                 psi(i,j,k)=psi(i-1,j-1,k+1)  &
  &                        -(-bnd(i,j-1,k+1)*dx(i)  &
  &                          -bnd(i-1,j,k+1)*dy(j)  &
  &                          +bnd(i-1,j-1,k)*dz(k))/3.0

              case (23)  ! ξեå (1,1,nz) , ⤷ΰ.
                 psi(i,j,k)=psi(i+1,j+1,k-1)  &
  &                        -(bnd(i,j+1,k-1)*dx(i)  &
  &                         +bnd(i+1,j,k-1)*dy(j)  &
  &                         -bnd(i+1,j+1,k)*dz(k))/3.0

              case (29)  ! ξեå (nx,1,nz) , ⤷ΰ.
                 psi(i,j,k)=psi(i-1,j+1,k-1)  &
  &                        -(-bnd(i,j+1,k-1)*dx(i)  &
  &                          +bnd(i-1,j,k-1)*dy(j)  &
  &                          -bnd(i-1,j+1,k)*dz(k))/3.0

              case (31)  ! ξեå (1,ny,nz) , ⤷ΰ.
                 psi(i,j,k)=psi(i+1,j-1,k-1)  &
  &                        -(bnd(i,j-1,k-1)*dx(i)  &
  &                         -bnd(i+1,j,k-1)*dy(j)  &
  &                         -bnd(i+1,j-1,k)*dz(k))/3.0

              case (37)  ! ξեå (nx,ny,nz) , ⤷ΰ.
                 psi(i,j,k)=psi(i-1,j-1,k-1)  &
  &                        -(-bnd(i,j-1,k-1)*dx(i)  &
  &                          -bnd(i-1,j,k-1)*dy(j)  &
  &                          -bnd(i-1,j-1,k)*dz(k))/3.0

              case (-11)  ! ξեå (i+1,j+1,k+1)  10 .
                 psi(i,j,k)=(psi(i-1,j+1,k+1)+psi(i+1,j-1,k+1)+psi(i+1,j+1,k-1)  &
  &                         +bnd(i,j+1,k+1)*dx(i)+bnd(i+1,j,k+1)*dy(j)  &
  &                         +bnd(i+1,j+1,k)*dz(k))/3.0

              case (-13)  ! ξեå (i-1,j+1,k+1)  10 .
                 psi(i,j,k)=(psi(i+1,j+1,k+1)+psi(i-1,j-1,k+1)+psi(i-1,j+1,k-1)  &
  &                         -bnd(i,j+1,k+1)*dx(i)+bnd(i-1,j,k+1)*dy(j)  &
  &                         +bnd(i-1,j+1,k)*dz(k))/3.0

              case (-17)  ! ξեå (i+1,j-1,k+1)  10 .
                 psi(i,j,k)=(psi(i-1,j-1,k+1)+psi(i+1,j+1,k+1)+psi(i+1,j-1,k-1)  &
  &                         +bnd(i,j-1,k+1)*dx(i)-bnd(i+1,j,k+1)*dy(j)  &
  &                         +bnd(i+1,j-1,k)*dz(k))/3.0

              case (-19)  ! ξեå (i-1,j-1,k+1)  10 .
                 psi(i,j,k)=(psi(i+1,j-1,k+1)+psi(i-1,j+1,k+1)+psi(i-1,j-1,k-1)  &
  &                         -bnd(i,j-1,k+1)*dx(i)-bnd(i-1,j,k+1)*dy(j)  &
  &                         +bnd(i-1,j-1,k)*dz(k))/3.0

              case (-23)  ! ξեå (i+1,j+1,k-1)  10 .
                 psi(i,j,k)=(psi(i-1,j+1,k-1)+psi(i+1,j-1,k-1)+psi(i+1,j+1,k+1)  &
  &                         +bnd(i,j+1,k-1)*dx(i)+bnd(i+1,j,k-1)*dy(j)  &
  &                         -bnd(i+1,j+1,k)*dz(k))/3.0

              case (-29)  ! ξեå (i-1,j+1,k-1)  10 .
                 psi(i,j,k)=(psi(i+1,j+1,k-1)+psi(i-1,j-1,k-1)+psi(i-1,j+1,k+1)  &
  &                         -bnd(i,j+1,k-1)*dx(i)+bnd(i-1,j,k-1)*dy(j)  &
  &                         -bnd(i-1,j+1,k)*dz(k))/3.0

              case (-31)  ! ξեå (i+1,j-1,k-1)  10 .
                 psi(i,j,k)=(psi(i-1,j-1,k-1)+psi(i+1,j+1,k-1)+psi(i+1,j-1,k+1)  &
  &                         +bnd(i,j-1,k-1)*dx(i)-bnd(i+1,j,k-1)*dy(j)  &
  &                         -bnd(i+1,j-1,k)*dz(k))/3.0

              case (-37)  ! ξեå (i-1,j-1,k-1)  10 .
                 psi(i,j,k)=(psi(i+1,j-1,k-1)+psi(i-1,j+1,k-1)+psi(i-1,j-1,k+1)  &
  &                         -bnd(i,j-1,k-1)*dx(i)-bnd(i-1,j,k-1)*dy(j)  &
  &                         -bnd(i-1,j-1,k)*dz(k))/3.0

              end select

           end if
        end do
     end do
  end do
!$omp end do
!$omp end parallel

end subroutine calculate_bound_3d

end module Ellip_Slv
