module m_phase1

  implicit none

contains

  subroutine phase1( nx, ny, ival1, oval1, wnx, wny, spgix, spgiy )

  use Math_Const
  use ffts

  implicit none

  integer, intent(in) :: nx, ny
  real, dimension(nx,ny), intent(in) :: ival1
  real, dimension(nx,ny), intent(out) :: oval1
  integer, intent(in) :: wnx, wny
  integer, intent(in) :: spgix, spgiy

  integer, parameter :: ifft=5
  integer :: i, j
  real :: t1, t2, t3
  integer, dimension(ifft) :: pxfact, pyfact, pxsfact, pysfact
  complex, dimension(nx,ny) :: sp, spi
  complex, dimension(nx/spgix,ny/spgiy) :: cpval1, cpval2, sps1, sps2, spis1, spis2
  complex, allocatable, dimension(:,:) :: omegaxbr, omegaybr, omegaxbi, omegaybi
  complex, allocatable, dimension(:,:) :: omegaxnr, omegaynr, omegaxni, omegayni
  complex, allocatable, dimension(:,:) :: omegaxbrs, omegaybrs, omegaxbis, omegaybis
  complex, allocatable, dimension(:,:) :: omegaxnrs, omegaynrs, omegaxnis, omegaynis

  call rotate_array_f()
  call prim_calc( nx, pxfact(1:4), pxfact(5) )
  call prim_calc( ny, pyfact(1:4), pyfact(5) )
  call prim_calc( nx/spgix, pxsfact(1:4), pxsfact(5) )
  call prim_calc( ny/spgiy, pysfact(1:4), pysfact(5) )

  allocate(omegaxnr(0:nx-1,0:nx-1))
  allocate(omegaynr(0:ny-1,0:ny-1))
  allocate(omegaxni(0:nx-1,0:nx-1))
  allocate(omegayni(0:ny-1,0:ny-1))
  allocate(omegaxbr(0:pxfact(5)-1,0:pxfact(5)-1))
  allocate(omegaybr(0:pyfact(5)-1,0:pyfact(5)-1))
  allocate(omegaxbi(0:pxfact(5)-1,0:pxfact(5)-1))
  allocate(omegaybi(0:pyfact(5)-1,0:pyfact(5)-1))
  allocate(omegaxnrs(0:nx/spgix-1,0:nx/spgix-1))
  allocate(omegaynrs(0:ny/spgiy-1,0:ny/spgiy-1))
  allocate(omegaxnis(0:nx/spgix-1,0:nx/spgix-1))
  allocate(omegaynis(0:ny/spgiy-1,0:ny/spgiy-1))
  allocate(omegaxbrs(0:pxsfact(5)-1,0:pxsfact(5)-1))
  allocate(omegaybrs(0:pysfact(5)-1,0:pysfact(5)-1))
  allocate(omegaxbis(0:pxsfact(5)-1,0:pxsfact(5)-1))
  allocate(omegaybis(0:pysfact(5)-1,0:pysfact(5)-1))

  call rotate_calc( nx, 'r', pxfact,  &
  &               omegaxbr(0:pxfact(5)-1,0:pxfact(5)-1),  &
  &               omegaxnr(0:nx-1,0:nx-1) )
  call rotate_calc( nx, 'i', pxfact,  &
  &               omegaxbi(0:pxfact(5)-1,0:pxfact(5)-1),  &
  &               omegaxni(0:nx-1,0:nx-1) )
  call rotate_calc( ny, 'r', pyfact,  &
  &               omegaybr(0:pyfact(5)-1,0:pyfact(5)-1),  &
  &               omegaynr(0:ny-1,0:ny-1) )
  call rotate_calc( ny, 'i', pyfact,  &
  &               omegaybi(0:pyfact(5)-1,0:pyfact(5)-1),  &
  &               omegayni(0:ny-1,0:ny-1) )

  call rotate_calc( nx/spgix, 'r', pxsfact,  &
  &               omegaxbrs(0:pxsfact(5)-1,0:pxsfact(5)-1),  &
  &               omegaxnrs(0:nx/spgix-1,0:nx/spgix-1) )
  call rotate_calc( nx/spgix, 'i', pxsfact,  &
  &               omegaxbis(0:pxsfact(5)-1,0:pxsfact(5)-1),  &
  &               omegaxnis(0:nx/spgix-1,0:nx/spgix-1) )
  call rotate_calc( ny/spgiy, 'r', pysfact,  &
  &               omegaybrs(0:pysfact(5)-1,0:pysfact(5)-1),  &
  &               omegaynrs(0:ny/spgiy-1,0:ny/spgiy-1) )
  call rotate_calc( ny/spgiy, 'i', pysfact,  &
  &               omegaybis(0:pysfact(5)-1,0:pysfact(5)-1),  &
  &               omegaynis(0:ny/spgiy-1,0:ny/spgiy-1) )

  do j=1,ny/spgiy
     do i=1,nx/spgix
        cpval1(i,j)=ival1((i-1)*spgix+1,(j-1)*spgiy+1)
     end do
  end do

  call cpu_time(t1)

  call ffttp_2d( nx/spgix, ny/spgiy,  &
  &              cpval1(1:nx/spgix,1:ny/spgiy),  &
  &              cpval2(1:nx/spgix,1:ny/spgiy),  &
  &              'r', 'o', prim_factx=pxsfact, prim_facty=pysfact,  &
  &              omegax_fix=omegaxbrs, omegaxn_fix=omegaxnrs,  &
  &              omegay_fix=omegaybrs, omegayn_fix=omegaynrs )

  call cpu_time(t2)

  write(*,*) "cpu_time is ", t2-t1, "[sec]."

  sp=0.0

  sp(1,1)=cpval2(1,1)

  do j=2,wny+1
     sp(1,j)=cpval2(1,j)
  end do

  do i=2,wnx+1
     sp(i,1)=cpval2(i,1)
  end do

  do j=2,wny+1
     do i=2,wnx+1
        sp(i,j)=cpval2(i,j)
     end do
  end do

  call ffttp_2d( nx, ny, sp(1:nx,1:ny), spi(1:nx,1:ny),  &
  &              'i', 'o', prim_factx=pxfact, prim_facty=pyfact,  &
  &              omegax_fix=omegaxbi, omegaxn_fix=omegaxni,  &
  &              omegay_fix=omegaybi, omegayn_fix=omegayni )

  do j=1,ny
     do i=1,nx
        oval1(i,j)=real(spi(i,j))
     end do
  end do

  end subroutine phase1

end module m_phase1

program advanced2

!-- FFT ѴΥǡǤտǴְ.
!-- 󥰥ץǤΤư.
!-- Ǥդοʿ 2 ǡǤդȿޤФ
!-- η̤̥ե˽Ϥ

  use m_phase1
  use dcl
  use dcl_automatic

  implicit none

  integer, parameter :: nx=1400, ny=800
  integer, parameter :: spgix=10, spgiy=10

  integer :: i, j, icounter, ip, jp
  integer :: wnx, wny
  real :: x(nx), y(ny)
  real, allocatable, dimension(:,:) :: valp1
  real, allocatable, dimension(:) :: totsp1, totsp2
  real, dimension(nx,ny) :: ival1, oval0, oval1, oval2

     wnx=7
     wny=4

     open(unit=10,file=trim(adjustl(fname)),recl=4*nx*ny,access='direct',status='old')

     read(10,rec=1) ((ival1(i,j),i=1,nx),j=1,ny)

     close(10)

     x=(/((real(i)/real(nx)),i=1,nx)/)
     y=(/((real(j)/real(ny)),j=1,ny)/)

     call phase1( nx, ny, ival1, oval1, wnx, wny, spgix, spgiy )

     open(unit=11,file='result_'//trim(adjustl(fname)),recl=4*nx*ny,access='direct',status='old')

     read(10,rec=1) ((oval1(i,j),i=1,nx),j=1,ny)

     close(10)

end program advanced2
