!---------------------------------------------------------------
! Copyright (C) 2009-2015 GFD Dennou Club. All rights reserved.
!---------------------------------------------------------------

module Geometry  ! ؤ˴ؤ롼

  public :: rt_2_xy,  &
  &         xy_2_rt

  interface rt_2_xy
  module procedure rt_2_xy_r,  &
  &                rt_2_xy_d
  end interface rt_2_xy

  interface xy_2_rt
  module procedure xy_2_rt_r,  &
  &                xy_2_rt_d
  end interface xy_2_rt

contains

subroutine rt_2_xy_r( r, t, x, y )
! ʿ̶˺ɸʿ̥ǥȺɸؤѴ
!
! ξϺɸθ r ǼưŪ˻ꤵƤΤ,
! ꤹɬפʤ.
! դ֤ x, y ͤ, r=0 Ȥ
! ǥȺɸϤȤ֤뤳Ȥդ.
  implicit none
  real, intent(in) :: r  ! 濴εΥ
  real, intent(in) :: t  ! x γ [rad]
  real, intent(inout) :: x  ! x ɸ
  real, intent(inout) :: y  ! y ɸ

  x=r*cos(t)
  y=r*sin(t)

end subroutine


subroutine rt_2_xy_d( r, t, x, y )
! ʿ̶˺ɸʿ̥ǥȺɸؤѴ
!
! ξϺɸθ r ǼưŪ˻ꤵƤΤ,
! ꤹɬפʤ.
! դ֤ x, y ͤ, r=0 Ȥ
! ǥȺɸϤȤ֤뤳Ȥդ.
  implicit none
  double precision, intent(in) :: r  ! 濴εΥ
  double precision, intent(in) :: t  ! x γ [rad]
  double precision, intent(inout) :: x  ! x ɸ
  double precision, intent(inout) :: y  ! y ɸ

  x=r*dcos(t)
  y=r*dsin(t)

end subroutine


subroutine xy_2_rt_r( x, y, xc, yc, r, t )
! ʿ̥ǥȺɸʿ̶˺ɸؤѴ
!
! ξϺɸθ r ǼưŪ˻ꤵƤΤ,
! ꤹɬפʤ.
! դ֤ x, y ͤ, r=0 Ȥ
! ǥȺɸϤȤ֤뤳Ȥդ.
  use Math_Const
  implicit none
  real, intent(in) :: x  ! x ɸ
  real, intent(in) :: y  ! y ɸ
  real, intent(in) :: xc ! x ɸ濴
  real, intent(in) :: yc ! y ɸ濴
  real, intent(inout) :: r  ! 濴εΥ
  real, intent(inout) :: t  ! x γ [rad]
  real :: rx, ry

  rx=x-xc
  ry=y-yc

  r=sqrt(rx**2+ry**2)

  if(rx==0.0.and.ry==0.0)then
     t=0.0
  else if(rx==0.0.and.ry/=0.0)then
     if(ry>0.0)then
        t=0.5*pi
     else
        t=1.5*pi
     end if
  else if(rx/=0.0.and.ry==0.0)then
     if(rx>0.0)then
        t=0.0
     else
        t=pi
     end if
  else
     if(rx>0.0.and.ry>0.0)then
        t=atan(ry/rx)
     else if(rx<0.0.and.ry>0.0)then
        t=pi-atan(ry/abs(rx))
     else if(rx>0.0.and.ry<0.0)then
        t=2.0*pi-atan(abs(ry)/rx)
     else if(rx<0.0.and.ry<0.0)then
        t=pi+atan(ry/rx)
     end if
  end if

end subroutine


subroutine xy_2_rt_d( x, y, xc, yc, r, t )
! ʿ̥ǥȺɸʿ̶˺ɸؤѴ
!
! ξϺɸθ r ǼưŪ˻ꤵƤΤ,
! ꤹɬפʤ.
! դ֤ x, y ͤ, r=0 Ȥ
! ǥȺɸϤȤ֤뤳Ȥդ.
  use Math_Const
  implicit none
  double precision, intent(in) :: x  ! x ɸ
  double precision, intent(in) :: y  ! y ɸ
  double precision, intent(in) :: xc ! x ɸ濴
  double precision, intent(in) :: yc ! y ɸ濴
  double precision, intent(inout) :: r  ! 濴εΥ
  double precision, intent(inout) :: t  ! x γ [rad]
  double precision :: rx, ry

  rx=x-xc
  ry=y-yc

  r=dsqrt(rx**2+ry**2)

  if(rx==0.0d0.and.ry==0.0d0)then
     t=0.0d0
  else if(rx==0.0d0.and.ry/=0.0d0)then
     if(ry>0.0d0)then
        t=0.5d0*pi_dp
     else
        t=1.5d0*pi_dp
     end if
  else if(rx/=0.0d0.and.ry==0.0d0)then
     if(rx>0.0d0)then
        t=0.0d0
     else
        t=pi_dp
     end if
  else
     if(rx>0.0d0.and.ry>0.0d0)then
        t=datan(ry/rx)
     else if(rx<0.0d0.and.ry>0.0d0)then
        t=pi_dp-datan(ry/dabs(rx))
     else if(rx>0.0d0.and.ry<0.0d0)then
        t=2.0d0*pi_dp-datan(dabs(ry)/rx)
     else if(rx<0.0d0.and.ry<0.0d0)then
        t=pi_dp+datan(ry/rx)
     end if
  end if

end subroutine


subroutine product_circle( xp, yp, rad, num, xd, yd )
! ǥ xp, yp Ⱦ rad αߤ, ͤ
! ˺ɸƱ̳ num ĤǤ˳Ǽ.
! xd, yd αߤΥǥȺɸǤ.
  use math_const
  implicit none
  real, intent(in) :: xp  ! ߤ濴 x ɸ
  real, intent(in) :: yp  ! ߤ濴 y ɸ
  real, intent(in) :: rad  ! ߤȾ
  integer, intent(in) :: num  ! ǿ
  real, intent(inout) :: xd(num)  ! ߤ x ɸǡ
  real, intent(inout) :: yd(num)  ! ߤ y ɸǡ
  integer :: i

  do i=1,num
     xd(i)=xp+rad*cos(real(i-1)*2.0*pi/real(num-1))
     yd(i)=yp+rad*sin(real(i-1)*2.0*pi/real(num-1))
  end do

end subroutine

!subroutine xy_2_rt( x, y, r, t )
! ʿ̥ǥȺɸʿ̶˺ɸؤѴ
!
! x=0, y=0  r=0 θȤʤä֤뤳Ȥ.
! ʿ̶˺ɸǤθȤʤ.
!  implicit none
!  real, intent(in) :: x  ! x ɸ
!  real, intent(in) :: y  ! y ɸ
!  real, intent(inout) :: r  ! 濴εΥ
!  real, intent(inout) :: t  ! x γ [rad]

!  r=sqrt(x**2+y**2)  ! Ϥɤξݸ¤ǤƱ׻ɾǤ.

!  if(x=0.0.and.y=0.0)then
!     t=0.0
!  else
!     if(x*y>0.0)then  ! x*y>0 ʤ,  1, 3 ݸΰɽ.
!        t=
!     else
!     end if
!  end if

!end subroutine

!-------------------------------------------


end module
