!---------------------------------------------------------------
! Copyright (C) 2009-2015 GFD Dennou Club. All rights reserved.
!---------------------------------------------------------------

module Statistics  ! ײϴطΥ롼

  use Basis
  use Matrix_Calc
  use Max_Min

  private :: summ, summf, summd
  private :: replace_undef_f, replace_undef_d

interface Mean_1d

  module procedure Mean_1df, Mean_1dd

end interface Mean_1d

interface Mean_2d

  module procedure Mean_2df, Mean_2dd

end interface Mean_2d

interface Mean_3d

  module procedure Mean_3df, Mean_3dd

end interface Mean_3d

interface Median_1d

  module procedure Median_1df, Median_1dd

end interface Median_1d

interface Median_2d

  module procedure Median_2df, Median_2dd

end interface Median_2d

interface Median_3d

  module procedure Median_3df, Median_3dd

end interface Median_3d

interface Quartile_1d

  module procedure Quartile_1df, Quartile_1dd

end interface Quartile_1d

interface Quartile_2d

  module procedure Quartile_2df, Quartile_2dd

end interface Quartile_2d

interface Quartile_3d

  module procedure Quartile_3df, Quartile_3dd

end interface Quartile_3d

interface Anomaly_1d

  module procedure Anomaly_1df, Anomaly_1dd

end interface Anomaly_1d

interface Anomaly_2d

  module procedure Anomaly_2df, Anomaly_2dd

end interface Anomaly_2d

interface Anomaly_3d

  module procedure Anomaly_3df, Anomaly_3dd

end interface Anomaly_3d

interface stand_devi_1d

  module procedure stand_devi_1df, stand_devi_1dd

end interface stand_devi_1d

interface stand_devi_2d

  module procedure stand_devi_2df, stand_devi_2dd

end interface stand_devi_2d

interface stand_devi_3d

  module procedure stand_devi_3df, stand_devi_3dd

end interface stand_devi_3d

interface covariance_1d

  module procedure covariance_1df, covariance_1dd

end interface covariance_1d

interface covariance_2d

  module procedure covariance_2df, covariance_2dd

end interface covariance_2d

interface covariance_3d

  module procedure covariance_3df, covariance_3dd

end interface covariance_3d

interface nearest_neighbor_search_1d

  module procedure nearest_neighbor_search_1df, nearest_neighbor_search_1dd

end interface nearest_neighbor_search_1d

interface nearest_neighbor_search_2d

  module procedure nearest_neighbor_search_2df, nearest_neighbor_search_2dd

end interface nearest_neighbor_search_2d

interface nearest_neighbor_search_3d

  module procedure nearest_neighbor_search_3df, nearest_neighbor_search_3dd

end interface nearest_neighbor_search_3d

interface nearest_search_1d

  module procedure nearest_search_1df, nearest_search_1dd

end interface nearest_search_1d

interface nearest_search_2d

  module procedure nearest_search_2df, nearest_search_2dd

end interface nearest_search_2d

interface nearest_search_3d

  module procedure nearest_search_3df, nearest_search_3dd

end interface nearest_search_3d

interface interpo_search_1d

  module procedure interpo_search_1df, interpo_search_1dd

end interface interpo_search_1d

interface interpo_search_2d

  module procedure interpo_search_2df, interpo_search_2dd

end interface interpo_search_2d

interface interpo_search_3d

  module procedure interpo_search_3df, interpo_search_3dd

end interface interpo_search_3d

interface auto_interpo_search_1d

  module procedure auto_interpo_search_1df, auto_interpo_search_1dd

end interface auto_interpo_search_1d

interface auto_interpo_search_2d

  module procedure auto_interpo_search_2df, auto_interpo_search_2dd

end interface auto_interpo_search_2d

interface auto_interpo_search_3d

  module procedure auto_interpo_search_3df, auto_interpo_search_3dd

end interface auto_interpo_search_3d

interface interpolation_1d

  module procedure interpolation_1df, interpolation_1dd

end interface interpolation_1d

interface interpolation_2d

  module procedure interpolation_2df, interpolation_2dd

end interface interpolation_2d

interface interpolation_3d

  module procedure interpolation_3df, interpolation_3dd

end interface interpolation_3d

interface interpo_undef_1d

  module procedure interpo_undef_1df, interpo_undef_1dd

end interface interpo_undef_1d

interface auto_interpolation_1d

  module procedure auto_interpolation_1df, auto_interpolation_1dd

end interface auto_interpolation_1d

interface auto_interpolation_2d

  module procedure auto_interpolation_2df, auto_interpolation_2dd

end interface auto_interpolation_2d

interface auto_interpolation_3d

  module procedure auto_interpolation_3df, auto_interpolation_3dd

end interface auto_interpolation_3d

interface LSM_1d

  module procedure LSM_1df, LSM_1dd

end interface LSM_1d

interface LSM_2d

  module procedure LSM_2df, LSM_2dd

end interface LSM_2d

interface LSM_3d

  module procedure LSM_3df, LSM_3dd

end interface LSM_3d

interface LSM_poly_1d

  module procedure LSM_poly_1df, LSM_poly_1dd

end interface LSM_poly_1d

interface LSM_poly_2d

  module procedure LSM_poly_2df, LSM_poly_2dd

end interface LSM_poly_2d

interface LSM_poly_3d

  module procedure LSM_poly_3df, LSM_poly_3dd

end interface LSM_poly_3d

interface LSM_multi

  module procedure LSM_multi_f, LSM_multi_d

end interface LSM_multi

interface Cor_Coe_1d

  module procedure Cor_Coe_1df, Cor_Coe_1dd

end interface Cor_Coe_1d

interface Cor_Coe_2d

  module procedure Cor_Coe_2df, Cor_Coe_2dd

end interface Cor_Coe_2d

interface Cor_Coe_3d

  module procedure Cor_Coe_3df, Cor_Coe_3dd

end interface Cor_Coe_3d

interface Reg_Line_1d

  module procedure Reg_Line_1df, Reg_Line_1dd

end interface Reg_Line_1d

interface Reg_Line_2d

  module procedure Reg_Line_2df, Reg_Line_2dd

end interface Reg_Line_2d

interface Reg_Line_3d

  module procedure Reg_Line_3df, Reg_Line_3dd

end interface Reg_Line_3d

interface spline_3

  module procedure spline_3_f, spline_3_d

end interface spline_3

interface Bubble_Sort
! Bubble_Sort

  module procedure Bubble_Sort_i, Bubble_Sort_f, Bubble_Sort_d

end interface Bubble_Sort

interface Quick_Sort
! Quick_Sort

  module procedure Quick_Sort_i, Quick_Sort_f, Quick_Sort_d

end interface Quick_Sort

!--- interface

contains

!--- subroutines

subroutine Mean_1df( x, ave, error, nc )  ! 1 ʿͷ׻롼
  implicit none
  real, intent(in) :: x(:)  ! ǡ
  real, intent(inout) :: ave  ! ׻ʿ
  real, intent(in), optional :: error  ! »ͤ¸ߤǡåȤη»
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, nt
  integer :: nx  ! ǡǿ
  real :: summ

  summ=0.0
  nt=0
  nx=size(x)

  if(present(error))then
     do i=1,nx
        if(x(i)/=error)then
           summ=summ+x(i)
           nt=1+nt
        end if
     end do

     if(nt/=0)then
        ave=summ/real(nt)
     else
        ave=error
     end if

     if(present(nc))then
        nc=nt
     end if

  else

     do i=1,nx
        summ=summ+x(i)
     end do

     ave=summ/real(nx)

  end if

end subroutine Mean_1df


subroutine Mean_1dd( x, ave, error, nc )  ! 1 ʿͷ׻롼
  implicit none
  double precision, intent(in) :: x(:)  ! ǡ
  double precision, intent(inout) :: ave  ! ׻ʿ
  double precision, intent(in), optional :: error  ! »ͤ¸ߤǡåȤη»
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, nt
  integer :: nx  ! ǡǿ
  double precision :: summ

  summ=0.0d0
  nt=0
  nx=size(x)

  if(present(error))then
     do i=1,nx
        if(x(i)/=error)then
           summ=summ+x(i)
           nt=1+nt
        end if
     end do

     if(nt/=0)then
        ave=summ/dble(nt)
     else
        ave=error
     end if

     if(present(nc))then
        nc=nt
     end if

  else

     do i=1,nx
        summ=summ+x(i)
     end do

     ave=summ/dble(nx)

  end if

end subroutine Mean_1dd


subroutine Mean_2df( x, ave, error, nc )  ! 2 ʿͷ׻롼
  implicit none
  real, intent(in) :: x(:,:)  ! ǡ
  real, intent(inout) :: ave  ! ׻ʿ
  real, intent(in), optional :: error  ! »ͤ¸ߤǡåȤη»
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, j, nt
  integer :: nx  ! ǡǿ 1
  integer :: ny  ! ǡǿ 2
  real :: summ

  summ=0.0
  nt=0
  nx=size(x,1)
  ny=size(x,2)

  if(present(error))then
     do j=1,ny
        do i=1,nx
           if(x(i,j)/=error)then
              summ=summ+x(i,j)
              nt=1+nt
           end if
        end do
     end do

     if(nt/=0)then
        ave=summ/real(nt)
     else
        ave=error
     end if

     if(present(nc))then
        nc=nt
     end if

  else

     do j=1,ny
        do i=1,nx
           summ=summ+x(i,j)
        end do
     end do

     ave=summ/real(nx*ny)

  end if

end subroutine Mean_2df


subroutine Mean_2dd( x, ave, error, nc )  ! 2 ʿͷ׻롼
  implicit none
  double precision, intent(in) :: x(:,:)  ! ǡ
  double precision, intent(inout) :: ave  ! ׻ʿ
  double precision, intent(in), optional :: error  ! »ͤ¸ߤǡåȤη»
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, j, nt
  integer :: nx  ! ǡǿ 1
  integer :: ny  ! ǡǿ 2
  double precision :: summ

  summ=0.0d0
  nt=0
  nx=size(x,1)
  ny=size(x,2)

  if(present(error))then
     do j=1,ny
        do i=1,nx
           if(x(i,j)/=error)then
              summ=summ+x(i,j)
              nt=1+nt
           end if
        end do
     end do

     if(nt/=0)then
        ave=summ/dble(nt)
     else
        ave=error
     end if

     if(present(nc))then
        nc=nt
     end if

  else

     do j=1,ny
        do i=1,nx
           summ=summ+x(i,j)
        end do
     end do

     ave=summ/dble(nx*ny)

  end if

end subroutine Mean_2dd


subroutine Mean_3df( x, ave, error, nc )  ! 3 ʿͷ׻롼
  implicit none
  real, intent(in) :: x(:,:,:)  ! ǡ
  real, intent(inout) :: ave  ! ׻ʿ
  real, intent(in), optional :: error  ! »ͤ¸ߤǡåȤη»
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, j, k, nt
  integer :: nx  ! ǡǿ 1
  integer :: ny  ! ǡǿ 2
  integer :: nz  ! ǡǿ 2
  real :: summ

  summ=0.0
  nt=0
  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  if(present(error))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(x(i,j,k)/=error)then
                 summ=summ+x(i,j,k)
                 nt=1+nt
              end if
           end do
        end do
     end do

     if(nt/=0)then
        ave=summ/real(nt)
     else
        ave=error
     end if

     if(present(nc))then
        nc=nt
     end if

  else

     do k=1,nz
        do j=1,ny
           do i=1,nx
              summ=summ+x(i,j,k)
           end do
        end do
     end do

     ave=summ/real(nx*ny*nz)

  end if

end subroutine Mean_3df


subroutine Mean_3dd( x, ave, error, nc )  ! 3 ʿͷ׻롼
  implicit none
  double precision, intent(in) :: x(:,:,:)  ! ǡ
  double precision, intent(inout) :: ave  ! ׻ʿ
  double precision, intent(in), optional :: error  ! »ͤ¸ߤǡåȤη»
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, j, k, nt
  integer :: nx  ! ǡǿ 1
  integer :: ny  ! ǡǿ 2
  integer :: nz  ! ǡǿ 2
  double precision :: summ

  summ=0.0d0
  nt=0
  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  if(present(error))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(x(i,j,k)/=error)then
                 summ=summ+x(i,j,k)
                 nt=1+nt
              end if
           end do
        end do
     end do

     if(nt/=0)then
        ave=summ/dble(nt)
     else
        ave=error
     end if

     if(present(nc))then
        nc=nt
     end if

  else

     do k=1,nz
        do j=1,ny
           do i=1,nx
              summ=summ+x(i,j,k)
           end do
        end do
     end do

     ave=summ/dble(nx*ny*nz)

  end if

end subroutine Mean_3dd


subroutine Median_1df( x, med, error, nc )  ! 1 ͷ׻롼
  implicit none
  real, intent(in) :: x(:)  ! ǡ
  real, intent(inout) :: med  ! ׻
  real, intent(in), optional :: error  ! »ͤ¸ߤǡåȤη»
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, nt
  integer :: nx  ! ǡǿ
  real :: rx(size(x)), sx(size(x))

  nt=0
  rx=0.0
  nx=size(x)

  if(present(error))then
     do i=1,nx
        if(x(i)/=error)then
           nt=1+nt
           rx(nt)=x(i)
        end if
     end do

     if(nt/=0)then
        call Quick_Sort_f( rx(1:nt), sx(1:nt), 'i' )
        if(mod(nt,2)==0)then  ! ǡ
           med=0.5*(sx(nt/2)+sx(nt/2+1))
        else  ! ǡ
           med=sx(nt/2+1)
        end if
     else
        med=error
     end if

     if(present(nc))then
        nc=nt
     end if

  else

     call Quick_Sort_f( x(1:nx), sx(1:nx), 'i' )
     if(mod(nx,2)==0)then  ! ǡ
        med=0.5*(sx(nx/2)+sx(nx/2+1))
     else  ! ǡ
        med=sx(nx/2+1)
     end if

     if(present(nc))then
        nc=nx
     end if

  end if

end subroutine Median_1df


subroutine Median_1dd( x, med, error, nc )  ! 1 ͷ׻롼
  implicit none
  double precision, intent(in) :: x(:)  ! ǡ
  double precision, intent(inout) :: med  ! ׻
  double precision, intent(in), optional :: error  ! »ͤ¸ߤǡåȤη»
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, nt
  integer :: nx  ! ǡǿ
  double precision :: rx(size(x)), sx(size(x))

  nt=0
  rx=0.0
  nx=size(x)

  if(present(error))then
     do i=1,nx
        if(x(i)/=error)then
           nt=1+nt
           rx(nt)=x(i)
        end if
     end do

     if(nt/=0)then
        call Quick_Sort_d( rx(1:nt), sx(1:nt), 'i' )
        if(mod(nt,2)==0)then  ! ǡ
           med=0.5d0*(sx(nt/2)+sx(nt/2+1))
        else  ! ǡ
           med=sx(nt/2+1)
        end if
     else
        med=error
     end if

     if(present(nc))then
        nc=nt
     end if

  else

     call Quick_Sort_d( x(1:nx), sx(1:nx), 'i' )
     if(mod(nx,2)==0)then  ! ǡ
        med=0.5d0*(sx(nx/2)+sx(nx/2+1))
     else  ! ǡ
        med=sx(nx/2+1)
     end if

     if(present(nc))then
        nc=nx
     end if

  end if

end subroutine Median_1dd


subroutine Median_2df( x, med, error, nc )  ! 2 ͷ׻롼
  implicit none
  real, intent(in) :: x(:,:)  ! ǡ
  real, intent(inout) :: med  ! ׻
  real, intent(in), optional :: error  ! »ͤ¸ߤǡåȤη»
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, j, nt
  integer :: nx  ! ǡǿ 1
  integer :: ny  ! ǡǿ 2
  logical :: error_flag  ! ̤֤ɤν.
  real :: rx(size(x,1)*size(x,2))

  !--  2  1 ֤

  nt=0
  nx=size(x,1)
  ny=size(x,2)
  error_flag=.false.

  if(present(error))then
     do j=1,ny
        do i=1,nx
           if(x(i,j)/=error)then
              nt=1+nt
              rx(nt)=x(i,j)
           end if
        end do
     end do

     if(nt==0)then
        med=error
        error_flag=.true.
     end if

  else

     do j=1,ny
        do i=1,nx
           nt=1+nt
           rx(nt)=x(i,j)
        end do
     end do

  end if

  if(present(nc))then
     nc=nt
  end if

  if(error_flag.eqv..false.)then
     call Median_1df( rx(1:nt), med )
  end if

end subroutine Median_2df


subroutine Median_2dd( x, med, error, nc )  ! 2 ͷ׻롼
  implicit none
  double precision, intent(in) :: x(:,:)  ! ǡ
  double precision, intent(inout) :: med  ! ׻
  double precision, intent(in), optional :: error  ! »ͤ¸ߤǡåȤη»
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, j, nt
  integer :: nx  ! ǡǿ 1
  integer :: ny  ! ǡǿ 2
  logical :: error_flag  ! ̤֤ɤν.
  double precision :: rx(size(x,1)*size(x,2))

  !--  2  1 ֤

  nt=0
  nx=size(x,1)
  ny=size(x,2)
  error_flag=.false.

  if(present(error))then
     do j=1,ny
        do i=1,nx
           if(x(i,j)/=error)then
              nt=1+nt
              rx(nt)=x(i,j)
           end if
        end do
     end do

     if(nt==0)then
        med=error
        error_flag=.true.
     end if

  else

     do j=1,ny
        do i=1,nx
           nt=1+nt
           rx(nt)=x(i,j)
        end do
     end do

  end if

  if(present(nc))then
     nc=nt
  end if

  if(error_flag.eqv..false.)then
     call Median_1dd( rx(1:nt), med )
  end if

end subroutine Median_2dd


subroutine Median_3df( x, med, error, nc )  ! 3 ͷ׻롼
  implicit none
  real, intent(in) :: x(:,:,:)  ! ǡ
  real, intent(inout) :: med  ! ׻
  real, intent(in), optional :: error  ! »ͤ¸ߤǡåȤη»
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, j, k, nt
  integer :: nx  ! ǡǿ 1
  integer :: ny  ! ǡǿ 2
  integer :: nz  ! ǡǿ 3
  logical :: error_flag  ! ̤֤ɤν.
  real :: rx(size(x,1)*size(x,2)*size(x,3))

  !--  2  1 ֤

  nt=0
  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)
  error_flag=.false.

  if(present(error))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(x(i,j,k)/=error)then
                 nt=1+nt
                 rx(nt)=x(i,j,k)
              end if
           end do
        end do
     end do

     if(nt==0)then
        med=error
        error_flag=.true.
     end if

  else

     do k=1,nz
        do j=1,ny
           do i=1,nx
              nt=1+nt
              rx(nt)=x(i,j,k)
           end do
        end do
     end do

  end if

  if(present(nc))then
     nc=nt
  end if

  if(error_flag.eqv..false.)then
     call Median_1df( rx(1:nt), med )
  end if

end subroutine Median_3df


subroutine Median_3dd( x, med, error, nc )  ! 3 ͷ׻롼
  implicit none
  double precision, intent(in) :: x(:,:,:)  ! ǡ
  double precision, intent(inout) :: med  ! ׻
  double precision, intent(in), optional :: error  ! »ͤ¸ߤǡåȤη»
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, j, k, nt
  integer :: nx  ! ǡǿ 1
  integer :: ny  ! ǡǿ 2
  integer :: nz  ! ǡǿ 3
  logical :: error_flag  ! ̤֤ɤν.
  double precision :: rx(size(x,1)*size(x,2)*size(x,3))

  !--  2  1 ֤

  nt=0
  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)
  error_flag=.false.

  if(present(error))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(x(i,j,k)/=error)then
                 nt=1+nt
                 rx(nt)=x(i,j,k)
              end if
           end do
        end do
     end do

     if(nt==0)then
        med=error
        error_flag=.true.
     end if

  else

     do k=1,nz
        do j=1,ny
           do i=1,nx
              nt=1+nt
              rx(nt)=x(i,j,k)
           end do
        end do
     end do

  end if

  if(present(nc))then
     nc=nt
  end if

  if(error_flag.eqv..false.)then
     call Median_1dd( rx(1:nt), med )
  end if

end subroutine Median_3dd


subroutine Quartile_1df( x, qua, error, nc )  ! 1 ʬ̷׻롼
  implicit none
  real, intent(in) :: x(:)  ! ǡ
  real, intent(inout) :: qua(3)  ! ׻ʬ (25, 50, 75)
  real, intent(in), optional :: error  ! »ͤ¸ߤǡåȤη»
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, nt
  integer :: nx  ! ǡǿ
  real :: rx(size(x)), sx(size(x))

  nt=0
  rx=0.0
  nx=size(x)

  if(present(error))then
     do i=1,nx
        if(x(i)/=error)then
           nt=1+nt
           rx(nt)=x(i)
        end if
     end do

     if(nt/=0)then
        call Quick_Sort_f( rx(1:nt), sx(1:nt), 'i' )
        if(mod(nt,2)==0)then  ! ǡ
           qua(2)=0.5*(sx(nt/2)+sx(nt/2+1))
           if(mod(nt/2,2)==0)then  ! ǡ
              qua(1)=0.5*(sx(nt/4)+sx(nt/4+1))
              qua(3)=0.5*(sx(3*nt/4)+sx(3*nt/4+1))
           else
              qua(1)=sx(nt/4+1)
              qua(3)=sx(3*nt/4+1)
           end if
        else  ! ǡ
           qua(2)=sx(nt/2+1)
           if(mod(nt/2,2)==0)then  ! ǡ
              qua(1)=0.5*(sx(nt/4)+sx(nt/4+1))
              qua(3)=0.5*(sx(3*nt/4)+sx(3*nt/4+1))
           else
              qua(1)=sx(nt/4+1)
              qua(3)=sx(3*nt/4+1)
           end if
        end if
     else
        qua=error
     end if

     if(present(nc))then
        nc=nt
     end if

  else

     call Quick_Sort_f( x(1:nx), sx(1:nx), 'i' )
     if(mod(nx,2)==0)then  ! ǡ
        qua(2)=0.5*(sx(nx/2)+sx(nx/2+1))
        if(mod(nx/2,2)==0)then  ! ǡ
           qua(1)=0.5*(sx(nx/4)+sx(nx/4+1))
           qua(3)=0.5*(sx(3*nx/4)+sx(3*nx/4+1))
        else
           qua(1)=sx(nx/4+1)
           qua(3)=sx(3*nx/4+1)
        end if
     else  ! ǡ
        qua(2)=sx(nx/2+1)
        if(mod(nx/2,2)==0)then  ! ǡ
           qua(1)=0.5*(sx(nx/4)+sx(nx/4+1))
           qua(3)=0.5*(sx(3*nx/4)+sx(3*nx/4+1))
        else
           qua(1)=sx(nx/4+1)
           qua(3)=sx(3*nx/4+1)
        end if
     end if

     if(present(nc))then
        nc=nx
     end if

  end if

end subroutine Quartile_1df


subroutine Quartile_1dd( x, qua, error, nc )  ! 1 ʬ̷׻롼
  implicit none
  double precision, intent(in) :: x(:)  ! ǡ
  double precision, intent(inout) :: qua(3)  ! ׻ʬ (25, 50, 75)
  double precision, intent(in), optional :: error  ! »ͤ¸ߤǡåȤη»
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, nt
  integer :: nx  ! ǡǿ
  double precision :: rx(size(x)), sx(size(x))

  nt=0
  rx=0.0
  nx=size(x)

  if(present(error))then
     do i=1,nx
        if(x(i)/=error)then
           nt=1+nt
           rx(nt)=x(i)
        end if
     end do

     if(nt/=0)then
        call Quick_Sort_d( rx(1:nt), sx(1:nt), 'i' )
        if(mod(nt,2)==0)then  ! ǡ
           qua(2)=0.5*(sx(nt/2)+sx(nt/2+1))
           if(mod(nt/2,2)==0)then  ! ǡ
              qua(1)=0.5*(sx(nt/4)+sx(nt/4+1))
              qua(3)=0.5*(sx(3*nt/4)+sx(3*nt/4+1))
           else
              qua(1)=sx(nt/4+1)
              qua(3)=sx(3*nt/4+1)
           end if
        else  ! ǡ
           qua(2)=sx(nt/2+1)
           if(mod(nt/2,2)==0)then  ! ǡ
              qua(1)=0.5*(sx(nt/4)+sx(nt/4+1))
              qua(3)=0.5*(sx(3*nt/4)+sx(3*nt/4+1))
           else
              qua(1)=sx(nt/4+1)
              qua(3)=sx(3*nt/4+1)
           end if
        end if
     else
        qua=error
     end if

     if(present(nc))then
        nc=nt
     end if

  else

     call Quick_Sort_d( x(1:nx), sx(1:nx), 'i' )
     if(mod(nx,2)==0)then  ! ǡ
        qua(2)=0.5*(sx(nx/2)+sx(nx/2+1))
        if(mod(nx/2,2)==0)then  ! ǡ
           qua(1)=0.5*(sx(nx/4)+sx(nx/4+1))
           qua(3)=0.5*(sx(3*nx/4)+sx(3*nx/4+1))
        else
           qua(1)=sx(nx/4+1)
           qua(3)=sx(3*nx/4+1)
        end if
     else  ! ǡ
        qua(2)=sx(nx/2+1)
        if(mod(nx/2,2)==0)then  ! ǡ
           qua(1)=0.5*(sx(nx/4)+sx(nx/4+1))
           qua(3)=0.5*(sx(3*nx/4)+sx(3*nx/4+1))
        else
           qua(1)=sx(nx/4+1)
           qua(3)=sx(3*nx/4+1)
        end if
     end if

     if(present(nc))then
        nc=nx
     end if

  end if

end subroutine Quartile_1dd


subroutine Quartile_2df( x, qua, error, nc )  ! 2 ͷ׻롼
  implicit none
  real, intent(in) :: x(:,:)  ! ǡ
  real, intent(inout) :: qua(3)  ! ׻
  real, intent(in), optional :: error  ! »ͤ¸ߤǡåȤη»
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, j, nt
  integer :: nx  ! ǡǿ 1
  integer :: ny  ! ǡǿ 2
  logical :: error_flag  ! ̤֤ɤν.
  real :: rx(size(x,1)*size(x,2))

  !--  2  1 ֤

  nt=0
  nx=size(x,1)
  ny=size(x,2)
  error_flag=.false.

  if(present(error))then
     do j=1,ny
        do i=1,nx
           if(x(i,j)/=error)then
              nt=1+nt
              rx(nt)=x(i,j)
           end if
        end do
     end do

     if(nt==0)then
        qua=error
        error_flag=.true.
     end if

  else

     do j=1,ny
        do i=1,nx
           nt=1+nt
           rx(nt)=x(i,j)
        end do
     end do

  end if

  if(present(nc))then
     nc=nt
  end if

  if(error_flag.eqv..false.)then
     call Quartile_1df( rx(1:nt), qua )
  end if

end subroutine Quartile_2df


subroutine Quartile_2dd( x, qua, error, nc )  ! 2 ͷ׻롼
  implicit none
  double precision, intent(in) :: x(:,:)  ! ǡ
  double precision, intent(inout) :: qua(3)  ! ׻
  double precision, intent(in), optional :: error  ! »ͤ¸ߤǡåȤη»
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, j, nt
  integer :: nx  ! ǡǿ 1
  integer :: ny  ! ǡǿ 2
  logical :: error_flag  ! ̤֤ɤν.
  double precision :: rx(size(x,1)*size(x,2))

  !--  2  1 ֤

  nt=0
  nx=size(x,1)
  ny=size(x,2)
  error_flag=.false.

  if(present(error))then
     do j=1,ny
        do i=1,nx
           if(x(i,j)/=error)then
              nt=1+nt
              rx(nt)=x(i,j)
           end if
        end do
     end do

     if(nt==0)then
        qua=error
        error_flag=.true.
     end if

  else

     do j=1,ny
        do i=1,nx
           nt=1+nt
           rx(nt)=x(i,j)
        end do
     end do

  end if

  if(present(nc))then
     nc=nt
  end if

  if(error_flag.eqv..false.)then
     call Quartile_1dd( rx(1:nt), qua )
  end if

end subroutine Quartile_2dd


subroutine Quartile_3df( x, qua, error, nc )  ! 3 ͷ׻롼
  implicit none
  real, intent(in) :: x(:,:,:)  ! ǡ
  real, intent(inout) :: qua(3)  ! ׻
  real, intent(in), optional :: error  ! »ͤ¸ߤǡåȤη»
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, j, k, nt
  integer :: nx  ! ǡǿ 1
  integer :: ny  ! ǡǿ 2
  integer :: nz  ! ǡǿ 3
  logical :: error_flag  ! ̤֤ɤν.
  real :: rx(size(x,1)*size(x,2)*size(x,3))

  !--  2  1 ֤

  nt=0
  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)
  error_flag=.false.

  if(present(error))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(x(i,j,k)/=error)then
                 nt=1+nt
                 rx(nt)=x(i,j,k)
              end if
           end do
        end do
     end do

     if(nt==0)then
        qua=error
        error_flag=.true.
     end if

  else

     do k=1,nz
        do j=1,ny
           do i=1,nx
              nt=1+nt
              rx(nt)=x(i,j,k)
           end do
        end do
     end do

  end if

  if(present(nc))then
     nc=nt
  end if

  if(error_flag.eqv..false.)then
     call Quartile_1df( rx(1:nt), qua )
  end if

end subroutine Quartile_3df


subroutine Quartile_3dd( x, qua, error, nc )  ! 3 ͷ׻롼
  implicit none
  double precision, intent(in) :: x(:,:,:)  ! ǡ
  double precision, intent(inout) :: qua(3)  ! ׻
  double precision, intent(in), optional :: error  ! »ͤ¸ߤǡåȤη»
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, j, k, nt
  integer :: nx  ! ǡǿ 1
  integer :: ny  ! ǡǿ 2
  integer :: nz  ! ǡǿ 3
  logical :: error_flag  ! ̤֤ɤν.
  double precision :: rx(size(x,1)*size(x,2)*size(x,3))

  !--  2  1 ֤

  nt=0
  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)
  error_flag=.false.

  if(present(error))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(x(i,j,k)/=error)then
                 nt=1+nt
                 rx(nt)=x(i,j,k)
              end if
           end do
        end do
     end do

     if(nt==0)then
        qua=error
        error_flag=.true.
     end if

  else

     do k=1,nz
        do j=1,ny
           do i=1,nx
              nt=1+nt
              rx(nt)=x(i,j,k)
           end do
        end do
     end do

  end if

  if(present(nc))then
     nc=nt
  end if

  if(error_flag.eqv..false.)then
     call Quartile_1dd( rx(1:nt), qua )
  end if

end subroutine Quartile_3dd


subroutine Anomaly_1df( x, anor, error, nc )  ! 1 ǡк֤
  implicit none
  real, intent(in) :: x(:)  ! ǡ
  real, intent(inout) :: anor(size(x))  !  x(i) бк anor(i)
  real, intent(in), optional :: error  ! »ͤ¸ߤǡåȤξη»
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i
  integer :: nx  ! ǡǿ
  real :: ave

  nx=size(x)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nx, anor ),  &
  &                                     "Anomaly_1d" )
  end if

  if(present(error))then
     call Mean_1df( x, ave, error, nc=nc )
     do i=1,nx
        if(x(i)==error)then
           anor(i)=error
        else
           anor(i)=x(i)-ave
        end if
     end do
  else
     call Mean_1df( x, ave )
     do i=1,nx
        anor(i)=x(i)-ave
     end do
  end if

end subroutine Anomaly_1df


subroutine Anomaly_1dd( x, anor, error, nc )  ! 1 ǡк֤
  implicit none
  double precision, intent(in) :: x(:)  ! ǡ
  double precision, intent(inout) :: anor(size(x))  !  x(i) бк anor(i)
  double precision, intent(in), optional :: error  ! »ͤ¸ߤǡåȤξη»
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i
  integer :: nx  ! ǡǿ
  double precision :: ave

  nx=size(x)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nx, anor ),  &
  &                                     "Anomaly_1d" )
  end if

  if(present(error))then
     call Mean_1dd( x, ave, error, nc=nc )
     do i=1,nx
        if(x(i)==error)then
           anor(i)=error
        else
           anor(i)=x(i)-ave
        end if
     end do
  else
     call Mean_1dd( x, ave )
     do i=1,nx
        anor(i)=x(i)-ave
     end do
  end if

end subroutine Anomaly_1dd


subroutine Anomaly_2df( x, anor, error, nc )  ! 2 ǡк֤
  implicit none
  real, intent(in) :: x(:,:)  ! ǡ
  real, intent(inout) :: anor(size(x,1),size(x,2))  !  x(i,j) бк anor(i,j)
  real, intent(in), optional :: error  ! »ͤ¸ߤǡåȤξη»
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, j
  integer :: nx  ! ǡǿ 1
  integer :: ny  ! ǡǿ 2
  real :: ave

  nx=size(x,1)
  ny=size(x,2)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, anor ),  &
  &                                     "Anomaly_2d" )
  end if

  if(present(error))then
     call Mean_2df( x, ave, error, nc=nc )
     do j=1,ny
        do i=1,nx
           if(x(i,j)==error)then
              anor(i,j)=error
           else
              anor(i,j)=x(i,j)-ave
           end if
        end do
     end do
  else
     call Mean_2df( x, ave )
     do j=1,ny
        do i=1,nx
           anor(i,j)=x(i,j)-ave
        end do
     end do
  end if

end subroutine Anomaly_2df


subroutine Anomaly_2dd( x, anor, error, nc )  ! 2 ǡк֤
  implicit none
  double precision, intent(in) :: x(:,:)  ! ǡ
  double precision, intent(inout) :: anor(size(x,1),size(x,2))  !  x(i,j) бк anor(i,j)
  double precision, intent(in), optional :: error  ! »ͤ¸ߤǡåȤξη»
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, j
  integer :: nx  ! ǡǿ 1
  integer :: ny  ! ǡǿ 2
  double precision :: ave

  nx=size(x,1)
  ny=size(x,2)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, anor ),  &
  &                                     "Anomaly_2d" )
  end if

  if(present(error))then
     call Mean_2dd( x, ave, error, nc=nc )
     do j=1,ny
        do i=1,nx
           if(x(i,j)==error)then
              anor(i,j)=error
           else
              anor(i,j)=x(i,j)-ave
           end if
        end do
     end do
  else
     call Mean_2dd( x, ave )
     do j=1,ny
        do i=1,nx
           anor(i,j)=x(i,j)-ave
        end do
     end do
  end if

end subroutine Anomaly_2dd


subroutine Anomaly_3df( x, anor, error, nc )  ! 3 ǡк֤
  implicit none
  real, intent(in) :: x(:,:,:)  ! ǡ
  real, intent(inout) :: anor(size(x,1),size(x,2),size(x,3))  !  x(i,j,k) бк anor(i,j,k)
  real, intent(in), optional :: error  ! »ͤ¸ߤǡåȤξη»
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, j, k
  integer :: nx  ! ǡǿ 1
  integer :: ny  ! ǡǿ 2
  integer :: nz  ! ǡǿ 3
  real :: ave

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_3d(  &
  &                                          nx, ny, nz, anor ),  &
  &                                     "Anomaly_3d" )
  end if

  if(present(error))then
     call Mean_3df( x, ave, error, nc=nc )
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(x(i,j,k)==error)then
                 anor(i,j,k)=error
              else
                 anor(i,j,k)=x(i,j,k)-ave
              end if
           end do
        end do
     end do
  else
     call Mean_3df( x, ave )
     do k=1,nz
        do j=1,ny
           do i=1,nx
              anor(i,j,k)=x(i,j,k)-ave
           end do
        end do
     end do
  end if

end subroutine Anomaly_3df


subroutine Anomaly_3dd( x, anor, error, nc )  ! 3 ǡк֤
  implicit none
  double precision, intent(in) :: x(:,:,:)  ! ǡ
  double precision, intent(inout) :: anor(size(x,1),size(x,2),size(x,3))  !  x(i,j,k) бк anor(i,j,k)
  double precision, intent(in), optional :: error  ! »ͤ¸ߤǡåȤξη»
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, j, k
  integer :: nx  ! ǡǿ 1
  integer :: ny  ! ǡǿ 2
  integer :: nz  ! ǡǿ 3
  double precision :: ave

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_3d(  &
  &                                          nx, ny, nz, anor ),  &
  &                                     "Anomaly_3d" )
  end if

  if(present(error))then
     call Mean_3dd( x, ave, error, nc=nc )
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(x(i,j,k)==error)then
                 anor(i,j,k)=error
              else
                 anor(i,j,k)=x(i,j,k)-ave
              end if
           end do
        end do
     end do
  else
     call Mean_3dd( x, ave )
     do k=1,nz
        do j=1,ny
           do i=1,nx
              anor(i,j,k)=x(i,j,k)-ave
           end do
        end do
     end do
  end if

end subroutine Anomaly_3dd

!---------------------------------------
!---------------------------------------

subroutine stand_devi_1df( x, anor, error )  ! 1 ǡɸк׻
  ! ɸк$\sigma $,
  ! $$\sigma =\sum^{nx}_{i=1}{epsilon ^2} $$
  ! , $\epsilon $ʿͤΤ$x-\bar{x}$Ǥ.
  implicit none
  real, intent(in) :: x(:)  ! ǡ
  real, intent(inout) :: anor  ! ɸк
  real, intent(in), optional :: error  ! »
  integer :: i
  integer :: nx  ! ǡ
  integer :: nt
  real :: an(size(x))

  nx=size(x)
  anor=0.0

  if(present(error))then
     call Anomaly_1df( x, an, error, nc=nt )
     do i=1,nx
        if(x(i)/=error)then
           anor=anor+an(i)**2
        end if
     end do
     if(anor/=error.and.nt/=0)then
        anor=sqrt(anor/real(nt))
     end if
  else
     call Anomaly_1df( x, an )
     do i=1,nx
        anor=anor+an(i)**2
     end do
     anor=sqrt(anor/real(nx))
  end if

end subroutine stand_devi_1df

!---------------------------------------
!---------------------------------------

subroutine stand_devi_1dd( x, anor, error )  ! 1 ǡɸк׻
  ! ɸк$\sigma $,
  ! $$\sigma =\sum^{nx}_{i=1}{epsilon ^2} $$
  ! , $\epsilon $ʿͤΤ$x-\bar{x}$Ǥ.
  implicit none
  double precision, intent(in) :: x(:)  ! ǡ
  double precision, intent(inout) :: anor  ! ɸк
  double precision, intent(in), optional :: error  ! »
  integer :: i
  integer :: nx  ! ǡ
  integer :: nt
  double precision :: an(size(x))

  nx=size(x)
  anor=0.0d0

  if(present(error))then
     call Anomaly_1dd( x, an, error, nc=nt )
     do i=1,nx
        if(x(i)/=error)then
           anor=anor+an(i)**2
        end if
     end do
     if(anor/=error.and.nt/=0)then
        anor=dsqrt(anor/dble(nt))
     end if
  else
     call Anomaly_1dd( x, an )
     do i=1,nx
        anor=anor+an(i)**2
     end do
     anor=dsqrt(anor/dble(nx))
  end if

end subroutine stand_devi_1dd

!---------------------------------------
!---------------------------------------

subroutine stand_devi_2df( x, anor, error )  ! 2 ǡɸк׻
  implicit none
  real, intent(in) :: x(:,:)  ! ǡ
  real, intent(inout) :: anor  ! ɸк
  real, intent(in), optional :: error  ! »
  integer :: i, j, counter
  integer :: nx  ! ǡ 1
  integer :: ny  ! ǡ 2
  real :: val(size(x,1)*size(x,2))

  nx=size(x,1)
  ny=size(x,2)

  counter=0
  do j=1,ny
     do i=1,nx
        counter=counter+1
        val(counter)=x(i,j)
     end do
  end do

  anor=0.0

  if(present(error))then
     call stand_devi_1df( val, anor, error )
  else
     call stand_devi_1df( val, anor )
  end if

end subroutine stand_devi_2df

!---------------------------------------
!---------------------------------------

subroutine stand_devi_2dd( x, anor, error )  ! 2 ǡɸк׻
  implicit none
  double precision, intent(in) :: x(:,:)  ! ǡ
  double precision, intent(inout) :: anor  ! ɸк
  double precision, intent(in), optional :: error  ! »
  integer :: i, j, counter
  integer :: nx  ! ǡ 1
  integer :: ny  ! ǡ 2
  double precision :: val(size(x,1)*size(x,2))

  nx=size(x,1)
  ny=size(x,2)

  counter=0
  do j=1,ny
     do i=1,nx
        counter=counter+1
        val(counter)=x(i,j)
     end do
  end do

  anor=0.0d0

  if(present(error))then
     call stand_devi_1dd( val, anor, error )
  else
     call stand_devi_1dd( val, anor )
  end if

end subroutine stand_devi_2dd

!---------------------------------------
!---------------------------------------

subroutine stand_devi_3df( x, anor, error )  ! 3 ǡɸк׻
  implicit none
  real, intent(in) :: x(:,:,:)  ! ǡ
  real, intent(inout) :: anor  ! ɸк
  real, intent(in), optional :: error  ! »
  integer :: i, j, k, counter
  integer :: nx  ! ǡ 1
  integer :: ny  ! ǡ 2
  integer :: nz  ! ǡ 3
  real :: val(size(x,1)*size(x,2)*size(x,3))

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  counter=0
  do k=1,nz
     do j=1,ny
        do i=1,nx
           counter=counter+1
           val(counter)=x(i,j,k)
        end do
     end do
  end do

  anor=0.0

  if(present(error))then
     call stand_devi_1df( val, anor, error )
  else
     call stand_devi_1df( val, anor )
  end if

end subroutine stand_devi_3df

!---------------------------------------
!---------------------------------------

subroutine stand_devi_3dd( x, anor, error )  ! 3 ǡɸк׻
  implicit none
  double precision, intent(in) :: x(:,:,:)  ! ǡ
  double precision, intent(inout) :: anor  ! ɸк
  double precision, intent(in), optional :: error  ! »
  integer :: i, j, k, counter
  integer :: nx  ! ǡ 1
  integer :: ny  ! ǡ 2
  integer :: nz  ! ǡ 3
  double precision :: val(size(x,1)*size(x,2)*size(x,3))

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  counter=0
  do k=1,nz
     do j=1,ny
        do i=1,nx
           counter=counter+1
           val(counter)=x(i,j,k)
        end do
     end do
  end do

  anor=0.0d0

  if(present(error))then
     call stand_devi_1dd( val, anor, error )
  else
     call stand_devi_1dd( val, anor )
  end if

end subroutine stand_devi_3dd

!---------------------------------------
!---------------------------------------

subroutine covariance_1df( x, y, cov, error, nc )  ! 2 Ĥ 1 ǡζʬ׻
  ! ʬ$\sigma $,
  ! $$\sigma =\sum^{nx}_{i=1}{(x-\bar{x})(y-\bar{y})} $$
  implicit none
  real, intent(in) :: x(:)  ! ǡ 1
  real, intent(in) :: y(size(x))  ! ǡ 2
  real, intent(inout) :: cov  ! ɸк
  real, intent(in), optional :: error  ! »
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i
  integer :: nx  ! ǡ
  integer :: nt
  real :: an1(size(x)), an2(size(x))
  real :: rx(size(x)), ry(size(x))

  nx=size(x)
  cov=0.0

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nx, y ),  &
  &                                     "covariance_1d" )
  end if

  if(present(error))then
     call replace_undef_f( x, y, rx, ry, error )
     nt=0
     call Anomaly_1df( rx, an1, error )
     call Anomaly_1df( ry, an2, error )
     do i=1,nx
        if(an1(i)/=error.and.an2(i)/=error)then
           cov=cov+an1(i)*an2(i)
           nt=nt+1
        end if
     end do

     if(present(nc))then
        nc=nt
     end if

     if(cov/=error.and.nt/=0)then
        cov=cov/real(nt)
     end if
  else
     call Anomaly_1df( x, an1 )
     call Anomaly_1df( y, an2 )
     do i=1,nx
        cov=cov+an1(i)*an2(i)
     end do
     cov=cov/real(nx)
  end if

end subroutine covariance_1df

!---------------------------------------
!---------------------------------------

subroutine covariance_1dd( x, y, cov, error, nc )  ! 2 Ĥ 1 ǡζʬ׻
  ! ʬ$\sigma $,
  ! $$\sigma =\sum^{nx}_{i=1}{(x-\bar{x})(y-\bar{y})} $$
  implicit none
  double precision, intent(in) :: x(:)  ! ǡ 1
  double precision, intent(in) :: y(size(x))  ! ǡ 2
  double precision, intent(inout) :: cov  ! ɸк
  double precision, intent(in), optional :: error  ! »
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i
  integer :: nx  ! ǡ
  integer :: nt
  double precision :: an1(size(x)), an2(size(x))
  double precision :: rx(size(x)), ry(size(x))

  nx=size(x)
  cov=0.0d0

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nx, y ),  &
  &                                     "covariance_1d" )
  end if

  if(present(error))then
     call replace_undef_d( x, y, rx, ry, error )
     nt=0
     call Anomaly_1dd( rx, an1, error )
     call Anomaly_1dd( ry, an2, error )
     do i=1,nx
        if(an1(i)/=error.and.an2(i)/=error)then
           cov=cov+an1(i)*an2(i)
           nt=nt+1
        end if
     end do

     if(present(nc))then
        nc=nt
     end if

     if(cov/=error.and.nt/=0)then
        cov=cov/dble(nt)
     end if
  else
     call Anomaly_1dd( x, an1 )
     call Anomaly_1dd( y, an2 )
     do i=1,nx
        cov=cov+an1(i)*an2(i)
     end do
     cov=cov/dble(nx)
  end if

end subroutine covariance_1dd

!---------------------------------------
!---------------------------------------

subroutine covariance_2df( x, y, cov, error, nc )  ! 2 Ĥ 2 ǡζʬ׻
  implicit none
  real, intent(in) :: x(:,:)  ! ǡ 1
  real, intent(in) :: y(size(x,1),size(x,2))  ! ǡ 2
  real, intent(inout) :: cov  ! ɸк
  real, intent(in), optional :: error  ! »
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, j, counter
  integer :: nx  ! ǡ 1
  integer :: ny  ! ǡ 2
  real :: val1(size(x,1)*size(x,2)), val2(size(x,1)*size(x,2))

  nx=size(x,1)
  ny=size(x,2)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, y ),  &
  &                                     "covariance_2d" )
  end if

  counter=0

  do j=1,ny
     do i=1,nx
        counter=counter+1
        val1(counter)=x(i,j)
        val2(counter)=y(i,j)
     end do
  end do

  cov=0.0

  if(present(error))then
     if(present(nc))then
        call covariance_1df( val1, val2, cov, error, nc=nc )
     else
        call covariance_1df( val1, val2, cov, error )
     end if
  else
     call covariance_1df( val1, val2, cov )
  end if

end subroutine covariance_2df

!---------------------------------------
!---------------------------------------

subroutine covariance_2dd( x, y, cov, error, nc )  ! 2 Ĥ 2 ǡζʬ׻
  implicit none
  double precision, intent(in) :: x(:,:)  ! ǡ 1
  double precision, intent(in) :: y(size(x,1),size(x,2))  ! ǡ 2
  double precision, intent(inout) :: cov  ! ɸк
  double precision, intent(in), optional :: error  ! »
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, j, counter
  integer :: nx  ! ǡ 1
  integer :: ny  ! ǡ 2
  double precision :: val1(size(x,1)*size(x,2)), val2(size(x,1)*size(x,2))

  nx=size(x,1)
  ny=size(x,2)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, y ),  &
  &                                     "covariance_2d" )
  end if

  counter=0

  do j=1,ny
     do i=1,nx
        counter=counter+1
        val1(counter)=x(i,j)
        val2(counter)=y(i,j)
     end do
  end do

  cov=0.0d0

  if(present(error))then
     if(present(nc))then
        call covariance_1dd( val1, val2, cov, error, nc=nc )
     else
        call covariance_1dd( val1, val2, cov, error )
     end if
  else
     call covariance_1dd( val1, val2, cov )
  end if

end subroutine covariance_2dd

!---------------------------------------
!---------------------------------------

subroutine covariance_3df( x, y, cov, error, nc )  ! 2 Ĥ 3 ǡζʬ׻
  implicit none
  real, intent(in) :: x(:,:,:)  ! ǡ 1
  real, intent(in) :: y(size(x,1),size(x,2),size(x,3))  ! ǡ 2
  real, intent(inout) :: cov  ! ɸк
  real, intent(in), optional :: error  ! »
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, j, k, counter
  integer :: nx  ! ǡ 1
  integer :: ny  ! ǡ 2
  integer :: nz  ! ǡ 3
  real :: val1(size(x,1)*size(x,2)*size(x,3)), val2(size(x,1)*size(x,2)*size(x,3))

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, y ),  &
  &                                     "covariance_3d" )
  end if

  counter=0

  do k=1,nz
     do j=1,ny
        do i=1,nx
           counter=counter+1
           val1(counter)=x(i,j,k)
           val2(counter)=y(i,j,k)
        end do
     end do
  end do

  cov=0.0

  if(present(error))then
     if(present(nc))then
        call covariance_1df( val1, val2, cov, error, nc=nc )
     else
        call covariance_1df( val1, val2, cov, error )
     end if
  else
     call covariance_1df( val1, val2, cov )
  end if

end subroutine covariance_3df

!---------------------------------------
!---------------------------------------

subroutine covariance_3dd( x, y, cov, error, nc )  ! 2 Ĥ 3 ǡζʬ׻
  implicit none
  double precision, intent(in) :: x(:,:,:)  ! ǡ 1
  double precision, intent(in) :: y(size(x,1),size(x,2),size(x,3))  ! ǡ 2
  double precision, intent(inout) :: cov  ! ɸк
  double precision, intent(in), optional :: error  ! »
  integer, intent(inout), optional :: nc  ! »ͤ¸ߤǡåȤʿ
                                          ! Ѥǡ.
  integer :: i, j, k, counter
  integer :: nx  ! ǡ 1
  integer :: ny  ! ǡ 2
  integer :: nz  ! ǡ 3
  double precision :: val1(size(x,1)*size(x,2)*size(x,3)), val2(size(x,1)*size(x,2)*size(x,3))

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, y ),  &
  &                                     "covariance_3d" )
  end if

  counter=0

  do k=1,nz
     do j=1,ny
        do i=1,nx
           counter=counter+1
           val1(counter)=x(i,j,k)
           val2(counter)=y(i,j,k)
        end do
     end do
  end do

  cov=0.0d0

  if(present(error))then
     if(present(nc))then
        call covariance_1dd( val1, val2, cov, error, nc=nc )
     else
        call covariance_1dd( val1, val2, cov, error )
     end if
  else
     call covariance_1dd( val1, val2, cov )
  end if

end subroutine covariance_3dd

!---------------------------------------
!---------------------------------------

subroutine nearest_search_1df( x, point, i, hx, hp )
  ! 1 Ƕ˵õ롼
  ! interpo_search_1d ͤ, ͤ +1 ͤεΥӤ
  ! Υû򤹤.
  implicit none
  real, intent(in) :: x(:)  ! 
  real, intent(in) :: point  ! 
  integer, intent(inout) :: i  ! point κǶ˵ֹ
  real, intent(in), optional :: hx(size(x))  ! x ɸΥ
  real, intent(in), optional :: hp  ! point ǤΥ !! ޤѰդ
  real :: tmp1, tmp2
  integer :: j, nx

  nx=size(x)

  call interpo_search_1df( x, point, j )

  if(j==0)then  ! i=1 ˤΤ, tmp1 x(1), tmp2  x(2) ,  if ʸ
           ! Ǥޤ.
     j=1
     tmp1=x(j)
     tmp2=x(j+1)
  else
     if(j==nx)then  ! i=nx ˤΤ, tmp2  x(nx), tmp1  x(nx-1) ,
            !  if ʸǤޤ.
        tmp1=x(j)
        tmp2=x(j-1)
     else
        tmp1=x(j)
        tmp2=x(j+1)
     end if
  end if

  if(abs(point-tmp1)>abs(tmp2-point))then
     i=j+1
  else
     i=j
  end if

end subroutine nearest_search_1df

!---------------------------------------
!---------------------------------------

subroutine nearest_search_1dd( x, point, i, hx, hp )
  ! 1 Ƕ˵õ롼
  ! interpo_search_1d ͤ, ͤ +1 ͤεΥӤ
  ! Υû򤹤.
  implicit none
  double precision, intent(in) :: x(:)  ! 
  double precision, intent(in) :: point  ! 
  integer, intent(inout) :: i  ! point κǶ˵ֹ
  double precision, intent(in), optional :: hx(size(x))  ! x ɸΥ
  double precision, intent(in), optional :: hp  ! point ǤΥ !! ޤѰդ
  double precision :: tmp1, tmp2
  integer :: j, nx

  nx=size(x)

  call interpo_search_1dd( x, point, j )

  if(j==0)then  ! i=1 ˤΤ, tmp1 x(1), tmp2  x(2) ,  if ʸ
           ! Ǥޤ.
     j=1
     tmp1=x(j+1)
     tmp2=x(j+2)
  else
     if(j==nx)then  ! i=nx ˤΤ, tmp2  x(nx), tmp1  x(nx-1) ,
            !  if ʸǤޤ.
        tmp1=x(j)
        tmp2=x(j-1)
     else
        tmp1=x(j)
        tmp2=x(j+1)
     end if
  end if

  if(abs(point-tmp1)>abs(tmp2-point))then
     i=j+1
  else
     i=j
  end if

end subroutine nearest_search_1dd

!---------------------------------------
!---------------------------------------

subroutine nearest_search_2df( x, y, pointx, pointy, i, j )
  ! 2 Ƕ˵õ롼
  ! nearest_search_1d ͤ.
  ! , 2 Ǥ뤿,  4 κǶ׻ɬפ뤬,
  ! ǤľľɸͤƤΤ, ƼΩǺǶ׻,
  ! ɤǶ᤿ 2 κǶȤʤ.
  implicit none
  real, intent(in) :: x(:)  !  x
  real, intent(in) :: y(:)  !  y
  real, intent(in) :: pointx  !  x
  real, intent(in) :: pointy  !  y
  integer, intent(inout) :: i  ! pointx κǶֹ
  integer, intent(inout) :: j  ! pointy κǶֹ

  call nearest_search_1df( x, pointx, i )
  call nearest_search_1df( y, pointy, j )

end subroutine nearest_search_2df

!---------------------------------------
!---------------------------------------

subroutine nearest_search_2dd( x, y, pointx, pointy, i, j )
  ! 2 Ƕ˵õ롼
  ! nearest_search_1d ͤ.
  ! , 2 Ǥ뤿,  4 κǶ׻ɬפ뤬,
  ! ǤľľɸͤƤΤ, ƼΩǺǶ׻,
  ! ɤǶ᤿ 2 κǶȤʤ.
  implicit none
  double precision, intent(in) :: x(:)  !  x
  double precision, intent(in) :: y(:)  !  y
  double precision, intent(in) :: pointx  !  x
  double precision, intent(in) :: pointy  !  y
  integer, intent(inout) :: i  ! pointx κǶֹ
  integer, intent(inout) :: j  ! pointy κǶֹ

  call nearest_search_1dd( x, pointx, i )
  call nearest_search_1dd( y, pointy, j )

end subroutine nearest_search_2dd

!---------------------------------------
!---------------------------------------

subroutine nearest_search_3df( x, y, z, pointx, pointy, pointz, i, j, k )
  ! 2 Ƕ˵õ롼
  ! nearest_search_1d ͤ.
  ! , 2 Ǥ뤿,  4 κǶ׻ɬפ뤬,
  ! ǤľľɸͤƤΤ, ƼΩǺǶ׻,
  ! ɤǶ᤿ 2 κǶȤʤ.
  implicit none
  real, intent(in) :: x(:)  !  x
  real, intent(in) :: y(:)  !  y
  real, intent(in) :: z(:)  !  z
  real, intent(in) :: pointx  !  x
  real, intent(in) :: pointy  !  y
  real, intent(in) :: pointz  !  z
  integer, intent(inout) :: i  ! pointx κǶֹ
  integer, intent(inout) :: j  ! pointy κǶֹ
  integer, intent(inout) :: k  ! pointz κǶֹ

  call nearest_search_1df( x, pointx, i )
  call nearest_search_1df( y, pointy, j )
  call nearest_search_1df( z, pointz, k )

end subroutine nearest_search_3df

!---------------------------------------
!---------------------------------------

subroutine nearest_search_3dd( x, y, z, pointx, pointy, pointz, i, j, k )
  ! 2 Ƕ˵õ롼
  ! nearest_search_1d ͤ.
  ! , 2 Ǥ뤿,  4 κǶ׻ɬפ뤬,
  ! ǤľľɸͤƤΤ, ƼΩǺǶ׻,
  ! ɤǶ᤿ 2 κǶȤʤ.
  implicit none
  double precision, intent(in) :: x(:)  !  x
  double precision, intent(in) :: y(:)  !  y
  double precision, intent(in) :: z(:)  !  z
  double precision, intent(in) :: pointx  !  x
  double precision, intent(in) :: pointy  !  y
  double precision, intent(in) :: pointz  !  z
  integer, intent(inout) :: i  ! pointx κǶֹ
  integer, intent(inout) :: j  ! pointy κǶֹ
  integer, intent(inout) :: k  ! pointz κǶֹ

  call nearest_search_1dd( x, pointx, i )
  call nearest_search_1dd( y, pointy, j )
  call nearest_search_1dd( z, pointz, k )

end subroutine nearest_search_3dd

!---------------------------------------
!---------------------------------------

subroutine nearest_neighbor_search_1df( x, point, i, undef )
  ! 1 Ƕ˵õ롼
  ! ɸ x ؿǤʤƤ褤.
  ! | point - x | κǾͤȤʤ i Ȥ֤.
  implicit none
  real, intent(in) :: x(:)  ! 
  real, intent(in) :: point  ! 
  integer, intent(inout) :: i  ! point κǶ˵ֹ
  real, intent(in), optional :: undef   ! ̤
  real, dimension(size(x)) :: dx
  integer :: j
  real :: tmpv

  if(present(undef))then
     dx=undef
     do j=1,size(x)
        if(x(j)/=undef)then
           dx(j)=abs(x(j)-point)
        end if
     end do

     call min_val_1d( dx, i, tmpv, undef=undef )

  else

     do j=1,size(x)
        dx(j)=abs(x(j)-point)
     end do

     call min_val_1d( dx, i, tmpv )

  end if

end subroutine nearest_neighbor_search_1df

!---------------------------------------
!---------------------------------------

subroutine nearest_neighbor_search_1dd( x, point, i, undef )
  ! 1 Ƕ˵õ롼
  ! ɸ x ؿǤʤƤ褤.
  ! | point - x | κǾͤȤʤ i Ȥ֤.
  implicit none
  double precision, intent(in) :: x(:)  ! 
  double precision, intent(in) :: point  ! 
  integer, intent(inout) :: i  ! point κǶ˵ֹ
  double precision, intent(in), optional :: undef   ! ̤
  double precision, dimension(size(x)) :: dx
  integer :: j
  double precision :: tmpv

  if(present(undef))then
     dx=undef
     do j=1,size(x)
        if(x(j)/=undef)then
           dx(j)=abs(x(j)-point)
        end if
     end do

     call min_val_1d( dx, i, tmpv, undef=undef )

  else

     do j=1,size(x)
        dx(j)=abs(x(j)-point)
     end do

     call min_val_1d( dx, i, tmpv )

  end if

end subroutine nearest_neighbor_search_1dd

!---------------------------------------
!---------------------------------------

subroutine nearest_neighbor_search_2df( x, y, pointx, pointy, i, j, undef )
  ! 2 Ƕ˵õ롼
  ! nearest_neighbor_search_1d ͤ.
  ! x, y ؿǤʤƤ褤.
  ! , 2 Ǥ뤿,  4 κǶ׻ɬפ뤬,
  ! ǤľľɸͤƤΤ, ƼΩǺǶ׻,
  ! ɤǶ᤿ 2 κǶȤʤ.
  implicit none
  real, intent(in) :: x(:)  !  x
  real, intent(in) :: y(:)  !  y
  real, intent(in) :: pointx  !  x
  real, intent(in) :: pointy  !  y
  integer, intent(inout) :: i  ! pointx κǶֹ
  integer, intent(inout) :: j  ! pointy κǶֹ
  real, optional :: undef  ! ̤

  if(present(undef))then
     call nearest_neighbor_search_1df( x, pointx, i, undef=undef )
     call nearest_neighbor_search_1df( y, pointy, j, undef=undef )
  else
     call nearest_neighbor_search_1df( x, pointx, i )
     call nearest_neighbor_search_1df( y, pointy, j )
  end if

end subroutine nearest_neighbor_search_2df

!---------------------------------------
!---------------------------------------

subroutine nearest_neighbor_search_2dd( x, y, pointx, pointy, i, j, undef )
  ! 2 Ƕ˵õ롼
  ! nearest_neighbor_search_1d ͤ.
  ! x, y ؿǤʤƤ褤.
  ! , 2 Ǥ뤿,  4 κǶ׻ɬפ뤬,
  ! ǤľľɸͤƤΤ, ƼΩǺǶ׻,
  ! ɤǶ᤿ 2 κǶȤʤ.
  implicit none
  double precision, intent(in) :: x(:)  !  x
  double precision, intent(in) :: y(:)  !  y
  double precision, intent(in) :: pointx  !  x
  double precision, intent(in) :: pointy  !  y
  integer, intent(inout) :: i  ! pointx κǶֹ
  integer, intent(inout) :: j  ! pointy κǶֹ
  double precision, optional :: undef  ! ̤

  if(present(undef))then
     call nearest_neighbor_search_1dd( x, pointx, i, undef=undef )
     call nearest_neighbor_search_1dd( y, pointy, j, undef=undef )
  else
     call nearest_neighbor_search_1dd( x, pointx, i )
     call nearest_neighbor_search_1dd( y, pointy, j )
  end if

end subroutine nearest_neighbor_search_2dd

!---------------------------------------
!---------------------------------------

subroutine nearest_neighbor_search_3df( x, y, z, pointx, pointy, pointz,  &
  &                                     i, j, k, undef )
  ! 3 Ƕ˵õ롼
  ! nearest_neighbor_search_1d ͤ.
  ! x, y ؿǤʤƤ褤.
  ! , 3 Ǥ뤿,  8 κǶ׻ɬפ뤬,
  ! ǤľľɸͤƤΤ, ƼΩǺǶ׻,
  ! ɤǶ᤿ 3 κǶȤʤ.
  implicit none
  real, intent(in) :: x(:)  !  x
  real, intent(in) :: y(:)  !  y
  real, intent(in) :: z(:)  !  z
  real, intent(in) :: pointx  !  x
  real, intent(in) :: pointy  !  y
  real, intent(in) :: pointz  !  z
  integer, intent(inout) :: i  ! pointx κǶֹ
  integer, intent(inout) :: j  ! pointy κǶֹ
  integer, intent(inout) :: k  ! pointz κǶֹ
  real, optional :: undef  ! ̤

  if(present(undef))then
     call nearest_neighbor_search_1df( x, pointx, i, undef=undef )
     call nearest_neighbor_search_1df( y, pointy, j, undef=undef )
     call nearest_neighbor_search_1df( z, pointz, k, undef=undef )
  else
     call nearest_neighbor_search_1df( x, pointx, i )
     call nearest_neighbor_search_1df( y, pointy, j )
     call nearest_neighbor_search_1df( z, pointz, k )
  end if

end subroutine nearest_neighbor_search_3df

!---------------------------------------
!---------------------------------------

subroutine nearest_neighbor_search_3dd( x, y, z, pointx, pointy, pointz,  &
  &                                     i, j, k, undef )
  ! 3 Ƕ˵õ롼
  ! nearest_neighbor_search_1d ͤ.
  ! x, y ؿǤʤƤ褤.
  ! , 3 Ǥ뤿,  8 κǶ׻ɬפ뤬,
  ! ǤľľɸͤƤΤ, ƼΩǺǶ׻,
  ! ɤǶ᤿ 3 κǶȤʤ.
  implicit none
  double precision, intent(in) :: x(:)  !  x
  double precision, intent(in) :: y(:)  !  y
  double precision, intent(in) :: z(:)  !  z
  double precision, intent(in) :: pointx  !  x
  double precision, intent(in) :: pointy  !  y
  double precision, intent(in) :: pointz  !  z
  integer, intent(inout) :: i  ! pointx κǶֹ
  integer, intent(inout) :: j  ! pointy κǶֹ
  integer, intent(inout) :: k  ! pointz κǶֹ
  double precision, optional :: undef  ! ̤

  if(present(undef))then
     call nearest_neighbor_search_1dd( x, pointx, i, undef=undef )
     call nearest_neighbor_search_1dd( y, pointy, j, undef=undef )
     call nearest_neighbor_search_1dd( z, pointz, k, undef=undef )
  else
     call nearest_neighbor_search_1dd( x, pointx, i )
     call nearest_neighbor_search_1dd( y, pointy, j )
     call nearest_neighbor_search_1dd( z, pointz, k )
  end if

end subroutine nearest_neighbor_search_3dd

!---------------------------------------
!---------------------------------------

subroutine interpo_search_1df( x, point, i, undeff, stdopt )
  ! ǿ뤴Ȥͤ礭ʤˤΤʤ,
  ! point ֹϤ.
  implicit none
  real, intent(in) :: x(:)  ! 
  real, intent(in) :: point  ! 
  integer, intent(inout) :: i  ! point ͤۤʤֹͤ
  integer, intent(in), optional :: undeff  ! õϰϤǤ꾮ͤõ褦Ȥ, undef ֤,  undef ͤꤹ. default Ǥ 0.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  integer :: nx, j
  integer :: just
  logical :: stderr

  nx=size(x)
  if(present(undeff))then
     just=undeff
  else
     just=0
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(x(1)>point)then

     if(stderr.eqv..false.)then
        write(*,*) "****** WARNING ******"
        write(*,*) "searching point was not found :", x(1), point
        write(*,*) "Abort. Exit.!!!"
     end if
     i=just

  else

     do j=1,nx
        if(x(j)<=point)then
           i=j
        else
           exit
        end if
     end do

  end if

end subroutine interpo_search_1df

!---------------------------------------
!---------------------------------------

subroutine interpo_search_1dd( x, point, i, undeff, stdopt )
  ! ǿ뤴Ȥͤ礭ʤˤΤʤ,
  ! point ֹϤ.
  implicit none
  double precision, intent(in) :: x(:)  ! 
  double precision, intent(in) :: point  ! 
  integer, intent(inout) :: i  ! point ͤۤʤֹͤ
  integer, intent(in), optional :: undeff  ! õϰϤǤ꾮ͤõ褦Ȥ, undef ֤,  undef ͤꤹ. default Ǥ 0.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  integer :: nx, j
  integer :: just
  logical :: stderr

  nx=size(x)
  if(present(undeff))then
     just=undeff
  else
     just=0
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(x(1)>point)then

     if(stderr.eqv..false.)then
        write(*,*) "****** WARNING ******"
        write(*,*) "searching point was not found :", x(1), point
        write(*,*) "Abort. Exit.!!!"
     end if
     i=just

  else

     do j=1,nx
        if(x(j)<=point)then
           i=j
        else
           exit
        end if
     end do

  end if

end subroutine interpo_search_1dd


subroutine interpo_search_2df( x, y, pointx, pointy, i, j, undeff, stdopt )
  ! ǿ뤴Ȥͤ礭ʤˤΤʤ,
  ! point ֹϤ.
  implicit none
  real, intent(in) :: x(:)  !  x
  real, intent(in) :: y(:)  !  y
  real, intent(in) :: pointx  !  x
  real, intent(in) :: pointy  !  y
  integer, intent(inout) :: i  ! pointx ͤۤʤֹͤ
  integer, intent(inout) :: j  ! pointy ͤۤʤֹͤ
  integer, intent(in), optional :: undeff  ! õϰϤǤ꾮ͤõ褦Ȥ, undef ֤,  undef ͤꤹ. default Ǥ 0.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
  integer :: just
  logical :: stderr

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(undeff))then
     just=undeff
     call interpo_search_1df( x, pointx, i, just, stdopt=stderr )
     call interpo_search_1df( y, pointy, j, just, stdopt=stderr )
  else
     call interpo_search_1df( x, pointx, i, stdopt=stderr )
     call interpo_search_1df( y, pointy, j, stdopt=stderr )
  end if

end subroutine interpo_search_2df


subroutine interpo_search_2dd( x, y, pointx, pointy, i, j, undeff, stdopt )
  ! ǿ뤴Ȥͤ礭ʤˤΤʤ,
  ! point ֹϤ.
  implicit none
  double precision, intent(in) :: x(:)  !  x
  double precision, intent(in) :: y(:)  !  y
  double precision, intent(in) :: pointx  !  x
  double precision, intent(in) :: pointy  !  y
  integer, intent(inout) :: i  ! pointx ͤۤʤֹͤ
  integer, intent(inout) :: j  ! pointy ͤۤʤֹͤ
  integer, intent(in), optional :: undeff  ! õϰϤǤ꾮ͤõ褦Ȥ, undef ֤,  undef ͤꤹ. default Ǥ 0.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
  integer :: just
  logical :: stderr

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(undeff))then
     just=undeff
     call interpo_search_1dd( x, pointx, i, just, stdopt=stderr )
     call interpo_search_1dd( y, pointy, j, just, stdopt=stderr )
  else
     call interpo_search_1dd( x, pointx, i, stdopt=stderr )
     call interpo_search_1dd( y, pointy, j, stdopt=stderr )
  end if

end subroutine interpo_search_2dd


subroutine interpo_search_3df( x, y, z, pointx, pointy, pointz, i, j, k,  &
  &                            undeff, stdopt )
  ! ǿ뤴Ȥͤ礭ʤˤΤʤ,
  ! point ֹϤ.
  implicit none
  real, intent(in) :: x(:)  !  x
  real, intent(in) :: y(:)  !  y
  real, intent(in) :: z(:)  !  z
  real, intent(in) :: pointx  !  x
  real, intent(in) :: pointy  !  y
  real, intent(in) :: pointz  !  z
  integer, intent(inout) :: i  ! pointx ͤۤʤֹͤ
  integer, intent(inout) :: j  ! pointy ͤۤʤֹͤ
  integer, intent(inout) :: k  ! pointz ͤۤʤֹͤ
  integer, intent(in), optional :: undeff  ! õϰϤǤ꾮ͤõ褦Ȥ, undef ֤,  undef ͤꤹ. default Ǥ 0.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
  integer :: just
  logical :: stderr

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(undeff))then
     just=int(undeff)
     call interpo_search_1df( x, pointx, i, just, stdopt=stderr )
     call interpo_search_1df( y, pointy, j, just, stdopt=stderr )
     call interpo_search_1df( z, pointz, k, just, stdopt=stderr )
  else
     call interpo_search_1df( x, pointx, i, stdopt=stderr )
     call interpo_search_1df( y, pointy, j, stdopt=stderr )
     call interpo_search_1df( z, pointz, k, stdopt=stderr )
  end if

end subroutine interpo_search_3df


subroutine interpo_search_3dd( x, y, z, pointx, pointy, pointz, i, j, k,  &
  &                            undeff, stdopt )
  ! ǿ뤴Ȥͤ礭ʤˤΤʤ,
  ! point ֹϤ.
  implicit none
  double precision, intent(in) :: x(:)  !  x
  double precision, intent(in) :: y(:)  !  y
  double precision, intent(in) :: z(:)  !  z
  double precision, intent(in) :: pointx  !  x
  double precision, intent(in) :: pointy  !  y
  double precision, intent(in) :: pointz  !  z
  integer, intent(inout) :: i  ! pointx ͤۤʤֹͤ
  integer, intent(inout) :: j  ! pointy ͤۤʤֹͤ
  integer, intent(inout) :: k  ! pointz ͤۤʤֹͤ
  integer, intent(in), optional :: undeff  ! õϰϤǤ꾮ͤõ褦Ȥ, undef ֤,  undef ͤꤹ. default Ǥ 0.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
  integer :: just
  logical :: stderr

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(undeff))then
     just=int(undeff)
     call interpo_search_1dd( x, pointx, i, just, stdopt=stderr )
     call interpo_search_1dd( y, pointy, j, just, stdopt=stderr )
     call interpo_search_1dd( z, pointz, k, just, stdopt=stderr )
  else
     call interpo_search_1dd( x, pointx, i, stdopt=stderr )
     call interpo_search_1dd( y, pointy, j, stdopt=stderr )
     call interpo_search_1dd( z, pointz, k, stdopt=stderr )
  end if

end subroutine interpo_search_3dd

!---------------------------------------
!---------------------------------------

subroutine auto_interpo_search_1df( x, point, i, undeff, stdopt )
  ! ǿ뤴Ȥͤ礭ʤˤΤʤ,
  !  point ֹϤ.
  implicit none
  real, intent(in) :: x(:)  ! 
  real, intent(in) :: point(:)  ! ᤿ (ʣ)
  integer, intent(inout) :: i(size(point)) !  point ͤۤʤֹͤ
  integer, intent(in), optional :: undeff  ! õϰϤǤ꾮ͤõ褦Ȥ, undef ֤,  undef ͤꤹ. default Ǥ 0.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  integer :: nx, ni, j, icount, jcount
  integer :: just
  logical :: stderr

  nx=size(x)
  ni=size(point)

  if(present(undeff))then
     just=undeff
  else
     just=0
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

!-- Ϥ point Τɤ줯餤 x κͤ겼 (䤬ʤ)

  do j=1,ni
     if(x(1)>point(j))then
        if(stderr.eqv..false.)then
           write(*,*) "****** WARNING ******"
           write(*,*) "searching point was not found :", x(1), point(j)
           write(*,*) "Abort. Exit.!!!"
        end if
        i(j)=just
     else
        jcount=j
        exit
     end if
  end do

!-- jcount (point  x(1) ˺Ǥܤ)  x ˤĤƥ롼פ
!-- Ȥ򳫻Ϥ.

  icount=1

  do j=jcount,ni
     if(x(icount)<=point(j))then
        do while(x(icount)<=point(j))
           i(j)=icount
           icount=icount+1

           if(icount>nx)then
              i(j:ni)=nx
              exit
           end if
        end do
        icount=icount-1
     else
        icount=icount+1
     end if
  end do

end subroutine auto_interpo_search_1df

!---------------------------------------
!---------------------------------------

subroutine auto_interpo_search_1dd( x, point, i, undeff, stdopt )
  ! ǿ뤴Ȥͤ礭ʤˤΤʤ,
  !  point ֹϤ.
  implicit none
  double precision, intent(in) :: x(:)  ! 
  double precision, intent(in) :: point(:)  ! ᤿ (ʣ)
  integer, intent(inout) :: i(size(point)) !  point ͤۤʤֹͤ
  integer, intent(in), optional :: undeff  ! õϰϤǤ꾮ͤõ褦Ȥ, undef ֤,  undef ͤꤹ. default Ǥ 0.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
                                           ! default Ǥ .false. (ɽ)
  integer :: nx, ni, j, icount, jcount
  integer :: just
  logical :: stderr

  nx=size(x)
  ni=size(point)

  if(present(undeff))then
     just=undeff
  else
     just=0
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

!-- Ϥ point Τɤ줯餤 x κͤ겼 (䤬ʤ)

  do j=1,ni
     if(x(1)>point(j))then
        if(stderr.eqv..false.)then
           write(*,*) "****** WARNING ******"
           write(*,*) "searching point was not found :", x(1), point(j)
           write(*,*) "Abort. Exit.!!!"
        end if
        i(j)=just
     else
        jcount=j
        exit
     end if
  end do

!-- jcount (point  x(1) ˺Ǥܤ)  x ˤĤƥ롼פ
!-- Ȥ򳫻Ϥ.

  icount=1

  do j=jcount,ni
     if(x(icount)<=point(j))then
        do while(x(icount)<=point(j))
           i(j)=icount
           icount=icount+1

           if(icount>nx)then
              i(j:ni)=nx
              exit
           end if
        end do
        icount=icount-1
     else
        icount=icount+1
     end if
  end do

end subroutine auto_interpo_search_1dd

!---------------------------------------
!---------------------------------------

subroutine auto_interpo_search_2df( x, y, pointx, pointy, i, j, undeff, stdopt )
  ! ǿ뤴Ȥͤ礭ʤˤΤʤ,
  ! pointx, pointy ֹϤ.
  implicit none
  real, intent(in) :: x(:)  !  x
  real, intent(in) :: y(:)  !  y
  real, intent(in) :: pointx(:)  ! x ˤĤƤΰ֤᤿
  real, intent(in) :: pointy(:)  ! y ˤĤƤΰ֤᤿
  integer, intent(inout) :: i(size(pointx))  ! pointx ͤۤʤֹͤ
  integer, intent(inout) :: j(size(pointy))  ! pointy ͤۤʤֹͤ
  integer, intent(in), optional :: undeff  ! õϰϤǤ꾮ͤõ褦Ȥ, undef ֤,  undef ͤꤹ. default Ǥ 0.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
  integer :: just
  logical :: stderr

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(undeff))then
     just=undeff
     call auto_interpo_search_1df( x, pointx, i, just, stdopt=stderr )
     call auto_interpo_search_1df( y, pointy, j, just, stdopt=stderr )
  else
     call auto_interpo_search_1df( x, pointx, i, stdopt=stderr )
     call auto_interpo_search_1df( y, pointy, j, stdopt=stderr )
  end if

end subroutine auto_interpo_search_2df

!---------------------------------------
!---------------------------------------

subroutine auto_interpo_search_2dd( x, y, pointx, pointy, i, j, undeff, stdopt )
  ! ǿ뤴Ȥͤ礭ʤˤΤʤ,
  ! pointx, pointy ֹϤ.
  implicit none
  double precision, intent(in) :: x(:)  !  x
  double precision, intent(in) :: y(:)  !  y
  double precision, intent(in) :: pointx(:)  ! x ˤĤƤΰ֤᤿
  double precision, intent(in) :: pointy(:)  ! y ˤĤƤΰ֤᤿
  integer, intent(inout) :: i(size(pointx))  ! pointx ͤۤʤֹͤ
  integer, intent(inout) :: j(size(pointy))  ! pointy ͤۤʤֹͤ
  integer, intent(in), optional :: undeff  ! õϰϤǤ꾮ͤõ褦Ȥ, undef ֤,  undef ͤꤹ. default Ǥ 0.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
  integer :: just
  logical :: stderr

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(undeff))then
     just=undeff
     call auto_interpo_search_1dd( x, pointx, i, just, stdopt=stderr )
     call auto_interpo_search_1dd( y, pointy, j, just, stdopt=stderr )
  else
     call auto_interpo_search_1dd( x, pointx, i, stdopt=stderr )
     call auto_interpo_search_1dd( y, pointy, j, stdopt=stderr )
  end if

end subroutine auto_interpo_search_2dd

!---------------------------------------
!---------------------------------------

subroutine auto_interpo_search_3df( x, y, z, pointx, pointy, pointz, i, j, k,  &
  &                                 undeff, stdopt )
  ! ǿ뤴Ȥͤ礭ʤˤΤʤ,
  ! point ֹϤ.
  implicit none
  real, intent(in) :: x(:)  !  x
  real, intent(in) :: y(:)  !  y
  real, intent(in) :: z(:)  !  z
  real, intent(in) :: pointx(:)  ! x ˤĤƤΰ֤᤿
  real, intent(in) :: pointy(:)  ! y ˤĤƤΰ֤᤿
  real, intent(in) :: pointz(:)  ! z ˤĤƤΰ֤᤿
  integer, intent(inout) :: i(size(pointx))  ! pointx ͤۤʤֹͤ
  integer, intent(inout) :: j(size(pointy))  ! pointy ͤۤʤֹͤ
  integer, intent(inout) :: k(size(pointz))  ! pointz ͤۤʤֹͤ
  integer, intent(in), optional :: undeff  ! õϰϤǤ꾮ͤõ褦Ȥ, undef ֤,  undef ͤꤹ. default Ǥ 0.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
  integer :: just
  logical :: stderr

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(undeff))then
     just=int(undeff)
     call auto_interpo_search_1df( x, pointx, i, just, stdopt=stderr )
     call auto_interpo_search_1df( y, pointy, j, just, stdopt=stderr )
     call auto_interpo_search_1df( z, pointz, k, just, stdopt=stderr )
  else
     call auto_interpo_search_1df( x, pointx, i, stdopt=stderr )
     call auto_interpo_search_1df( y, pointy, j, stdopt=stderr )
     call auto_interpo_search_1df( z, pointz, k, stdopt=stderr )
  end if

end subroutine auto_interpo_search_3df

!---------------------------------------
!---------------------------------------

subroutine auto_interpo_search_3dd( x, y, z, pointx, pointy, pointz, i, j, k,  &
  &                                 undeff, stdopt )
  ! ǿ뤴Ȥͤ礭ʤˤΤʤ,
  ! point ֹϤ.
  implicit none
  double precision, intent(in) :: x(:)  !  x
  double precision, intent(in) :: y(:)  !  y
  double precision, intent(in) :: z(:)  !  z
  double precision, intent(in) :: pointx(:)  ! x ˤĤƤΰ֤᤿
  double precision, intent(in) :: pointy(:)  ! y ˤĤƤΰ֤᤿
  double precision, intent(in) :: pointz(:)  ! z ˤĤƤΰ֤᤿
  integer, intent(inout) :: i(size(pointx))  ! pointx ͤۤʤֹͤ
  integer, intent(inout) :: j(size(pointy))  ! pointy ͤۤʤֹͤ
  integer, intent(inout) :: k(size(pointz))  ! pointz ͤۤʤֹͤ
  integer, intent(in), optional :: undeff  ! õϰϤǤ꾮ͤõ褦Ȥ, undef ֤,  undef ͤꤹ. default Ǥ 0.
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
  integer :: just
  logical :: stderr

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(undeff))then
     just=int(undeff)
     call auto_interpo_search_1dd( x, pointx, i, just, stdopt=stderr )
     call auto_interpo_search_1dd( y, pointy, j, just, stdopt=stderr )
     call auto_interpo_search_1dd( z, pointz, k, just, stdopt=stderr )
  else
     call auto_interpo_search_1dd( x, pointx, i, stdopt=stderr )
     call auto_interpo_search_1dd( y, pointy, j, stdopt=stderr )
     call auto_interpo_search_1dd( z, pointz, k, stdopt=stderr )
  end if

end subroutine auto_interpo_search_3dd

!---------------------------------------
!---------------------------------------

subroutine interpolation_1df( x, y, point, val, h, hp )
  ! 1 ޥ롼
  implicit none
  real, intent(in) :: x(2)  ! κü
  real, intent(in) :: y(2)  ! x Ƥ
  real, intent(in) :: point  ! 
  real, intent(inout) :: val  ! Ǥ
  real, intent(in), optional :: h(2)  ! κǤΥ
  real, intent(in), optional :: hp  ! ǤΥ
  real :: fd, dt
  real :: tmin
  real :: tmax
  real :: xmin
  real :: xmax

  if(present(h))then
     tmin=x(1)*h(1)
     tmax=x(2)*h(2)
  else
     tmin=x(1)
     tmax=x(2)
  end if

  xmin=y(1)
  xmax=y(2)

  if(present(hp))then
     dt=hp*point-tmin
  else
     dt=point-tmin
  end if

  fd=(xmax-xmin)/(tmax-tmin)

  val=xmin+dt*fd

end subroutine interpolation_1df


subroutine interpolation_1dd( x, y, point, val, h, hp )
  ! 1 ޥ롼
  implicit none
  double precision, intent(in) :: x(2)  ! κü
  double precision, intent(in) :: y(2)  ! x Ƥ
  double precision, intent(in) :: point  ! 
  double precision, intent(inout) :: val  ! Ǥ
  double precision, intent(in), optional :: h(2)  ! κǤΥ
  double precision, intent(in), optional :: hp  ! ǤΥ
  double precision :: fd, dt
  double precision :: tmin
  double precision :: tmax
  double precision :: xmin
  double precision :: xmax

  if(present(h))then
     tmin=x(1)*h(1)
     tmax=x(2)*h(2)
  else
     tmin=x(1)
     tmax=x(2)
  end if

  xmin=y(1)
  xmax=y(2)

  if(present(hp))then
     dt=hp*point-tmin
  else
     dt=point-tmin
  end if

  fd=(xmax-xmin)/(tmax-tmin)

  val=xmin+dt*fd

end subroutine interpolation_1dd


subroutine interpolation_2df( x, y, z, point, val, h, hp )
  ! 2 νޥ롼
  ! ܥ롼ľľɸ֤ǤΤ߻Ѳǽ.
  implicit none
  real, intent(in) :: x(2)  ! ޤζ x κü
  real, intent(in) :: y(2)  ! ޤζ y κü
  real, intent(in) :: z(2,2)  ! x, y ǤγǤ, (i,j) ˤĤ, i<=x, j<=y
  real, intent(in) :: point(2)  !  point(1)<=x ɸ, point(2)<=y ɸ
  real, intent(inout) :: val  ! Ǥ
  real, intent(in), optional :: h(2,2)  ! λͶǤΥ
  real, intent(in), optional :: hp(2)  ! ǤΥ
  real :: valx(2)

  if(present(h))then
     ! y(1) Ǥ x Ǥ
     call interpolation_1df( x, (/z(1,1), z(2,1)/), point(1), valx(1),  &
  &                          (/h(1,1), h(2,1)/), hp(1) )

     ! y(2) Ǥ x Ǥ
     call interpolation_1df( x, (/z(1,2), z(2,2)/), point(1), valx(2),  &
  &                          (/h(1,2), h(2,2)/), hp(1) )
   
     ! x  y Ǥ(줬)
     call interpolation_1df( y, valx, point(2), val, (/h(1,1), h(1,2)/), hp(2) )
  else
     ! y(1) Ǥ x Ǥ
     call interpolation_1df( x, (/z(1,1), z(2,1)/), point(1), valx(1) )

     ! y(2) Ǥ x Ǥ
     call interpolation_1df( x, (/z(1,2), z(2,2)/), point(1), valx(2) )
   
     ! x  y Ǥ(줬)
     call interpolation_1df( y, valx, point(2), val )
  end if

end subroutine interpolation_2df


subroutine interpolation_2dd( x, y, z, point, val, h, hp )
  ! 2 νޥ롼
  ! ܥ롼ľľɸ֤ǤΤ߻Ѳǽ.
  implicit none
  double precision, intent(in) :: x(2)  ! ޤζ x κü
  double precision, intent(in) :: y(2)  ! ޤζ y κü
  double precision, intent(in) :: z(2,2)  ! x, y ǤγǤ, (i,j) ˤĤ, i<=x, j<=y
  double precision, intent(in) :: point(2)  !  point(1)<=x ɸ, point(2)<=y ɸ
  double precision, intent(inout) :: val  ! Ǥ
  double precision, intent(in), optional :: h(2,2)  ! λͶǤΥ
  double precision, intent(in), optional :: hp(2)  ! ǤΥ
  double precision :: valx(2)

  if(present(h))then
     ! y(1) Ǥ x Ǥ
     call interpolation_1dd( x, (/z(1,1), z(2,1)/), point(1), valx(1),  &
  &                          (/h(1,1), h(2,1)/), hp(1) )

     ! y(2) Ǥ x Ǥ
     call interpolation_1dd( x, (/z(1,2), z(2,2)/), point(1), valx(2),  &
  &                          (/h(1,2), h(2,2)/), hp(1) )
   
     ! x  y Ǥ(줬)
     call interpolation_1dd( y, valx, point(2), val, (/h(1,1), h(1,2)/), hp(2) )
  else
     ! y(1) Ǥ x Ǥ
     call interpolation_1dd( x, (/z(1,1), z(2,1)/), point(1), valx(1) )

     ! y(2) Ǥ x Ǥ
     call interpolation_1dd( x, (/z(1,2), z(2,2)/), point(1), valx(2) )
   
     ! x  y Ǥ(줬)
     call interpolation_1dd( y, valx, point(2), val )
  end if

end subroutine interpolation_2dd


subroutine interpolation_3df( x, y, z, u, point, val, h, hp )
  ! 3 νޥ롼
  ! ܥ롼ľľɸ֤ǤΤ߻Ѳǽ.
  implicit none
  real, intent(in) :: x(2)  ! ޤζ x κü
  real, intent(in) :: y(2)  ! ޤζ y κü
  real, intent(in) :: z(2)  ! ޤζ z κü
  real, intent(in) :: u(2,2,2)  ! x, y, z ǤγǤ, (i,j,k) ˤĤ, i<=x, j<=y, k<=z
  real, intent(in) :: point(3)  !  point(1)<=x ɸ, point(2)<=y ɸ, point(3)<=z ɸ
  real, intent(inout) :: val  ! Ǥ
  real, intent(in), optional :: h(2,2,2)  ! ȬǤΥ
  real, intent(in), optional :: hp(3)  ! ǤΥ
  real :: valx(2)

  if(present(h))then
     ! z(1) Ǥ x-y ʿ̤Ǥνޤ
     call interpolation_2df( x, y, u(:,:,1), point(1:2), valx(1),  &
  &                          h(:,:,1), hp(1:2) )
   
     ! z(2) Ǥ x Ǥ
     call interpolation_2df( x, y, u(:,:,2), point(1:2), valx(2),  &
  &                          h(:,:,2), hp(1:2) )
   
     ! z(1)  z Ǥ(줬)
     call interpolation_1df( z, valx, point(3), val, h(1,1,:), hp(3) )
  else
     ! z(1) Ǥ x-y ʿ̤Ǥνޤ
     call interpolation_2df( x, y, u(:,:,1), point(1:2), valx(1) )
   
     ! z(2) Ǥ x Ǥ
     call interpolation_2df( x, y, u(:,:,2), point(1:2), valx(2) )
   
     ! z(1)  z Ǥ(줬)
     call interpolation_1df( (/z(1), z(2)/), (/valx(1), valx(2)/), point(3), val )
  end if

end subroutine interpolation_3df


subroutine interpolation_3dd( x, y, z, u, point, val, h, hp )
  ! 3 νޥ롼
  ! ܥ롼ľľɸ֤ǤΤ߻Ѳǽ.
  implicit none
  double precision, intent(in) :: x(2)  ! ޤζ x κü
  double precision, intent(in) :: y(2)  ! ޤζ y κü
  double precision, intent(in) :: z(2)  ! ޤζ z κü
  double precision, intent(in) :: u(2,2,2)  ! x, y, z ǤγǤ, (i,j,k) ˤĤ, i<=x, j<=y, k<=z
  double precision, intent(in) :: point(3)  !  point(1)<=x ɸ, point(2)<=y ɸ, point(3)<=z ɸ
  double precision, intent(inout) :: val  ! Ǥ
  double precision, intent(in), optional :: h(2,2,2)  ! ȬǤΥ
  double precision, intent(in), optional :: hp(3)  ! ǤΥ
  double precision :: valx(2)

  if(present(h))then
     ! z(1) Ǥ x-y ʿ̤Ǥνޤ
     call interpolation_2dd( x, y, u(:,:,1), point(1:2), valx(1),  &
  &                          h(:,:,1), hp(1:2) )
   
     ! z(2) Ǥ x Ǥ
     call interpolation_2dd( x, y, u(:,:,2), point(1:2), valx(2),  &
  &                          h(:,:,2), hp(1:2) )
   
     ! z(1)  z Ǥ(줬)
     call interpolation_1dd( z, valx, point(3), val, h(1,1,:), hp(3) )
  else
     ! z(1) Ǥ x-y ʿ̤Ǥνޤ
     call interpolation_2dd( x, y, u(:,:,1), point(1:2), valx(1) )
   
     ! z(2) Ǥ x Ǥ
     call interpolation_2dd( x, y, u(:,:,2), point(1:2), valx(2) )
   
     ! z(1)  z Ǥ(줬)
     call interpolation_1dd( (/z(1), z(2)/), (/valx(1), valx(2)/), point(3), val )
  end if

end subroutine interpolation_3dd

!------------------------------------
!------------------------------------

subroutine interpo_undef_1df( x, undef, u )
  ! ɸ x Ƥǡ u  undef ,
  ! ܤͤäʻҤΥǡޤԤ.
  ! ܳʻҤʤγޤϹԤʤ.
  implicit none
  real, intent(in) :: x(:)  ! ɸ
  real, intent(in) :: undef  ! ̤
  real, intent(inout) :: u(size(x))  ! ǡ

  integer :: i, j, nx, counts, counte
  integer :: ns(size(x)), ne(size(x))
  integer, allocatable, dimension(:) :: nt
  real :: du

  nx=size(x)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nx, u ),  &
  &                                     "interpo_undef_1d" )
  end if

  counts=0
  counte=0

  if(u(1)==undef)then
     if(u(2)==undef)then
        counte=-1
     end if
  end if
  if(u(nx)==undef)then
     if(u(nx-1)==undef)then
        counts=-1
     end if
  end if

  do i=2,nx-1
     if(u(i)==undef)then
        if(u(i+1)/=undef)then
           counte=counte+1
           if(counte>0)then
              ne(counte)=i
           end if
        end if
     end if
  end do

  do i=nx-1,2,-1
     if(u(i)==undef)then
        if(u(i-1)/=undef)then
           counts=counts+1
           if(counts>0)then
              ns(counts)=i
           end if
        end if
     end if
  end do

  !-- ns loop is opposite, so ns order reverse.

  if(counts>0)then
     allocate(nt(counts))
     do i=1,counts
        nt(i)=ns(counts-i+1)
     end do
     do i=1,counts
        ns(i)=nt(i)
     end do
  end if

  if(counts>0.and.counte>0)then
     do i=1,counts
        du=(u(ne(i)+1)-u(ns(i)-1))/(x(ne(i)+1)-x(ns(i)-1))
        do j=ns(i),ne(i)
           u(j)=u(j-1)+du*(x(j)-x(j-1))
        end do
     end do
  end if

end subroutine interpo_undef_1df

!------------------------------------
!------------------------------------

subroutine interpo_undef_1dd( x, undef, u )
  ! ɸ x Ƥǡ u  undef ,
  ! ܤͤäʻҤΥǡޤԤ.
  ! ܳʻҤʤγޤϹԤʤ.
  implicit none
  double precision, intent(in) :: x(:)  ! ɸ
  double precision, intent(in) :: undef  ! ̤
  double precision, intent(inout) :: u(size(x))  ! ǡ

  integer :: i, j, nx, counts, counte
  integer :: ns(size(x)), ne(size(x))
  integer, allocatable, dimension(:) :: nt
  double precision :: du

  nx=size(x)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nx, u ),  &
  &                                     "interpo_undef_1d" )
  end if

  counts=0
  counte=0

  if(u(1)==undef)then
     if(u(2)==undef)then
        counte=-1
     end if
  end if
  if(u(nx)==undef)then
     if(u(nx-1)==undef)then
        counts=-1
     end if
  end if

  do i=2,nx-1
     if(u(i)==undef)then
        if(u(i+1)/=undef)then
           counte=counte+1
           if(counte>0)then
              ne(counte)=i
           end if
        end if
     end if
  end do

  do i=nx-1,2,-1
     if(u(i)==undef)then
        if(u(i-1)/=undef)then
           counts=counts+1
           if(counts>0)then
              ns(counts)=i
           end if
        end if
     end if
  end do

  !-- ns loop is opposite, so ns order reverse.

  if(counts>0)then
     allocate(nt(counts))
     do i=1,counts
        nt(i)=ns(counts-i+1)
     end do
     do i=1,counts
        ns(i)=nt(i)
     end do
  end if

  if(counts>0.and.counte>0)then
     do i=1,counts
        du=(u(ne(i)+1)-u(ns(i)-1))/(x(ne(i)+1)-x(ns(i)-1))
        do j=ns(i),ne(i)
           u(j)=u(j-1)+du*(x(j)-x(j-1))
        end do
     end do
  end if

end subroutine interpo_undef_1dd

!------------------------------------
!------------------------------------

subroutine auto_interpolation_1df( x, r, u, v, undef, undefr, stdopt, extopt )
  ! ɸ x Ƥǡ u 
  ! ɸ r ǡ v ˼ưޤ.
  implicit none
  real, intent(in) :: x(:)  ! ɸ
  real, intent(in) :: r(:)  ! ޺ɸ
  real, intent(in) :: u(size(x))  ! ǡ
  real, intent(inout) :: v(size(r))  ! ޤǡ
  real, intent(in), optional :: undef  ! ̤
  real, intent(in), optional :: undefr  ! ΰǤ̤.
        !  undefr ʤ,  undefr 
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
  logical, intent(in), optional :: extopt  ! õϰϳξ, ǡΤǶͤ򥳥ԡ.
                                           ! ǥեȤǤϥԡʤ .false.
  integer :: ir(size(r))
  integer :: i, nx, nr
  real :: defun
  real :: rdefun
  logical :: stderr, extra

  nx=size(x)
  nr=size(r)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nx, u ),  &
  &                                     "auto_interpolation_1d" )
     call check_array_size_dmp_message( check_array_size_1d( nr, v ),  &
  &                                     "auto_interpolation_1d" )
  end if

  if(present(undef))then
     defun=undef
  else
     defun=-999.0
  end if

  if(present(undefr))then
     rdefun=undefr
  else
     rdefun=-999.0
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(extopt))then
     extra=extopt
  else
     extra=.false.
  end if

  call auto_interpo_search_1df( x, r, ir, undeff=0, stdopt=stderr )

  do i=1, nr
     if(ir(i)/=0)then
        if(ir(i)<nx)then
           if(u(ir(i))/=rdefun.and.u(ir(i)+1)/=rdefun)then
              call interpolation_1df( x(ir(i):ir(i)+1),  &
  &                                   u(ir(i):ir(i)+1), r(i), v(i) )
           else
              v(i)=rdefun
           end if
        else if(ir(i)==nx.and.x(nx)==r(i))then
           v(i)=u(ir(i))
        else
           if(extra.eqv..true.)then
              v(i)=u(nx)
           else
              v(i)=defun
           end if
        end if
     else
        if(extra.eqv..true.)then
           v(i)=u(1)
        else
           v(i)=defun
        end if
     end if
  end do

end subroutine auto_interpolation_1df

!------------------------------------
!------------------------------------

subroutine auto_interpolation_1dd( x, r, u, v, undef, undefr, stdopt, extopt )
  ! ɸ x Ƥǡ u 
  ! ɸ r ǡ v ˼ưޤ.
  implicit none
  double precision, intent(in) :: x(:)  ! ɸ
  double precision, intent(in) :: r(:)  ! ޺ɸ
  double precision, intent(in) :: u(size(x))  ! ǡ
  double precision, intent(inout) :: v(size(r))  ! ޤǡ
  double precision, intent(in), optional :: undef  ! ̤
  double precision, intent(in), optional :: undefr  ! ΰǤ̤.
        !  undefr ʤ,  undefr 
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
  logical, intent(in), optional :: extopt  ! õϰϳξ, ǡΤǶͤ򥳥ԡ.
                                           ! ǥեȤǤϥԡʤ .false.
  integer :: ir(size(r))
  integer :: i, nx, nr
  double precision :: defun
  double precision :: rdefun
  logical :: stderr, extra

  nx=size(x)
  nr=size(r)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nx, u ),  &
  &                                     "auto_interpolation_1d" )
     call check_array_size_dmp_message( check_array_size_1d( nr, v ),  &
  &                                     "auto_interpolation_1d" )
  end if

  if(present(undef))then
     defun=undef
  else
     defun=-999.0d0
  end if

  if(present(undefr))then
     rdefun=undefr
  else
     rdefun=-999.0d0
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(extopt))then
     extra=extopt
  else
     extra=.false.
  end if

  call auto_interpo_search_1dd( x, r, ir, undeff=0, stdopt=stderr )

  do i=1, nr
     if(ir(i)/=0)then
        if(ir(i)<nx)then
           if(u(ir(i))/=rdefun.and.u(ir(i)+1)/=rdefun)then
              call interpolation_1dd( x(ir(i):ir(i)+1),  &
  &                                   u(ir(i):ir(i)+1), r(i), v(i) )
           else
              v(i)=rdefun
           end if
        else if(ir(i)==nx.and.x(nx)==r(i))then
           v(i)=u(ir(i))
        else
           if(extra.eqv..true.)then
              v(i)=u(nx)
           else
              v(i)=defun
           end if
        end if
     else
        if(extra.eqv..true.)then
           v(i)=u(1)
        else
           v(i)=defun
        end if
     end if
  end do

end subroutine auto_interpolation_1dd

!------------------------------------
!------------------------------------

subroutine auto_interpolation_2df( x, y, r, q, u, v, undef, undefr, stdopt,  &
  &                                extopt )
  ! ɸ x, y Ƥǡ u 
  ! ɸ r, q ǡ v ˼ưޤ.
  implicit none
  real, intent(in) :: x(:)  ! ɸ 1
  real, intent(in) :: y(:)  ! ɸ 2
  real, intent(in) :: r(:)  ! ޺ɸ 1
  real, intent(in) :: q(:)  ! ޺ɸ 2
  real, intent(in) :: u(size(x),size(y))  ! ǡ
  real, intent(inout) :: v(size(r),size(q))  ! ޤǡ
  real, intent(in), optional :: undef  ! ̤
  real, intent(in), optional :: undefr  ! ΰǤ̤.
        !  undefr ʤ,  undefr 
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
  logical, intent(in), optional :: extopt  ! õϰϳξ, ǡΤǶͤ򥳥ԡ.
                                           ! ǥեȤǤϥԡʤ .false.
  integer :: ir(size(r)), iq(size(q))
  integer :: i, j, nx, ny, nr, nq
  real :: defun
  real :: rdefun
  logical :: stderr, extra

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nq=size(q)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, u ),  &
  &                                     "auto_interpolation_2d" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nq, v ),  &
  &                                     "auto_interpolation_2d" )
  end if

  if(present(undef))then
     defun=undef
  else
     defun=-999.0
  end if

  if(present(undefr))then
     rdefun=undefr
  else
     rdefun=-999.0
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(extopt))then
     extra=extopt
  else
     extra=.false.
  end if

  call auto_interpo_search_2df( x, y, r, q, ir, iq, undeff=0, stdopt=stderr )

  do j=1, nq
     do i=1, nr
        if(ir(i)/=0.and.iq(j)/=0)then
           if(u(ir(i),iq(j))/=rdefun)then
              if(ir(i)<nx.and.iq(j)<ny)then
                 if(u(ir(i),iq(j)+1)/=rdefun.and.  &
  &                 u(ir(i)+1,iq(j))/=rdefun.and.  &
  &                 u(ir(i)+1,iq(j)+1)/=rdefun)then
                    call interpolation_2df( x(ir(i):ir(i)+1),  &
  &                                         y(iq(j):iq(j)+1),  &
  &                                         u(ir(i):ir(i)+1,iq(j):iq(j)+1),  &
  &                                         (/r(i), q(j)/), v(i,j) )
                 else
                    v(i,j)=rdefun
                 end if

              else if(x(nx)==r(i).and.y(ny)==q(j))then
                 v(i,j)=u(nx,ny)

              else if(x(nx)==r(i).and.iq(j)<ny)then
                 if(u(nx,iq(j)+1)/=rdefun)then
                    call interpolation_1df( y(iq(j):iq(j)+1),  &
  &                                         u(nx,iq(j):iq(j)+1),  &
  &                                         q(j), v(i,j) )
                 else
                    v(i,j)=rdefun
                 end if

              else if(y(ny)==q(j).and.ir(i)<nx)then
                 if(u(ir(i)+1,ny)/=rdefun)then
                    call interpolation_1df( x(ir(i):ir(i)+1),  &
  &                                         u(ir(i):ir(i)+1,ny),  &
  &                                         r(i), v(i,j) )
                 else
                    v(i,j)=rdefun
                 end if
              else
                 if(extra.eqv..true.)then
                    if(ir(i)==nx.and.iq(j)==ny)then
                       v(i,j)=u(nx,ny)
                    else if(ir(i)==nx.and.iq(j)<ny)then
                       if(u(nx,iq(j))/=rdefun.and.u(nx,iq(j)+1)/=rdefun)then
                          call interpolation_1df( y(iq(j):iq(j)+1),  &
  &                                               u(nx,iq(j):iq(j)+1),  &
  &                                               q(j), v(i,j) )
                       else
                          v(i,j)=rdefun
                       end if
                    else if(ir(i)<nx.and.iq(j)==ny)then
                       if(u(ir(i),ny)/=rdefun.and.u(ir(i)+1,ny)/=rdefun)then
                          call interpolation_1df( x(ir(i):ir(i)+1),  &
  &                                               u(ir(i):ir(i)+1,ny),  &
  &                                               r(i), v(i,j) )
                       else
                          v(i,j)=rdefun
                       end if
                    end if
                 else
                    v(i,j)=defun
                 end if
              end if
           else
              v(i,j)=rdefun
           end if
        else
           if(extra.eqv..true.)then
              if(ir(i)==0.and.iq(j)==0)then
                 v(i,j)=u(1,1)
              else if(ir(i)==0.and.iq(j)/=0)then
                 if(u(1,iq(j))/=rdefun.and.u(1,iq(j)+1)/=rdefun)then
                    call interpolation_1df( y(iq(j):iq(j)+1),  &
  &                                         u(1,iq(j):iq(j)+1),  &
  &                                         q(j), v(i,j) )
                 else
                    v(i,j)=rdefun
                 end if
              else if(ir(i)/=0.and.iq(j)==0)then
                 if(u(ir(i),1)/=rdefun.and.u(ir(i)+1,1)/=rdefun)then
                    call interpolation_1df( x(ir(i):ir(i)+1),  &
  &                                         u(ir(i):ir(i)+1,1),  &
  &                                         r(i), v(i,j) )
                 else
                    v(i,j)=rdefun
                 end if
              end if
           else
              v(i,j)=defun
           end if
        end if
     end do
  end do

end subroutine auto_interpolation_2df

!------------------------------------
!------------------------------------

subroutine auto_interpolation_2dd( x, y, r, q, u, v, undef, undefr, stdopt,  &
  &                                extopt )
  ! ɸ x, y Ƥǡ u 
  ! ɸ r, q ǡ v ˼ưޤ.
  implicit none
  double precision, intent(in) :: x(:)  ! ɸ 1
  double precision, intent(in) :: y(:)  ! ɸ 2
  double precision, intent(in) :: r(:)  ! ޺ɸ 1
  double precision, intent(in) :: q(:)  ! ޺ɸ 2
  double precision, intent(in) :: u(size(x),size(y))  ! ǡ
  double precision, intent(inout) :: v(size(r),size(q))  ! ޤǡ
  double precision, intent(in), optional :: undef  ! ̤
  double precision, intent(in), optional :: undefr  ! ΰǤ̤.
        !  undefr ʤ,  undefr 
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
  logical, intent(in), optional :: extopt  ! õϰϳξ, ǡΤǶͤ򥳥ԡ.
                                           ! ǥեȤǤϥԡʤ .false.
  integer :: ir(size(r)), iq(size(q))
  integer :: i, j, nx, ny, nr, nq
  double precision :: defun
  double precision :: rdefun
  logical :: stderr, extra

  nx=size(x)
  ny=size(y)
  nr=size(r)
  nq=size(q)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, u ),  &
  &                                     "auto_interpolation_2d" )
     call check_array_size_dmp_message( check_array_size_2d( nr, nq, v ),  &
  &                                     "auto_interpolation_2d" )
  end if

  if(present(undef))then
     defun=undef
  else
     defun=-999.0d0
  end if

  if(present(undefr))then
     rdefun=undefr
  else
     rdefun=-999.0d0
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(extopt))then
     extra=extopt
  else
     extra=.false.
  end if

  call auto_interpo_search_2dd( x, y, r, q, ir, iq, undeff=0, stdopt=stderr )

  do j=1, nq
     do i=1, nr
        if(ir(i)/=0.and.iq(j)/=0)then
           if(u(ir(i),iq(j))/=rdefun)then
              if(ir(i)<nx.and.iq(j)<ny)then
                 if(u(ir(i),iq(j)+1)/=rdefun.and.  &
  &                 u(ir(i)+1,iq(j))/=rdefun.and.  &
  &                 u(ir(i)+1,iq(j)+1)/=rdefun)then
                    call interpolation_2dd( x(ir(i):ir(i)+1),  &
  &                                         y(iq(j):iq(j)+1),  &
  &                                         u(ir(i):ir(i)+1,iq(j):iq(j)+1),  &
  &                                         (/r(i), q(j)/), v(i,j) )
                 else
                    v(i,j)=rdefun
                 end if

              else if(x(nx)==r(i).and.y(ny)==q(j))then
                 v(i,j)=u(nx,ny)

              else if(x(nx)==r(i).and.iq(j)<ny)then
                 if(u(nx,iq(j)+1)/=rdefun)then
                    call interpolation_1dd( y(iq(j):iq(j)+1),  &
  &                                         u(nx,iq(j):iq(j)+1),  &
  &                                         q(j), v(i,j) )
                 else
                    v(i,j)=rdefun
                 end if

              else if(y(ny)==q(j).and.ir(i)<nx)then
                 if(u(ir(i)+1,ny)/=rdefun)then
                    call interpolation_1dd( x(ir(i):ir(i)+1),  &
  &                                         u(ir(i):ir(i)+1,ny),  &
  &                                         r(i), v(i,j) )
                 else
                    v(i,j)=rdefun
                 end if
              else
                 if(extra.eqv..true.)then
                    if(ir(i)==nx.and.iq(j)==ny)then
                       v(i,j)=u(nx,ny)
                    else if(ir(i)==nx.and.iq(j)<ny)then
                       if(u(nx,iq(j))/=rdefun.and.u(nx,iq(j)+1)/=rdefun)then
                          call interpolation_1dd( y(iq(j):iq(j)+1),  &
  &                                               u(nx,iq(j):iq(j)+1),  &
  &                                               q(j), v(i,j) )
                       else
                          v(i,j)=rdefun
                       end if
                    else if(ir(i)<nx.and.iq(j)==ny)then
                       if(u(ir(i),ny)/=rdefun.and.u(ir(i)+1,ny)/=rdefun)then
                          call interpolation_1dd( x(ir(i):ir(i)+1),  &
  &                                               u(ir(i):ir(i)+1,ny),  &
  &                                               r(i), v(i,j) )
                       else
                          v(i,j)=rdefun
                       end if
                    end if
                 else
                    v(i,j)=defun
                 end if
              end if
           else
              v(i,j)=rdefun
           end if
        else
           if(extra.eqv..true.)then
              if(ir(i)==0.and.iq(j)==0)then
                 v(i,j)=u(1,1)
              else if(ir(i)==0.and.iq(j)/=0)then
                 if(u(1,iq(j))/=rdefun.and.u(1,iq(j)+1)/=rdefun)then
                    call interpolation_1dd( y(iq(j):iq(j)+1),  &
  &                                         u(1,iq(j):iq(j)+1),  &
  &                                         q(j), v(i,j) )
                 else
                    v(i,j)=rdefun
                 end if
              else if(ir(i)/=0.and.iq(j)==0)then
                 if(u(ir(i),1)/=rdefun.and.u(ir(i)+1,1)/=rdefun)then
                    call interpolation_1dd( x(ir(i):ir(i)+1),  &
  &                                         u(ir(i):ir(i)+1,1),  &
  &                                         r(i), v(i,j) )
                 else
                    v(i,j)=rdefun
                 end if
              end if
           else
              v(i,j)=defun
           end if
        end if
     end do
  end do

end subroutine auto_interpolation_2dd

!------------------------------------
!------------------------------------

subroutine auto_interpolation_3df( x, y, z, r, q, p, u, v, undef, undefr,  &
  &                                stdopt, extopt )
  ! ɸ x, y, z Ƥǡ u 
  ! ɸ r, q, p ǡ v ˼ưޤ.
  implicit none
  real, intent(in) :: x(:)  ! ɸ 1
  real, intent(in) :: y(:)  ! ɸ 2
  real, intent(in) :: z(:)  ! ɸ 3
  real, intent(in) :: r(:)  ! ޺ɸ 1
  real, intent(in) :: q(:)  ! ޺ɸ 2
  real, intent(in) :: p(:)  ! ޺ɸ 3
  real, intent(in) :: u(size(x),size(y),size(z))  ! ǡ
  real, intent(inout) :: v(size(r),size(q),size(p))  ! ޤǡ
  real, intent(in), optional :: undef  ! ̤
  real, intent(in), optional :: undefr  ! ΰǤ̤.
        !  undefr ʤ,  undefr 
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
  logical, intent(in), optional :: extopt  ! õϰϳξ, ǡΤǶͤ򥳥ԡ.
                                           ! ǥեȤǤϥԡʤ .false.
  integer :: ir(size(r)), iq(size(q)), ip(size(p))
  integer :: i, j, k, nx, ny, nz, nr, nq, np
  real :: defun
  real :: rdefun
  logical :: stderr, extra

  nx=size(x)
  ny=size(y)
  nz=size(z)
  nr=size(r)
  nq=size(q)
  np=size(p)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, u ),  &
  &                                     "auto_interpolation_3d" )
     call check_array_size_dmp_message( check_array_size_3d( nr, nq, np, v ),  &
  &                                     "auto_interpolation_3d" )
  end if

  if(present(undef))then
     defun=undef
  else
     defun=-999.0
  end if

  if(present(undefr))then
     rdefun=undefr
  else
     rdefun=-999.0
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(extopt))then
     extra=extopt
  else
     extra=.false.
  end if

  call auto_interpo_search_3df( x, y, z, r, q, p, ir, iq, ip,  &
  &                             undeff=0, stdopt=stderr )

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j,k)

  do k=1, np
     do j=1, nq
        do i=1, nr
           if(ir(i)/=0.and.iq(j)/=0.and.ip(k)/=0)then
              if(u(ir(i),iq(j),ip(k))/=rdefun)then
                 if(ir(i)<nx.and.iq(j)<ny.and.ip(k)<nz)then
                    if(u(ir(i)+1,iq(j),ip(k))/=rdefun.and.  &
  &                    u(ir(i),iq(j)+1,ip(k))/=rdefun.and.  &
  &                    u(ir(i)+1,iq(j)+1,ip(k))/=rdefun.and.  &
  &                    u(ir(i),iq(j),ip(k)+1)/=rdefun.and.  &
  &                    u(ir(i)+1,iq(j),ip(k)+1)/=rdefun.and.  &
  &                    u(ir(i),iq(j)+1,ip(k)+1)/=rdefun.and.  &
  &                    u(ir(i)+1,iq(j)+1,ip(k)+1)/=rdefun)then
                       call interpolation_3df( x(ir(i):ir(i)+1),  &
  &                                            y(iq(j):iq(j)+1),  &
  &                                            z(ip(k):ip(k)+1),  &
  &                                            u(ir(i):ir(i)+1,iq(j):iq(j)+1,ip(k):ip(k)+1),  &
  &                                            (/r(i), q(j), p(k)/), v(i,j,k) )
                    else
                       v(i,j,k)=rdefun
                    end if

                 else if(x(nx)==r(i).and.y(ny)==q(j).and.z(nz)==p(k))then
                    v(i,j,k)=u(ir(i),iq(j),ip(k))

                 else if(x(nx)==r(i).and.iq(j)<ny.and.ip(k)<nz)then
                    if(u(nx,iq(j)+1,ip(k))/=rdefun.and.u(nx,iq(j),ip(k)+1)/=rdefun.and.  &
  &                    u(nx,iq(j)+1,ip(k)+1)/=rdefun)then
                       call interpolation_2df( y(iq(j):iq(j)+1),  &
  &                                            z(ip(k):ip(k)+1),  &
  &                                            u(nx,iq(j):iq(j)+1,ip(k):ip(k)+1),  &
  &                                            (/q(j), p(k)/), v(i,j,k) )
                    else
                       v(i,j,k)=rdefun
                    end if

                 else if(y(ny)==q(j).and.ir(i)<nx.and.ip(k)<nz)then
                    if(u(ir(i)+1,ny,ip(k))/=rdefun.and.u(ir(i),ny,ip(k)+1)/=rdefun.and.  &
  &                    u(ir(i)+1,ny,ip(k)+1)/=rdefun)then
                       call interpolation_2df( x(ir(i):ir(i)+1),  &
  &                                            z(ip(k):ip(k)+1),  &
  &                                            u(ir(i):ir(i)+1,ny,ip(k):ip(k)+1),  &
  &                                            (/r(i), p(k)/), v(i,j,k) )
                    else
                       v(i,j,k)=rdefun
                    end if

                 else if(z(nz)==p(k).and.ir(i)<nx.and.iq(j)<ny)then
                    if(u(ir(i)+1,iq(j),nz)/=rdefun.and.u(ir(i),iq(j)+1,nz)/=rdefun.and.  &
  &                    u(ir(i)+1,iq(j)+1,nz)/=rdefun)then
                       call interpolation_2df( x(ir(i):ir(i)+1),  &
  &                                            y(iq(j):iq(j)+1),  &
  &                                            u(ir(i):ir(i)+1,iq(j):iq(j)+1,nz),  &
  &                                            (/r(i), q(j)/), v(i,j,k) )
                    else
                       v(i,j,k)=rdefun
                    end if

                 else if(x(nx)==r(i).and.y(ny)==q(j).and.ip(k)<nz)then
                    if(u(nx,ny,ip(k)+1)/=rdefun)then
                       call interpolation_1df( z(ip(k):ip(k)+1),  &
  &                                            u(nx,ny,ip(k):ip(k)+1),  &
  &                                            p(k), v(i,j,k) )
                    else
                       v(i,j,k)=rdefun
                    end if

                 else if(x(nx)==r(i).and.z(nz)==p(k).and.iq(j)<ny)then
                    if(u(nx,iq(j)+1,nz)/=rdefun)then
                       call interpolation_1df( y(iq(j):iq(j)+1),  &
  &                                            u(nx,iq(j):iq(j)+1,nz),  &
  &                                            q(j), v(i,j,k) )
                    else
                       v(i,j,k)=rdefun
                    end if

                 else if(y(ny)==q(j).and.z(nz)==p(k).and.ir(i)<nx)then
                    if(u(ir(i)+1,ny,nz)/=rdefun)then
                       call interpolation_1df( x(ir(i):ir(i)+1),  &
  &                                            u(ir(i):ir(i)+1,ny,nz),  &
  &                                            r(i), v(i,j,k) )
                    else
                       v(i,j,k)=rdefun
                    end if

                 else

                    if(extra.eqv..true.)then    ! ʲ, ̤ if ʸ (1,1,1) Ϥʤ.
                       if(ir(i)==nx)then
                          if(iq(j)==ny)then
                             if(ip(k)==nz)then   ! (0,0,0)
                                v(i,j,k)=u(nx,ny,nz)
                             else               ! (0,0,1)
                                if(u(nx,ny,ip(k))/=rdefun.and.  &
  &                                u(nx,ny,ip(k)+1)/=rdefun)then
                                   call interpolation_1df( z(ip(k):ip(k)+1),  &
  &                                                        u(nx,ny,ip(k):ip(k)+1),  &
  &                                                        p(k), v(i,j,k) )
                                else
                                   v(i,j,k)=rdefun
                                end if
                             end if
                          else
                             if(ip(k)==nz)then   ! (0,1,0)
                                if(u(nx,iq(j),nz)/=rdefun.and.  &
  &                                u(nx,iq(j)+1,nz)/=rdefun)then
                                   call interpolation_1df( y(iq(j):iq(j)+1),  &
  &                                                        u(nx,iq(j):iq(j)+1,nz),  &
  &                                                        q(j), v(i,j,k) )
                                else
                                   v(i,j,k)=rdefun
                                end if
                             else               ! (0,1,1)
                                if(u(nx,iq(j),ip(k))/=rdefun.and.  &
  &                                u(nx,iq(j)+1,ip(k))/=rdefun.and.  &
  &                                u(nx,iq(j),ip(k)+1)/=rdefun.and.  &
  &                                u(nx,iq(j)+1,ip(k)+1)/=rdefun)then
                                   call interpolation_2df( y(iq(j):iq(j)+1),  &
  &                                                        z(ip(k):ip(k)+1),  &
  &                                                        u(nx,iq(j):iq(j)+1,ip(k):ip(k)+1),  &
  &                                                        (/q(j), p(k)/), v(i,j,k) )
                                else
                                   v(i,j,k)=rdefun
                                end if
                             end if
                          end if
                       else
                          if(iq(j)==ny)then
                             if(ip(k)==nz)then   ! (1,0,0)
                                if(u(ir(i),ny,nz)/=rdefun.and.  &
  &                                u(ir(i)+1,ny,nz)/=rdefun)then
                                   call interpolation_1df( x(ir(i):ir(i)+1),  &
  &                                                        u(ir(i):ir(i)+1,ny,nz),  &
  &                                                        r(i), v(i,j,k) )
                                else
                                   v(i,j,k)=rdefun
                                end if
                             else               ! (1,0,1)
                                if(u(ir(i),ny,ip(k))/=rdefun.and.  &
  &                                u(ir(i)+1,ny,ip(k))/=rdefun.and.  &
  &                                u(ir(i),ny,ip(k)+1)/=rdefun.and.  &
  &                                u(ir(i)+1,ny,ip(k)+1)/=rdefun)then
                                   call interpolation_2df( x(ir(i):ir(i)+1),  &
  &                                                        z(ip(k):ip(k)+1),  &
  &                                                        u(ir(i):ir(i)+1,ny,ip(k):ip(k)+1),  &
  &                                                        (/r(i), p(k)/), v(i,j,k) )
                                else
                                   v(i,j,k)=rdefun
                                end if
                             end if
                          else
                             if(ip(k)==nz)then   ! (1,1,0)
                                if(u(ir(i),iq(j),nz)/=rdefun.and.  &
  &                                u(ir(i)+1,iq(j),nz)/=rdefun.and.  &
  &                                u(ir(i),iq(j)+1,nz)/=rdefun.and.  &
  &                                u(ir(i)+1,iq(j)+1,nz)/=rdefun)then
                                   call interpolation_2df( x(ir(i):ir(i)+1),  &
  &                                                        y(iq(j):iq(j)+1),  &
  &                                                        u(ir(i):ir(i)+1,iq(j):iq(j)+1,nz),  &
  &                                                        (/r(i), q(j)/), v(i,j,k) )
                                else
                                   v(i,j,k)=rdefun
                                end if
                             end if
                          end if
                       end if
                    else
                       v(i,j,k)=defun
                    end if
                 end if
              else
                 v(i,j,k)=rdefun
              end if
           else
              if(extra.eqv..true.)then    ! ʲ, ̤ if ʸ (1,1,1) Ϥʤ.
                 if(ir(i)==0)then
                    if(iq(j)==0)then
                       if(ip(k)==0)then   ! (0,0,0)
                          v(i,j,k)=u(1,1,1)
                       else               ! (0,0,1)
                          if(u(1,1,ip(k))/=rdefun.and.  &
  &                          u(1,1,ip(k)+1)/=rdefun)then
                             call interpolation_1df( z(ip(k):ip(k)+1),  &
  &                                                  u(1,1,ip(k):ip(k)+1),  &
  &                                                  p(k), v(i,j,k) )
                          else
                             v(i,j,k)=rdefun
                          end if
                       end if
                    else
                       if(ip(k)==0)then   ! (0,1,0)
                          if(u(1,iq(j),1)/=rdefun.and.  &
  &                          u(1,iq(j)+1,1)/=rdefun)then
                             call interpolation_1df( y(iq(j):iq(j)+1),  &
  &                                                  u(1,iq(j):iq(j)+1,1),  &
  &                                                  q(j), v(i,j,k) )
                          else
                             v(i,j,k)=rdefun
                          end if
                       else               ! (0,1,1)
                          if(u(1,iq(j),ip(k))/=rdefun.and.  &
  &                          u(1,iq(j)+1,ip(k))/=rdefun.and.  &
  &                          u(1,iq(j),ip(k)+1)/=rdefun.and.  &
  &                          u(1,iq(j)+1,ip(k)+1)/=rdefun)then
                             call interpolation_2df( y(iq(j):iq(j)+1),  &
  &                                                  z(ip(k):ip(k)+1),  &
  &                                                  u(1,iq(j):iq(j)+1,ip(k):ip(k)+1),  &
  &                                                  (/q(j), p(k)/), v(i,j,k) )
                          else
                             v(i,j,k)=rdefun
                          end if
                       end if
                    end if
                 else
                    if(iq(j)==0)then
                       if(ip(k)==0)then   ! (1,0,0)
                          if(u(ir(i),1,1)/=rdefun.and.  &
  &                          u(ir(i)+1,1,1)/=rdefun)then
                             call interpolation_1df( x(ir(i):ir(i)+1),  &
  &                                                  u(ir(i):ir(i)+1,1,1),  &
  &                                                  r(i), v(i,j,k) )
                          else
                             v(i,j,k)=rdefun
                          end if
                       else               ! (1,0,1)
                          if(u(ir(i),1,ip(k))/=rdefun.and.  &
  &                          u(ir(i)+1,1,ip(k))/=rdefun.and.  &
  &                          u(ir(i),1,ip(k)+1)/=rdefun.and.  &
  &                          u(ir(i)+1,1,ip(k)+1)/=rdefun)then
                             call interpolation_2df( x(ir(i):ir(i)+1),  &
  &                                                  z(ip(k):ip(k)+1),  &
  &                                                  u(ir(i):ir(i)+1,1,ip(k):ip(k)+1),  &
  &                                                  (/r(i), p(k)/), v(i,j,k) )
                          else
                             v(i,j,k)=rdefun
                          end if
                       end if
                    else
                       if(ip(k)==0)then   ! (1,1,0)
                          if(u(ir(i),iq(j),1)/=rdefun.and.  &
  &                          u(ir(i)+1,iq(j),1)/=rdefun.and.  &
  &                          u(ir(i),iq(j)+1,1)/=rdefun.and.  &
  &                          u(ir(i)+1,iq(j)+1,1)/=rdefun)then
                             call interpolation_2df( x(ir(i):ir(i)+1),  &
  &                                                  y(iq(j):iq(j)+1),  &
  &                                                  u(ir(i):ir(i)+1,iq(j):iq(j)+1,1),  &
  &                                                  (/r(i), q(j)/), v(i,j,k) )
                          else
                             v(i,j,k)=rdefun
                          end if
                       end if
                    end if
                 end if
              else
                 v(i,j,k)=defun
              end if
           end if
        end do
     end do
  end do

!$omp end do
!$omp end parallel

end subroutine auto_interpolation_3df

!------------------------------------
!------------------------------------

subroutine auto_interpolation_3dd( x, y, z, r, q, p, u, v, undef, undefr,  &
  &                                stdopt, extopt )
  ! ɸ x, y, z Ƥǡ u 
  ! ɸ r, q, p ǡ v ˼ưޤ.
  implicit none
  double precision, intent(in) :: x(:)  ! ɸ 1
  double precision, intent(in) :: y(:)  ! ɸ 2
  double precision, intent(in) :: z(:)  ! ɸ 3
  double precision, intent(in) :: r(:)  ! ޺ɸ 1
  double precision, intent(in) :: q(:)  ! ޺ɸ 2
  double precision, intent(in) :: p(:)  ! ޺ɸ 3
  double precision, intent(in) :: u(size(x),size(y),size(z))  ! ǡ
  double precision, intent(inout) :: v(size(r),size(q),size(p))  ! ޤǡ
  double precision, intent(in), optional :: undef  ! ̤
  double precision, intent(in), optional :: undefr  ! ΰǤ̤.
        !  undefr ʤ,  undefr 
  logical, intent(in), optional :: stdopt  ! õϰϤĤʤݤɸϤɽʤ褦ˤ.
  logical, intent(in), optional :: extopt  ! õϰϳξ, ǡΤǶͤ򥳥ԡ.
                                           ! ǥեȤǤϥԡʤ .false.
  integer :: ir(size(r)), iq(size(q)), ip(size(p))
  integer :: i, j, k, nx, ny, nz, nr, nq, np
  double precision :: defun
  double precision :: rdefun
  logical :: stderr, extra

  nx=size(x)
  ny=size(y)
  nz=size(z)
  nr=size(r)
  nq=size(q)
  np=size(p)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, u ),  &
  &                                     "auto_interpolation_3d" )
     call check_array_size_dmp_message( check_array_size_3d( nr, nq, np, v ),  &
  &                                     "auto_interpolation_3d" )
  end if

  if(present(undef))then
     defun=undef
  else
     defun=-999.0d0
  end if

  if(present(undefr))then
     rdefun=undefr
  else
     rdefun=-999.0d0
  end if

  if(present(stdopt))then
     stderr=stdopt
  else
     stderr=.false.
  end if

  if(present(extopt))then
     extra=extopt
  else
     extra=.false.
  end if

  call auto_interpo_search_3dd( x, y, z, r, q, p, ir, iq, ip,  &
  &                             undeff=0, stdopt=stderr )

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j,k)

  do k=1, np
     do j=1, nq
        do i=1, nr
           if(ir(i)/=0.and.iq(j)/=0.and.ip(k)/=0)then
              if(u(ir(i),iq(j),ip(k))/=rdefun)then
                 if(ir(i)<nx.and.iq(j)<ny.and.ip(k)<nz)then
                    if(u(ir(i)+1,iq(j),ip(k))/=rdefun.and.  &
  &                    u(ir(i),iq(j)+1,ip(k))/=rdefun.and.  &
  &                    u(ir(i)+1,iq(j)+1,ip(k))/=rdefun.and.  &
  &                    u(ir(i),iq(j),ip(k)+1)/=rdefun.and.  &
  &                    u(ir(i)+1,iq(j),ip(k)+1)/=rdefun.and.  &
  &                    u(ir(i),iq(j)+1,ip(k)+1)/=rdefun.and.  &
  &                    u(ir(i)+1,iq(j)+1,ip(k)+1)/=rdefun)then
                       call interpolation_3dd( x(ir(i):ir(i)+1),  &
  &                                            y(iq(j):iq(j)+1),  &
  &                                            z(ip(k):ip(k)+1),  &
  &                                            u(ir(i):ir(i)+1,iq(j):iq(j)+1,ip(k):ip(k)+1),  &
  &                                            (/r(i), q(j), p(k)/), v(i,j,k) )
                    else
                       v(i,j,k)=rdefun
                    end if

                 else if(x(nx)==r(i).and.y(ny)==q(j).and.z(nz)==p(k))then
                    v(i,j,k)=u(ir(i),iq(j),ip(k))

                 else if(x(nx)==r(i).and.iq(j)<ny.and.ip(k)<nz)then
                    if(u(nx,iq(j)+1,ip(k))/=rdefun.and.u(nx,iq(j),ip(k)+1)/=rdefun.and.  &
  &                    u(nx,iq(j)+1,ip(k)+1)/=rdefun)then
                       call interpolation_2dd( y(iq(j):iq(j)+1),  &
  &                                            z(ip(k):ip(k)+1),  &
  &                                            u(nx,iq(j):iq(j)+1,ip(k):ip(k)+1),  &
  &                                            (/q(j), p(k)/), v(i,j,k) )
                    else
                       v(i,j,k)=rdefun
                    end if

                 else if(y(ny)==q(j).and.ir(i)<nx.and.ip(k)<nz)then
                    if(u(ir(i)+1,ny,ip(k))/=rdefun.and.u(ir(i),ny,ip(k)+1)/=rdefun.and.  &
  &                    u(ir(i)+1,ny,ip(k)+1)/=rdefun)then
                       call interpolation_2dd( x(ir(i):ir(i)+1),  &
  &                                            z(ip(k):ip(k)+1),  &
  &                                            u(ir(i):ir(i)+1,ny,ip(k):ip(k)+1),  &
  &                                            (/r(i), p(k)/), v(i,j,k) )
                    else
                       v(i,j,k)=rdefun
                    end if

                 else if(z(nz)==p(k).and.ir(i)<nx.and.iq(j)<ny)then
                    if(u(ir(i)+1,iq(j),nz)/=rdefun.and.u(ir(i),iq(j)+1,nz)/=rdefun.and.  &
  &                    u(ir(i)+1,iq(j)+1,nz)/=rdefun)then
                       call interpolation_2dd( x(ir(i):ir(i)+1),  &
  &                                            y(iq(j):iq(j)+1),  &
  &                                            u(ir(i):ir(i)+1,iq(j):iq(j)+1,nz),  &
  &                                            (/r(i), q(j)/), v(i,j,k) )
                    else
                       v(i,j,k)=rdefun
                    end if

                 else if(x(nx)==r(i).and.y(ny)==q(j).and.ip(k)<nz)then
                    if(u(nx,ny,ip(k)+1)/=rdefun)then
                       call interpolation_1dd( z(ip(k):ip(k)+1),  &
  &                                            u(nx,ny,ip(k):ip(k)+1),  &
  &                                            p(k), v(i,j,k) )
                    else
                       v(i,j,k)=rdefun
                    end if

                 else if(x(nx)==r(i).and.z(nz)==p(k).and.iq(j)<ny)then
                    if(u(nx,iq(j)+1,nz)/=rdefun)then
                       call interpolation_1dd( y(iq(j):iq(j)+1),  &
  &                                            u(nx,iq(j):iq(j)+1,nz),  &
  &                                            q(j), v(i,j,k) )
                    else
                       v(i,j,k)=rdefun
                    end if

                 else if(y(ny)==q(j).and.z(nz)==p(k).and.ir(i)<nx)then
                    if(u(ir(i)+1,ny,nz)/=rdefun)then
                       call interpolation_1dd( x(ir(i):ir(i)+1),  &
  &                                            u(ir(i):ir(i)+1,ny,nz),  &
  &                                            r(i), v(i,j,k) )
                    else
                       v(i,j,k)=rdefun
                    end if

                 else

                    if(extra.eqv..true.)then    ! ʲ, ̤ if ʸ (1,1,1) Ϥʤ.
                       if(ir(i)==nx)then
                          if(iq(j)==ny)then
                             if(ip(k)==nz)then   ! (0,0,0)
                                v(i,j,k)=u(nx,ny,nz)
                             else               ! (0,0,1)
                                if(u(nx,ny,ip(k))/=rdefun.and.  &
  &                                u(nx,ny,ip(k)+1)/=rdefun)then
                                   call interpolation_1dd( z(ip(k):ip(k)+1),  &
  &                                                        u(nx,ny,ip(k):ip(k)+1),  &
  &                                                        p(k), v(i,j,k) )
                                else
                                   v(i,j,k)=rdefun
                                end if
                             end if
                          else
                             if(ip(k)==nz)then   ! (0,1,0)
                                if(u(nx,iq(j),nz)/=rdefun.and.  &
  &                                u(nx,iq(j)+1,nz)/=rdefun)then
                                   call interpolation_1dd( y(iq(j):iq(j)+1),  &
  &                                                        u(nx,iq(j):iq(j)+1,nz),  &
  &                                                        q(j), v(i,j,k) )
                                else
                                   v(i,j,k)=rdefun
                                end if
                             else               ! (0,1,1)
                                if(u(nx,iq(j),ip(k))/=rdefun.and.  &
  &                                u(nx,iq(j)+1,ip(k))/=rdefun.and.  &
  &                                u(nx,iq(j),ip(k)+1)/=rdefun.and.  &
  &                                u(nx,iq(j)+1,ip(k)+1)/=rdefun)then
                                   call interpolation_2dd( y(iq(j):iq(j)+1),  &
  &                                                        z(ip(k):ip(k)+1),  &
  &                                                        u(nx,iq(j):iq(j)+1,ip(k):ip(k)+1),  &
  &                                                        (/q(j), p(k)/), v(i,j,k) )
                                else
                                   v(i,j,k)=rdefun
                                end if
                             end if
                          end if
                       else
                          if(iq(j)==ny)then
                             if(ip(k)==nz)then   ! (1,0,0)
                                if(u(ir(i),ny,nz)/=rdefun.and.  &
  &                                u(ir(i)+1,ny,nz)/=rdefun)then
                                   call interpolation_1dd( x(ir(i):ir(i)+1),  &
  &                                                        u(ir(i):ir(i)+1,ny,nz),  &
  &                                                        r(i), v(i,j,k) )
                                else
                                   v(i,j,k)=rdefun
                                end if
                             else               ! (1,0,1)
                                if(u(ir(i),ny,ip(k))/=rdefun.and.  &
  &                                u(ir(i)+1,ny,ip(k))/=rdefun.and.  &
  &                                u(ir(i),ny,ip(k)+1)/=rdefun.and.  &
  &                                u(ir(i)+1,ny,ip(k)+1)/=rdefun)then
                                   call interpolation_2dd( x(ir(i):ir(i)+1),  &
  &                                                        z(ip(k):ip(k)+1),  &
  &                                                        u(ir(i):ir(i)+1,ny,ip(k):ip(k)+1),  &
  &                                                        (/r(i), p(k)/), v(i,j,k) )
                                else
                                   v(i,j,k)=rdefun
                                end if
                             end if
                          else
                             if(ip(k)==nz)then   ! (1,1,0)
                                if(u(ir(i),iq(j),nz)/=rdefun.and.  &
  &                                u(ir(i)+1,iq(j),nz)/=rdefun.and.  &
  &                                u(ir(i),iq(j)+1,nz)/=rdefun.and.  &
  &                                u(ir(i)+1,iq(j)+1,nz)/=rdefun)then
                                   call interpolation_2dd( x(ir(i):ir(i)+1),  &
  &                                                        y(iq(j):iq(j)+1),  &
  &                                                        u(ir(i):ir(i)+1,iq(j):iq(j)+1,nz),  &
  &                                                        (/r(i), q(j)/), v(i,j,k) )
                                else
                                   v(i,j,k)=rdefun
                                end if
                             end if
                          end if
                       end if
                    else
                       v(i,j,k)=defun
                    end if
                 end if
              else
                 v(i,j,k)=rdefun
              end if
           else
              if(extra.eqv..true.)then    ! ʲ, ̤ if ʸ (1,1,1) Ϥʤ.
                 if(ir(i)==0)then
                    if(iq(j)==0)then
                       if(ip(k)==0)then   ! (0,0,0)
                          v(i,j,k)=u(1,1,1)
                       else               ! (0,0,1)
                          if(u(1,1,ip(k))/=rdefun.and.  &
  &                          u(1,1,ip(k)+1)/=rdefun)then
                             call interpolation_1dd( z(ip(k):ip(k)+1),  &
  &                                                  u(1,1,ip(k):ip(k)+1),  &
  &                                                  p(k), v(i,j,k) )
                          else
                             v(i,j,k)=rdefun
                          end if
                       end if
                    else
                       if(ip(k)==0)then   ! (0,1,0)
                          if(u(1,iq(j),1)/=rdefun.and.  &
  &                          u(1,iq(j)+1,1)/=rdefun)then
                             call interpolation_1dd( y(iq(j):iq(j)+1),  &
  &                                                  u(1,iq(j):iq(j)+1,1),  &
  &                                                  q(j), v(i,j,k) )
                          else
                             v(i,j,k)=rdefun
                          end if
                       else               ! (0,1,1)
                          if(u(1,iq(j),ip(k))/=rdefun.and.  &
  &                          u(1,iq(j)+1,ip(k))/=rdefun.and.  &
  &                          u(1,iq(j),ip(k)+1)/=rdefun.and.  &
  &                          u(1,iq(j)+1,ip(k)+1)/=rdefun)then
                             call interpolation_2dd( y(iq(j):iq(j)+1),  &
  &                                                  z(ip(k):ip(k)+1),  &
  &                                                  u(1,iq(j):iq(j)+1,ip(k):ip(k)+1),  &
  &                                                  (/q(j), p(k)/), v(i,j,k) )
                          else
                             v(i,j,k)=rdefun
                          end if
                       end if
                    end if
                 else
                    if(iq(j)==0)then
                       if(ip(k)==0)then   ! (1,0,0)
                          if(u(ir(i),1,1)/=rdefun.and.  &
  &                          u(ir(i)+1,1,1)/=rdefun)then
                             call interpolation_1dd( x(ir(i):ir(i)+1),  &
  &                                                  u(ir(i):ir(i)+1,1,1),  &
  &                                                  r(i), v(i,j,k) )
                          else
                             v(i,j,k)=rdefun
                          end if
                       else               ! (1,0,1)
                          if(u(ir(i),1,ip(k))/=rdefun.and.  &
  &                          u(ir(i)+1,1,ip(k))/=rdefun.and.  &
  &                          u(ir(i),1,ip(k)+1)/=rdefun.and.  &
  &                          u(ir(i)+1,1,ip(k)+1)/=rdefun)then
                             call interpolation_2dd( x(ir(i):ir(i)+1),  &
  &                                                  z(ip(k):ip(k)+1),  &
  &                                                  u(ir(i):ir(i)+1,1,ip(k):ip(k)+1),  &
  &                                                  (/r(i), p(k)/), v(i,j,k) )
                          else
                             v(i,j,k)=rdefun
                          end if
                       end if
                    else
                       if(ip(k)==0)then   ! (1,1,0)
                          if(u(ir(i),iq(j),1)/=rdefun.and.  &
  &                          u(ir(i)+1,iq(j),1)/=rdefun.and.  &
  &                          u(ir(i),iq(j)+1,1)/=rdefun.and.  &
  &                          u(ir(i)+1,iq(j)+1,1)/=rdefun)then
                             call interpolation_2dd( x(ir(i):ir(i)+1),  &
  &                                                  y(iq(j):iq(j)+1),  &
  &                                                  u(ir(i):ir(i)+1,iq(j):iq(j)+1,1),  &
  &                                                  (/r(i), q(j)/), v(i,j,k) )
                          else
                             v(i,j,k)=rdefun
                          end if
                       end if
                    end if
                 end if
              else
                 v(i,j,k)=defun
              end if
           end if
        end do
     end do
  end do

!$omp end do
!$omp end parallel

end subroutine auto_interpolation_3dd

!------------------------------------
!------------------------------------

subroutine LSM_1df( x, y, slope, intercept, undef )  ! Ǿˡˤ뷹ҷ׻ (1 ǡ)
  implicit none
  real, intent(in) :: x(:)  ! ǡ 1
  real, intent(in) :: y(size(x))  ! ǡ 2
  real, intent(inout) :: slope  ! Ŭʷ
  real, intent(inout) :: intercept  ! Ŭ
  real, intent(in), optional :: undef ! undef 
  real :: u(size(x)), v(size(x))
  integer :: i
  integer :: nx  ! ǡ
  real :: a, b, c, d

  nx=size(x)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nx, y ),  &
  &                                     "LSM_1d" )
  end if

  a=0.0
  b=0.0
  c=0.0
  d=0.0

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i)
  do i=1,nx
     u(i)=x(i)*x(i)
     v(i)=x(i)*y(i)
  end do
!$omp end do
!$omp end parallel

  if(present(undef))then
     call summf(v,a,undef)
     call summf(x,b,undef)
     call summf(y,c,undef)
     call summf(u,d,undef)
  else
     call summf(v,a)
     call summf(x,b)
     call summf(y,c)
     call summf(u,d)
  end if

  slope=(nx*a-b*c)/(nx*d-b**2)
  intercept=(c*d-a*b)/(nx*d-b**2)

end subroutine LSM_1df

!------------------------------------
!------------------------------------

subroutine LSM_1dd( x, y, slope, intercept, undef )  ! Ǿˡˤ뷹ҷ׻ (1 ǡ)
  implicit none
  double precision, intent(in) :: x(:)  ! ǡ 1
  double precision, intent(in) :: y(size(x))  ! ǡ 2
  double precision, intent(inout) :: slope  ! Ŭʷ
  double precision, intent(inout) :: intercept  ! Ŭ
  double precision, intent(in), optional :: undef ! undef 
  double precision :: u(size(x)), v(size(x))
  integer :: i
  integer :: nx  ! ǡ
  double precision :: a, b, c, d

  nx=size(x)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nx, y ),  &
  &                                     "LSM_1d" )
  end if

  a=0.0d0
  b=0.0d0
  c=0.0d0
  d=0.0d0

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i)
  do i=1,nx
     u(i)=x(i)*x(i)
     v(i)=x(i)*y(i)
  end do
!$omp end do
!$omp end parallel

  if(present(undef))then
     call summd(v,a,undef)
     call summd(x,b,undef)
     call summd(y,c,undef)
     call summd(u,d,undef)
  else
     call summd(v,a)
     call summd(x,b)
     call summd(y,c)
     call summd(u,d)
  end if

  slope=(nx*a-b*c)/(nx*d-b**2)
  intercept=(c*d-a*b)/(nx*d-b**2)

end subroutine LSM_1dd

!------------------------------------
!------------------------------------

subroutine LSM_2df( x, y, slope, intercept, undef )  ! Ǿˡˤ뷹ҷ׻ (2 ǡ)
  implicit none
  real, intent(in) :: x(:,:)  ! ǡ 1
  real, intent(in) :: y(size(x,1),size(x,2))  ! ǡ 2
  real, intent(inout) :: slope  ! Ŭʷ
  real, intent(inout) :: intercept  ! Ŭ
  real, intent(in), optional :: undef ! undef 
  real :: u(size(x,1)*size(x,2)), v(size(x,1)*size(x,2))
  integer :: i, j, counter
  integer :: nx  ! ǡ 1
  integer :: ny  ! ǡ 2

  nx=size(x,1)
  ny=size(x,2)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, y ),  &
  &                                     "LSM_2d" )
  end if

  counter=0

  do j=1,ny
     do i=1,nx
        counter=counter+1
        u(counter)=x(i,j)
        v(counter)=y(i,j)
     end do
  end do

  if(present(undef))then
     call LSM_1df( u, v, slope, intercept, undef )
  else
     call LSM_1df( u, v, slope, intercept )
  end if

end subroutine LSM_2df

!------------------------------------
!------------------------------------

subroutine LSM_2dd( x, y, slope, intercept, undef )  ! Ǿˡˤ뷹ҷ׻ (2 ǡ)
  implicit none
  double precision, intent(in) :: x(:,:)  ! ǡ 1
  double precision, intent(in) :: y(size(x,1),size(x,2))  ! ǡ 2
  double precision, intent(inout) :: slope  ! Ŭʷ
  double precision, intent(inout) :: intercept  ! Ŭ
  double precision, intent(in), optional :: undef ! undef 
  double precision :: u(size(x,1)*size(x,2)), v(size(x,1)*size(x,2))
  integer :: i, j, counter
  integer :: nx  ! ǡ 1
  integer :: ny  ! ǡ 2

  nx=size(x,1)
  ny=size(x,2)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, y ),  &
  &                                     "LSM_2d" )
  end if

  counter=0

  do j=1,ny
     do i=1,nx
        counter=counter+1
        u(counter)=x(i,j)
        v(counter)=y(i,j)
     end do
  end do

  if(present(undef))then
     call LSM_1dd( u, v, slope, intercept, undef )
  else
     call LSM_1dd( u, v, slope, intercept )
  end if

end subroutine LSM_2dd

!------------------------------------
!------------------------------------

subroutine LSM_3df( x, y, slope, intercept, undef )  ! Ǿˡˤ뷹ҷ׻ (3 ǡ)
  implicit none
  real, intent(in) :: x(:,:,:)  ! ǡ 1
  real, intent(in) :: y(size(x,1),size(x,2),size(x,3))  ! ǡ 2
  real, intent(inout) :: slope  ! Ŭʷ
  real, intent(inout) :: intercept  ! Ŭ
  real, intent(in), optional :: undef ! undef 
  real :: u(size(x,1)*size(x,2)*size(x,3)), v(size(x,1)*size(x,2)*size(x,3))
  integer :: i, j, k, counter
  integer :: nx  ! ǡ 1
  integer :: ny  ! ǡ 2
  integer :: nz  ! ǡ 3

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, y ),  &
  &                                     "LSM_3d" )
  end if

  counter=0

  do k=1,nz
     do j=1,ny
        do i=1,nx
           counter=counter+1
           u(counter)=x(i,j,k)
           v(counter)=y(i,j,k)
        end do
     end do
  end do

  if(present(undef))then
     call LSM_1df( u, v, slope, intercept, undef )
  else
     call LSM_1df( u, v, slope, intercept )
  end if

end subroutine LSM_3df

!------------------------------------
!------------------------------------

subroutine LSM_3dd( x, y, slope, intercept, undef )  ! Ǿˡˤ뷹ҷ׻ (3 ǡ)
  implicit none
  double precision, intent(in) :: x(:,:,:)  ! ǡ 1
  double precision, intent(in) :: y(size(x,1),size(x,2),size(x,3))  ! ǡ 2
  double precision, intent(inout) :: slope  ! Ŭʷ
  double precision, intent(inout) :: intercept  ! Ŭ
  double precision, intent(in), optional :: undef ! undef 
  double precision :: u(size(x,1)*size(x,2)*size(x,3)), v(size(x,1)*size(x,2)*size(x,3))
  integer :: i, j, k, counter
  integer :: nx  ! ǡ 1
  integer :: ny  ! ǡ 2
  integer :: nz  ! ǡ 3

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, y ),  &
  &                                     "LSM_3d" )
  end if

  counter=0

  do k=1,nz
     do j=1,ny
        do i=1,nx
           counter=counter+1
           u(counter)=x(i,j,k)
           v(counter)=y(i,j,k)
        end do
     end do
  end do

  if(present(undef))then
     call LSM_1dd( u, v, slope, intercept, undef )
  else
     call LSM_1dd( u, v, slope, intercept )
  end if

end subroutine LSM_3dd

!------------------------------------
!------------------------------------

subroutine LSM_poly_1df( x, y, a, intercept, undef )
! LSM ¿༰С.
! LSM Ǥ, F(x)=a_0+a_1x ľԤäƤ,
! LSM_poly Ǥ, F(x)=\sum^{N}_{n=0}{a_nx^n}
! Ǥռ¿༰ԤȤǽ.
! 르ꥺϺǾˡѤƤ, ΥФˤ gausss 롼.
  implicit none
  real, intent(in) :: x(:)  ! ǡ 1
  real, intent(in) :: y(size(x))  ! ǡ 2
  real, intent(inout) :: a(:)  ! ¿༰η
  real, intent(inout) :: intercept  ! y . 
                         ! a Ȥ߹ȰϤȤ, poly_n+1 Ϥɬפ
                         ! , ʶ路ȽǤ, a_0 Ǥ y Ҥ
                         ! ΩǰȤϤȤˤ.
  real, intent(in), optional :: undef  ! ̤.
  integer :: i, j, k
  integer :: nx  ! ǡθĿ
  integer :: poly_n  ! κǹ⼡. 1 ʤ, LSM Ʊ.
  real :: coe(0:size(a)), tmpa_coe(0:size(a),0:size(a)), tmpb_coe(0:size(a))
          ! coe  a_n . tmp_coe ϥǡ¤.
          ! [] : Ǥ. Ǥ.
  real :: tmp(size(x))  ! ٤׻ΰ

  nx=size(x)
  poly_n=size(a)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nx, y ),  &
  &                                     "LSM_poly_1d" )
  end if

!-- gausss Ϥ䤹褦, Ѱդ˰.
  if(present(undef))then
     do k=0,poly_n  ! ʬη׻
        do j=0,poly_n  ! ʬη׻. ʬη׻˲뤳Ȥ.
           if(j >= k)then  ! ʬ(j)ʬ(k)ǿ, ͤ
                           ! ޤ˷׻.
              do i=1,nx
                 if(x(i)/=undef)then
                    tmp(i)=x(i)**(j+k)
                 else
                    tmp(i)=undef
                 end if
              end do
              call summf( tmp, tmpa_coe(j,k), undef )
           else  ! ʬ(j)ʬ(k)ǿ礭, 򤯷
                 ! оιǤ뤳Ȥ, ͤλΤ߹Ԥ.
              tmpa_coe(j,k)=tmpa_coe(k,j)  ! оʬʤǤ˷׻Ѥߡ
           end if
        end do
     end do
     do j=0,poly_n
        do i=1,nx
           if(x(i)/=undef)then
              tmp(i)=y(i)*(x(i)**j)
           else
              tmp(i)=undef
           end if
        end do
        call summf( tmp, tmpb_coe(j), undef )
     end do
  else  ! undef ʤȤ.
     do k=0,poly_n  ! ʬη׻
        do j=0,poly_n  ! ʬη׻. ʬη׻˲뤳Ȥ.
           if(j >= k)then  ! ʬ(j)ʬ(k)ǿ, ͤ
                           ! ޤ˷׻.
              do i=1,nx
                 tmp(i)=x(i)**(j+k)
              end do
              call summf( tmp, tmpa_coe(j,k), undef )
           else  ! ʬ(j)ʬ(k)ǿ礭, 򤯷
                 ! оιǤ뤳Ȥ, ͤλΤ߹Ԥ.
              tmpa_coe(j,k)=tmpa_coe(k,j)  ! оʬʤǤ˷׻Ѥߡ
           end if
        end do
     end do
     do j=0,poly_n
        do i=1,nx
           tmp(i)=y(i)*(x(i)**j)
        end do
        call summf( tmp, tmpb_coe(j), undef )
     end do
  end if

!  ʾǷͤä.

  call gausssf( tmpa_coe(0:poly_n,0:poly_n), tmpb_coe(0:poly_n),  &
  &            coe(0:poly_n) )

  do i=1,poly_n
     a(i)=coe(i)
  end do
  intercept=coe(0)

end subroutine LSM_poly_1df

!------------------------------------
!------------------------------------

subroutine LSM_poly_1dd( x, y, a, intercept, undef )
! LSM ¿༰С.
! LSM Ǥ, F(x)=a_0+a_1x ľԤäƤ,
! LSM_poly Ǥ, F(x)=\sum^{N}_{n=0}{a_nx^n}
! Ǥռ¿༰ԤȤǽ.
! 르ꥺϺǾˡѤƤ, ΥФˤ gausss 롼.
  implicit none
  double precision, intent(in) :: x(:)  ! ǡ 1
  double precision, intent(in) :: y(size(x))  ! ǡ 2
  double precision, intent(inout) :: a(:)  ! ¿༰η
  double precision, intent(inout) :: intercept  ! y . 
                         ! a Ȥ߹ȰϤȤ, poly_n+1 Ϥɬפ
                         ! , ʶ路ȽǤ, a_0 Ǥ y Ҥ
                         ! ΩǰȤϤȤˤ.
  double precision, intent(in), optional :: undef  ! ̤.
  integer :: i, j, k
  integer :: nx  ! ǡθĿ
  integer :: poly_n  ! κǹ⼡. 1 ʤ, LSM Ʊ.
  double precision :: coe(0:size(a)), tmpa_coe(0:size(a),0:size(a)), tmpb_coe(0:size(a))
          ! coe  a_n . tmp_coe ϥǡ¤.
          ! [] : Ǥ. Ǥ.
  double precision :: tmp(size(x))  ! ٤׻ΰ

  nx=size(x)
  poly_n=size(a)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nx, y ),  &
  &                                     "LSM_poly_1d" )
  end if

!-- gausss Ϥ䤹褦, Ѱդ˰.
  if(present(undef))then
     do k=0,poly_n  ! ʬη׻
        do j=0,poly_n  ! ʬη׻. ʬη׻˲뤳Ȥ.
           if(j >= k)then  ! ʬ(j)ʬ(k)ǿ, ͤ
                           ! ޤ˷׻.
              do i=1,nx
                 if(x(i)/=undef)then
                    tmp(i)=x(i)**(j+k)
                 else
                    tmp(i)=undef
                 end if
              end do
              call summd( tmp, tmpa_coe(j,k), undef )
           else  ! ʬ(j)ʬ(k)ǿ礭, 򤯷
                 ! оιǤ뤳Ȥ, ͤλΤ߹Ԥ.
              tmpa_coe(j,k)=tmpa_coe(k,j)  ! оʬʤǤ˷׻Ѥߡ
           end if
        end do
     end do
     do j=0,poly_n
        do i=1,nx
           if(x(i)/=undef)then
              tmp(i)=y(i)*(x(i)**j)
           else
              tmp(i)=undef
           end if
        end do
        call summd( tmp, tmpb_coe(j), undef )
     end do
  else  ! undef ʤȤ.
     do k=0,poly_n  ! ʬη׻
        do j=0,poly_n  ! ʬη׻. ʬη׻˲뤳Ȥ.
           if(j >= k)then  ! ʬ(j)ʬ(k)ǿ, ͤ
                           ! ޤ˷׻.
              do i=1,nx
                 tmp(i)=x(i)**(j+k)
              end do
              call summd( tmp, tmpa_coe(j,k), undef )
           else  ! ʬ(j)ʬ(k)ǿ礭, 򤯷
                 ! оιǤ뤳Ȥ, ͤλΤ߹Ԥ.
              tmpa_coe(j,k)=tmpa_coe(k,j)  ! оʬʤǤ˷׻Ѥߡ
           end if
        end do
     end do
     do j=0,poly_n
        do i=1,nx
           tmp(i)=y(i)*(x(i)**j)
        end do
        call summd( tmp, tmpb_coe(j), undef )
     end do
  end if

!  ʾǷͤä.

  call gausssd( tmpa_coe(0:poly_n,0:poly_n), tmpb_coe(0:poly_n),  &
  &             coe(0:poly_n) )

  do i=1,poly_n
     a(i)=coe(i)
  end do
  intercept=coe(0)

end subroutine LSM_poly_1dd

!------------------------------------
!------------------------------------

subroutine LSM_poly_2df( x, y, a, intercept, undef )
! LSM ¿༰С. (2 ǡ)
  implicit none
  real, intent(in) :: x(:,:)  ! ǡ 1
  real, intent(in) :: y(size(x,1),size(x,2))  ! ǡ 2
  real, intent(inout) :: a(:)  ! ¿༰η
  real, intent(inout) :: intercept  ! y . 
                         ! a Ȥ߹ȰϤȤ, poly_n+1 Ϥɬפ
                         ! , ʶ路ȽǤ, a_0 Ǥ y Ҥ
                         ! ΩǰȤϤȤˤ.
  real, intent(in), optional :: undef  ! ̤.
  integer :: i, j, counter
  integer :: nx  ! ǡθĿ 1
  integer :: ny  ! ǡθĿ 2
  real, dimension(size(x,1)*size(x,2)) :: val1, val2

  nx=size(x,1)
  ny=size(x,2)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, y ),  &
  &                                     "LSM_poly_2d" )
  end if

  counter=0

  do j=1,ny
     do i=1,nx
        counter=counter+1
        val1(counter)=x(i,j)
        val2(counter)=y(i,j)
     end do
  end do

  if(present(undef))then
     call LSM_poly_1df( val1, val2, a, intercept, undef )
  else
     call LSM_poly_1df( val1, val2, a, intercept )
  end if

end subroutine LSM_poly_2df

!------------------------------------
!------------------------------------

subroutine LSM_poly_2dd( x, y, a, intercept, undef )
! LSM ¿༰С. (2 ǡ)
  implicit none
  double precision, intent(in) :: x(:,:)  ! ǡ 1
  double precision, intent(in) :: y(size(x,1),size(x,2))  ! ǡ 2
  double precision, intent(inout) :: a(:)  ! ¿༰η
  double precision, intent(inout) :: intercept  ! y . 
                         ! a Ȥ߹ȰϤȤ, poly_n+1 Ϥɬפ
                         ! , ʶ路ȽǤ, a_0 Ǥ y Ҥ
                         ! ΩǰȤϤȤˤ.
  double precision, intent(in), optional :: undef  ! ̤.
  integer :: i, j, counter
  integer :: nx  ! ǡθĿ 1
  integer :: ny  ! ǡθĿ 2
  double precision, dimension(size(x,1)*size(x,2)) :: val1, val2

  nx=size(x,1)
  ny=size(x,2)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, y ),  &
  &                                     "LSM_poly_2d" )
  end if

  counter=0

  do j=1,ny
     do i=1,nx
        counter=counter+1
        val1(counter)=x(i,j)
        val2(counter)=y(i,j)
     end do
  end do

  if(present(undef))then
     call LSM_poly_1dd( val1, val2, a, intercept, undef )
  else
     call LSM_poly_1dd( val1, val2, a, intercept )
  end if

end subroutine LSM_poly_2dd

!------------------------------------
!------------------------------------

subroutine LSM_poly_3df( x, y, a, intercept, undef )
! LSM ¿༰С. (3 ǡ)
  implicit none
  real, intent(in) :: x(:,:,:)  ! ǡ 1
  real, intent(in) :: y(size(x,1),size(x,2),size(x,3))  ! ǡ 2
  real, intent(inout) :: a(:)  ! ¿༰η
  real, intent(inout) :: intercept  ! y . 
                         ! a Ȥ߹ȰϤȤ, poly_n+1 Ϥɬפ
                         ! , ʶ路ȽǤ, a_0 Ǥ y Ҥ
                         ! ΩǰȤϤȤˤ.
  real, intent(in), optional :: undef  ! ̤.
  integer :: i, j, k, counter
  integer :: nx  ! ǡθĿ 1
  integer :: ny  ! ǡθĿ 2
  integer :: nz  ! ǡθĿ 3
  real, dimension(size(x,1)*size(x,2)*size(x,3)) :: val1, val2

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, y ),  &
  &                                     "LSM_poly_3d" )
  end if

  counter=0

  do k=1,nz
     do j=1,ny
        do i=1,nx
           counter=counter+1
           val1(counter)=x(i,j,k)
           val2(counter)=y(i,j,k)
        end do
     end do
  end do

  if(present(undef))then
     call LSM_poly_1df( val1, val2, a, intercept, undef )
  else
     call LSM_poly_1df( val1, val2, a, intercept )
  end if

end subroutine LSM_poly_3df

!------------------------------------
!------------------------------------

subroutine LSM_poly_3dd( x, y, a, intercept, undef )
! LSM ¿༰С. (3 ǡ)
  implicit none
  double precision, intent(in) :: x(:,:,:)  ! ǡ 1
  double precision, intent(in) :: y(size(x,1),size(x,2),size(x,3))  ! ǡ 2
  double precision, intent(inout) :: a(:)  ! ¿༰η
  double precision, intent(inout) :: intercept  ! y . 
                         ! a Ȥ߹ȰϤȤ, poly_n+1 Ϥɬפ
                         ! , ʶ路ȽǤ, a_0 Ǥ y Ҥ
                         ! ΩǰȤϤȤˤ.
  double precision, intent(in), optional :: undef  ! ̤.
  integer :: i, j, k, counter
  integer :: nx  ! ǡθĿ 1
  integer :: ny  ! ǡθĿ 2
  integer :: nz  ! ǡθĿ 3
  double precision, dimension(size(x,1)*size(x,2)*size(x,3)) :: val1, val2

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, y ),  &
  &                                     "LSM_poly_3d" )
  end if

  counter=0

  do k=1,nz
     do j=1,ny
        do i=1,nx
           counter=counter+1
           val1(counter)=x(i,j,k)
           val2(counter)=y(i,j,k)
        end do
     end do
  end do

  if(present(undef))then
     call LSM_poly_1dd( val1, val2, a, intercept, undef )
  else
     call LSM_poly_1dd( val1, val2, a, intercept )
  end if

end subroutine LSM_poly_3dd

!------------------------------------
!------------------------------------

subroutine LSM_multi_f( x, y, a, undef )
! LSM ¿ѿ¿༰С.
! LSM_multi Ǥ, F(x_0,x_1,...,x_n)=\sum^{N}_{n=0}{a_nx_n}
! Ǥռ¿༰ԤȤǽ.
! 르ꥺϺǾˡѤƤ, ΥФˤ gausss 롼.
  implicit none
  real, intent(in) :: x(:,:)  ! ǡ 1
  real, intent(in) :: y(size(x,1))  ! ǡ 2
  real, intent(inout) :: a(size(x,2))  ! ¿༰η
  real, intent(in), optional :: undef  ! ̤.
  integer :: i, j, k
  integer :: nx  ! ǡθĿ
  integer :: multi_n  ! ¿ѿο. 1 ʤ, LSM Ʊ.
  real :: coe(size(x,2)), tmpa_coe(size(x,2),size(x,2)), tmpb_coe(size(x,2))
          ! coe  a_n . tmp_coe ϥǡ¤.
          ! [] : Ǥ. Ǥ.
  real :: tmp(size(x,1))  ! ٤׻ΰ
  ! [] , ǡθĿ nx ǡοǤ,  1 ĤĤ
  !        multi_n ĤμΩʥǡƤ뤳Ȥꤹ.

  nx=size(x,1)
  multi_n=size(x,2)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nx, y ),  &
  &                                     "LSM_multi" )
  end if

!-- gausss Ϥ䤹褦, Ѱդ˰.
  if(present(undef))then
     do k=1,multi_n  ! ʬη׻
        do j=1,multi_n  ! ʬη׻. ʬη׻˲뤳Ȥ.
           if(j >= k)then  ! ʬ(j)ʬ(k)ǿ, ͤ
                           ! ޤ˷׻.
              do i=1,nx
                 if(x(i,j)/=undef.and.x(i,k)/=undef)then
                    tmp(i)=x(i,j)*x(i,k)
                 else
                    tmp(i)=undef
                 end if
              end do
              call summf( tmp, tmpa_coe(j,k), undef )
           else  ! ʬ(j)ʬ(k)ǿ礭, 򤯷
                 ! оιǤ뤳Ȥ, ͤλΤ߹Ԥ.
              tmpa_coe(j,k)=tmpa_coe(k,j)  ! оʬʤǤ˷׻Ѥߡ
           end if
        end do
     end do
     do j=1,multi_n
        do i=1,nx
           if(x(i,j)/=undef)then
              tmp(i)=y(i)*x(i,j)
           else
              tmp(i)=undef
           end if
        end do
        call summf( tmp, tmpb_coe(j), undef )
     end do
  else  ! undef ʤȤ.
     do k=1,multi_n  ! ʬη׻
        do j=1,multi_n  ! ʬη׻. ʬη׻˲뤳Ȥ.
           if(j >= k)then  ! ʬ(j)ʬ(k)ǿ, ͤ
                           ! ޤ˷׻.
              do i=1,nx
                 tmp(i)=x(i,j)*x(i,k)
              end do
              call summf( tmp, tmpa_coe(j,k), undef )
           else  ! ʬ(j)ʬ(k)ǿ礭, 򤯷
                 ! оιǤ뤳Ȥ, ͤλΤ߹Ԥ.
              tmpa_coe(j,k)=tmpa_coe(k,j)  ! оʬʤǤ˷׻Ѥߡ
           end if
        end do
     end do
     do j=1,multi_n
        do i=1,nx
           tmp(i)=y(i)*x(i,j)
        end do
        call summf( tmp, tmpb_coe(j), undef )
     end do
  end if

!  ʾǷͤä.

  call gausssf( tmpa_coe(1:multi_n,1:multi_n), tmpb_coe(1:multi_n),  &
  &            coe(1:multi_n) )

  do i=1,multi_n
     a(i)=coe(i)
  end do

end subroutine LSM_multi_f

!------------------------------------
!------------------------------------

subroutine LSM_multi_d( x, y, a, undef )
! LSM ¿ѿ¿༰С.
! LSM_multi Ǥ, F(x_0,x_1,...,x_n)=\sum^{N}_{n=0}{a_nx_n}
! Ǥռ¿༰ԤȤǽ.
! 르ꥺϺǾˡѤƤ, ΥФˤ gausss 롼.
  implicit none
  double precision, intent(in) :: x(:,:)  ! ǡ 1
  double precision, intent(in) :: y(size(x,1))  ! ǡ 2
  double precision, intent(inout) :: a(size(x,2))  ! ¿༰η
  double precision, intent(in), optional :: undef  ! ̤.
  integer :: i, j, k
  integer :: nx  ! ǡθĿ
  integer :: multi_n  ! ¿ѿο. 1 ʤ, LSM Ʊ.
  double precision :: coe(size(x,2)), tmpa_coe(size(x,2),size(x,2)), tmpb_coe(size(x,2))
          ! coe  a_n . tmp_coe ϥǡ¤.
          ! [] : Ǥ. Ǥ.
  double precision :: tmp(size(x,1))  ! ٤׻ΰ
  ! [] , ǡθĿ nx ǡοǤ,  1 ĤĤ
  !        multi_n ĤμΩʥǡƤ뤳Ȥꤹ.

  nx=size(x,1)
  multi_n=size(x,2)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nx, y ),  &
  &                                     "LSM_multi" )
  end if

!-- gausss Ϥ䤹褦, Ѱդ˰.
  if(present(undef))then
     do k=1,multi_n  ! ʬη׻
        do j=1,multi_n  ! ʬη׻. ʬη׻˲뤳Ȥ.
           if(j >= k)then  ! ʬ(j)ʬ(k)ǿ, ͤ
                           ! ޤ˷׻.
              do i=1,nx
                 if(x(i,j)/=undef.and.x(i,k)/=undef)then
                    tmp(i)=x(i,j)*x(i,k)
                 else
                    tmp(i)=undef
                 end if
              end do
              call summd( tmp, tmpa_coe(j,k), undef )
           else  ! ʬ(j)ʬ(k)ǿ礭, 򤯷
                 ! оιǤ뤳Ȥ, ͤλΤ߹Ԥ.
              tmpa_coe(j,k)=tmpa_coe(k,j)  ! оʬʤǤ˷׻Ѥߡ
           end if
        end do
     end do
     do j=1,multi_n
        do i=1,nx
           if(x(i,j)/=undef)then
              tmp(i)=y(i)*x(i,j)
           else
              tmp(i)=undef
           end if
        end do
        call summd( tmp, tmpb_coe(j), undef )
     end do
  else  ! undef ʤȤ.
     do k=1,multi_n  ! ʬη׻
        do j=1,multi_n  ! ʬη׻. ʬη׻˲뤳Ȥ.
           if(j >= k)then  ! ʬ(j)ʬ(k)ǿ, ͤ
                           ! ޤ˷׻.
              do i=1,nx
                 tmp(i)=x(i,j)*x(i,k)
              end do
              call summd( tmp, tmpa_coe(j,k), undef )
           else  ! ʬ(j)ʬ(k)ǿ礭, 򤯷
                 ! оιǤ뤳Ȥ, ͤλΤ߹Ԥ.
              tmpa_coe(j,k)=tmpa_coe(k,j)  ! оʬʤǤ˷׻Ѥߡ
           end if
        end do
     end do
     do j=1,multi_n
        do i=1,nx
           tmp(i)=y(i)*x(i,j)
        end do
        call summd( tmp, tmpb_coe(j), undef )
     end do
  end if

!  ʾǷͤä.

  call gausssd( tmpa_coe(1:multi_n,1:multi_n), tmpb_coe(1:multi_n),  &
  &            coe(1:multi_n) )

  do i=1,multi_n
     a(i)=coe(i)
  end do

end subroutine LSM_multi_d

!------------------------------------
!------------------------------------

subroutine Reg_Line_1df( x, y, slope, intercept, undef )
  ! LSM ѤƲľη slope  intercept ׻롼
  implicit none
  real, intent(in) :: x(:)  ! ǡ 1
  real, intent(in) :: y(size(x))  ! ǡ 2
  real, intent(inout) :: slope  ! Ŭʷ
  real, intent(inout) :: intercept  ! Ŭ
  real, intent(in), optional :: undef  ! ̤
  real :: u(size(x)), v(size(x))
  integer :: nx  ! ǡ

  nx=size(x)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nx, y ),  &
  &                                     "Reg_Line_1d" )
  end if

  if(present(undef))then
     call Anomaly_1df( x, u, undef )
     call Anomaly_1df( y, v, undef )
     call LSM_1df( u, v, slope, intercept, undef )
  else
     call Anomaly_1df( x, u )
     call Anomaly_1df( y, v )
     call LSM_1df( u, v, slope, intercept )
  end if

end subroutine Reg_Line_1df

!------------------------------------
!------------------------------------

subroutine Reg_Line_1dd( x, y, slope, intercept, undef )
  ! LSM ѤƲľη slope  intercept ׻롼
  implicit none
  double precision, intent(in) :: x(:)  ! ǡ 1
  double precision, intent(in) :: y(size(x))  ! ǡ 2
  double precision, intent(inout) :: slope  ! Ŭʷ
  double precision, intent(inout) :: intercept  ! Ŭ
  double precision, intent(in), optional :: undef  ! ̤
  double precision :: u(size(x)), v(size(x))
  integer :: nx  ! ǡ

  nx=size(x)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nx, y ),  &
  &                                     "Reg_Line_1d" )
  end if

  if(present(undef))then
     call Anomaly_1dd( x, u, undef )
     call Anomaly_1dd( y, v, undef )
     call LSM_1dd( u, v, slope, intercept, undef )
  else
     call Anomaly_1dd( x, u )
     call Anomaly_1dd( y, v )
     call LSM_1dd( u, v, slope, intercept )
  end if

end subroutine Reg_Line_1dd

!------------------------------------
!------------------------------------

subroutine Reg_Line_2df( x, y, slope, intercept, error )
  ! LSM ѤƲľη slope  intercept ׻롼 (2 )
  implicit none
  real, intent(in) :: x(:,:)  ! ǡ 1
  real, intent(in) :: y(size(x,1),size(x,2))  ! ǡ 2
  real, intent(inout) :: slope  ! Ŭʷ
  real, intent(inout) :: intercept  ! Ŭ
  real, intent(in), optional :: error
  real, dimension(size(x,1)*size(x,2)) :: u, v
  integer :: i, j, counter
  integer :: nx  ! ǡ 1
  integer :: ny  ! ǡ 2

  nx=size(x,1)
  ny=size(x,2)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, y ),  &
  &                                     "Reg_Line_2d" )
  end if

  counter=0

  do j=1,ny
     do i=1,nx
        counter=counter+1
        u(counter)=x(i,j)
        v(counter)=y(i,j)
     end do
  end do

  if(present(error))then
     call Reg_Line_1df( u, v, slope, intercept, error )
  else
     call Reg_Line_1df( u, v, slope, intercept )
  end if

end subroutine Reg_Line_2df

!------------------------------------
!------------------------------------

subroutine Reg_Line_2dd( x, y, slope, intercept, error )
  ! LSM ѤƲľη slope  intercept ׻롼 (2 )
  implicit none
  double precision, intent(in) :: x(:,:)  ! ǡ 1
  double precision, intent(in) :: y(size(x,1),size(x,2))  ! ǡ 2
  double precision, intent(inout) :: slope  ! Ŭʷ
  double precision, intent(inout) :: intercept  ! Ŭ
  double precision, intent(in), optional :: error
  double precision, dimension(size(x,1)*size(x,2)) :: u, v
  integer :: i, j, counter
  integer :: nx  ! ǡ 1
  integer :: ny  ! ǡ 2

  nx=size(x,1)
  ny=size(x,2)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, y ),  &
  &                                     "Reg_Line_2d" )
  end if

  counter=0

  do j=1,ny
     do i=1,nx
        counter=counter+1
        u(counter)=x(i,j)
        v(counter)=y(i,j)
     end do
  end do

  if(present(error))then
     call Reg_Line_1dd( u, v, slope, intercept, error )
  else
     call Reg_Line_1dd( u, v, slope, intercept )
  end if

end subroutine Reg_Line_2dd

!------------------------------------
!------------------------------------

subroutine Reg_Line_3df( x, y, slope, intercept, error )
  ! LSM ѤƲľη slope  intercept ׻롼 (3 )
  implicit none
  real, intent(in) :: x(:,:,:)  ! ǡ 1
  real, intent(in) :: y(size(x,1),size(x,2),size(x,3))  ! ǡ 2
  real, intent(inout) :: slope  ! Ŭʷ
  real, intent(inout) :: intercept  ! Ŭ
  real, intent(in), optional :: error
  real, dimension(size(x,1)*size(x,2)*size(x,3)) :: u, v
  integer :: i, j, k, counter
  integer :: nx  ! ǡ 1
  integer :: ny  ! ǡ 2
  integer :: nz  ! ǡ 3

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, y ),  &
  &                                     "Reg_Line_3d" )
  end if

  counter=0

  do k=1,nz
     do j=1,ny
        do i=1,nx
           counter=counter+1
           u(counter)=x(i,j,k)
           v(counter)=y(i,j,k)
        end do
     end do
  end do

  if(present(error))then
     call Reg_Line_1df( u, v, slope, intercept, error )
  else
     call Reg_Line_1df( u, v, slope, intercept )
  end if

end subroutine Reg_Line_3df

!------------------------------------
!------------------------------------

subroutine Reg_Line_3dd( x, y, slope, intercept, error )
  ! LSM ѤƲľη slope  intercept ׻롼 (3 )
  implicit none
  double precision, intent(in) :: x(:,:,:)  ! ǡ 1
  double precision, intent(in) :: y(size(x,1),size(x,2),size(x,3))  ! ǡ 2
  double precision, intent(inout) :: slope  ! Ŭʷ
  double precision, intent(inout) :: intercept  ! Ŭ
  double precision, intent(in), optional :: error
  double precision, dimension(size(x,1)*size(x,2)*size(x,3)) :: u, v
  integer :: i, j, k, counter
  integer :: nx  ! ǡ 1
  integer :: ny  ! ǡ 2
  integer :: nz  ! ǡ 3

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, y ),  &
  &                                     "Reg_Line_3d" )
  end if

  counter=0

  do k=1,nz
     do j=1,ny
        do i=1,nx
           counter=counter+1
           u(counter)=x(i,j,k)
           v(counter)=y(i,j,k)
        end do
     end do
  end do

  if(present(error))then
     call Reg_Line_1dd( u, v, slope, intercept, error )
  else
     call Reg_Line_1dd( u, v, slope, intercept )
  end if

end subroutine Reg_Line_3dd

!------------------------------------
!------------------------------------

subroutine Cor_Coe_1df( x, y ,cc, error )  ! 2 ǡط׻롼
  implicit none
  real, intent(in) :: x(:)  ! ǡ 1
  real, intent(in) :: y(size(x))  ! ǡ 2
  real, intent(inout) :: cc  ! ط
  real, intent(in), optional :: error  ! »
  integer :: nx  ! ǡĿ
  real :: cov, anor1, anor2
  real :: rx(size(x)), ry(size(x))

  nx=size(x)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nx, y ),  &
  &                                     "Cor_Coe_1d" )
  end if

  if(present(error))then
     call replace_undef_f( x, y, rx, ry, error )
     call covariance_1df( rx, ry, cov, error )
     call stand_devi_1df( rx, anor1, error )
     call stand_devi_1df( ry, anor2, error )
  else
     call covariance_1df( x, y, cov )
     call stand_devi_1df( x, anor1 )
     call stand_devi_1df( y, anor2 )
  end if

  cc=cov/(anor1*anor2)

end subroutine Cor_Coe_1df

!---------------------------------
!------------------------------------

subroutine Cor_Coe_1dd( x, y ,cc, error )  ! 2 ǡط׻롼
  implicit none
  double precision, intent(in) :: x(:)  ! ǡ 1
  double precision, intent(in) :: y(size(x))  ! ǡ 2
  double precision, intent(inout) :: cc  ! ط
  double precision, intent(in), optional :: error  ! »
  integer :: nx  ! ǡĿ
  double precision :: cov, anor1, anor2
  double precision :: rx(size(x)), ry(size(x))

  nx=size(x)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nx, y ),  &
  &                                     "Cor_Coe_1d" )
  end if

  if(present(error))then
     call replace_undef_d( x, y, rx, ry, error )
     call covariance_1dd( rx, ry, cov, error )
     call stand_devi_1dd( rx, anor1, error )
     call stand_devi_1dd( ry, anor2, error )
  else
     call covariance_1dd( x, y, cov )
     call stand_devi_1dd( x, anor1 )
     call stand_devi_1dd( y, anor2 )
  end if

  cc=cov/(anor1*anor2)

end subroutine Cor_Coe_1dd

!---------------------------------
!------------------------------------

subroutine Cor_Coe_2df( x, y ,cc, error )  ! 2 ǡط׻롼 (2 )
  implicit none
  real, intent(in) :: x(:,:)  ! ǡ 1
  real, intent(in) :: y(size(x,1),size(x,2))  ! ǡ 2
  real, intent(inout) :: cc  ! ط
  real, intent(in), optional :: error  ! »
  integer :: i, j, counter
  integer :: nx  ! ǡĿ 1
  integer :: ny  ! ǡĿ 2
  real, dimension(size(x,1)*size(x,2)) :: val1, val2

  nx=size(x,1)
  ny=size(x,2)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, y ),  &
  &                                     "Cor_Coe_2d" )
  end if

  counter=0

  do j=1,ny
     do i=1,nx
        counter=counter+1
        val1(counter)=x(i,j)
        val2(counter)=y(i,j)
     end do
  end do

  if(present(error))then
     call Cor_Coe_1df( val1, val2, cc, error )
  else
     call Cor_Coe_1df( val1, val2, cc )
  end if

end subroutine Cor_Coe_2df

!---------------------------------
!------------------------------------

subroutine Cor_Coe_2dd( x, y ,cc, error )  ! 2 ǡط׻롼 (2 )
  implicit none
  double precision, intent(in) :: x(:,:)  ! ǡ 1
  double precision, intent(in) :: y(size(x,1),size(x,2))  ! ǡ 2
  double precision, intent(inout) :: cc  ! ط
  double precision, intent(in), optional :: error  ! »
  integer :: i, j, counter
  integer :: nx  ! ǡĿ 1
  integer :: ny  ! ǡĿ 2
  double precision, dimension(size(x,1)*size(x,2)) :: val1, val2

  nx=size(x,1)
  ny=size(x,2)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( nx, ny, y ),  &
  &                                     "Cor_Coe_2d" )
  end if

  counter=0

  do j=1,ny
     do i=1,nx
        counter=counter+1
        val1(counter)=x(i,j)
        val2(counter)=y(i,j)
     end do
  end do

  if(present(error))then
     call Cor_Coe_1dd( val1, val2, cc, error )
  else
     call Cor_Coe_1dd( val1, val2, cc )
  end if

end subroutine Cor_Coe_2dd

!---------------------------------
!------------------------------------

subroutine Cor_Coe_3df( x, y ,cc, error )  ! 2 ǡط׻롼 (3 )
  implicit none
  real, intent(in) :: x(:,:,:)  ! ǡ 1
  real, intent(in) :: y(size(x,1),size(x,2),size(x,3))  ! ǡ 2
  real, intent(inout) :: cc  ! ط
  real, intent(in), optional :: error  ! »
  integer :: i, j, k, counter
  integer :: nx  ! ǡĿ 1
  integer :: ny  ! ǡĿ 2
  integer :: nz  ! ǡĿ 2
  real, dimension(size(x,1)*size(x,2)*size(x,3)) :: val1, val2

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, y ),  &
  &                                     "Cor_Coe_3d" )
  end if

  counter=0

  do k=1,nz
     do j=1,ny
        do i=1,nx
           counter=counter+1
           val1(counter)=x(i,j,k)
           val2(counter)=y(i,j,k)
        end do
     end do
  end do

  if(present(error))then
     call Cor_Coe_1df( val1, val2, cc, error )
  else
     call Cor_Coe_1df( val1, val2, cc )
  end if

end subroutine Cor_Coe_3df

!---------------------------------
!------------------------------------

subroutine Cor_Coe_3dd( x, y ,cc, error )  ! 2 ǡط׻롼 (3 )
  implicit none
  double precision, intent(in) :: x(:,:,:)  ! ǡ 1
  double precision, intent(in) :: y(size(x,1),size(x,2),size(x,3))  ! ǡ 2
  double precision, intent(inout) :: cc  ! ط
  double precision, intent(in), optional :: error  ! »
  integer :: i, j, k, counter
  integer :: nx  ! ǡĿ 1
  integer :: ny  ! ǡĿ 2
  integer :: nz  ! ǡĿ 2
  double precision, dimension(size(x,1)*size(x,2)*size(x,3)) :: val1, val2

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_3d( nx, ny, nz, y ),  &
  &                                     "Cor_Coe_3d" )
  end if

  counter=0

  do k=1,nz
     do j=1,ny
        do i=1,nx
           counter=counter+1
           val1(counter)=x(i,j,k)
           val2(counter)=y(i,j,k)
        end do
     end do
  end do

  if(present(error))then
     call Cor_Coe_1dd( val1, val2, cc, error )
  else
     call Cor_Coe_1dd( val1, val2, cc )
  end if

end subroutine Cor_Coe_3dd

!---------------------------------
!---------------------------------

subroutine smooth_1d( x, n, y, method, weight, error )
! 1 ǡˤĤ, ࡼ󥰤롼
! , error ץϵǽƤʤ.
  implicit none
  real, intent(in) :: x(:)  ! ࡼ󥰤ǡ
  integer, intent(in) :: n  ! ࡼαƶʻҿ(濴ޤ᤿)
  real, intent(inout) :: y(size(x))  ! ࡼ󥰤줿ǡ
  character(3), intent(in) :: method  ! ࡼ󥰤ˡ
                            ! "SMP" = ñʿ, "OPT" = ץŤ
                            ! "MAX" = , "MIN" = Ǿ
  real, intent(in), optional :: weight(n)  ! method  "OPT" ξ
                            ! weight(1) ü, weight(n) üȤƽŤ
  real, intent(in), optional :: error  ! ̤
  integer :: ix, j, mx, half, val
  real :: div_fact
  real :: wg(n)

  y=0.0
  mx=size(x)
  half=(n-1)/2

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( mx, y ),  &
  &                                     "smooth_1d" )
  end if

  select case (method(1:3))
  case ("SMP")
     do j=1,n
        wg(j)=1.0
     end do

  case ("OPT")
     if(present(weight))then
        do j=1,n
           wg(j)=weight(j)
        end do
     end if
  end select

  if(method(1:3)/="MIN".and.method(1:3)/="MAX")then
!-- determining dividing factor

     div_fact=0.0

     do j=1,n
        if(wg(j)<0.0)then
           div_fact=1.0
           exit
        else
           div_fact=div_fact+wg(j)
        end if
     end do

!-- avoiding zero dividing

     if(div_fact==0.0)then
        div_fact=1.0
     end if

     do ix=half+1,mx-half
        do j=1,n
           y(ix)=y(ix)+x(ix-half-1+j)*wg(j)
        end do
        y(ix)=y(ix)/div_fact
     end do

  else

     select case (method(1:3))
     case ("MAX")
        do ix=half+1,mx-half
           val=x(ix-half)
           do j=2,n
              if(val<x(ix-half-1+j))then
                 val=x(ix-half-1+j)
              end if
           end do
           y(ix-half)=val
        end do

     case ("MIN")
        do ix=half+1,mx-half
           val=x(ix-half)
           do j=2,n
              if(val>x(ix-half-1+j))then
                 val=x(ix-half-1+j)
              end if
           end do
           y(ix-half)=val
        end do

     end select

  end if

end subroutine smooth_1d

!---------------------------------
!---------------------------------

subroutine smooth_2d( x, n, y, method, weight, error )
! 2 ǡˤĤ, ࡼ󥰤롼
! , error ץϵǽƤʤ.
  implicit none
  real, intent(in) :: x(:,:)  ! ࡼ󥰤ǡ
  integer, intent(in) :: n  ! ࡼαƶʻҿ(濴ޤ᤿)
  real, intent(inout) :: y(size(x,1),size(x,2))  ! ࡼ󥰤줿ǡ
  character(3), intent(in) :: method  ! ࡼ󥰤ˡ
                            ! "SMP" = ñʿ, "OPT" = ץŤ
                            ! "MAX" = , "MIN" = Ǿ
  real, intent(in), optional :: weight(n,n)  ! method  "OPT" ξ
                          ! weight(1,1) ü, weight(n,n) üȤƽŤ
  real, intent(in), optional :: error  ! ̤
  integer :: ix, iy, j, k, mx, my, half, val
  real :: div_fact
  real :: wg(n,n)

  y=0.0
  mx=size(x,1)
  my=size(x,2)
  half=(n-1)/2

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_2d( mx, my, y ),  &
  &                                     "smooth_2d" )
  end if

  select case (method(1:3))
  case ("SMP")
     do k=1,n
        do j=1,n
           wg(j,k)=1.0
        end do
     end do

  case ("OPT")
     if(present(weight))then
        do k=1,n
           do j=1,n
              wg(j,k)=weight(j,k)
           end do
        end do
     end if
  end select

  if(method(1:3)/="MIN".and.method(1:3)/="MAX")then
!-- determining dividing factor

     div_fact=0.0

     do k=1,n
        do j=1,n
           if(wg(j,k)<0.0)then
              div_fact=1.0
              exit
           else
              div_fact=div_fact+wg(j,k)
           end if
        end do
     end do

!-- avoiding zero dividing

     if(div_fact==0.0)then
        div_fact=1.0
     end if

     do iy=half+1,my-half
        do ix=half+1,mx-half
           do k=1,n
              do j=1,n
                 y(ix,iy)=y(ix,iy)+x(ix-half-1+j,iy-half-1+k)*wg(j,k)
              end do
           end do

           y(ix,iy)=y(ix,iy)/div_fact
        end do
     end do

  else

     select case (method(1:3))
     case ("MAX")
        do iy=half+1,my-half
           do ix=half+1,mx-half
              val=x(ix-half,iy-half)
              do k=2,n
                 do j=2,n
                    if(val<x(ix-half-1+j,iy-half-1+k))then
                       val=x(ix-half-1+j,iy-half-1+k)
                    end if
                 end do
              end do
              y(ix-half,iy-half)=val
           end do
        end do

     case ("MIN")
        do iy=half+1,my-half
           do ix=half+1,mx-half
              val=x(ix-half,iy-half)
              do k=2,n
                 do j=2,n
                    if(val>x(ix-half-1+j,iy-half-1+k))then
                       val=x(ix-half-1+j,iy-half-1+k)
                    end if
                 end do
              end do
              y(ix-half,iy-half)=val
           end do
        end do

     end select

  end if

end subroutine smooth_2d

!---------------------------------
!---------------------------------

subroutine smooth_3d( x, n, y, method, weight, error )
! 3 ǡˤĤ, ࡼ󥰤롼
! , error ץϵǽƤʤ.
  implicit none
  real, intent(in) :: x(:,:,:)  ! ࡼ󥰤ǡ
  integer, intent(in) :: n  ! ࡼαƶʻҿ(濴ޤ᤿)
  real, intent(inout) :: y(size(x,1),size(x,2),size(x,3))
                            ! ࡼ󥰤줿ǡ
  character(3), intent(in) :: method  ! ࡼ󥰤ˡ
                            ! "SMP" = ñʿ, "OPT" = ץŤ
                            ! "MAX" = , "MIN" = Ǿ
  real, intent(in), optional :: weight(n,n,n)  ! method  "OPT" ξ
  real, intent(in), optional :: error  ! ̤
  integer :: ix, iy, iz, j, k, l, mx, my, mz, half, val
  real :: div_fact
  real :: wg(n,n,n)

  y=0.0
  mx=size(x,1)
  my=size(x,2)
  mz=size(x,3)
  half=(n-1)/2

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_3d( mx, my, mz, y ),  &
  &                                     "smooth_3d" )
  end if

  select case (method(1:3))
  case ("SMP")
     do l=1,n
        do k=1,n
           do j=1,n
              wg(j,k,l)=1.0
           end do
        end do
     end do

  case ("OPT")
     if(present(weight))then
        do l=1,n
           do k=1,n
              do j=1,n
                 wg(j,k,l)=weight(j,k,l)
              end do
           end do
        end do
     end if
  end select

  if(method(1:3)/="MIN".and.method(1:3)/="MAX")then
!-- determining dividing factor

     div_fact=0.0

     do l=1,n
        do k=1,n
           do j=1,n
              if(wg(j,k,l)<0.0)then
                 div_fact=1.0
                 exit
              else
                 div_fact=div_fact+wg(j,k,l)
              end if
           end do
        end do
     end do

!-- avoiding zero dividing

     if(div_fact==0.0)then
        div_fact=1.0
     end if

     do iz=half+1,mz-half
        do iy=half+1,my-half
           do ix=half+1,mx-half
              do l=1,n
                 do k=1,n
                    do j=1,n
                       y(ix,iy,iz)=y(ix,iy,iz)  &
  &                                +x(ix-half-1+j,iy-half-1+k,iz-half-1+l)  &
  &                                *wg(j,k,l)
                    end do
                 end do
              end do

              y(ix,iy,iz)=y(ix,iy,iz)/div_fact
           end do
        end do
     end do

  else

     select case (method(1:3))
     case ("MAX")
        do iz=half+1,mz-half
           do iy=half+1,my-half
              do ix=half+1,mx-half
                 val=x(ix-half,iy-half,iz-half)
                 do l=2,n
                    do k=2,n
                       do j=2,n
                          if(val<x(ix-half-1+j,iy-half-1+k,iz-half-1+l))then
                             val=x(ix-half-1+j,iy-half-1+k,iz-half-1+l)
                          end if
                       end do
                    end do
                 end do
                 y(ix-half,iy-half,iz-half)=val
              end do
           end do
        end do

     case ("MIN")
        do iz=half+1,mz-half
           do iy=half+1,my-half
              do ix=half+1,mx-half
                 val=x(ix-half,iy-half,iz-half)
                 do l=2,n
                    do k=2,n
                       do j=2,n
                          if(val>x(ix-half-1+j,iy-half-1+k,iz-half-1+l))then
                             val=x(ix-half-1+j,iy-half-1+k,iz-half-1+l)
                          end if
                       end do
                    end do
                 end do
                 y(ix-half,iy-half,iz-half)=val
              end do
           end do
        end do

     end select

  end if

end subroutine smooth_3d

!---------------------------------
!---------------------------------

subroutine Move_ave( x, n, y, error, offset )
! ưʿѤ׻롼
  implicit none
  real, intent(in) :: x(:)  ! ǡ
  integer, intent(in) :: n  ! ʿѤȤ
  real, intent(inout) :: y(size(x))  ! ʿѲΥǡ.
                      ! ºݤ, y(1:n-1) ޤǤˤϥ.
  real, intent(in), optional :: error  ! »
  integer, intent(in), optional :: offset  ! ưʿѤ򳫻Ϥֹ.
                      ! default = n
  integer :: nx, i, ioff
  real :: tmp

  nx=size(x)
  y=0.0

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nx, y ),  &
  &                                     "Move_ave" )
  end if

  if(nx<n.or.n<2)then
     write(*,*) "### ERROR ### (Move_ave)"
     write(*,*) "x(nx) : nx must be more than n or n must be more than 2."
     write(*,*) "nx is ", nx, ", n is ", n, "."
     write(*,*) "STOP"
     stop
  end if

  if(present(offset))then
     if(offset>0)then
        ioff=offset
     else
        write(*,*) "### ERROR ### (Move_ave)"
        write(*,*) "offset must be more than 1."
        write(*,*) "STOP"
        stop
     end if
  else
     ioff=n
  end if

  if(present(error))then
     call Mean_1d( x(1:n), tmp, error )
     if(ioff>2)then
        y(1:ioff-1)=0.0
        y(nx-n+ioff+1:nx)=0.0
     end if
     y(ioff)=tmp

     do i=ioff+1,nx-n+ioff
        if(x(i+n-ioff)/=error.and.x(i-ioff)/=error)then
           y(i)=y(i-1)+(x(i+n-ioff)-x(i-ioff))/real(n)
        else
           call Mean_1d( x(i-ioff+1:i+n-ioff), y(i), error )
        end if
     end do
  else
     call Mean_1d( x(1:n), tmp )
     if(ioff>2)then
        y(1:ioff-1)=0.0
        y(nx-n+ioff+1:nx)=0.0
     end if
     y(ioff)=tmp

     do i=ioff+1,nx-n+ioff
        y(i)=y(i-1)+(x(i+n-ioff)-x(i-ioff))/real(n)
     end do
  end if

end subroutine Move_ave

!---------------------------------
!---------------------------------

subroutine Move_anom( x, n, y, error, offset )
! ưʿѤΥΥޥ׻롼
  implicit none
  real, intent(in) :: x(:)  ! ǡ
  integer, intent(in) :: n  ! ʿѤȤ
  real, intent(inout) :: y(size(x))  ! ʿѲΥǡ.
                      ! ºݤ, y(1:n-1) ޤǤˤϥ.
  real, intent(in), optional :: error  ! »
  integer, intent(in), optional :: offset  ! ưʿѤ򳫻Ϥֹ.
                      ! default = n
  integer :: nx, i, ioff
  real :: tmp, undef
  real :: bar(size(x))

  nx=size(x)
  y=0.0

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( nx, y ),  &
  &                                     "Move_anom" )
  end if

  if(nx<n.or.n<2)then
     write(*,*) "### ERROR ### (Move_anom)"
     write(*,*) "x(nx) : nx must be more than n or n must be more than 2."
     write(*,*) "nx is ", nx, ", n is ", n, "."
     write(*,*) "STOP"
     stop
  end if

  if(present(offset))then
     if(offset>0)then
        ioff=offset
     else
        write(*,*) "### ERROR ### (Move_anom)"
        write(*,*) "offset must be more than 1."
        write(*,*) "STOP"
        stop
     end if
  else
     ioff=n
  end if

  if(present(error))then
     undef=error
  else
     undef=0.0
  end if

  call Move_ave( x, n, bar, error=undef, offset=ioff )

  if(ioff>2)then
     y(1:ioff-1)=0.0
     y(nx-n+ioff+1:nx)=0.0
  end if
  do i=ioff,nx-n+ioff
     y(i)=x(i)-bar(i)
  end do

end subroutine Move_anom

!---------------------------------
!---------------------------------

subroutine spline_3_f( xi, xo, yi, yo, itype, t1, tn )
! xi 줿ǡ yi 3 ץ饤ؿ xo Ȥɸ
! yo Ȥ֤ͤ롼.
! itype, t1, tn ξüꤵɲþǤ, 餬ޤä
! ꤵʤ, ץ饤֤褦ꤵƤ.
! []
! xi, xo ϤȤƱɸ¸ߤ, ñ̤ƱΤƤʤ
! ʤʤ.
  implicit none
  real, intent(in) :: xi(:)  ! ǡƤ
  real, intent(in) :: xo(:)  ! ֤Ԥ
  real, intent(in) :: yi(size(xi))  ! ǡƤ
  real, intent(inout) :: yo(size(xo))  ! ǡƤ
  integer, intent(in), optional :: itype  ! ξüμ.
                             ! 1 = 1 ʬǻ.
                             ! 2 = 2 ʬǻ. [default]
  real, intent(in), optional :: t1  ! xo(1) Ǥʬ. [default = 0.0]
  real, intent(in), optional :: tn  ! xo(n) Ǥʬ. [default = 0.0]

  integer :: i, j, k, ni, no, inter_type, ix
  real :: ti1, ti2
  real, dimension(size(xi)) :: ai, bi, ci, di, zi, hi
  real, dimension(size(xi),size(xi)) :: a

  ni=size(xi)
  no=size(xo)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( ni, yi ),  &
  &                                     "spline_3" )
     call check_array_size_dmp_message( check_array_size_1d( no, yo ),  &
  &                                     "spline_3" )
  end if

  a=0.0
  ai=0.0
  bi=0.0
  ci=0.0
  di=0.0
  zi=0.0
  hi=0.0

  if(present(t1))then
     ti1=t1
  else
     ti1=0.0
  end if

  if(present(tn))then
     ti2=tn
  else
     ti2=0.0
  end if

  if(present(itype))then
     inter_type=itype
  else
     inter_type=2
  end if

!-- ϰϤΥå
  if(xi(1)>xo(1))then
     write(*,*) "*** ERROR (spline_3) *** : xo(1) must be G.E. to xi(1)."
     write(*,*) "stop."
     stop
  end if
  if(xi(ni)<xo(no))then
     write(*,*) "*** ERROR (spline_3) *** : xo(N) must be L.E. to xi(N)."
     write(*,*) "stop."
     stop
  end if

!-- 

  do i=2,ni
     hi(i)=xi(i)-xi(i-1)
  end do

  do i=2,ni-2
     a(i,i)=2.0*(hi(i+1)+hi(i))
     a(i,i-1)=hi(i)
     a(i,i+1)=hi(i+1)
     zi(i)=3.0*(yi(i+1)-yi(i))/hi(i+1)-3.0*(yi(i)-yi(i-1))/hi(i)
  end do

  if(inter_type==1)then
     a(1,1)=2.0
     a(1,2)=1.0
     a(ni-1,ni-2)=2.0*hi(ni-1)
     a(ni-1,ni-1)=4.0*hi(ni-1)+3.0*hi(ni)
     zi(1)=3.0*(yi(2)-yi(1))/(hi(2)**2)-3.0*ti1/hi(2)
     zi(ni-1)=-3.0*ti2+9.0*(yi(ni)-yi(ni-1))/hi(ni)  &
  &           -6.0*(yi(ni-1)-yi(ni-2))/hi(ni-1)
  else if(inter_type==2)then
     a(1,1)=1.0
     a(ni-1,ni-2)=hi(ni-1)
     a(ni-1,ni-1)=2.0*(hi(ni-1)+hi(ni))
     zi(1)=0.5*ti1
     zi(ni-1)=-0.5*ti2*hi(ni)+3.0*(yi(ni)-yi(ni-1))/hi(ni)  &
  &           -3.0*(yi(ni-1)-yi(ni-2))/hi(ni-1)
  end if

!--  b ׻.

  call tri_gauss( a(1:ni-1,1:ni-1), zi(1:ni-1), bi(1:ni-1) )

!-- b 򸵤, a, c, d 򻻽.

  do i=2,ni-1
     ai(i-1)=(bi(i)-bi(i-1))/(3.0*hi(i))
     ci(i-1)=(yi(i)-yi(i-1))/hi(i)-hi(i)*(bi(i)+2.0*bi(i-1))/3.0
     di(i-1)=yi(i-1)
  end do

  di(ni-1)=yi(ni-1)

  if(inter_type==1)then
     ci(ni-1)=-0.5*hi(ni)*bi(ni-1)+1.5*(yi(ni)-yi(ni-1))/hi(ni)-0.5*ti2
     ai(ni-1)=(ti2-ci(ni-1))/(3.0*hi(ni)*hi(ni))-2.0*bi(ni-1)/(3.0*hi(ni))
  else if(inter_type==2)then
     ci(ni-1)=-2.0*hi(ni)*bi(ni-1)/3.0+(yi(ni)-yi(ni-1))/hi(ni)-ti2*hi(ni)/6.0
     ai(ni-1)=(0.5*ti2-bi(ni-1))/(3.0*hi(ni))
  end if

!-- ǽŪʥץ饤ؿ xo Ǥͤ׻.

  do i=1,no
     call interpo_search_1df( xi, xo(i), ix )
     yo(i)=ai(ix)*((xo(i)-xi(ix))**3)  &
  &       +bi(ix)*((xo(i)-xi(ix))**2)  &
  &       +ci(ix)*(xo(i)-xi(ix))+di(ix)
  end do

end subroutine spline_3_f

!---------------------------------
!---------------------------------

subroutine spline_3_d( xi, xo, yi, yo, itype, t1, tn )
! xi 줿ǡ yi 3 ץ饤ؿ xo Ȥɸ
! yo Ȥ֤ͤ롼.
! itype, t1, tn ξüꤵɲþǤ, 餬ޤä
! ꤵʤ, ץ饤֤褦ꤵƤ.
! []
! xi, xo ϤȤƱɸ¸ߤ, ñ̤ƱΤƤʤ
! ʤʤ.
  implicit none
  double precision, intent(in) :: xi(:)  ! ǡƤ
  double precision, intent(in) :: xo(:)  ! ֤Ԥ
  double precision, intent(in) :: yi(size(xi))  ! ǡƤ
  double precision, intent(inout) :: yo(size(xo))  ! ǡƤ
  integer, intent(in), optional :: itype  ! ξüμ.
                             ! 1 = 1 ʬǻ.
                             ! 2 = 2 ʬǻ. [default]
  double precision, intent(in), optional :: t1  ! xo(1) Ǥʬ. [default = 0.0]
  double precision, intent(in), optional :: tn  ! xo(n) Ǥʬ. [default = 0.0]

  integer :: i, j, k, ni, no, inter_type, ix
  double precision :: ti1, ti2
  double precision, dimension(size(xi)) :: ai, bi, ci, di, zi, hi
  double precision, dimension(size(xi),size(xi)) :: a

  ni=size(xi)
  no=size(xo)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( ni, yi ),  &
  &                                     "spline_3" )
     call check_array_size_dmp_message( check_array_size_1d( no, yo ),  &
  &                                     "spline_3" )
  end if

  a=0.0d0
  ai=0.0d0
  bi=0.0d0
  ci=0.0d0
  di=0.0d0
  zi=0.0d0
  hi=0.0d0

  if(present(t1))then
     ti1=t1
  else
     ti1=0.0d0
  end if

  if(present(tn))then
     ti2=tn
  else
     ti2=0.0d0
  end if

  if(present(itype))then
     inter_type=itype
  else
     inter_type=2
  end if

!-- ϰϤΥå
  if(xi(1)>xo(1))then
     write(*,*) "*** ERROR (spline_3) *** : xo(1) must be G.E. to xi(1)."
     write(*,*) "stop."
     stop
  end if
  if(xi(ni)<xo(no))then
     write(*,*) "*** ERROR (spline_3) *** : xo(N) must be L.E. to xi(N)."
     write(*,*) "stop."
     stop
  end if

!-- 

  do i=2,ni
     hi(i)=xi(i)-xi(i-1)
  end do

  do i=2,ni-2
     a(i,i)=2.0d0*(hi(i+1)+hi(i))
     a(i,i-1)=hi(i)
     a(i,i+1)=hi(i+1)
     zi(i)=3.0d0*(yi(i+1)-yi(i))/hi(i+1)-3.0d0*(yi(i)-yi(i-1))/hi(i)
  end do

  if(inter_type==1)then
     a(1,1)=2.0d0
     a(1,2)=1.0d0
     a(ni-1,ni-2)=2.0d0*hi(ni-1)
     a(ni-1,ni-1)=4.0d0*hi(ni-1)+3.0d0*hi(ni)
     zi(1)=3.0d0*(yi(2)-yi(1))/(hi(2)**2)-3.0d0*ti1/hi(2)
     zi(ni-1)=-3.0d0*ti2+9.0d0*(yi(ni)-yi(ni-1))/hi(ni)  &
  &           -6.0d0*(yi(ni-1)-yi(ni-2))/hi(ni-1)
  else if(inter_type==2)then
     a(1,1)=1.0d0
     a(ni-1,ni-2)=hi(ni-1)
     a(ni-1,ni-1)=2.0d0*(hi(ni-1)+hi(ni))
     zi(1)=0.5d0*ti1
     zi(ni-1)=-0.5d0*ti2*hi(ni)+3.0d0*(yi(ni)-yi(ni-1))/hi(ni)  &
  &           -3.0d0*(yi(ni-1)-yi(ni-2))/hi(ni-1)
  end if

!--  b ׻.

  call tri_gauss( a(1:ni-1,1:ni-1), zi(1:ni-1), bi(1:ni-1) )

!-- b 򸵤, a, c, d 򻻽.

  do i=2,ni-1
     ai(i-1)=(bi(i)-bi(i-1))/(3.0d0*hi(i))
     ci(i-1)=(yi(i)-yi(i-1))/hi(i)-hi(i)*(bi(i)+2.0d0*bi(i-1))/3.0d0
     di(i-1)=yi(i-1)
  end do

  di(ni-1)=yi(ni-1)

  if(inter_type==1)then
     ci(ni-1)=-0.5d0*hi(ni)*bi(ni-1)+1.5d0*(yi(ni)-yi(ni-1))/hi(ni)-0.5d0*ti2
     ai(ni-1)=(ti2-ci(ni-1))/(3.0d0*hi(ni)*hi(ni))-2.0d0*bi(ni-1)/(3.0d0*hi(ni))
  else if(inter_type==2)then
     ci(ni-1)=-2.0d0*hi(ni)*bi(ni-1)/3.0d0+(yi(ni)-yi(ni-1))/hi(ni)-ti2*hi(ni)/6.0d0
     ai(ni-1)=(0.5d0*ti2-bi(ni-1))/(3.0d0*hi(ni))
  end if

!-- ǽŪʥץ饤ؿ xo Ǥͤ׻.

  do i=1,no
     call interpo_search_1dd( xi, xo(i), ix )
     yo(i)=ai(ix)*((xo(i)-xi(ix))**3)  &
  &       +bi(ix)*((xo(i)-xi(ix))**2)  &
  &       +ci(ix)*(xo(i)-xi(ix))+di(ix)
  end do

end subroutine spline_3_d

!---------------------------------
!---------------------------------

subroutine Bubble_Sort_i( a, b, sig )
! Х֥륽ȤѤƿͥǡ sig ˥Ȥ.
  implicit none
  integer, intent(in) :: a(:)  ! Ȥ
  integer, intent(inout) :: b(size(a))  ! Ȥ̤Ǽ
  character(1), intent(in) :: sig  ! Ȥν
                                   ! 'i' = ֹμ㤤Τ˾ͤ
                                   ! 'r' = ֹμ㤤Τ礭ͤ
  integer :: i, j, n
  integer :: tmp

  n=size(a)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( n, b ),  &
  &                                     "Bubble_Sort" )
  end if

  if(sig/='i'.and.sig/='r')then
     write(*,*) "### ERROR ###"
     write(*,*) "sig flag is 'r' .or. 'i', STOP."
     stop
  end if

  do i=1,n
     b(i)=a(i)
  end do

  if(sig=='i')then  ! ٤
     do i=1,n
        do j=1,n-1
           if(b(j)>b(j+1))then
              tmp=b(j+1)
              b(j+1)=b(j)
              b(j)=tmp
           end if
        end do
     end do
  else
     do i=1,n
        do j=1,n-1
           if(b(j)<b(j+1))then
              tmp=b(j+1)
              b(j+1)=b(j)
              b(j)=tmp
           end if
        end do
     end do
  end if

end subroutine Bubble_Sort_i

!---------------------------------
!---------------------------------

subroutine Bubble_Sort_f( a, b, sig )
! Х֥륽ȤѤƿͥǡ sig ˥Ȥ.
  implicit none
  real, intent(in) :: a(:)  ! Ȥ
  real, intent(inout) :: b(size(a))  ! Ȥ̤Ǽ
  character(1), intent(in) :: sig  ! Ȥν
                                   ! 'i' = ֹμ㤤Τ˾ͤ
                                   ! 'r' = ֹμ㤤Τ礭ͤ
  integer :: i, j, n
  real :: tmp

  n=size(a)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( n, b ),  &
  &                                     "Bubble_Sort" )
  end if

  if(sig/='i'.and.sig/='r')then
     write(*,*) "### ERROR ###"
     write(*,*) "sig flag is 'r' .or. 'i', STOP."
     stop
  end if

  do i=1,n
     b(i)=a(i)
  end do

  if(sig=='i')then  ! ٤
     do i=1,n
        do j=1,n-1
           if(b(j)>b(j+1))then
              tmp=b(j+1)
              b(j+1)=b(j)
              b(j)=tmp
           end if
        end do
     end do
  else
     do i=1,n
        do j=1,n-1
           if(b(j)<b(j+1))then
              tmp=b(j+1)
              b(j+1)=b(j)
              b(j)=tmp
           end if
        end do
     end do
  end if

end subroutine Bubble_Sort_f

!---------------------------------
!---------------------------------

subroutine Bubble_Sort_d( a, b, sig )
! Х֥륽ȤѤƿͥǡ sig ˥Ȥ.
  implicit none
  double precision, intent(in) :: a(:)  ! Ȥ
  double precision, intent(inout) :: b(size(a))  ! Ȥ̤Ǽ
  character(1), intent(in) :: sig  ! Ȥν
                                   ! 'i' = ֹμ㤤Τ˾ͤ
                                   ! 'r' = ֹμ㤤Τ礭ͤ
  integer :: i, j, n
  double precision :: tmp

  n=size(a)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( n, b ),  &
  &                                     "Bubble_Sort" )
  end if

  if(sig/='i'.and.sig/='r')then
     write(*,*) "### ERROR ###"
     write(*,*) "sig flag is 'r' .or. 'i', STOP."
     stop
  end if

  do i=1,n
     b(i)=a(i)
  end do

  if(sig=='i')then  ! ٤
     do i=1,n
        do j=1,n-1
           if(b(j)>b(j+1))then
              tmp=b(j+1)
              b(j+1)=b(j)
              b(j)=tmp
           end if
        end do
     end do
  else
     do i=1,n
        do j=1,n-1
           if(b(j)<b(j+1))then
              tmp=b(j+1)
              b(j+1)=b(j)
              b(j)=tmp
           end if
        end do
     end do
  end if

end subroutine Bubble_Sort_d

!---------------------------------
!---------------------------------

subroutine Quick_Sort_i( a, b, sig )
! Quick ȤѤƿͥǡ sig ˥Ȥ.
  implicit none
  integer, intent(in) :: a(:)  ! Ȥ
  integer, intent(inout) :: b(size(a))  ! Ȥ̤Ǽ
  character(1), intent(in) :: sig  ! Ȥν
                                   ! 'i' = ֹμ㤤Τ˾ͤ
                                   ! 'r' = ֹμ㤤Τ礭ͤ
  integer :: i, j, k, n, itmp, nt, isplt
  integer :: vtmp, refv
  integer :: c(size(a))  ! Ȥ̤Ǽ
  logical :: diflag
  logical :: splitflag(size(a))

  nt=size(a)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( n, b ),  &
  &                                     "Bubble_Sort" )
  end if

  if(sig/='i'.and.sig/='r')then
     write(*,*) "### ERROR ###"
     write(*,*) "sig flag is 'r' .or. 'i', STOP."
     stop
  end if

  c=a
  n=nt
  isplt=nt
  splitflag=.false.
  splitflag(1)=.true.

  do k=1,nt

     if(k>1.and.splitflag(k).eqv..true.)then
        do j=k+1,nt
           if(splitflag(j).eqv..true.)then
              isplt=j
              n=isplt-1
              exit
           else if(j==nt)then
              isplt=nt+1
              n=nt
              exit
           end if
        end do
     end if

     ! ѡƥե饰뤫å
     do while(splitflag(k).eqv..true.)

        !-- 1 ѡƥǤο (ƱͤΤߤǤޤȤƤ뤫)
        diflag=.false.

        if(isplt-1>k)then
           do i=k+1,isplt-1
              if(c(i-1)/=c(i))then
                 diflag=.true.
                 exit
              end if
           end do
        end if

        if(diflag.eqv..true.)then

           itmp=k
           refv=c(itmp)

           !-- 1 ѡƥǤΥȤ 2 ʬ䲽
           !-- ǽõ, refv = ѡƥƬȤƤΤ.
           !-- k = õ (itmp), n = õ (isplt)
           !-- [ѡƥΰ]
           !-- 1. õĤ餺, õȽв񤦾, 
           !--    вä 1 ĸѡƥ.
           !-- 2. õĤ餺, õȽв񤦾,
           !--    вä 1 ѡƥ.
           do j=n,k,-1
              if(j>itmp)then
                 if(refv>c(j))then  ! õ, refv ̤򸡽
                    vtmp=c(j)
                    c(j)=c(itmp)
                    c(itmp)=vtmp  ! , c(itmp) ؤ

                    if(itmp+1==j)then  ! ؤܤǵ, 
                       isplt=j
                       n=j-1
                       splitflag(j)=.true.
                       exit
                    else
                       do i=itmp+1,n  ! ʳõ, refv ʾ򸡽
                          if(i<j)then
                             if(refv<=c(i))then  ! Τ, ֹ.
                                itmp=i
                                exit
                             end if
                          else  ! Τʤ, itmp  j ľ (go to 20)
                             itmp=j
                             exit
                          end if
                       end do
                    end if
                 end if
              else if(j==itmp)then  ! õõȽв
                 if(itmp==k)then  ! вä꤬ѡƥƬξ,
                    isplt=j+1  ! ʬ䤵줿ѡƥƬֹ
                    n=j
                    splitflag(j+1)=.true.
                    exit
                 else  ! вä꤬ѡƥξ, 
                    isplt=j  ! ʬ䤵줿ѡƥƬֹ
                    n=j-1
                    splitflag(j)=.true.
                    exit
                 end if
              else if(j<itmp)then  ! õõȽв (20 )
                 isplt=j+1  ! ʬ䤵줿ѡƥƬֹ
                 n=j
                 splitflag(j+1)=.true.
                 exit
              end if
           end do

        else

           splitflag(k)=.false.

        end if

     end do

  end do

  b=c

  if(sig=='r')then  ! ٤
     do i=1,n
        b(i)=c(n-i+1)
     end do
  end if

end subroutine Quick_Sort_i

!---------------------------------
!---------------------------------

subroutine Quick_Sort_f( a, b, sig )
! Quick ȤѤƿͥǡ sig ˥Ȥ.
  implicit none
  real, intent(in) :: a(:)  ! Ȥ
  real, intent(inout) :: b(size(a))  ! Ȥ̤Ǽ
  character(1), intent(in) :: sig  ! Ȥν
                                   ! 'i' = ֹμ㤤Τ˾ͤ
                                   ! 'r' = ֹμ㤤Τ礭ͤ
  integer :: i, j, k, n, itmp, nt, isplt
  real :: vtmp, refv
  real :: c(size(a))  ! Ȥ̤Ǽ
  logical :: diflag
  logical :: splitflag(size(a))

  nt=size(a)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( n, b ),  &
  &                                     "Bubble_Sort" )
  end if

  if(sig/='i'.and.sig/='r')then
     write(*,*) "### ERROR ###"
     write(*,*) "sig flag is 'r' .or. 'i', STOP."
     stop
  end if

  c=a
  n=nt
  isplt=nt
  splitflag=.false.
  splitflag(1)=.true.

  do k=1,nt

     if(k>1.and.splitflag(k).eqv..true.)then
        do j=k+1,nt
           if(splitflag(j).eqv..true.)then
              isplt=j
              n=isplt-1
              exit
           else if(j==nt)then
              isplt=nt+1
              n=nt
              exit
           end if
        end do
     end if

     ! ѡƥե饰뤫å
     do while(splitflag(k).eqv..true.)

        !-- 1 ѡƥǤο (ƱͤΤߤǤޤȤƤ뤫)
        diflag=.false.

        if(isplt-1>k)then
           do i=k+1,isplt-1
              if(c(i-1)/=c(i))then
                 diflag=.true.
                 exit
              end if
           end do
        end if

        if(diflag.eqv..true.)then

           itmp=k
           refv=c(itmp)

           !-- 1 ѡƥǤΥȤ 2 ʬ䲽
           !-- ǽõ, refv = ѡƥƬȤƤΤ.
           !-- k = õ (itmp), n = õ (isplt)
           !-- [ѡƥΰ]
           !-- 1. õĤ餺, õȽв񤦾, 
           !--    вä 1 ĸѡƥ.
           !-- 2. õĤ餺, õȽв񤦾,
           !--    вä 1 ѡƥ.
           do j=n,k,-1
              if(j>itmp)then
                 if(refv>c(j))then  ! õ, refv ̤򸡽
                    vtmp=c(j)
                    c(j)=c(itmp)
                    c(itmp)=vtmp  ! , c(itmp) ؤ

                    if(itmp+1==j)then  ! ؤܤǵ, 
                       isplt=j
                       n=j-1
                       splitflag(j)=.true.
                       exit
                    else
                       do i=itmp+1,n  ! ʳõ, refv ʾ򸡽
                          if(i<j)then
                             if(refv<=c(i))then  ! Τ, ֹ.
                                itmp=i
                                exit
                             end if
                          else  ! Τʤ, itmp  j ľ (go to 20)
                             itmp=j
                             exit
                          end if
                       end do
                    end if
                 end if
              else if(j==itmp)then  ! õõȽв
                 if(itmp==k)then  ! вä꤬ѡƥƬξ,
                    isplt=j+1  ! ʬ䤵줿ѡƥƬֹ
                    n=j
                    splitflag(j+1)=.true.
                    exit
                 else  ! вä꤬ѡƥξ, 
                    isplt=j  ! ʬ䤵줿ѡƥƬֹ
                    n=j-1
                    splitflag(j)=.true.
                    exit
                 end if
              else if(j<itmp)then  ! õõȽв (20 )
                 isplt=j+1  ! ʬ䤵줿ѡƥƬֹ
                 n=j
                 splitflag(j+1)=.true.
                 exit
              end if
           end do

        else

           splitflag(k)=.false.

        end if

     end do

  end do

  b=c

  if(sig=='r')then  ! ٤
     do i=1,n
        b(i)=c(n-i+1)
     end do
  end if

end subroutine Quick_Sort_f

!---------------------------------
!---------------------------------

subroutine Quick_Sort_d( a, b, sig )
! Quick ȤѤƿͥǡ sig ˥Ȥ.
  implicit none
  double precision, intent(in) :: a(:)  ! Ȥ
  double precision, intent(inout) :: b(size(a))  ! Ȥ̤Ǽ
  character(1), intent(in) :: sig  ! Ȥν
                                   ! 'i' = ֹμ㤤Τ˾ͤ
                                   ! 'r' = ֹμ㤤Τ礭ͤ
  integer :: i, j, k, n, itmp, nt, isplt
  double precision :: vtmp, refv
  double precision :: c(size(a))  ! Ȥ̤Ǽ
  logical :: diflag
  logical :: splitflag(size(a))

  nt=size(a)

  if(check_array_size_iflag>0)then
     call check_array_size_dmp_message( check_array_size_1d( n, b ),  &
  &                                     "Bubble_Sort" )
  end if

  if(sig/='i'.and.sig/='r')then
     write(*,*) "### ERROR ###"
     write(*,*) "sig flag is 'r' .or. 'i', STOP."
     stop
  end if

  c=a
  n=nt
  isplt=nt
  splitflag=.false.
  splitflag(1)=.true.

  do k=1,nt

     if(k>1.and.splitflag(k).eqv..true.)then
        do j=k+1,nt
           if(splitflag(j).eqv..true.)then
              isplt=j
              n=isplt-1
              exit
           else if(j==nt)then
              isplt=nt+1
              n=nt
              exit
           end if
        end do
     end if

     ! ѡƥե饰뤫å
     do while(splitflag(k).eqv..true.)

        !-- 1 ѡƥǤο (ƱͤΤߤǤޤȤƤ뤫)
        diflag=.false.

        if(isplt-1>k)then
           do i=k+1,isplt-1
              if(c(i-1)/=c(i))then
                 diflag=.true.
                 exit
              end if
           end do
        end if

        if(diflag.eqv..true.)then

           itmp=k
           refv=c(itmp)

           !-- 1 ѡƥǤΥȤ 2 ʬ䲽
           !-- ǽõ, refv = ѡƥƬȤƤΤ.
           !-- k = õ (itmp), n = õ (isplt)
           !-- [ѡƥΰ]
           !-- 1. õĤ餺, õȽв񤦾, 
           !--    вä 1 ĸѡƥ.
           !-- 2. õĤ餺, õȽв񤦾,
           !--    вä 1 ѡƥ.
           do j=n,k,-1
              if(j>itmp)then
                 if(refv>c(j))then  ! õ, refv ̤򸡽
                    vtmp=c(j)
                    c(j)=c(itmp)
                    c(itmp)=vtmp  ! , c(itmp) ؤ

                    if(itmp+1==j)then  ! ؤܤǵ, 
                       isplt=j
                       n=j-1
                       splitflag(j)=.true.
                       exit
                    else
                       do i=itmp+1,n  ! ʳõ, refv ʾ򸡽
                          if(i<j)then
                             if(refv<=c(i))then  ! Τ, ֹ.
                                itmp=i
                                exit
                             end if
                          else  ! Τʤ, itmp  j ľ (go to 20)
                             itmp=j
                             exit
                          end if
                       end do
                    end if
                 end if
              else if(j==itmp)then  ! õõȽв
                 if(itmp==k)then  ! вä꤬ѡƥƬξ,
                    isplt=j+1  ! ʬ䤵줿ѡƥƬֹ
                    n=j
                    splitflag(j+1)=.true.
                    exit
                 else  ! вä꤬ѡƥξ, 
                    isplt=j  ! ʬ䤵줿ѡƥƬֹ
                    n=j-1
                    splitflag(j)=.true.
                    exit
                 end if
              else if(j<itmp)then  ! õõȽв (20 )
                 isplt=j+1  ! ʬ䤵줿ѡƥƬֹ
                 n=j
                 splitflag(j+1)=.true.
                 exit
              end if
           end do

        else

           splitflag(k)=.false.

        end if

     end do

  end do

  b=c

  if(sig=='r')then  ! ٤
     do i=1,n
        b(i)=c(n-i+1)
     end do
  end if

end subroutine Quick_Sort_d

!---------------------------------
!---------------------------------
!---- ʲ, private 롼----
!---------------------------------
!---------------------------------

subroutine summf( z, add, undeff )
! undef ±黻Ԥ private 롼. ȤԲ.
  implicit none
  real, intent(in) :: z(:)
  real, intent(inout) :: add
  real, intent(in), optional :: undeff
  integer :: i
  integer :: nx

  nx=size(z)

  add=0.0
  if(present(undeff))then
     do i=1,nx
        if(undeff/=z(i))then
           add=add+z(i)
        end if
     end do
  else
     do i=1,nx
        add=add+z(i)
     end do
  end if

end subroutine summf

subroutine summd( z, add, undeff )
! undef ±黻Ԥ private 롼. ȤԲ.
  implicit none
  double precision, intent(in) :: z(:)
  double precision, intent(inout) :: add
  double precision, intent(in), optional :: undeff
  integer :: i
  integer :: nx

  nx=size(z)

  add=0.0d0
  if(present(undeff))then
     do i=1,nx
        if(undeff/=z(i))then
           add=add+z(i)
        end if
     end do
  else
     do i=1,nx
        add=add+z(i)
     end do
  end if

end subroutine summd

subroutine replace_undef_f( fix, fiy, fox, foy, undef )
! fix, fiy ȤǡƱ 2 ĤΥǡˤĤ, ƥǡӤ,
! ̤ͤäƤ, ⤦̤ǤϤʤ, ξȤ
! ̤Ȥ undef .
  implicit none
  real, intent(in) :: fix(:), fiy(size(fix))
  real, intent(inout) :: fox(size(fix)), foy(size(fix))
  real, intent(in) :: undef
  integer :: i, nx

  nx=size(fix)
  fox=fix
  foy=fiy

  do i=1,nx
     if(fix(i)==undef.or.fiy(i)==undef)then
        fox(i)=undef
        foy(i)=undef
     end if
  end do

end subroutine replace_undef_f

subroutine replace_undef_d( fix, fiy, fox, foy, undef )
! fix, fiy ȤǡƱ 2 ĤΥǡˤĤ, ƥǡӤ,
! ̤ͤäƤ, ⤦̤ǤϤʤ, ξȤ
! ̤Ȥ undef .
  implicit none
  double precision, intent(in) :: fix(:), fiy(size(fix))
  double precision, intent(inout) :: fox(size(fix)), foy(size(fix))
  double precision, intent(in) :: undef
  integer :: i, nx

  nx=size(fix)
  fox=fix
  foy=fiy

  do i=1,nx
     if(fix(i)==undef.or.fiy(i)==undef)then
        fox(i)=undef
        foy(i)=undef
     end if
  end do

end subroutine replace_undef_d

end module
