module val_alloc
! 変数の定義
! 変数名の命名規則
! 実数 -> r, 純虚数 -> i, 複素数 -> c
! 平均場 -> b, 擾乱場 -> p
! 時間発展 -> old, new

  use val_define
  use read_namelist

  implicit none

contains

subroutine val_allocate()

  implicit none

  integer :: i, j

  allocate(ri(ni))  ! スカラー動径座標初期値
  allocate(thetai(nthetai))  ! 接線座標初期値
  allocate(rs(nr))  ! スカラー動径座標
  allocate(rv(nr))  ! ベクトル動径座標
  allocate(theta(ntheta))  ! 接線座標
  allocate(hib(nthetai,ni))  ! 初期ジオポテンシャル平均場
  allocate(uib(nthetai,ni))  ! 初期動径風平均場
  allocate(vib(nthetai,ni))  ! 初期接線風平均場
  allocate(epsu(nr))  ! レイリーダンピング係数 u
  allocate(epsv(nr))  ! レイリーダンピング係数 v
  allocate(epsh(nr))  ! レイリーダンピング係数 h
  allocate(coril(nr))  ! コリオリパラメータ
!-- 2d val
  allocate(urp_dmp(nr,ntheta))  ! 動径風速 dmp
  allocate(vrp_dmp(nr,ntheta))  ! 接線風速 dmp
  allocate(hrp_dmp(nr,ntheta))  ! ジオポテンシャル dmp
  allocate(urp_old(nr,ntheta))  ! 動径風速 old
  allocate(vrp_old(nr,ntheta))  ! 接線風速 old
  allocate(hrp_old(nr,ntheta))  ! ジオポテンシャル old
  allocate(uip_old(nr,ntheta))  ! 動径風速 old
  allocate(vip_old(nr,ntheta))  ! 接線風速 old
  allocate(hip_old(nr,ntheta))  ! ジオポテンシャル old
  allocate(urp_new(nr,ntheta))  ! 動径風速 new
  allocate(vrp_new(nr,ntheta))  ! 接線風速 new
  allocate(hrp_new(nr,ntheta))  ! ジオポテンシャル new
  allocate(uip_new(nr,ntheta))  ! 動径風速 new
  allocate(vip_new(nr,ntheta))  ! 接線風速 new
  allocate(hip_new(nr,ntheta))  ! ジオポテンシャル new
  allocate(durpdr(nr,ntheta))
  allocate(dvrpdr(nr,ntheta))
  allocate(dhrpdr(nr,ntheta))
  allocate(duipdr(nr,ntheta))
  allocate(dvipdr(nr,ntheta))
  allocate(dhipdr(nr,ntheta))
  allocate(inv_up(ntheta,nr))
  allocate(inv_vp(ntheta,nr))
  allocate(inv_hp(ntheta,nr))

!-- complex, save part

  allocate(ucp_dmp(nr,ntheta))  ! 動径風速 old
  allocate(vcp_dmp(nr,ntheta))  ! 接線風速 old
  allocate(hcp_dmp(nr,ntheta))  ! ジオポテンシャル old
  allocate(ucp_tmp(nr,ntheta))  ! 動径風速 old
  allocate(vcp_tmp(nr,ntheta))  ! 接線風速 old
  allocate(hcp_tmp(nr,ntheta))  ! ジオポテンシャル old
  allocate(ucp_old(nr,ntheta))  ! 動径風速 old
  allocate(vcp_old(nr,ntheta))  ! 接線風速 old
  allocate(hcp_old(nr,ntheta))  ! ジオポテンシャル old
  allocate(ucp_new(nr,ntheta))  ! 動径風速 new
  allocate(vcp_new(nr,ntheta))  ! 接線風速 new
  allocate(hcp_new(nr,ntheta))  ! ジオポテンシャル new
  allocate(ducpdr(nr,ntheta))
  allocate(dvcpdr(nr,ntheta))
  allocate(dhcpdr(nr,ntheta))
  allocate(updup(nr,ntheta))  ! updup
  allocate(updvp(nr,ntheta))  ! updvp
  allocate(updhp(nr,ntheta))  ! updhp
  allocate(vpdup(nr,ntheta))  ! vpdup
  allocate(vpdvp(nr,ntheta))  ! vpdvp
  allocate(vpdhp(nr,ntheta))  ! vpdhp
  allocate(hpdup(nr,ntheta))  ! hpdup
  allocate(hpdvp(nr,ntheta))  ! hpdvp
  allocate(hpdhp(nr,ntheta))  ! hpdhp
  allocate(upup(nr,ntheta))  ! upup
  allocate(upvp(nr,ntheta))  ! upvp
  allocate(uphp(nr,ntheta))  ! uphp
  allocate(vpup(nr,ntheta))  ! vpup
  allocate(vpvp(nr,ntheta))  ! vpvp
  allocate(vphp(nr,ntheta))  ! vphp
  allocate(hpup(nr,ntheta))  ! hpup
  allocate(hpvp(nr,ntheta))  ! hpvp
  allocate(hphp(nr,ntheta))  ! hphp
  allocate(forceu(nr,ntheta))  ! forceu
  allocate(forcev(nr,ntheta))  ! forcev
  allocate(forceh(nr,ntheta))  ! forceh
  allocate(forceua(nr,ntheta))  ! forceu
  allocate(forceva(nr,ntheta))  ! forcev
  allocate(forceha(nr,ntheta))  ! forceh
  allocate(eup(nr,ntheta))  ! レイリーダンピング項 u
  allocate(evp(nr,ntheta))  ! レイリーダンピング項 v
  allocate(ehp(nr,ntheta))  ! レイリーダンピング項 h
  allocate(corilu(nr,ntheta))  ! コリオリ項 u
  allocate(corilv(nr,ntheta))  ! コリオリ項 v
  allocate(fup(nr,jnt))
  allocate(fvp(nr,jnt))
  allocate(fhp(nr,jnt))
  allocate(fdupdr(nr,jnt))
  allocate(fdvpdr(nr,jnt))
  allocate(fdhpdr(nr,jnt))
  allocate(fdupdt(nr,jnt))
  allocate(fdvpdt(nr,jnt))
  allocate(fdhpdt(nr,jnt))
  allocate(frup(nr,jnt))
  allocate(frvp(nr,jnt))
  allocate(frhp(nr,jnt))
  allocate(frdupdr(nr,jnt))
  allocate(frdvpdr(nr,jnt))
  allocate(frdhpdr(nr,jnt))
  allocate(frdupdt(nr,jnt))
  allocate(frdvpdt(nr,jnt))
  allocate(frdhpdt(nr,jnt))
  allocate(fupup(nr,jnt)) 
  allocate(fupvp(nr,jnt))
  allocate(fuphp(nr,jnt))
  allocate(fvpvp(nr,jnt)) 
  allocate(fvphp(nr,jnt)) 
  allocate(fhphp(nr,jnt)) 
  allocate(fupdup(nr,jnt))
  allocate(fupdvp(nr,jnt))
  allocate(fupdhp(nr,jnt))
  allocate(fvpdup(nr,jnt))
  allocate(fvpdvp(nr,jnt))
  allocate(fvpdhp(nr,jnt))
  allocate(fhpdup(nr,jnt))
  allocate(fhpdvp(nr,jnt))
  allocate(fhpdhp(nr,jnt))
  allocate(fiupup(nr,jnt)) 
  allocate(fiupvp(nr,jnt))
  allocate(fiuphp(nr,jnt))
  allocate(fivpvp(nr,jnt)) 
  allocate(fivphp(nr,jnt)) 
  allocate(fihphp(nr,jnt)) 
  allocate(fiupdup(nr,jnt))
  allocate(fiupdvp(nr,jnt))
  allocate(fiupdhp(nr,jnt))
  allocate(fivpdup(nr,jnt))
  allocate(fivpdvp(nr,jnt))
  allocate(fivpdhp(nr,jnt))
  allocate(fihpdup(nr,jnt))
  allocate(fihpdvp(nr,jnt))
  allocate(fihpdhp(nr,jnt))

!  coril=1.0e-5
  do i=1,nr
     coril(i)=rs(i)*1.0e-11
  end do

end subroutine

end module
