program fft_solver_isp
! Holton (2004) non-divergent barotropic vortex model
! Updated to the non-divergent barotropic model with stretching forcing
!   in Rozoff et al. (2009; JAS)
  use gtool_history
  use Derivation
  use Statistics
  use Math_Const
  use Phys_Const
  use Basis
  use ffts
  use fft_saveval_define
  use fft_saveval_alloc
  use fft_val_define_isp
  use fft_rotate
  use fft_read_namelist
  use fft_val_alloc_isp
  use fft_time_scheme_isp
  use fftsub_mod
  use fftsub_mod_isp
  use fft_force_solv_isp

  implicit none

!-- do loop 用変数の定義
  integer :: i, j, it, subm
  integer :: access, status

  type(GT_HISTORY) :: dmp_hst

!-- namelist の読み込み

  call fft_read_name_isp()

!-- allocating array

  call fft_saveval_allocate()
  call fft_saveval_allocate_isp()
  call fft_val_allocate()

!-- 初期値化 (計算領域の設定や境界条件の設定, 特にポアソン計算について)

  call fft_all_clear_isp()

!-- 格子点の再定義

  call fft_val_coordinate()

  if(force_type==4)then
     write(*,*) "starting initialization."

     !-- calculating rotate array 2,3,5,7
     call rotate_array_d()

     !-- calculating rotate array jnt
     call prim_calc( jynt, pyfact(1:4), pyfact(5) )

     write(*,*) "prim_calc check", jynt, pyfact

     allocate(omegayjbr(0:jynt-1,0:jynt-1))
     allocate(omegayjnr(0:jynt-1,0:jynt-1))
     allocate(omegayjbi(0:jynt-1,0:jynt-1))
     allocate(omegayjni(0:jynt-1,0:jynt-1))

     call rotate_calc_d( jynt, 'r', pyfact,  &
  &                    omegayjbr(0:pyfact(5)-1,0:pyfact(5)-1),  &
  &                    omegayjnr(0:jynt-1,0:jynt-1) )
     call rotate_calc_d( jynt, 'i', pyfact,  &
  &                    omegayjbi(0:pyfact(5)-1,0:pyfact(5)-1),  &
  &                    omegayjni(0:jynt-1,0:jynt-1) )
  end if

!-- stretching 時の係数設定

  if(flag_stretch.eqv..true.)then
     f0=2.0d0*omega_dp*dsin(cent_lat*pi_dp/180.0d0)
     !-- x, y 座標は xi, yi と同じと仮定している (zi, cr は内挿用変数, ここだけで使う).
     call HistoryGet( trim(sth_fname), trim(adjustl(inixd)), xi )
     call HistoryGet( trim(sth_fname), trim(adjustl(iniyd)), yi )
     call HistoryGet( trim(sth_fname), trim(adjustl(sth_vname)), zi )
     write(*,*) "starting interpolation of stretching coefficient."
     call auto_interpolation_2d( xi, yi, xj, yj, zi, cr )
     call rearrange_rxy2ryx_isp( jxnt, jynt, cr(1:jxnt,1:jynt),  &
  &                              cr_isp(1:jynt,1:jxnt) )
     write(*,*) "starting interpolation of the initial vorticity."
     call HistoryGet( trim(ininame), trim(adjustl(iniz)), zi )
     call auto_interpolation_2d( xi, yi, xj, yj, zi, cr )
     call rearrange_rxy2ryx_isp( jxnt, jynt, cr(1:jxnt,1:jynt),  &
  &                              zinit_isp(1:jynt,1:jxnt) )
     if(force_kr(1)>0.and.force_kr(2)>=force_kr(1))then
        write(*,*) "forcing radial range (force_kr) is ", force_kr
     else
        write(*,*) "force_kr is invalid range (force_kr(1)>0 and force_kr(2)>=force_kr(1))."
        stop
     end if
  end if

write(*,*) "starting initialization."

!-- Initializing FFT

  !-- No change for ITJ, TJ, ITI, TI
  CALL P2INIT( ny, nx, ITJR, TJR, ITIR, TIR )
  CALL P2INIT( jynt, jxnt, ITJJ, TJJ, ITIJ, TIJ )

!-- reading initial data

  if(resopt==0)then
     call HistoryGet( trim(ininame), trim(adjustl(inixd)), xi )
     call HistoryGet( trim(ininame), trim(adjustl(iniyd)), yi )
!     call HistoryGet( trim(ininame), trim(adjustl(inif)), fi )
     call HistoryGet( trim(ininame), trim(adjustl(iniz)), zi )
     nrt=1
  else if(resopt==1)then
     call HistoryGetAttr( trim(adjustl(resfname)), trim(adjustl(respsir)),  &
  &                       trim(adjustl(restn)), nrt )
     call HistoryGetAttr( trim(adjustl(resfname)), trim(adjustl(respsir)),  &
  &                       trim(adjustl(rest)), restime )
  end if

!  do i=1,nx
!     xd(i)=real(x(i))
!  end do
!  do j=1,ny
!     yd(j)=real(y(j))
!  end do

!-- 初期データからモデルにおける物理・スペクトル空間への置き換え
  if(resopt==0)then
     write(*,*) "starting interpolation of initial data."
!     call auto_interpolation_1d( yi, y, fi, coril )
     call auto_interpolation_2d( xi, yi, x, y, zi, tmpr )

     do j=1,ny
        do i=1,nx
           zd(i,j)=real(tmpr(i,j))
           zor(i,j)=tmpr(i,j)
        end do
     end do

!  call grad_1d( y, coril, betaf )

!-- setting psi

     write(*,*) "setting initial data of psi."

     call rearrange_rxy2ryx_isp( nx, ny, zor(1:nx,1:ny), zor_isp(1:ny,1:nx) )

     CALL P2G2SA( hynt, hxnt, ny, nx, zor_isp(1:ny,1:nx),  &
  &               zko_isp(-hynt:hynt,-hxnt:hxnt),  &
  &               tmp_work(1:ny,1:nx), ITJR, TJR, ITIR, TIR )

     call rearrange_ryx2cxy_isp( hxnt, hynt, zko_isp(-hynt:hynt,-hxnt:hxnt),  &
  &                              zko(1:kxnt,1:kynt) )

     basezeta=zko(1,1)
     call zetak2psik( zko(1:kxnt,1:kynt), psiko(1:kxnt,1:kynt) )
     call psik2zetak( psiko(1:kxnt,1:kynt), zko(1:kxnt,1:kynt), basezeta )

     write(*,*) "normally pass the initialization."

  else if(resopt==1)then

     write(*,*) "Start as restart mode. nrt, restime = ", nrt, restime

     call HistoryGet( trim(adjustl(resfname)), trim(adjustl(respsir)),  &
  &                   tmpr(1:kxnt,1:kynt) )
     call HistoryGet( trim(adjustl(resfname)), trim(adjustl(respsii)),  &
  &                   tmpi(1:kxnt,1:kynt) )
     do j=1,kynt
        do i=1,kxnt
           psiko(i,j)=dble(tmpr(i,j))+img_cdp*tmpi(i,j)
        end do
     end do

     call HistoryGet( trim(adjustl(resfname)), trim(adjustl(reszetar)),  &
  &                   tmpr(1:kxnt,1:kynt) )
     call HistoryGet( trim(adjustl(resfname)), trim(adjustl(reszetai)),  &
  &                   tmpi(1:kxnt,1:kynt) )
     do j=1,kynt
        do i=1,kxnt
           zko(i,j)=dble(tmpr(i,j))+img_cdp*tmpi(i,j)
        end do
     end do

     basezeta=zko(1,1)

  end if

!-- 出力ファイルの初期化
  if(resopt==0)then
     call HistoryCreate( file=trim(adjustl(foname)),  &
  &       title='BAROTRO result data', source='test',  &
  &       institution='test', dims=(/'x', 'y', 't'/),  &
  &       dimsizes=(/ nx, ny, 0 /),  & 
  &       longnames=(/'X-coordinate','Y-coordinate', 'time        '/),  &
  &       units=(/'m', 'm', 's'/), origin=0.0,  &
  &       interval=real(dmpstp)*real(dt), history=dmp_hst )
  else if(resopt==1)then
     do i=1,subn
        status=access( 'swap'//trim(adjustl(subhead(i)))//'.'//  &
  &                    trim(adjustl(foname)), ' ' )
        if(status/=0)then
           subm=i
           exit
        end if
     end do
     call HistoryCreate( file='swap'//trim(adjustl(subhead(subm)))//'.'//  &
  &                           trim(adjustl(foname)),  &
  &       title='BAROTRO result data', &
  &       source='test', institution='test', dims=(/'x', 'y', 't'/),  &
  &       dimsizes=(/ nx, ny, 0 /),  & 
  &       longnames=(/'X-coordinate','Y-coordinate', 'time        '/),  &
  &       units=(/'m', 'm', 's'/), origin=restime,  &
  &       interval=real(dmpstp)*real(dt), history=dmp_hst )
  
  end if

  call HistoryPut( 'x', xd, history=dmp_hst )
  call HistoryPut( 'y', yd, history=dmp_hst )
  
  call HistoryAddVariable( varname='psi', dims=(/'x','y','t'/), &
  &                        longname='stream line function',  &
  &                        units='m2 s-1', xtype='float', history=dmp_hst )

  call HistoryAddVariable( varname='zeta', dims=(/'x','y','t'/), &
  &                        longname='vorticity', units='s-1',  &
  &                        xtype='float', history=dmp_hst )

  call HistoryAddVariable( varname='u', dims=(/'x','y','t'/), &
  &                        longname='X wind', units='m s-1',  &
  &                        xtype='float', history=dmp_hst )

  call HistoryAddVariable( varname='v', dims=(/'x','y','t'/), &
  &                        longname='Y wind', units='m s-1',  &
  &                        xtype='float', history=dmp_hst )

  call HistoryAddVariable( varname='sth', dims=(/'x','y','t'/), &
  &                        longname='stretch term', units='m s-1',  &
  &                        xtype='float', history=dmp_hst )

  call HistoryAddVariable( varname='adv', dims=(/'x','y','t'/), &
  &                        longname='advection term', units='m s-1',  &
  &                        xtype='float', history=dmp_hst )

  write(*,*) "time integration start."

  if(resopt==0)then
     !-- 出力等の処理 (初期値の出力)

     call psik2ukvk( psiko(1:kxnt,1:kynt), uk(1:kxnt,1:kynt),  &
  &                  vk(1:kxnt,1:kynt) )

     call rearrange_cxy2ryx_isp( hxnt, hynt, psiko(1:kxnt,1:kynt),  &
        &                        psiko_isp(-hynt:hynt,-hxnt:hxnt) )

     CALL P2S2GA( hynt, hxnt, ny, nx, psiko_isp(-hynt:hynt,-hxnt:hxnt),  &
  &               psior_isp(1:ny,1:nx),  &
  &               tmp_work(1:ny,1:nx), ITJR, TJR, ITIR, TIR )

     call rearrange_ryx2rxy_isp( nx, ny, psior_isp(1:ny,1:nx),  &
  &                              psior(1:nx,1:ny) )

     call rearrange_cxy2ryx_isp( hxnt, hynt, uk(1:kxnt,1:kynt),  &
  &                              uk_isp(-hynt:hynt,-hxnt:hxnt) )

     CALL P2S2GA( hynt, hxnt, ny, nx, uk_isp(-hynt:hynt,-hxnt:hxnt),  &
  &               ur_isp(1:ny,1:nx),  &
  &               tmp_work(1:ny,1:nx), ITJR, TJR, ITIR, TIR )

     call rearrange_ryx2rxy_isp( nx, ny, ur_isp(1:ny,1:nx),  &
  &                              ur(1:nx,1:ny) )

     call rearrange_cxy2ryx_isp( hxnt, hynt, vk(1:kxnt,1:kynt),  &
  &                              vk_isp(-hynt:hynt,-hxnt:hxnt) )

     CALL P2S2GA( hynt, hxnt, ny, nx, vk_isp(-hynt:hynt,-hxnt:hxnt),  &
  &               vr_isp(1:ny,1:nx),  &
  &               tmp_work(1:ny,1:nx), ITJR, TJR, ITIR, TIR )

     call rearrange_ryx2rxy_isp( nx, ny, vr_isp(1:ny,1:nx),  &
  &                              vr(1:nx,1:ny) )

     call rearrange_cxy2ryx_isp( hxnt, hynt, zko(1:kxnt,1:kynt),  &
  &                              zko_isp(-hynt:hynt,-hxnt:hxnt) )

     CALL P2S2GA( hynt, hxnt, ny, nx, zko_isp(-hynt:hynt,-hxnt:hxnt),  &
  &               zor_isp(1:ny,1:nx),  &
  &               tmp_work(1:ny,1:nx), ITJR, TJR, ITIR, TIR )

     call rearrange_ryx2rxy_isp( nx, ny, zor_isp(1:ny,1:nx),  &
  &                              zor(1:nx,1:ny) )

     do j=1,ny
        do i=1,nx
           psid(i,j)=real(psior(i,j))
           ud(i,j)=real(ur(i,j))
           vd(i,j)=real(vr(i,j))
           zd(i,j)=real(zor(i,j))
        end do
     end do

     write(*,*) "*******************************************"
     write(*,*) "File damp (time =", 0.0d0, "[s])."
     write(*,*) "*******************************************"

     call HistoryPut( 'psi', psid, history=dmp_hst )
     call HistoryPut( 'zeta', zd, history=dmp_hst )
     call HistoryPut( 'u', ud, history=dmp_hst )
     call HistoryPut( 'v', vd, history=dmp_hst )
  end if

!-- solver スタート

  do it=nrt,nt

     select case (time_flag(1:3))
     case ('L-F')
        call fft_time_schematic( it, psiko, psikn, zopt1 )
     case ('AB2')
        call fft_time_schematic( it, psiko, psikn, zopt1 )
     case default
        call fft_time_schematic( it, psiko, psikn )
     end select

     psiko=psikn

  !-- ステップの進み具合出力
     write(*,*) "This step is ", it, "(time =", dble(it)*dt, "[s])."

     !-- 出力等の処理 (2)
     if(mod(it,dmpstp)==0)then  ! 逆変換を行い実数出力する.

        call psik2ukvk( psiko(1:kxnt,1:kynt), uk(1:kxnt,1:kynt),  &
  &                     vk(1:kxnt,1:kynt) )
        call psik2zetak( psiko(1:kxnt,1:kynt), zko(1:kxnt,1:kynt),  &
  &                      zkopt=basezeta )

        call rearrange_cxy2ryx_isp( hxnt, hynt, psiko(1:kxnt,1:kynt),  &
  &                                 psiko_isp(-hynt:hynt,-hxnt:hxnt) )

        CALL P2S2GA( hynt, hxnt, ny, nx, psiko_isp(-hynt:hynt,-hxnt:hxnt),  &
  &                  psior_isp(1:ny,1:nx),  &
  &                  tmp_work(1:ny,1:nx), ITJR, TJR, ITIR, TIR )

        call rearrange_ryx2rxy_isp( nx, ny, psior_isp(1:ny,1:nx),  &
  &                                 psior(1:nx,1:ny) )

        call rearrange_cxy2ryx_isp( hxnt, hynt, uk(1:kxnt,1:kynt),  &
  &                                 uk_isp(-hynt:hynt,-hxnt:hxnt) )

        CALL P2S2GA( hynt, hxnt, ny, nx, uk_isp(-hynt:hynt,-hxnt:hxnt),  &
  &                  ur_isp(1:ny,1:nx),  &
  &                  tmp_work(1:ny,1:nx), ITJR, TJR, ITIR, TIR )

        call rearrange_ryx2rxy_isp( nx, ny, ur_isp(1:ny,1:nx),  &
  &                                 ur(1:nx,1:ny) )

        call rearrange_cxy2ryx_isp( hxnt, hynt, vk(1:kxnt,1:kynt),  &
  &                                 vk_isp(-hynt:hynt,-hxnt:hxnt) )

        CALL P2S2GA( hynt, hxnt, ny, nx, vk_isp(-hynt:hynt,-hxnt:hxnt),  &
  &                  vr_isp(1:ny,1:nx),  &
  &                  tmp_work(1:ny,1:nx), ITJR, TJR, ITIR, TIR )

        call rearrange_ryx2rxy_isp( nx, ny, vr_isp(1:ny,1:nx),  &
  &                                 vr(1:nx,1:ny) )

        call rearrange_cxy2ryx_isp( hxnt, hynt, zko(1:kxnt,1:kynt),  &
  &                                 zko_isp(-hynt:hynt,-hxnt:hxnt) )

        CALL P2S2GA( hynt, hxnt, ny, nx, zko_isp(-hynt:hynt,-hxnt:hxnt),  &
  &                  zor_isp(1:ny,1:nx),  &
  &                  tmp_work(1:ny,1:nx), ITJR, TJR, ITIR, TIR )

        call rearrange_ryx2rxy_isp( nx, ny, zor_isp(1:ny,1:nx),  &
  &                                 zor(1:nx,1:ny) )

        !-- monitor variables
        call rearrange_cxy2ryx_isp( hxnt, hynt, dmp_stretchk(1:kxnt,1:kynt),  &
  &                                 dmp_stretchk_isp(-hynt:hynt,-hxnt:hxnt) )

        CALL P2S2GA( hynt, hxnt, ny, nx, dmp_stretchk_isp(-hynt:hynt,-hxnt:hxnt),  &
  &                  dmp_stretchr_isp(1:ny,1:nx),  &
  &                  tmp_work(1:ny,1:nx), ITJR, TJR, ITIR, TIR )

        call rearrange_ryx2rxy_isp( nx, ny, dmp_stretchr_isp(1:ny,1:nx),  &
  &                                 dmp_stretchr(1:nx,1:ny) )

        call rearrange_cxy2ryx_isp( hxnt, hynt, dmp_advectk(1:kxnt,1:kynt),  &
  &                                 dmp_advectk_isp(-hynt:hynt,-hxnt:hxnt) )

        CALL P2S2GA( hynt, hxnt, ny, nx, dmp_advectk_isp(-hynt:hynt,-hxnt:hxnt),  &
  &                  dmp_advectr_isp(1:ny,1:nx),  &
  &                  tmp_work(1:ny,1:nx), ITJR, TJR, ITIR, TIR )

        call rearrange_ryx2rxy_isp( nx, ny, dmp_advectr_isp(1:ny,1:nx),  &
  &                                 dmp_advectr(1:nx,1:ny) )

        write(*,*) "*******************************************"
        write(*,*) "File damp (time =", dble(it)*dt, "[s])."
        write(*,*) "*******************************************"

        do j=1,ny
           do i=1,nx
              psid(i,j)=real(psior(i,j))
              ud(i,j)=real(ur(i,j))
              vd(i,j)=real(vr(i,j))
              zd(i,j)=real(zor(i,j))
              dmp_stretchd(i,j)=real(dmp_stretchr(i,j))
              dmp_advectd(i,j)=real(dmp_advectr(i,j))
           end do
        end do

        call HistoryPut( 'psi', psid, history=dmp_hst )
        call HistoryPut( 'zeta', zd, history=dmp_hst )
        call HistoryPut( 'u', ud, history=dmp_hst )
        call HistoryPut( 'v', vd, history=dmp_hst )
        call HistoryPut( 'sth', dmp_stretchd, history=dmp_hst )
        call HistoryPut( 'adv', dmp_advectd, history=dmp_hst )

     end if

     !-- リスタートファイル出力処理
     if(mod(it,restp)==0)then

        select case (time_flag(1:3))
        case ('L-F','AB2')
           call make_restart_isp( it+1, real(it)*real(dt), psiko, zko, zopt1 )
        case default
           call make_restart_isp( it+1, real(it)*real(dt), psiko, zko )
        end select

     end if

  end do

!-- solver ストップ

  call HistoryClose( history=dmp_hst )

  write(*,*) "solver is normally."

end program fft_solver_isp
