require "numru/netcdf"
include NumRu
include NMath

nx = 100
ny = 100
fname = 'init.dat'
mean_height = 100.0

inix = NArray.sfloat(nx).indgen(0.0)
tmpx = inix[nx/2]
for i in 0..nx-1
   inix[i] = nx * (inix[i] - tmpx)
end
#inix = inix * nx
iniy = NArray.sfloat(ny).indgen(0.0)
tmpy = iniy[ny/2]
for i in 0..ny-1
   iniy[i] = ny * (iniy[i] - tmpy)
end
#iniy = iniy * ny
hei = NArray.sfloat(nx,ny)
ini = NArray.sfloat(nx,ny)
ini_tmp = NArray.sfloat(nx,ny)

hei[0..nx-1,0..ny-1] = 0.0
ini[0..nx-1,0..ny-1] = 0.0
ini_tmp[0..nx-1,0..ny-1] = 0.0

for j in 0..ny-1
   for i in 0..nx-1
#      if (((inix[i]-inix[nx/2])**2+(iniy[j]-iniy[ny/2])**2)**0.5<10.0*nx) then
#         ini[i,j] = 1.0
#      end
      ini[i,j]=exp(-0.01*((inix[i]/nx)**2+(iniy[j]/ny)**2))
      hei[i,j]=mean_height+0.0*exp(-0.01*((inix[i]/nx)**2+(iniy[j]/ny)**2))
   end
end

f = NetCDF.create(fname)
f.def_dim('x',nx)
f.def_dim('y',ny)
require 'date'
f.put_att('history','created by #{$0} #{Date.today}')
x = f.def_var('x','sfloat',['x'])
y = f.def_var('y','sfloat',['y'])

h = f.def_var('h','sfloat',['x','y'])
h.put_att('long_name','height')
h.put_att('units','m')
ht = f.def_var('ht','sfloat',['x','y'])
ht.put_att('long_name','height')
ht.put_att('units','m')
val1 = f.def_var('u','sfloat',['x','y'])
val1.put_att('long_name','zonal wind')
val1.put_att('units','m s-1')
val2 = f.def_var('v','sfloat',['x','y'])
val2.put_att('long_name','meridional wind')
val2.put_att('units','m s-1')
f.enddef

x.put(inix)
y.put(iniy)
h.put(ini)
ht.put(hei)
val1.put(ini_tmp)
val2.put(ini_tmp)

f.close
