program thermo  ! thermo طδؿǧ
  use Thermo_Function
  implicit none
  real :: temp, pres, rh, rho, es, qv, tmp, pt

  write(*,*) "pres [hPa]"
  read(*,*) pres
  write(*,*) "temp [K]"
  read(*,*) temp
  write(*,*) "rh [%]"
  read(*,*) rh
  pres=pres*100.0
  es=RHT_2_e(rh,temp)
  qv=eP_2_qv(es,pres)
  rho=TP_2_rho(temp,pres)
  pt=theta_dry(temp,pres)

  tmp=tetens(temp)
  write(*,*) "tetens", tetens(temp)*1.0e-2, "hPa"
  write(*,*) "goff-gratch", goff_gratch(temp)*1.0e-2, "hPa" 
  write(*,*) "goff-gratch_i", goff_gratch_i(temp)*1.0e-2, "hPa"
  write(*,*) "es_Bolton", es_Bolton(temp)*1.0e-2, "hPa"
  write(*,*) "es_TD", es_TD(es)*1.0e-2, "hPa"
  write(*,*) "LH", LH(temp), "J/kg"
  write(*,*) "eP_2_qv", eP_2_qv(es,pres), "kg/kg"
  write(*,*) "TP_2_qvs", TP_2_qvs(temp,pres), "kg/kg"
  write(*,*) "qvP_2_e", qvP_2_e(qv,pres)*1.0e-2, "hPa"
  write(*,*) "theta_dry", theta_dry(temp,pres), "K"
  write(*,*) "theta_moist", theta_moist(temp,pres,qv), "K"
  write(*,*) "thetaP_2_T", thetaP_2_T(temp,pres), "K"
  write(*,*) "thetaT_2_P", thetaT_2_P(pt,temp)*1.0e-2, "hPa"
  write(*,*) "TqvP_2_TLCL", TqvP_2_TLCL(temp,qv,pres), "K"
  write(*,*) "thetae_Bolton", thetae_Bolton(temp,qv,pres), "K"
  write(*,*) "thetaes_Bolton", thetaes_Bolton(temp,pres), "K"
  write(*,*) "TqvP_2_thetae", TqvP_2_thetae(temp,qv,pres), "K"
  write(*,*) "TqvP_2_thetaes", TqvP_2_thetaes(temp,pres), "K"
  write(*,*) "RHT_2_e", RHT_2_e(rh,temp)*1.0e-2, "hPa"
  write(*,*) "eT_2_RH", eT_2_RH(es,temp), "%"
  write(*,*) "RHTP_2_qv", RHTP_2_qv(rh,temp,pres), "kg/kg"
  write(*,*) "qvTP_2_RH", qvTP_2_RH(qv,temp,pres), "%"
  tmp=exner_func_dry(pres)
  write(*,*) "exner_func_dry", tmp
  write(*,*) "hypsometric_form", hypsometric_form(pres, 0.0, temp, 100.0)
  write(*,*) "rhoT_2_P", rhoT_2_P(rho,temp)*1.0e-2, "hPa"
  write(*,*) "rhoP_2_T", rhoP_2_T(rho,pres), "K"
  write(*,*) "TP_2_rho", TP_2_rho(temp,pres), "kg/m3"
  write(*,*) "get_gamma_d", get_gamma_d()*1.0e3, "K/km"
  write(*,*) "moist_laps_temp", moist_laps_temp(pres,temp,pres-10000.0)

end program
