program poison
  use gtool_history
  use Alge_Solv

  implicit none

  integer :: nx, ny
  integer :: i, j
  real :: dx, dy
  real :: t1, t2
  real, allocatable :: x(:), y(:)
  real, allocatable :: rho(:,:)
  real, allocatable :: psi(:,:)
  real, parameter :: undef=999.0
  integer :: method
  integer, allocatable :: ib(:,:)
  character(4) :: tp
  logical :: ter_flag

  namelist /input /nx,ny,tp,method,ter_flag
  read(5,input)

  allocate(x(nx))
  allocate(y(ny))
  allocate(psi(nx,ny))
  allocate(rho(nx,ny))
  allocate(ib(nx,ny))

  dx=1.0/real(nx-1)
  dy=1.0/real(ny-1)

  x=(/(dx*(i-1),i=1,nx)/)
  y=(/(dy*(i-1),i=1,ny)/)

  rho=0.0
! do i=1,nx
! do j=1,ny
! rho(i,j)=exp(-10.0*((x(i)-0.5)**2+(y(j)-0.5)**2))
! end do
! end do
  do i=1,nx
     do j=1,ny

        if((((i-50)**2+(j-50)**2)*dx*dy)<0.05*0.05)then

           rho(i,j)=-1.0e4/8.85

        end if

     end do
  end do

  call cpu_time( t1 )

  if(ter_flag.eqv..true.)then
     do j=1,ny
        do i=1,nx
           ib(i,j)=0
           if(j<=ny/4.and.i>=nx/4.and.i<=nx*3/4)then
              ib(i,j)=10
           end if
        end do
     end do
     ib(nx/4,1:ny/3)=1
     ib(nx/4:nx*3/4,ny/3)=1
     ib(nx*3/4,1:ny/3)=1
     select case (method)
     case(1)
        call Poisson_GauSei( x, y, rho, 1.0e-6, tp, psi,  &
  &                          inner_bound=ib, undef=undef )
     case(2)
        call Poisson_Jacobi( x, y, rho, 1.0e-6, tp, psi,  &
  &                          inner_bound=ib, undef=undef )
     end select
  else
     select case (method)
     case(1)
        call Poisson_GauSei(x,y,rho,1.0e-6,tp,psi)
     case(2)
        call Poisson_Jacobi(x,y,rho,1.0e-6,tp,psi)
     end select
  end if

  call cpu_time( t2 )

!-- gtool history (netcdf dump)

  call HistoryCreate( &                             ! ҥȥ꡼
    & file='poison.nc', title='poison model', &
    & source='Sample program of gtool_history/gtool5',   &
    & institution='GFD_Dennou Club davis project',       &
    & dims=(/'x','y'/), dimsizes=(/nx,ny/),               &
    & longnames=(/'X-coordinate','Y-coordinate'/),       &
    & units=(/'m','m'/),                                 &
    & origin=0.0, interval=0.0 )
  
  call HistoryPut( 'x', x )                            ! ѿ
  call HistoryPut( 'y', y )                            ! ѿ

  call HistoryAddVariable( &                           ! ѿ
    & varname='psi', dims=(/'x','y'/), &
    & longname='psi', units='1', xtype='float')

  call HistoryPut('psi',psi)                         ! ѿ

  call HistoryAddVariable( &                           ! ѿ
    & varname='rho', dims=(/'x','y'/), &
    & longname='forcing', units='1', xtype='float')

  call HistoryPut('rho',rho)                         ! ѿ
  call HistoryClose

  write(*,*) "--------------------------------------------"
  write(*,'(a28,1p,E14.5,a1)') "Main solver running time = ", t2-t1, " s"
  if(method==1)then
     write(*,*) "This Method is Seidel Method."
  else
     write(*,*) "This Method is Jacobi Method."
  end if
  write(*,*) "--------------------------------------------"

end program
